/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.creamtec.core.StringUtilities;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseFileHelper;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.ServerVersion;
import com.sygate.scm.util.SymantecMessageDigest;
import com.sygate.scm.util.Utility;
import java.io.File;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;

class LicenseFileRow
implements TableRow {
    private static final int MAX_SIZE_OF_LICENSE_FILE = 0x200000;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private File file = null;
    private String filechecksum = null;
    private ArrayList<ElsLicenseObject> licenseArrayList = new ArrayList();

    public LicenseFileRow(File file) throws LicenseImportConsoleException {
        this.file = file;
        this.parseLicenseFile(file);
    }

    private void parseLicenseFile(File file) throws LicenseImportConsoleException {
        if (file.length() > 0x200000L) {
            ConsoleLogger.log("Invalid license file!");
            this.throwLicenseImportExceptionWithKB(LicenseImportConsoleException.ErrorCode.FILE_TOO_BIG, "UploadLicenseFilesPanel.corruptSlfFile");
        }
        this.filechecksum = LicenseFileRow.calcLicenseFileChecksum(file);
        if (this.filechecksum == null) {
            ConsoleLogger.log("Failed to calculate license file checksum!");
            this.throwLicenseImportExceptionWithKB(LicenseImportConsoleException.ErrorCode.FAIL_CALC_CHECKSUM, "UploadLicenseFilesPanel.corruptSlfFile");
        }
        this.readLicense();
    }

    private void readLicense() throws LicenseImportConsoleException {
        try {
            ArrayList<String> xmldata = LicenseActivationHandler.readLicensesFile(this.file.getAbsolutePath());
            if (this.isLicenseTypeValidForImport(xmldata)) {
                this.licenseArrayList = LicenseActivationHandler.parseLicense(xmldata);
                ConsoleLogger.log("Loaded " + this.licenseArrayList.size() + " licenses from " + this.file.getAbsolutePath());
            } else {
                ConsoleLogger.log("Invalid license type for import!");
                this.throwLicenseImportException(LicenseImportConsoleException.ErrorCode.INVALID_LICENSE_TYPE_TO_IMPORT, "UploadLicenseFilesPanel.slfFileInWrongCategory");
            }
        }
        catch (LicenseImportConsoleException e) {
            throw e;
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            this.throwLicenseImportExceptionWithKB(LicenseImportConsoleException.ErrorCode.FAIL_PARSE_LICENSE, "UploadLicenseFilesPanel.corruptSlfFile");
        }
    }

    private void throwLicenseImportException(LicenseImportConsoleException.ErrorCode code, String msgKey) throws LicenseImportConsoleException {
        String fileNameShort = this.getDisplayableFileName();
        String desc = MessageFormat.format(MSGRES.getString(ADMINDIALOG, msgKey), fileNameShort);
        throw new LicenseImportConsoleException(code, desc);
    }

    private void throwLicenseImportExceptionWithKB(LicenseImportConsoleException.ErrorCode code, String msgKey) throws LicenseImportConsoleException {
        String fileNameShort = this.getDisplayableFileName();
        Object[] obj = new Object[]{ServerVersion.CURRENT_CED_VERSION, Utility.getLanguage(), fileNameShort};
        String desc = MessageFormat.format(MSGRES.getString(ADMINDIALOG, msgKey), obj);
        throw new LicenseImportConsoleException(code, desc);
    }

    public String getDisplayableFileName() {
        return LicenseFileRow.makeLongStringWrappable(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.filename") + LicenseFileRow.getUIVisibleFileName(this.file.getName()), 42);
    }

    public File getFile() {
        return this.file;
    }

    public String getFileChecksum() {
        return this.filechecksum;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return LicenseFileRow.getUIVisibleFileName(this.file.getName());
            }
            case 1: {
                return this.licenseArrayList.size();
            }
            case 2: {
                return this.file;
            }
        }
        return null;
    }

    public static String getUIVisibleFileName(String fileName) {
        return AjaxSwingUtil.getAjaxSwingFileName(new File(fileName));
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Integer.class;
            }
        }
        return File.class;
    }

    private boolean isLicenseTypeValidForImport(ArrayList<String> xmldata) {
        for (String xml : xmldata) {
            if (!LicenseUtils.isUpgradeLicense((String)xml) && !LicenseUtils.isNeverexpireLicense((String)xml) && !LicenseUtils.isODLicense((String)xml)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public ArrayList<ElsLicenseObject> getLicenseArrayList() {
        return this.licenseArrayList;
    }

    private static String calcLicenseFileChecksum(File file) {
        try {
            String content = LicenseFileHelper.getFileContents((String)file.getCanonicalPath());
            if (!StringUtilities.isEmpty((String)content)) {
                MessageDigest md = SymantecMessageDigest.getInstance();
                md.update(content.getBytes("UTF-8"));
                return Utility.toHexString((byte[])md.digest());
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return null;
    }

    public static String makeLongStringWrappable(String str, int width) {
        int numberInsertion;
        StringBuffer strShort = new StringBuffer(str);
        for (int i = numberInsertion = (int)Math.floor((float)strShort.length() / (float)width); i > 0; --i) {
            strShort.insert(i * width, " ");
        }
        return strShort.toString();
    }

    public static class LicenseImportConsoleException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ErrorCode code;

        public LicenseImportConsoleException(ErrorCode code, String message) {
            super(message);
            this.code = code;
        }

        public ErrorCode getCode() {
            return this.code;
        }

        static enum ErrorCode {
            FILE_TOO_BIG,
            FAIL_CALC_CHECKSUM,
            INVALID_LICENSE_TYPE_TO_IMPORT,
            FAIL_PARSE_LICENSE,
            DUPLICATE_LICENSE_TO_IMPORT;

        }
    }
}

