/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;

public class LicenseDisplayStringHelper {
    public static final String LICENSE_TOKEN_NOT_FOR_RESALE = "Not for Resale";
    public static final String LICENSE_TOKEN_PARTNER_EVALUATION = "Partner Evaluation";

    public static String getLicenseDisplayString(LicenseChainObject chainObj) {
        if (chainObj == null) {
            return "";
        }
        return LicenseDisplayStringHelper.getLicenseDisplayString(chainObj.getLastLicense());
    }

    public static String getLicenseDisplayString(ElsLicenseObject elsLicenseObj) {
        if (elsLicenseObj == null) {
            return "";
        }
        return LicenseDisplayStringHelper.getLicenseDisplayString(elsLicenseObj.getElsLicense());
    }

    public static String getLicenseDisplayString(TrialwareLicenseObject twLicense) {
        if (twLicense == null) {
            return "";
        }
        try {
            return LicenseDisplayStringHelper.getLicenseDisplayString(twLicense.getTrialwareLicense().getContent());
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            return twLicense.getProductName();
        }
    }

    public static String getLicenseDisplayString(UpgradeLicenseObject upLicense) {
        if (upLicense == null) {
            return "";
        }
        try {
            return LicenseDisplayStringHelper.getLicenseDisplayString(upLicense.getUpgradeLicense().getContent());
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            return upLicense.getProductName();
        }
    }

    public static String getLicenseDisplayString(String rawLicenseXML) throws LicenseException {
        ArrayList license = LicenseUtils.parseLicense((String)rawLicenseXML);
        if (license == null || license.size() < 1) {
            return "";
        }
        return LicenseDisplayStringHelper.getLicenseDisplayString((ElsLicense)license.get(0));
    }

    public static String getLicenseDisplayString(ElsLicense license) {
        try {
            if (license == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            ElsLicenseObject licObj = new ElsLicenseObject(license);
            if (LicenseDisplayStringHelper.isSAVLicense(licObj.getVersion())) {
                sb.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseDisplayStringHelper.LicenseDisplayString.Product.SAV"));
            } else if (LicenseDisplayStringHelper.isSCSLicense(licObj.getVersion())) {
                sb.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseDisplayStringHelper.LicenseDisplayString.Product.SCS"));
            } else if ("SEPSB".equalsIgnoreCase(LicenseUtils.getProductType((String)license.getOptProductID()))) {
                sb.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseDisplayStringHelper.LicenseDisplayString.Product.SEPSB"));
            } else if (licObj.isSNACLicense()) {
                sb.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseDisplayStringHelper.LicenseDisplayString.Product.SNAC"));
            } else {
                sb.append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseDisplayStringHelper.LicenseDisplayString.Product.SEP"));
            }
            if (!StringUtilities.isEmpty((String)licObj.getVersion())) {
                sb.append(" " + licObj.getVersion());
            }
            Object licenseDisplayStringKey = "LicenseDisplayStringHelper.LicenseDisplayString";
            String validDaysOrSeatsCountString = "";
            if (LicenseUtils.isTrialwareLicense((ElsLicense)license) || LicenseUtils.isUpgradeLicense((String)license.getContent())) {
                long validDays = LicenseUtils.calcTotalValidDays((ElsLicense)license);
                if (validDays != -1L) {
                    validDaysOrSeatsCountString = String.valueOf(validDays);
                    licenseDisplayStringKey = (String)licenseDisplayStringKey + ".days";
                }
            } else {
                int seatCount = licObj.getCount();
                validDaysOrSeatsCountString = String.valueOf(seatCount);
                String seatOrSeats = ".seats";
                if (seatCount <= 1) {
                    seatOrSeats = ".seat";
                }
                licenseDisplayStringKey = (String)licenseDisplayStringKey + seatOrSeats;
            }
            if (LicenseUtils.isTrialwareLicense((ElsLicense)license)) {
                licenseDisplayStringKey = (String)licenseDisplayStringKey + ".trial";
            } else if (LicenseUtils.isUpgradeLicense((String)license.getContent())) {
                licenseDisplayStringKey = (String)licenseDisplayStringKey + ".upgrade";
            } else if (LicenseUtils.isODLicense((String)license.getContent())) {
                licenseDisplayStringKey = (String)licenseDisplayStringKey + ".overdeployed";
            } else {
                String product_name = license.getOptProductName();
                if (!StringUtilities.isEmpty((String)product_name)) {
                    if (product_name.indexOf(LICENSE_TOKEN_NOT_FOR_RESALE) > -1) {
                        licenseDisplayStringKey = (String)licenseDisplayStringKey + ".notforresale";
                    } else if (product_name.indexOf(LICENSE_TOKEN_PARTNER_EVALUATION) > -1) {
                        licenseDisplayStringKey = (String)licenseDisplayStringKey + ".partnerevaluation";
                    }
                }
            }
            licenseDisplayStringKey = (String)licenseDisplayStringKey + ".license";
            sb.append(" " + MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", (String)licenseDisplayStringKey), validDaysOrSeatsCountString));
            return sb.toString();
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
            return license.getOptProductName();
        }
    }

    private static boolean isSAVLicense(String version) {
        try {
            if (!StringUtilities.isEmpty((String)version)) {
                int ver;
                String majorVerion = version;
                if (version.indexOf(".") > -1) {
                    majorVerion = version.substring(0, version.indexOf("."));
                }
                if ((ver = Integer.parseInt(majorVerion)) >= 9 && ver < 12) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return false;
    }

    private static boolean isSCSLicense(String version) {
        try {
            if (!StringUtilities.isEmpty((String)version)) {
                int ver;
                String majorVerion = version;
                if (version.indexOf(".") > -1) {
                    majorVerion = version.substring(0, version.indexOf("."));
                }
                if ((ver = Integer.parseInt(majorVerion)) < 9) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return false;
    }
}

