/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.rpc.IPLFulfillmentError;
import com.sygate.scm.common.configobject.rpc.IPLResponse;
import com.sygate.scm.common.configobject.rpc.IPLUserInputError;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.admin.iplLicense.IPLInformationPanel;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationFinishedPanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationSelectionPanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWelcomePanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationPanel;
import com.sygate.scm.console.ui.admin.iplLicense.RenewLicensePanel;
import com.sygate.scm.console.ui.admin.iplLicense.SerialNumberEntryPanel;
import com.sygate.scm.console.ui.admin.iplLicense.UploadLicenseFilesPanel;
import com.sygate.scm.console.ui.overview.OverviewPanel;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.WizardBase;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class LicenseActivationWizardDialog
extends WizardBase {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private IPLLicenseHandler iplLicenseHandler = new IPLLicenseHandler();
    private LicenseUtils.INFO_REQUIRED infoRequired = LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED;
    private Set<String> serialNumbers = new HashSet<String>();
    private IPLResponse rpcIPLResponse = new IPLResponse();
    private HashMap<String, String> licenseEntitlement = new HashMap();
    private ArrayList<ElsLicenseObject> seletecedLicenseList = new ArrayList();
    private ArrayList<ElsLicenseObject> elsLicensesList = new ArrayList();
    private Dimension panelSize = null;
    private boolean switchProductByRenew = false;
    private static final int STAGE_COUNT = 10;
    public static final int STAGE_OPERATION_SELECTION = 0;
    public static final int STAGE_RENEWAL_SELECTION = 1;
    public static final int STAGE_WELCOME_SELECTION = 2;
    public static final int STAGE_SERIAL_NUMBER_ENTRY = 3;
    public static final int STAGE_COMPANY_INFORMATION = 4;
    public static final int STAGE_TECHNICAL_CONTACT_INFORMATION = 5;
    public static final int STAGE_BOTH_INFORMATION = 6;
    public static final int STAGE_UPLOAD_LICENSE_FILE = 7;
    public static final int STAGE_LICENSE_INFORMATION = 8;
    public static final int STAGE_DEPLOY_SUMMARY = 9;
    protected LicenseActivationSelectionPanel operationSelectPanel = null;
    protected RenewLicensePanel renewLicensePanel = null;
    protected LicenseActivationWelcomePanel iplwelcomepanel = null;
    protected IPLInformationPanel companyinformationpanel = null;
    protected IPLInformationPanel technicalcontactinformationpanel = null;
    protected IPLInformationPanel bothinformationpanel = null;
    protected SerialNumberEntryPanel serialnumberentrypanel = null;
    protected LicenseActivationFinishedPanel deploySummaryPanel = null;
    protected UploadLicenseFilesPanel uploadLicenseFilesPanel = null;
    protected LicenseInformationPanel licenseInformationPanel = null;
    public static final Dimension SCROLL_PANE_DIMENSION = new Dimension(580, 270);
    public static final Dimension TABLE_DIMENSION = new Dimension(550, 150);
    public static final Dimension TABLE_DIMENSION_SMALL = new Dimension(550, 75);
    public static final int POPUP_MESSAGE_WIDTH = 290;
    public static final int POPUP_MESSAGE_WIDTH_WIDTH = 350;
    public static final int INPUT_TEXT_FIELD_WIDTH = 250;
    public static final int WORD_WRAP_NUMBER = 42;

    public LicenseActivationWizardDialog() {
        super(MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.LicenseActivation"), true, WizardBase.HelpButtonState.OFF);
        try {
            ArrayList<LicenseChainObject> renewLicenseChainList = LicenseHandler.getLicenseChains();
            if (renewLicenseChainList != null) {
                for (LicenseChainObject tempLicenseChainObject : renewLicenseChainList) {
                    this.elsLicensesList.addAll(tempLicenseChainObject.getLicenses());
                }
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            Object msg = e.getMessage();
            if (e.getErrorCode() == 306184192) {
                msg = e.getMessage() + MessageResources.getInstance().getString(ADMINDIALOG, "IPLLicenseHandler.invalidOrCorruptedLicense");
            }
            JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane((String)msg, "", true, 290), MessageResources.getInstance().getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
        }
        this.initDialog();
    }

    private void initDialog() {
        this.operationSelectPanel = new LicenseActivationSelectionPanel(this);
        this.renewLicensePanel = new RenewLicensePanel(this);
        this.iplwelcomepanel = new LicenseActivationWelcomePanel(this);
        this.companyinformationpanel = new IPLInformationPanel(LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED, this, this.iplLicenseHandler);
        this.technicalcontactinformationpanel = new IPLInformationPanel(LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED, this, this.iplLicenseHandler);
        this.bothinformationpanel = new IPLInformationPanel(LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED, this, this.iplLicenseHandler);
        this.serialnumberentrypanel = new SerialNumberEntryPanel(this);
        this.uploadLicenseFilesPanel = new UploadLicenseFilesPanel(this);
        this.licenseInformationPanel = new LicenseInformationPanel(this);
        this.deploySummaryPanel = new LicenseActivationFinishedPanel(this);
        this.addStage(this.operationSelectPanel, 0);
        this.addStage(this.renewLicensePanel, 1);
        this.addStage(this.iplwelcomepanel, 2);
        this.addStage(this.serialnumberentrypanel, 3);
        this.addStage(this.companyinformationpanel, 4);
        this.addStage(this.technicalcontactinformationpanel, 5);
        this.addStage(this.bothinformationpanel, 6);
        this.addStage(this.deploySummaryPanel, 9);
        this.addStage(this.uploadLicenseFilesPanel, 7);
        this.addStage(this.licenseInformationPanel, 8);
        this.panelSize = this.iplwelcomepanel.getPreferredSize();
        this.operationSelectPanel.setSize(this.panelSize);
        this.companyinformationpanel.setSize(this.panelSize);
        this.technicalcontactinformationpanel.setSize(this.panelSize);
        this.bothinformationpanel.setSize(this.panelSize);
        this.serialnumberentrypanel.setSize(this.panelSize);
        this.uploadLicenseFilesPanel.setSize(this.panelSize);
        this.licenseInformationPanel.setSize(this.panelSize);
        if (this.elsLicensesList.size() > 0) {
            this.showStage(0);
            this.updateButtons(0);
        } else {
            this.showStage(2);
            this.skipForward(2);
            this.updateButtons(2);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    protected void prepareNext(int stage) {
    }

    @Override
    protected boolean validatePanel(int stage) {
        boolean isValid = true;
        switch (stage) {
            case 1: {
                isValid = this.renewLicensePanel.isValidated();
                break;
            }
            case 2: {
                isValid = this.iplwelcomepanel.isValidated();
                break;
            }
            case 3: {
                isValid = this.serialnumberentrypanel.isValidated();
                break;
            }
            case 5: {
                isValid = this.technicalcontactinformationpanel.isValidated();
                break;
            }
            case 4: {
                isValid = this.companyinformationpanel.isValidated();
                break;
            }
            case 6: {
                isValid = this.bothinformationpanel.isValidated();
                break;
            }
            case 7: {
                isValid = this.uploadLicenseFilesPanel.isValidated();
                break;
            }
            case 8: {
                isValid = this.licenseInformationPanel.isValidated();
                break;
            }
            default: {
                isValid = true;
            }
        }
        return isValid;
    }

    @Override
    protected int getStageCount() {
        return 10;
    }

    private void processNoAnyLicenseForAllSerialNumbers() {
        String msg = MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.noAnyLicenseWhenSEPWithSNACProduct");
        if (LicenseObject.getInstance().isSAVOnlyProduct()) {
            msg = MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.noAnyLicenseWhenSEPProduct");
        } else if (LicenseObject.getInstance().isSNACOnlyProduct()) {
            msg = MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.noAnyLicenseWhenSNACProduct");
        }
        JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
    }

    private void updateInformationPanel() {
        this.licenseInformationPanel.updateRenewalFlowStatus();
        this.licenseInformationPanel.repaint();
    }

    private boolean isSameProductType(ArrayList<ElsLicenseObject> licenseList) {
        if (licenseList == null || licenseList.size() <= 0) {
            return true;
        }
        boolean isSEPlast = false;
        for (int i = 0; i < licenseList.size(); ++i) {
            boolean tempIsSEP = licenseList.get(i).isSEPLicense();
            if (i > 0 && isSEPlast != tempIsSEP) {
                return false;
            }
            isSEPlast = tempIsSEP;
        }
        return true;
    }

    private boolean isSEPLicense(ArrayList<ElsLicenseObject> licenseList) {
        if (licenseList != null && licenseList.size() > 0) {
            return licenseList.get(0).isSEPLicense();
        }
        return false;
    }

    private boolean switchProductTypeByRenew(ArrayList<ElsLicenseObject> licenseListOld, ArrayList<ElsLicenseObject> licenseListNew) {
        boolean isSEPNew;
        boolean isSEPRemove;
        boolean isAllSameRemove = this.isSameProductType(licenseListOld);
        boolean isAllSameNew = this.isSameProductType(licenseListNew);
        return isAllSameRemove && isAllSameNew && (isSEPRemove = this.isSEPLicense(licenseListOld)) != (isSEPNew = this.isSEPLicense(licenseListNew));
    }

    @Override
    protected int getNextStage(int currentStage) {
        this.switchProductByRenew = false;
        if (currentStage == 0) {
            if (this.isRenewalFlow()) {
                return 1;
            }
            return 2;
        }
        if (currentStage == 2) {
            this.updateInformationPanel();
            if (this.iplwelcomepanel.isIPLSelected()) {
                return 3;
            }
            return 7;
        }
        if (currentStage == 4 || currentStage == 5 || currentStage == 6 || currentStage == 3) {
            if (!this.downloadEntitlements(this.serialNumbers)) {
                return currentStage;
            }
            if (this.rpcIPLResponse.getOptResponseType().intValue() == LicenseUtils.IPL_RESPONSE_TYPE.IPL_ENTITLEMENT.getValue()) {
                if (this.licenseEntitlement != null && !this.licenseEntitlement.isEmpty()) {
                    ArrayList<ElsLicenseObject> licenseList = this.getNewLicenseXMLsFromEntitlements();
                    if (licenseList != null && !licenseList.isEmpty()) {
                        this.licenseInformationPanel.setLicenseList(licenseList);
                        if (this.isRenewalFlow()) {
                            this.licenseInformationPanel.setDeletingLicenseList(this.getSeletecedLicenseList());
                            this.switchProductByRenew = this.switchProductTypeByRenew(this.getSeletecedLicenseList(), licenseList);
                        }
                        return 8;
                    }
                    this.processNoAnyLicenseForAllSerialNumbers();
                    return currentStage;
                }
                return currentStage;
            }
            if (!this.processIPLResponse(this.rpcIPLResponse)) {
                return currentStage;
            }
            if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == this.infoRequired) {
                return 4;
            }
            if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == this.infoRequired) {
                return 5;
            }
            if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == this.infoRequired) {
                return 6;
            }
        } else {
            if (currentStage == 7) {
                this.licenseInformationPanel.setLicenseList(this.uploadLicenseFilesPanel.getNewLicenseXMLs());
                if (this.isRenewalFlow()) {
                    this.licenseInformationPanel.setDeletingLicenseList(this.getSeletecedLicenseList());
                }
                return 8;
            }
            if (currentStage == 8) {
                try {
                    ArrayList<ElsLicenseObject> validLicenses = this.licenseInformationPanel.getAllValidLicenses();
                    if (this.isRenewalFlow() && this.getSeletecedLicenseList() != null && this.getSeletecedLicenseList().size() > 0) {
                        LicenseActivationHandler.renewLicense(this.getSeletecedLicenseList(), validLicenses);
                    } else {
                        LicenseActivationHandler.addNewLicenses(validLicenses);
                    }
                }
                catch (LicenseException e) {
                    ConsoleLogger.log(e);
                    JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane(e.getMessage(), "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                    return currentStage;
                }
                catch (ConsoleException e) {
                    ConsoleLogger.log(e);
                    Object msg = e.getMessage();
                    if (e.getErrorCode() == 306184192) {
                        msg = e.getMessage() + MessageResources.getInstance().getString(ADMINDIALOG, "IPLLicenseHandler.invalidOrCorruptedLicense");
                    }
                    JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane((String)msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                    return currentStage;
                }
                return 9;
            }
        }
        return super.getNextStage(currentStage);
    }

    protected void setSerialNumbers(Set<String> inSerialNumbers) {
        if (inSerialNumbers != null) {
            this.serialNumbers = inSerialNumbers;
        }
    }

    @Override
    protected int getPreviousStage(int currentStage) {
        if (currentStage == 2) {
            if (this.isRenewalFlow()) {
                return 1;
            }
            return 0;
        }
        if (currentStage == 4 || currentStage == 5 || currentStage == 6) {
            this.infoRequired = LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED;
            return 3;
        }
        if (currentStage == 7) {
            return 2;
        }
        return super.getPreviousStage(currentStage);
    }

    @Override
    protected boolean disableBackButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected boolean disableCancelButtonAtCompletePanel() {
        return true;
    }

    @Override
    protected void updateButtons(int stage) {
        super.updateButtons(stage);
        this.jBNext.setEnabled(true);
        this.jBBack.setVisible(true);
        if (stage == 0) {
            this.jBBack.setVisible(false);
        } else if (stage == 1) {
            if (this.renewLicensePanel == null || this.renewLicensePanel.getSelectedLicenseList() == null || this.renewLicensePanel.getSelectedLicenseList().size() < 1) {
                this.jBNext.setEnabled(false);
            } else {
                this.jBNext.setEnabled(true);
            }
        } else if (stage == 2) {
            if (this.elsLicensesList.size() == 0) {
                this.jBBack.setVisible(false);
            }
            this.jBNext.requestFocusInWindow();
        } else if (stage == 3) {
            this.jBNext.setText(UIText.get(4622));
            this.enableNetxButton(true);
        } else if (stage == 4) {
            this.jBNext.setText(UIText.get(4622));
            if (this.companyinformationpanel.isLegalDisclaimerChkButtonSelected()) {
                this.enableNetxButton(true);
            } else {
                this.enableNetxButton(false);
            }
        } else if (stage == 5) {
            this.jBNext.setText(UIText.get(4622));
            if (this.technicalcontactinformationpanel.isLegalDisclaimerChkButtonSelected()) {
                this.enableNetxButton(true);
            } else {
                this.enableNetxButton(false);
            }
        } else if (stage == 6) {
            this.jBNext.setText(UIText.get(4622));
            if (this.bothinformationpanel.isLegalDisclaimerChkButtonSelected()) {
                this.enableNetxButton(true);
            } else {
                this.enableNetxButton(false);
            }
        } else if (stage == 7) {
            if (this.uploadLicenseFilesPanel == null || this.uploadLicenseFilesPanel.getElsLicenseCount() < 1) {
                this.jBNext.setEnabled(false);
            } else {
                this.jBNext.setEnabled(true);
            }
        } else if (stage == 8) {
            if (this.iplwelcomepanel.isIPLSelected()) {
                this.jBBack.setEnabled(false);
            }
            if (!this.switchProductByRenew && this.licenseInformationPanel.hasValidLicense()) {
                this.jBNext.setEnabled(true);
                this.jBNext.requestFocusInWindow();
            } else {
                this.jBNext.setEnabled(false);
            }
        }
    }

    @Override
    protected void cancel() {
        this.isOk = false;
        this.dispose();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    public boolean getisOk() {
        return this.isOk;
    }

    public void enableNetxButton(boolean enableButton) {
        this.jBNext.setEnabled(enableButton);
    }

    public void doNextClicked() {
        this.jBNext.doClick();
    }

    private ArrayList<ElsLicenseObject> getNewLicenseXMLsFromEntitlements() {
        ArrayList<ElsLicenseObject> newLicenseXMLsFromEntitlements = new ArrayList<ElsLicenseObject>();
        ArrayList<String> popupDesc = new ArrayList<String>();
        if (!this.licenseEntitlement.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = this.licenseEntitlement.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String LicenseStr = entry.getValue();
                try {
                    newLicenseXMLsFromEntitlements.addAll(LicenseActivationHandler.parseLicense(LicenseUtils.parseLicensesXML((String)LicenseStr, (boolean)false)));
                }
                catch (LicenseException e) {
                    if (e.getMessage() != null) {
                        ConsoleLogger.logError(e.getMessage());
                        ConsoleLogger.logError("License String in error: " + LicenseStr);
                    }
                    popupDesc.add(MessageFormat.format(MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.corruptLicenseFile"), "Serial number: " + key));
                }
            }
        } else {
            ConsoleLogger.log(MSGRES.getString(ADMINDIALOG, "LicenseActivationWizardDialog.NoEntitlement"));
        }
        for (String str : popupDesc) {
            JOptionPane.showMessageDialog(null, IPLLicenseHandler.getHyperLinkEditorPane(str, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
        }
        return newLicenseXMLsFromEntitlements;
    }

    private boolean downloadEntitlements(Set<String> serialNumbers) {
        boolean noError = this.iplLicenseHandler.downloadEntitlements(serialNumbers, this.infoRequired);
        this.rpcIPLResponse = this.iplLicenseHandler.getIPLResponse();
        this.licenseEntitlement = this.iplLicenseHandler.getEntitlement();
        return noError;
    }

    private boolean processIPLResponse(IPLResponse iPLResponse) {
        if (iPLResponse.getOptResponseType().intValue() == LicenseUtils.IPL_RESPONSE_TYPE.IPL_FULFILLMENTERROR.getValue()) {
            return this.processIPLFulfillmentError(iPLResponse);
        }
        if (iPLResponse.getOptResponseType().intValue() == LicenseUtils.IPL_RESPONSE_TYPE.IPL_GENERALERROR.getValue()) {
            this.iplLicenseHandler.processIPLGeneralErrorException(iPLResponse);
            return false;
        }
        if (iPLResponse.getOptResponseType().intValue() == LicenseUtils.IPL_RESPONSE_TYPE.IPL_USERINPUTERROR.getValue()) {
            this.processIPLUserInputError(iPLResponse);
            return false;
        }
        return false;
    }

    private void processIPLUserInputError(IPLResponse iPLResponse) {
        Vector iPLUserInputErrorVector = iPLResponse.getIPLUserInputError();
        for (IPLUserInputError iPLUserInputError : iPLUserInputErrorVector) {
            if (iPLUserInputError.getIPLUserInputErrorType().intValue() == LicenseUtils.IPL_USERINPUTERROR_TYPE.SERIALNUMBER_ERROR.getValue()) {
                this.serialnumberentrypanel.setLicenseEntryPanelIPLSerialNumberError(iPLUserInputError);
                continue;
            }
            if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == this.getInfoRequired()) {
                this.companyinformationpanel.setInputBoxError(iPLUserInputError);
                continue;
            }
            if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == this.getInfoRequired()) {
                this.technicalcontactinformationpanel.setInputBoxError(iPLUserInputError);
                continue;
            }
            if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED != this.getInfoRequired()) continue;
            this.bothinformationpanel.setInputBoxError(iPLUserInputError);
        }
    }

    private boolean processIPLFulfillmentError(IPLResponse iPLResponse) {
        Vector iPLFulfillmentErrorVector = iPLResponse.getIPLFulfillmentError();
        boolean noError = true;
        block5: for (IPLFulfillmentError iPLFulfillmentError : iPLFulfillmentErrorVector) {
            LicenseUtils.IPL_FULFILLMENT_ERROR_REASON reason = LicenseUtils.IPL_FULFILLMENT_ERROR_REASON.fromValue((int)iPLFulfillmentError.getOptReason());
            switch (reason) {
                case WRONG_PRODUCT_ID: 
                case INACTIVE_SERIAL_NUMBER: 
                case REG_COUNT_EXCEEDED: 
                case SERIAL_NUMBER_IS_NON_IPL: 
                case SERIAL_NUMBER_NOT_RECOGNIZED: 
                case SERVER_INTERNAL_ERROR: 
                case BLOCKED_BY_TRADE_COMPLIANCE: {
                    this.serialnumberentrypanel.setLicenseEntryPanelIPLFulfillmentError(iPLFulfillmentError);
                    noError = false;
                    continue block5;
                }
                case TECHNICAL_CONTACT_INFO_REQUIRED: {
                    if (this.getInfoRequired() == LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED) {
                        this.setInfoRequired(LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED);
                        continue block5;
                    }
                    if (this.getInfoRequired() != LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED) continue block5;
                    this.setInfoRequired(LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED);
                    continue block5;
                }
                case COMPANY_INFO_REQUIRED: {
                    if (this.getInfoRequired() == LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED) {
                        this.setInfoRequired(LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED);
                        continue block5;
                    }
                    if (this.getInfoRequired() != LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED) continue block5;
                    this.setInfoRequired(LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED);
                    continue block5;
                }
            }
            ConsoleLogger.log("IPL FulfillmentError condition: INPUT_VALIDATION_ERROR or UNKNOWN");
        }
        if (!noError) {
            this.setInfoRequired(LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED);
        }
        return noError;
    }

    @Override
    protected void showStage(int stage) {
        switch (stage) {
            case 4: {
                this.companyinformationpanel.setInfoPaneViewPosition();
                break;
            }
            case 5: {
                this.technicalcontactinformationpanel.setInfoPaneViewPosition();
                break;
            }
            case 6: {
                this.bothinformationpanel.setInfoPaneViewPosition();
                break;
            }
            case 9: {
                this.deploySummaryPanel.updateActivatedLicenseNumber(this.licenseInformationPanel.getAllValidLicenses().size());
                break;
            }
        }
        super.showStage(stage);
    }

    @Override
    protected void commit() {
        ConsoleLogger.log("Commit Called");
    }

    public boolean isRenewalFlow() {
        return !this.operationSelectPanel.isActivateNewLicenseSelected() && this.elsLicensesList.size() > 0;
    }

    public ArrayList<ElsLicenseObject> getElsLicensesList() {
        return this.elsLicensesList;
    }

    protected ArrayList<ElsLicenseObject> getSeletecedLicenseList() {
        return this.seletecedLicenseList;
    }

    public void setSeletecedLicenseList(ArrayList<ElsLicenseObject> seletecedLicenseList) {
        this.seletecedLicenseList = seletecedLicenseList;
    }

    public LicenseUtils.INFO_REQUIRED getInfoRequired() {
        return this.infoRequired;
    }

    public void setInfoRequired(LicenseUtils.INFO_REQUIRED infoRequired) {
        this.infoRequired = infoRequired;
    }

    public JButton getjBNext() {
        return this.jBNext;
    }

    @Override
    protected String getDefaultContentSensitiveHelpToken() {
        return "sesm_admin_licenses_license_activation_wizard";
    }

    @Override
    protected int getCurrentStageIndex() {
        return super.getCurrentStageIndex();
    }

    protected JButton getjBBack() {
        return this.jBBack;
    }

    @Override
    protected void jBBack_actionPerformed() {
        super.jBBack_actionPerformed();
    }

    @Override
    protected void jBNext_actionPerformed() {
        PagePanel pane;
        if (this.getCurrentStageIndex() == 9 && (pane = MainPanel.getOverviewPanel()) != null && pane instanceof OverviewPanel) {
            ((OverviewPanel)pane).setNeedPanelRefresh(true);
        }
        super.jBNext_actionPerformed();
    }

    @Override
    protected Object getCurrentStageComponent() {
        return super.getCurrentStageComponent();
    }
}

