/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.rpc.LicenseStatusInfo;
import com.sygate.scm.common.configobject.schema.ElsLicense;
import com.sygate.scm.common.configobject.schema.License;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseException;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.JLabelHyperLinkData;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseDateRender;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationModel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseInformationRowSorter;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseTableListenersImpl;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseValidityRenderer;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.symantec.slic.SlicException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class LicenseActivationHandler {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";

    public static ArrayList<String> readLicensesFile(String fileName) throws IOException, LicenseException {
        ArrayList list;
        Path filePath = Path.of(fileName, new String[0]);
        String fileData = Files.readString(filePath, Charset.defaultCharset());
        try {
            list = LicenseUtils.parseLicensesXML((String)fileData, (boolean)false);
        }
        catch (LicenseException e) {
            ConsoleLogger.logError(e.getMessage());
            ConsoleLogger.logError("License file in error: " + fileName);
            throw e;
        }
        return list;
    }

    public static ArrayList<ElsLicenseObject> parseLicense(ArrayList<String> licenseXMLs) throws LicenseException {
        ArrayList<ElsLicenseObject> newLicensesList = new ArrayList<ElsLicenseObject>();
        for (String xml : licenseXMLs) {
            try {
                ArrayList list = LicenseUtils.parseLicense((String)xml);
                if (list == null) continue;
                for (ElsLicense lic : list) {
                    int index;
                    ElsLicenseObject newLicense = new ElsLicenseObject(lic);
                    boolean duplicated = false;
                    for (ElsLicenseObject license : newLicensesList) {
                        if (!LicenseUtils.licensesIdentical((ElsLicense)license.getElsLicense(), (ElsLicense)newLicense.getElsLicense())) continue;
                        duplicated = true;
                        break;
                    }
                    if (duplicated) continue;
                    for (index = 0; index < newLicensesList.size() && newLicensesList.get(index).getExpireDate() < newLicense.getExpireDate(); ++index) {
                    }
                    newLicensesList.add(index, newLicense);
                }
            }
            catch (LicenseException e) {
                ConsoleLogger.logError("Parse license raw data error");
                ConsoleLogger.log(e);
                ConsoleLogger.logError("License String in error: " + xml);
                throw e;
            }
        }
        return newLicensesList;
    }

    static boolean isLicenseExpired(ElsLicenseObject licenseObject) {
        return licenseObject.getExpireDate() < System.currentTimeMillis();
    }

    public static boolean isLicenseExpiring(ElsLicenseObject licenseObject) {
        return licenseObject.getWarnDate() < System.currentTimeMillis();
    }

    public static boolean isLicenseValid(ElsLicenseObject licenseObject, LICENSE_FLOW licenseFlow) throws LicenseException {
        try {
            Integer intLicenseState;
            boolean isSEPSB = false;
            if (LicenseObject.getInstance().isSEPSBProduct()) {
                isSEPSB = true;
            }
            LicenseActivationHandler.checkLicenseProductType(licenseObject);
            if (licenseFlow.isNewLicense() && LicenseHandler.licenseExists(licenseObject)) {
                throw new LicenseException(770, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importLicenseExists"));
            }
            if (LicenseUtils.isTrialwareLicense((ElsLicense)licenseObject.getElsLicense()) && !(intLicenseState = LicenseHandler.getLicenseState()).equals(License.SEPE_TRIAL) && !intLicenseState.equals(License.SEPSB_TRIAL)) {
                throw new LicenseException(772, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.cannotImportTrialwareLicense"));
            }
            if (!licenseFlow.isExpiredLicenseAllowed() && LicenseActivationHandler.isLicenseExpired(licenseObject)) {
                String msg = null;
                String url = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.PartnerResellerLink");
                msg = licenseFlow == LICENSE_FLOW.LICENSE_INFORMATION_NEW ? (isSEPSB ? Utilities.getLocalizedMessage("AdminPanel.licenseExpiredSBE", new Object[]{url}) : Utilities.getLocalizedMessage("AdminPanel.licenseExpiredEE", new Object[]{url})) : (isSEPSB ? Utilities.getLocalizedMessage("AdminPanel.licenseExpiredExpiringSBE", new Object[]{url}) : Utilities.getLocalizedMessage("AdminPanel.licenseExpiredExpiringEE", new Object[]{url}));
                throw new LicenseException(769, msg);
            }
            return true;
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
        catch (SlicException e) {
            ConsoleLogger.log(e);
        }
        return false;
    }

    public static ElsLicense getLicenseById(String licenseId) {
        try {
            for (LicenseChainObject chainObj : LicenseHandler.getLicenseChains()) {
                for (ElsLicense lic : chainObj.getLicenseChain().getElsLicense()) {
                    if (!lic.getId().endsWith(licenseId)) continue;
                    return lic;
                }
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return null;
    }

    private static boolean checkLicenseProductType(ElsLicenseObject licenseObject) throws LicenseException {
        if ("SEPSB".equalsIgnoreCase(licenseObject.getProductType()) && !LicenseObject.getInstance().isSBProduct() || "SEPE".equalsIgnoreCase(licenseObject.getProductType()) && LicenseObject.getInstance().isSBProduct()) {
            throw new LicenseException(773, LicenseActivationHandler.getErrormessage());
        }
        boolean isSnacEnabled = false;
        boolean isSAVEnabled = false;
        if (LicenseObject.getInstance().isSNACOnlyProduct()) {
            isSnacEnabled = true;
            isSAVEnabled = false;
        } else if (LicenseObject.getInstance().isSAVOnlyProduct()) {
            isSnacEnabled = false;
            isSAVEnabled = true;
        } else {
            isSnacEnabled = true;
            isSAVEnabled = true;
        }
        if (licenseObject.isSEPLicense() && !isSAVEnabled || licenseObject.isSNACLicense() && !isSnacEnabled) {
            throw new LicenseException(773, LicenseActivationHandler.getErrormessage());
        }
        return true;
    }

    private static String getErrormessage() {
        String msg = null;
        String url = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.PartnerResellerLink");
        msg = LicenseObject.getInstance().isSEPSBProduct() ? Utilities.getLocalizedMessage("AdminPanel.unCompatibleProductLicenseSBE", new Object[]{url}) : Utilities.getLocalizedMessage("AdminPanel.unCompatibleProductLicenseEE", new Object[]{url});
        return msg;
    }

    public static void renewLicense(ArrayList<ElsLicenseObject> renewalLicenses, ArrayList<ElsLicenseObject> validNewLicenses) throws LicenseException, ConsoleException {
        for (ElsLicenseObject license : validNewLicenses) {
            if (LicenseActivationHandler.isLicenseValid(license, LICENSE_FLOW.LICENSE_INFORMATION_NEW)) continue;
            LicenseException exception = new LicenseException();
            exception.setErrorType(2);
            throw exception;
        }
        ArrayList<LicenseChainObject> deletingChain = new ArrayList<LicenseChainObject>();
        if (renewalLicenses != null) {
            ArrayList<String> idArr = new ArrayList<String>();
            for (ElsLicenseObject els : renewalLicenses) {
                idArr.add(els.getId());
            }
            block2: for (LicenseChainObject chain : LicenseHandler.getLicenseChains()) {
                for (ElsLicenseObject els : chain.getLicenses()) {
                    if (!idArr.contains(els.getId())) continue;
                    deletingChain.add(chain);
                    continue block2;
                }
            }
        }
        for (LicenseChainObject chain : deletingChain) {
            LicenseHandler.removeLicenseChainFromSystem(chain);
        }
        LicenseActivationHandler.addNewLicenses(validNewLicenses);
    }

    public static void addNewLicenses(ArrayList<ElsLicenseObject> validLicenses) throws LicenseException, ConsoleException {
        LicenseActivationHandler.addNewLicenses(validLicenses, LICENSE_FLOW.LICENSE_INFORMATION_NEW);
    }

    public static boolean checkLicenseValidState(Component parentComponent) {
        try {
            if (LicenseActivationHandler.isUnknownLicenseState()) {
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.ui", "QuickStartDialog.licenseUnknownStatusMessage");
                JOptionPane.showMessageDialog(parentComponent, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MessageResources.getInstance().getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                return false;
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            return false;
        }
        return true;
    }

    public static boolean isUnknownLicenseState() throws ConsoleException {
        LicenseStatusInfo licenseStatusInfo = LicenseHandler.getLicenseStatusForSAV();
        if (licenseStatusInfo == null) {
            licenseStatusInfo = LicenseHandler.getLicenseStatusForSNAC();
        }
        if (licenseStatusInfo != null) {
            String licenseStateString = licenseStatusInfo.getlicenseState();
            return licenseStateString.toUpperCase().endsWith("UNKNOWN");
        }
        return true;
    }

    public static void addNewLicenses(ArrayList<ElsLicenseObject> validLicenses, LICENSE_FLOW licenseFlow) throws LicenseException, ConsoleException {
        if (validLicenses == null || validLicenses.size() == 0) {
            return;
        }
        for (ElsLicenseObject license : validLicenses) {
            if (LicenseActivationHandler.isLicenseValid(license, licenseFlow)) continue;
            LicenseException exception = new LicenseException();
            exception.setErrorType(2);
            throw exception;
        }
        ArrayList<ElsLicenseObject> paidLicenses = new ArrayList<ElsLicenseObject>();
        ElsLicenseObject trialwareLicense = null;
        for (ElsLicenseObject licenseObject : validLicenses) {
            try {
                if (LicenseUtils.isTrialwareLicense((ElsLicense)licenseObject.getElsLicense())) {
                    trialwareLicense = licenseObject;
                    continue;
                }
                paidLicenses.add(licenseObject);
            }
            catch (SlicException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        if (trialwareLicense != null && paidLicenses.size() == 0) {
            TrialwareLicenseObject twLicense = new TrialwareLicenseObject(LicenseUtils.getTrialwareLicense((ElsLicense)trialwareLicense.getElsLicense()));
            LicenseHandler.addTrialwareLicenseToSystem(twLicense);
            return;
        }
        ArrayList<ElsLicenseObject> sortedPaidLicenses = LicenseActivationHandler.sortLicenses(paidLicenses);
        for (ElsLicenseObject lic : sortedPaidLicenses) {
            LicenseChainObject newLicenseChain = LicenseHandler.newLicenseChain(lic);
            LicenseHandler.addLicenseChainToSystem(newLicenseChain, licenseFlow);
        }
    }

    public static ArrayList<ElsLicenseObject> getRecoverableLicenses() throws ConsoleException {
        ArrayList<ElsLicenseObject> list = new ArrayList<ElsLicenseObject>();
        ArrayList chains = LicenseUtils.getDeletedLicenseChains((SemConfigRoot)DataobjectManager.getInstance().getSemConfigRoot());
        if (chains != null) {
            for (LicenseChain chain : chains) {
                if (chain.getChildren().size() <= 0) continue;
                list.add(new ElsLicenseObject((ElsLicense)chain.getChildren().get(chain.getChildren().size() - 1)));
            }
        }
        return list;
    }

    public static void recoverLicenses(ArrayList<ElsLicenseObject> recoverableLicenses) throws LicenseException, ConsoleException {
        LicenseActivationHandler.addNewLicenses(recoverableLicenses, LICENSE_FLOW.LICENSE_RECOVERY_LIST);
    }

    public static JTable createLicenseInformationTable(ArrayList<ElsLicenseObject> licenseList, LICENSE_FLOW licenseFlow) {
        return LicenseActivationHandler.createLicenseInformationTable(licenseList, licenseFlow, null);
    }

    public static JTable createLicenseInformationTable(ArrayList<ElsLicenseObject> licenseList, LICENSE_FLOW licenseFlow, JButton jBNext) {
        LicenseInformationModel model = null;
        model = new LicenseInformationModel(licenseList, licenseFlow);
        StripesTable table = new StripesTable(model, false, false);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            table.putClientProperty("dynamicEventsEnabled", true);
            table.putClientProperty("mouseEventListener", "onClick");
        });
        model.addMouseListenerToHeaderInTable((JTable)((Object)table));
        if (licenseFlow.isLicenseSelectable()) {
            LicenseTableListenersImpl impl = new LicenseTableListenersImpl((JTable)((Object)table), jBNext);
            model.addTableModelListener(impl);
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                Point p = new Point(e.getX(), e.getY());
                int col = target.columnAtPoint(p);
                int row = target.rowAtPoint(p);
                if (target.getValueAt(row, col) instanceof JLabelHyperLinkData) {
                    JLabelHyperLinkData value = (JLabelHyperLinkData)target.getValueAt(row, col);
                    Rectangle rec = target.getCellRect(row, col, false);
                    int x = rec.x + rec.width;
                    if (e.getPoint().x <= x) {
                        LicenseActivationHandler.showLicenseInvalidDetails(target, value);
                    }
                }
            }
        };
        table.addMouseListener(mouseAdapter);
        LicenseActivationHandler.initTableCellRender((JTable)((Object)table), model);
        if (!licenseFlow.isLicenseSelectable()) {
            table.removeColumn(table.getColumnModel().getColumn(0));
            UIUtilities.setTableColumnWidth((JTable)((Object)table), new float[]{0.2f, 0.4f, 0.05f, 0.15f, 0.2f}, (int)table.getPreferredScrollableViewportSize().getWidth());
        } else {
            UIUtilities.setTableColumnWidth((JTable)((Object)table), new float[]{0.05f, 0.2f, 0.35f, 0.05f, 0.15f, 0.2f}, (int)table.getPreferredScrollableViewportSize().getWidth());
        }
        return table;
    }

    private static ArrayList<ElsLicenseObject> sortLicenses(ArrayList<ElsLicenseObject> paidLicenses) {
        ArrayList<ElsLicenseObject> sortedLicenses = new ArrayList<ElsLicenseObject>();
        sortedLicenses.addAll(paidLicenses);
        Comparator<ElsLicenseObject> comp = new Comparator<ElsLicenseObject>(){

            @Override
            public int compare(ElsLicenseObject obj1, ElsLicenseObject obj2) {
                if (obj1 != null && obj1.getElsLicense() != null && obj1.getElsLicense().getOptEndDateString() != null && obj2 != null && obj2.getElsLicense() != null && obj2.getElsLicense().getOptEndDateString() != null) {
                    return obj1.getElsLicense().getOptEndDateString().compareTo(obj2.getElsLicense().getOptEndDateString());
                }
                return 0;
            }
        };
        Collections.sort(sortedLicenses, comp);
        return sortedLicenses;
    }

    private static void showLicenseInvalidDetails(Component parent, JLabelHyperLinkData data) {
        HTMLEditorPane panel = IPLLicenseHandler.getHyperLinkEditorPane(data.getInvalidReason(), "", true, 350);
        JOptionPane.showMessageDialog(parent, panel, MSGRES.getString(ADMINDIALOG, "LicenseInformationPanel.invalidLicenseTitle"), 1);
    }

    private static void initTableCellRender(JTable table, LicenseInformationModel model) {
        LicenseInformationRowSorter sorter = new LicenseInformationRowSorter(model, table.getColumnModel().getColumnCount() - 1);
        table.setRowSorter(sorter);
        LicenseDateRender dateRender = new LicenseDateRender();
        table.setDefaultRenderer(Long.class, dateRender);
        TableColumn statusLastColumn = table.getColumnModel().getColumn(table.getColumnModel().getColumnCount() - 1);
        LicenseValidityRenderer render = new LicenseValidityRenderer(table);
        render.setHorizontalAlignment(0);
        statusLastColumn.setCellRenderer(render);
    }

    public static enum LICENSE_FLOW {
        LICENSE_INFORMATION_NEW,
        LICENSE_INFORMATION_RENEWAL,
        LICENSE_RENEWAL_LIST,
        LICENSE_RECOVERY_LIST,
        UNKNOWN;


        public boolean isLicenseSelectable() {
            switch (this) {
                case LICENSE_INFORMATION_NEW: 
                case LICENSE_INFORMATION_RENEWAL: {
                    return false;
                }
                case LICENSE_RECOVERY_LIST: 
                case LICENSE_RENEWAL_LIST: {
                    return true;
                }
            }
            return false;
        }

        public boolean isNewLicense() {
            switch (this) {
                case LICENSE_INFORMATION_NEW: 
                case LICENSE_RECOVERY_LIST: {
                    return true;
                }
                case LICENSE_INFORMATION_RENEWAL: 
                case LICENSE_RENEWAL_LIST: {
                    return false;
                }
            }
            return false;
        }

        public boolean isExpiredLicenseAllowed() {
            switch (this) {
                case LICENSE_RECOVERY_LIST: {
                    return true;
                }
                case LICENSE_INFORMATION_NEW: 
                case LICENSE_INFORMATION_RENEWAL: 
                case LICENSE_RENEWAL_LIST: {
                    return false;
                }
            }
            return false;
        }
    }
}

