/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.console.ui.admin.iplLicense.IPLInformationPanel;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.InfoInputPanel;
import com.sygate.scm.console.util.ConsoleLogger;
import com.symantec.slic.ipl.CityError;
import com.symantec.slic.ipl.CompanyNameError;
import com.symantec.slic.ipl.ContactNameError;
import com.symantec.slic.ipl.EmailAddressError;
import com.symantec.slic.ipl.InputValidator;
import com.symantec.slic.ipl.PhoneNumberError;
import com.symantec.slic.ipl.PostalCodeError;
import com.symantec.slic.ipl.StateOrProvinceError;
import com.symantec.slic.ipl.StreetAddressError;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class InfoTextFieldPanel
extends InfoInputPanel {
    private static final long serialVersionUID = 1L;
    private InfoInputPanel.INPUT_FIELD_VALIDATION validationRule = InfoInputPanel.INPUT_FIELD_VALIDATION.NO_VALIDATION;
    private IPLInformationPanel iPLInformationPanel = null;

    public InfoTextFieldPanel(String desc, InfoInputPanel.INPUT_FIELD_VALIDATION inValidationRule) {
        super(desc, new JTextField());
        this.validationRule = inValidationRule;
        this.setValidationRule();
    }

    public InfoTextFieldPanel(String desc, InfoInputPanel.INPUT_FIELD_VALIDATION inValidationRule, IPLInformationPanel parent) {
        super(desc, new JTextField());
        this.iPLInformationPanel = parent;
        this.validationRule = inValidationRule;
        this.setValidationRule();
    }

    @Override
    protected String getInputText() {
        return ((JTextField)this.inputJComponent).getText().trim();
    }

    @Override
    protected void setInputText(String str) {
        ((JTextField)this.inputJComponent).setText(str);
    }

    @Override
    protected JTextField getJComponent() {
        return (JTextField)this.inputJComponent;
    }

    protected final void setValidationRule() {
        switch (this.validationRule) {
            case ADDRESS_FILED_LINE1_VALIDATION: {
                this.getJComponent().addFocusListener(new AdressLine1InputBoxFocusListener());
                break;
            }
            case ADDRESS_FILED_LINE2_VALIDATION: {
                this.getJComponent().addFocusListener(new AdressLine2InputBoxFocusListener());
                break;
            }
            case ADDRESS_FILED_LINE3_VALIDATION: {
                this.getJComponent().addFocusListener(new AdressLine3InputBoxFocusListener());
                break;
            }
            case CITY_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new CityInputBoxFocusListener());
                break;
            }
            case COMPANY_NAME_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new CompanyNameInputBoxFocusListener());
                break;
            }
            case POSTAL_CODE_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new PostalCodeInputBoxFocusListener());
                break;
            }
            case STATE_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new StateOrProvinceInputBoxFocusListener());
                break;
            }
            case EMAIL_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new EmailInputBoxFocusListener());
                break;
            }
            case FIRST_NAME_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new FirstNameInputBoxFocusListener());
                break;
            }
            case LAST_NAME_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new LastNameInputBoxFocusListener());
                break;
            }
            case PHONE_NUMBER_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new PhoneNumberInputBoxFocusListener());
                break;
            }
        }
    }

    static interface IPLInfoFocusListener
    extends FocusListener {
    }

    private class PhoneNumberInputBoxFocusListener
    implements IPLInfoFocusListener {
        private PhoneNumberInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String phoneNumberStr = InfoTextFieldPanel.this.getInputText();
            PhoneNumberError phoneNumberError = InputValidator.validatePhoneNumber((String)phoneNumberStr);
            String msg = IPLLicenseHandler.processPhoneNumberError(phoneNumberError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class CompanyNameInputBoxFocusListener
    implements IPLInfoFocusListener {
        private CompanyNameInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String companyNameStr = InfoTextFieldPanel.this.getInputText();
            CompanyNameError companyNameError = InputValidator.validateCompanyName((String)companyNameStr);
            String msg = IPLLicenseHandler.processCompanyNameError(companyNameError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class LastNameInputBoxFocusListener
    implements IPLInfoFocusListener {
        private LastNameInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String contactNameStr = InfoTextFieldPanel.this.getInputText();
            ContactNameError contactNameError = InputValidator.validateName((String)contactNameStr);
            String msg = IPLLicenseHandler.processContactLastNameError(contactNameError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class FirstNameInputBoxFocusListener
    implements IPLInfoFocusListener {
        private FirstNameInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String contactNameStr = InfoTextFieldPanel.this.getInputText();
            ContactNameError contactNameError = InputValidator.validateName((String)contactNameStr);
            String msg = IPLLicenseHandler.processContactFirstNameError(contactNameError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class PostalCodeInputBoxFocusListener
    implements IPLInfoFocusListener {
        private PostalCodeInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String postalCodeStr = InfoTextFieldPanel.this.getInputText();
            PostalCodeError postalCodeError = InputValidator.validatePostalCode((String)postalCodeStr);
            String msg = IPLLicenseHandler.processPostalCodeError(postalCodeError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class StateOrProvinceInputBoxFocusListener
    implements IPLInfoFocusListener {
        private StateOrProvinceInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String stateOrProvinceStr = InfoTextFieldPanel.this.getInputText();
            String countryCodeStr = null;
            countryCodeStr = InfoTextFieldPanel.this.iPLInformationPanel == null ? "US" : InfoTextFieldPanel.this.iPLInformationPanel.getCurrentCountryCode();
            StateOrProvinceError stateOrProvinceError = InputValidator.validateStateOrProvince((String)stateOrProvinceStr, (String)countryCodeStr);
            String msg = IPLLicenseHandler.processStateOrProvinceError(stateOrProvinceError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class EmailInputBoxFocusListener
    implements IPLInfoFocusListener {
        private EmailInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String emailAddressStr = InfoTextFieldPanel.this.getInputText();
            EmailAddressError emailAddressError = InputValidator.validateEmailAddress((String)emailAddressStr);
            String msg = IPLLicenseHandler.processEmailAddressError(emailAddressError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class CityInputBoxFocusListener
    implements IPLInfoFocusListener {
        private CityInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String cityStr = InfoTextFieldPanel.this.getInputText();
            CityError cityError = InputValidator.validateCity((String)cityStr);
            String msg = IPLLicenseHandler.processCityError(cityError, true);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class AdressLine3InputBoxFocusListener
    extends AdressInputBoxFocusListener {
        public AdressLine3InputBoxFocusListener() {
            this.lineNo = 3;
        }
    }

    private class AdressLine2InputBoxFocusListener
    extends AdressInputBoxFocusListener {
        public AdressLine2InputBoxFocusListener() {
            this.lineNo = 2;
        }
    }

    private class AdressLine1InputBoxFocusListener
    extends AdressInputBoxFocusListener {
        public AdressLine1InputBoxFocusListener() {
            this.lineNo = 1;
        }
    }

    private class AdressInputBoxFocusListener
    implements IPLInfoFocusListener {
        protected int lineNo = 1;

        private AdressInputBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String streetAddressStr = InfoTextFieldPanel.this.getInputText();
            StreetAddressError streetAddressError = InputValidator.validateAddressLine((String)streetAddressStr, (int)this.lineNo);
            String msg = IPLLicenseHandler.processStreetAddressError(streetAddressError, true, this.lineNo);
            if (msg == null) {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoTextFieldPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }
}

