/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class InfoInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private JEditorPane inputBoxErrorEditorPane = new JEditorPane();
    private JLabel inputBoxLabel = null;
    private String desc = null;
    protected JComponent inputJComponent = null;
    protected int hasError = 0;
    private Border defaultBorder = null;

    public InfoInputPanel(String desc, JComponent inComponent) {
        this.setInputJComponent(inComponent);
        this.initialize(desc);
        this.getInputBoxErrorEditorPane().setContentType("text/html");
        this.getInputBoxErrorEditorPane().setEditable(false);
        this.getInputBoxErrorEditorPane().setOpaque(false);
        this.getInputBoxErrorEditorPane().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpUtil.showURL(e);
                }
            }
        });
    }

    private final void initialize(String desc) {
        if (desc == null) {
            ConsoleLogger.log("No description specified.");
            return;
        }
        this.inputBoxLabel = new JLabel(desc, 4);
        this.desc = desc;
        this.defaultBorder = this.getJComponent().getBorder();
        this.setLayout(new GridBagLayout());
        JPanel inputPanel = new JPanel(new FlowLayout(0, 15, 2));
        inputPanel.add(this.inputBoxLabel);
        inputPanel.add(this.inputJComponent);
        this.add((Component)inputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.add((Component)this.getInputBoxErrorEditorPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 0, 5, 15), 0, 0));
        this.getInputBoxErrorEditorPane().setVisible(false);
    }

    protected JLabel getInputBoxLabel() {
        return this.inputBoxLabel;
    }

    protected abstract JComponent getJComponent();

    protected abstract String getInputText();

    protected abstract void setInputText(String var1);

    protected void setPanelFont(Font font) {
        this.inputBoxLabel.setFont(font);
        this.inputJComponent.setFont(font);
    }

    protected void setInputBoxErrorLabelInfo(boolean isVisible, String textStr) {
        this.setInputBoxErrorLabelInfo(isVisible, textStr, null);
    }

    protected void setInputBoxErrorLabelInfo(boolean isVisible, String textStr, String errorCode) {
        if (errorCode != null) {
            textStr = (String)textStr + "<BR>" + MSGRES.getString(ADMINDIALOG, "ErrorCode") + " (" + errorCode + ")";
        }
        if (isVisible) {
            String hyperLinkText = IPLLicenseHandler.getHTMLTextInRed((String)textStr);
            this.getInputBoxErrorEditorPane().setText(hyperLinkText);
            Dimension dim = IPLLicenseHandler.getPreferredSize(new JLabel(), hyperLinkText, true, 250);
            this.getInputBoxErrorEditorPane().setPreferredSize(new Dimension(dim.width, dim.height + 20));
            this.getJComponent().setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            this.getInputBoxErrorEditorPane().setVisible(isVisible);
            this.hasError = 1;
        } else {
            this.getInputBoxErrorEditorPane().setVisible(isVisible);
            this.getInputBoxErrorEditorPane().setText(null);
            this.getJComponent().setBorder(this.defaultBorder);
            this.hasError = 0;
        }
    }

    protected final JEditorPane getInputBoxErrorEditorPane() {
        return this.inputBoxErrorEditorPane;
    }

    public String getDesc() {
        return this.desc;
    }

    public final void setInputJComponent(JComponent inputJComponent) {
        this.inputJComponent = inputJComponent;
    }

    public static enum INPUT_FIELD_VALIDATION {
        NO_VALIDATION,
        ADDRESS_FILED_LINE1_VALIDATION,
        ADDRESS_FILED_LINE2_VALIDATION,
        ADDRESS_FILED_LINE3_VALIDATION,
        CITY_FILED_VALIDATION,
        COMPANY_NAME_FILED_VALIDATION,
        POSTAL_CODE_FILED_VALIDATION,
        STATE_FILED_VALIDATION,
        EMAIL_FILED_VALIDATION,
        FIRST_NAME_FILED_VALIDATION,
        LAST_NAME_FILED_VALIDATION,
        PHONE_NUMBER_FILED_VALIDATION,
        COUNTRY_FILED_VALIDATION,
        STATEORPROVINCE_FILED_VALIDATION;

    }
}

