/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.console.ui.admin.iplLicense.IPLInformationPanel;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.InfoInputPanel;
import com.sygate.scm.console.ui.admin.iplLicense.InfoTextFieldPanel;
import com.sygate.scm.console.util.ConsoleLogger;
import com.symantec.slic.ipl.CountryError;
import com.symantec.slic.ipl.InputValidator;
import com.symantec.slic.ipl.StateOrProvinceError;
import java.awt.event.FocusEvent;
import javax.swing.JComboBox;

public class InfoComboBoxPanel
extends InfoInputPanel {
    private static final long serialVersionUID = 1L;
    private InfoInputPanel.INPUT_FIELD_VALIDATION validationRule = InfoInputPanel.INPUT_FIELD_VALIDATION.NO_VALIDATION;
    private IPLInformationPanel iPLInformationPanel = null;

    public InfoComboBoxPanel(String desc, String[] itemsStr, InfoInputPanel.INPUT_FIELD_VALIDATION inValidationRule, IPLInformationPanel parent) {
        super(desc, new JComboBox<String>(itemsStr));
        this.validationRule = inValidationRule;
        this.iPLInformationPanel = parent;
        switch (this.validationRule) {
            case COUNTRY_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new CountryComboBoxFocusListener());
                break;
            }
            case STATEORPROVINCE_FILED_VALIDATION: {
                this.getJComponent().addFocusListener(new StateorprovinceComboBoxFocusListener());
                break;
            }
        }
    }

    @Override
    protected String getInputText() {
        return ((JComboBox)this.inputJComponent).getSelectedItem().toString().trim();
    }

    @Override
    protected void setInputText(String str) {
        ((JComboBox)this.inputJComponent).setSelectedItem(str);
    }

    @Override
    protected JComboBox<?> getJComponent() {
        return (JComboBox)this.inputJComponent;
    }

    private class CountryComboBoxFocusListener
    implements InfoTextFieldPanel.IPLInfoFocusListener {
        private CountryComboBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String countryStr = InfoComboBoxPanel.this.getInputText();
            CountryError countryError = InputValidator.validateCountry((String)countryStr);
            String msg = IPLLicenseHandler.processCountryError(countryError, true);
            if (msg == null) {
                InfoComboBoxPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoComboBoxPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }

    private class StateorprovinceComboBoxFocusListener
    implements InfoTextFieldPanel.IPLInfoFocusListener {
        private StateorprovinceComboBoxFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            String stateorprovinceStr = InfoComboBoxPanel.this.getInputText();
            String countryCodeStr = null;
            countryCodeStr = InfoComboBoxPanel.this.iPLInformationPanel == null ? "US" : InfoComboBoxPanel.this.iPLInformationPanel.getCurrentCountryCode();
            StateOrProvinceError stateorprovinceError = InputValidator.validateStateOrProvince((String)stateorprovinceStr, (String)countryCodeStr);
            String msg = IPLLicenseHandler.processStateOrProvinceError(stateorprovinceError, true);
            if (msg == null) {
                InfoComboBoxPanel.this.setInputBoxErrorLabelInfo(false, null);
            } else {
                InfoComboBoxPanel.this.setInputBoxErrorLabelInfo(true, msg);
                ConsoleLogger.log(msg);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }
}

