/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.rpc.IPLEntitlement;
import com.sygate.scm.common.configobject.rpc.IPLGeneralError;
import com.sygate.scm.common.configobject.rpc.IPLRequest;
import com.sygate.scm.common.configobject.rpc.IPLResponse;
import com.sygate.scm.common.configobject.rpc.IPLSerialNumber;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.util.HTMLEditorPane;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.HTMLUtilities;
import com.symantec.slic.ipl.CityError;
import com.symantec.slic.ipl.CompanyInfo;
import com.symantec.slic.ipl.CompanyNameError;
import com.symantec.slic.ipl.ContactNameError;
import com.symantec.slic.ipl.CountryError;
import com.symantec.slic.ipl.EmailAddressError;
import com.symantec.slic.ipl.PhoneNumberError;
import com.symantec.slic.ipl.PostalCodeError;
import com.symantec.slic.ipl.SerialNumberError;
import com.symantec.slic.ipl.StateOrProvinceError;
import com.symantec.slic.ipl.StreetAddressError;
import com.symantec.slic.ipl.TechnicalContactInfo;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.View;

public class IPLLicenseHandler {
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private static final String ADMINIPLDIALOG = "com.sygate.scm.console.ui.admin.dlg.adminIPLdialog";
    private IPLResponse rpcIPLResponse = null;
    private final HashMap<String, String> licenseEntitlement = new HashMap();
    private CompanyInfo companyInfo = null;
    private TechnicalContactInfo technicalContactInfo = null;

    public boolean downloadEntitlements(Set<String> serialNumbers, LicenseUtils.INFO_REQUIRED infoRequired) {
        if (serialNumbers.isEmpty()) {
            return false;
        }
        IPLRequest iPLRequest = new IPLRequest();
        iPLRequest.setOptInfoRequired(Integer.valueOf(infoRequired.getValue()));
        for (String tmpStr : serialNumbers) {
            IPLSerialNumber iPLSerialNumber = new IPLSerialNumber();
            iPLSerialNumber.setOptIPLSerialNumber(tmpStr);
            iPLRequest.addIPLSerialNumber(iPLSerialNumber);
        }
        long start = System.currentTimeMillis();
        IPLResponse iPLResponse = null;
        try {
            iPLResponse = LicenseHandler.getEntitlementsFromIPL(iPLRequest);
        }
        catch (ConsoleException e1) {
            ConsoleLogger.log(e1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, IPLLicenseHandler.getHyperLinkEditorPane(e1.getMessage(), "", true, 290), MSGRES.getString(IPLLicenseHandler.ADMINDIALOG, "IPLLicenseHandler.error"), 0);
                }
            });
            return false;
        }
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        ConsoleLogger.log("DownloadEntitlements() call (IPL) Duration: " + Long.toString(elapsedTimeMillis) + " ms");
        if (iPLResponse.getOptResponseType().intValue() == LicenseUtils.IPL_RESPONSE_TYPE.IPL_ENTITLEMENT.getValue()) {
            this.processIPLEntitlement(iPLResponse);
        }
        this.rpcIPLResponse = iPLResponse;
        return true;
    }

    void processIPLGeneralErrorException(IPLResponse iPLResponse) {
        IPLGeneralError iPLGeneralError = iPLResponse.getOptIPLGeneralError();
        String msg = null;
        LicenseUtils.IPL_GENERAL_ERROR_REASON reason = LicenseUtils.IPL_GENERAL_ERROR_REASON.fromValue((int)iPLGeneralError.getOptReason());
        switch (reason) {
            case INTERNAL_ERROR: {
                msg = MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.slicinternalerror");
                break;
            }
            case SERVER_COMMUNICATION_FAILURE: {
                msg = MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.serverCommunicationFailure");
                break;
            }
            case SERVER_CONNECTION_FAILURE: {
                msg = MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.serverConnectionFailure");
                break;
            }
            case INVALID_REQUEST: 
            case TOO_MANY_REQUESTS_FROM_IP: 
            case SERVER_DETECTED_TAMPERING: {
                msg = MSGRES.getString(ADMINIPLDIALOG, "LicenseActivationWizardDialog.invalidRequest");
                break;
            }
            case SERVER_DECLARED_REQUEST_INVALID: 
            case SERVER_RESPONSE_INVALID: {
                msg = LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_INTERNAL_ERROR.toErrorMessage();
                break;
            }
            case TRADE_COMPLIANCE_IP_CHECK_FAILED: {
                msg = LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_TRADE_COMPLIANCE_IP_CHECK_FAILED.toErrorMessage();
                break;
            }
            default: {
                msg = LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_NO_MESSAGE.toErrorMessage();
                ConsoleLogger.log("IPL GeneralError condition: UNKNOWN");
            }
        }
        if (iPLGeneralError.getOptErrorCode() != null) {
            JOptionPane.showMessageDialog(null, IPLLicenseHandler.getHyperLinkEditorPane(msg, iPLGeneralError.getOptErrorCode(), true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
        } else {
            JOptionPane.showMessageDialog(null, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLLicenseHandler.error"), 0);
        }
        ConsoleLogger.log(msg);
    }

    private void processIPLEntitlement(IPLResponse iPLResponse) {
        Vector iPLEntitlementVector = iPLResponse.getIPLEntitlement();
        for (IPLEntitlement tmpEn : iPLEntitlementVector) {
            String value = tmpEn.getOptContent();
            this.licenseEntitlement.put(tmpEn.getOptIPLSerialNumber(), value);
        }
        if (!this.licenseEntitlement.isEmpty()) {
            Integer totalSize = 0;
            Set<Map.Entry<String, String>> entrySet = this.licenseEntitlement.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String em = entry.getValue();
                ConsoleLogger.log("Size of Entitlement (IPL): " + em.length());
                totalSize = totalSize + em.length();
            }
            ConsoleLogger.log("Total size of Entitlements (IPL): " + totalSize.toString());
        }
    }

    public static HTMLEditorPane getHyperLinkEditorPane(String errorMessage, String errorCode, boolean width, int prefSize) {
        HTMLEditorPane hyperLinkEditorPane = new HTMLEditorPane();
        String hyperLinkText = null;
        hyperLinkText = errorCode != null && !errorCode.isEmpty() ? IPLLicenseHandler.getHTMLText(errorMessage + "<BR>" + MSGRES.getString(ADMINDIALOG, "ErrorCode") + " (" + errorCode + ") </BR>") : IPLLicenseHandler.getHTMLText(errorMessage);
        hyperLinkEditorPane.setText(hyperLinkText);
        if (hyperLinkEditorPane.getPreferredSize().getWidth() >= (double)prefSize) {
            Dimension dim = IPLLicenseHandler.getPreferredSize(new JLabel(), hyperLinkText, width, prefSize);
            hyperLinkEditorPane.setPreferredSize(new Dimension(dim.width, dim.height + 3));
        }
        return hyperLinkEditorPane;
    }

    public static Dimension getPreferredSize(JLabel resizer, String html, boolean width, int prefSize) {
        resizer.setText(html);
        View view = (View)resizer.getClientProperty("html");
        view.setSize(width ? (float)prefSize : 0.0f, width ? 0.0f : (float)prefSize);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
    }

    public static HtmlEnabledJLabel createLinkLabel(String text) {
        HtmlEnabledJLabel link = new HtmlEnabledJLabel(text, true);
        link.putClientProperty((Object)"cssClass", (Object)"licenseHelpPanelLink");
        link.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return link;
    }

    public static HtmlEnabledJLabel getslfFileHelpLabel() {
        HtmlEnabledJLabel jLblHelpLink = new HtmlEnabledJLabel(MSGRES.getString(ADMINDIALOG, "UploadLicenseFilesPanel.slfFileHelp"), true);
        jLblHelpLink.setIcon((Icon)ConsoleMain.whatsThisIcon);
        jLblHelpLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                IPLLicenseHandler.showSlfFileHelp();
            }
        });
        return jLblHelpLink;
    }

    public static void showHelpChoiceActivateOrRenewalLicense() {
        HelpUtil.showHelp("sesm_admin_license_wizard_activation_choice_activate_renewal_license");
    }

    public static void showSlfFileHelp() {
        HelpUtil.showHelp("sesm_admin_license_wizard_activation_whatisa_slf_file");
    }

    public static void showRenewLicenseHelp() {
        HelpUtil.showHelp("sesm_admin_license_wizard_renewal_whydoi_needto_dothis");
    }

    public static String getHyperLinkText(String strContent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><body><a href=\"#\">");
        buffer.append(strContent);
        buffer.append("</a></body></html>");
        return buffer.toString();
    }

    public static String getHTMLText(String strContent) {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY><DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + "\">");
        strBuffDesc.append(strContent);
        strBuffDesc.append("</DIV>");
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    public static String getHTMLTextWithDefaultFont(String strContent) {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY><DIV>");
        strBuffDesc.append(strContent);
        strBuffDesc.append("</DIV>");
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    public static String getHTMLTextInRed(String strContent) {
        StringBuffer strBuffDesc = new StringBuffer();
        strBuffDesc.append("<HTML><BODY><DIV " + HTMLUtilities.WIZARD_CONTENT_STYLE_STD + " \" color=\"red\">");
        strBuffDesc.append(strContent);
        strBuffDesc.append("</DIV>");
        strBuffDesc.append("</BODY></HTML>");
        return strBuffDesc.toString();
    }

    public IPLResponse getIPLResponse() {
        return this.rpcIPLResponse;
    }

    public HashMap<String, String> getEntitlement() {
        return this.licenseEntitlement;
    }

    public TechnicalContactInfo getTechnicalContactInfo() {
        return this.technicalContactInfo;
    }

    public CompanyInfo getCompanyInfo() {
        return this.companyInfo;
    }

    public void setTechnicalContactInfo(TechnicalContactInfo technicalContactInfo) {
        this.technicalContactInfo = technicalContactInfo;
    }

    public void setCompanyInfo(CompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    protected String getKeyFromValue(HashMap<String, String> hm, String value) {
        for (Map.Entry<String, String> o : hm.entrySet()) {
            if (!o.getValue().equals(value)) continue;
            return o.getKey();
        }
        return null;
    }

    public static String processCityError(CityError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_CITY_ERROR_REASON reason = LicenseUtils.processCityError((CityError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_CITY_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processPostalCodeError(PostalCodeError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_POSTALCODE_ERROR_REASON reason = LicenseUtils.processPostalCodeError((PostalCodeError)error);
        String msg = reason.getErrorMessage().toErrorMessage();
        if (isLocalValidation && reason == LicenseUtils.IPL_POSTALCODE_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return msg;
    }

    public static String processStateOrProvinceError(StateOrProvinceError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_STATEORPROVINCE_ERROR_REASON reason = LicenseUtils.processStateOrProvinceError((StateOrProvinceError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_STATEORPROVINCE_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processCountryError(CountryError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_COUNTRY_ERROR_REASON reason = LicenseUtils.processCountryError((CountryError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_COUNTRY_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processCompanyNameError(CompanyNameError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_COMPANYNAME_ERROR_REASON reason = LicenseUtils.processCompanyNameError((CompanyNameError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_COMPANYNAME_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processSerialNumberError(SerialNumberError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_SERIALNUMBER_ERROR_REASON reason = LicenseUtils.processSerialNumberError((SerialNumberError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_SERIALNUMBER_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processContactFirstNameError(ContactNameError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_FIRST_CONTACTNAME_ERROR_REASON reason = LicenseUtils.processFirstContactNameError((ContactNameError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_FIRST_CONTACTNAME_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processContactLastNameError(ContactNameError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_LAST_CONTACTNAME_ERROR_REASON reason = LicenseUtils.processLastContactNameError((ContactNameError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_LAST_CONTACTNAME_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processEmailAddressError(EmailAddressError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_EMAILADDRESS_ERROR_REASON reason = LicenseUtils.processEmailAddressError((EmailAddressError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_EMAILADDRESS_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processPhoneNumberError(PhoneNumberError error, boolean isLocalValidation) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_PHONENUMBER_ERROR_REASON reason = LicenseUtils.processPhoneNumberError((PhoneNumberError)error);
        if (isLocalValidation && reason == LicenseUtils.IPL_PHONENUMBER_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }

    public static String processStreetAddressError(StreetAddressError error, boolean isLocalValidation, int lineNo) {
        if (error == null) {
            return null;
        }
        LicenseUtils.IPL_STREETADDRESS_ERROR_REASON reason = LicenseUtils.processStreetAddressError((StreetAddressError)error, (int)lineNo);
        if (isLocalValidation && reason == LicenseUtils.IPL_STREETADDRESS_ERROR_REASON.FIELD_IS_MANDATORY) {
            return null;
        }
        return reason.getErrorMessage().toErrorMessage();
    }
}

