/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.iplLicense;

import com.sygate.scm.common.configobject.rpc.IPLUserInputError;
import com.sygate.scm.common.configobject.schema.IPLCompanyContactInfo;
import com.sygate.scm.common.configobject.schema.IPLTechContactInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.InfoComboBoxPanel;
import com.sygate.scm.console.ui.admin.iplLicense.InfoInputPanel;
import com.sygate.scm.console.ui.admin.iplLicense.InfoTextFieldPanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class IPLInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String ADMINDIALOG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private static final String COUNTRYCODE = "US:AL:DZ:AS:AD:AO:AI:AG:AR:AM:AW:AU:AT:AZ:BS:BH:BB:BY:BE:BZ:BJ:BM:BT:BO:BA:BW:BV:BR:IO:BN:BG:BF:BI:KH:CM:CA:CV:KY:CF:TD:CL:CN:CX:CC:CO:KM:CG:CD:CK:CR:CI:HR:CY:CS:DK:DJ:DM:DO:TP:EC:EG:SV:GQ:ER:EE:ET:FK:FO:FJ:FI:FR:GF:PF:TF:GA:GM:GE:DE:GH:GI:GR:GL:GD:GP:GU:GT:GN:GW:GY:HT:HM:VA:HN:HK:HU:IS:IN:ID:IE:IL:IT:JM:JP:JO:KZ:KE:KI:KR:KW:KG:LA:LV:LB:LS:LR:LY:LI:LT:LX:LU:MO:MK:MG:MW:MY:MV:ML:MT:MH:MQ:MR:MU:YT:MX:FM:MD:MC:MN:MS:MA:MZ:MM:NA:NR:NP:NL:AN:NC:NZ:NI:NE:NG:NU:NF:MP:NO:ZR:FX:OM:PK:PW:PS:PA:PG:PY:BD:PE:PH:PN:PL:PT:PR:QA:RE:RO:RU:RW:SH:KN:LC:PM:VC:WS:SM:ST:SA:SN:CS:SC:SL:sg:SK:SI:SB:SO:ZA:GS:ES:LK:SR:SJ:SZ:SE:CH:TW:TJ:TZ:TH:TG:TK:TO:TT:TN:TR:TM:TC:TV:UG:UA:AE:UK:UM:UY:UZ:VU:VE:VN:VG:VI:WF:EH:YE:YU:ZM:ZW";
    private LicenseActivationWizardDialog parent = null;
    private String[] countryStrings = MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.countryStrings").split(":");
    private String[] countryISOCode = "US:AL:DZ:AS:AD:AO:AI:AG:AR:AM:AW:AU:AT:AZ:BS:BH:BB:BY:BE:BZ:BJ:BM:BT:BO:BA:BW:BV:BR:IO:BN:BG:BF:BI:KH:CM:CA:CV:KY:CF:TD:CL:CN:CX:CC:CO:KM:CG:CD:CK:CR:CI:HR:CY:CS:DK:DJ:DM:DO:TP:EC:EG:SV:GQ:ER:EE:ET:FK:FO:FJ:FI:FR:GF:PF:TF:GA:GM:GE:DE:GH:GI:GR:GL:GD:GP:GU:GT:GN:GW:GY:HT:HM:VA:HN:HK:HU:IS:IN:ID:IE:IL:IT:JM:JP:JO:KZ:KE:KI:KR:KW:KG:LA:LV:LB:LS:LR:LY:LI:LT:LX:LU:MO:MK:MG:MW:MY:MV:ML:MT:MH:MQ:MR:MU:YT:MX:FM:MD:MC:MN:MS:MA:MZ:MM:NA:NR:NP:NL:AN:NC:NZ:NI:NE:NG:NU:NF:MP:NO:ZR:FX:OM:PK:PW:PS:PA:PG:PY:BD:PE:PH:PN:PL:PT:PR:QA:RE:RO:RU:RW:SH:KN:LC:PM:VC:WS:SM:ST:SA:SN:CS:SC:SL:sg:SK:SI:SB:SO:ZA:GS:ES:LK:SR:SJ:SZ:SE:CH:TW:TJ:TZ:TH:TG:TK:TO:TT:TN:TR:TM:TC:TV:UG:UA:AE:UK:UM:UY:UZ:VU:VE:VN:VG:VI:WF:EH:YE:YU:ZM:ZW".split(":");
    private HashMap<String, String> countryMap = new HashMap();
    private String[] usStateStrings = MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.usStateStrings").split(":");
    private String[] canadaStateStrings = MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.canadaStateStrings").split(":");
    private DescriptionTextArea descTechContact;
    private DescriptionTextArea descCompany;
    private DescriptionTextArea descPrimaryContact;
    private JLabel descCompanyLabel;
    private JLabel descPrimaryContactLabel;
    private JLabel descTechnicalContactLabel;
    private JLabel allFieldsRequiredCompLabel;
    private JLabel allFieldsRequiredTechLabel;
    private JLabel allFieldsRequiredPrimLabel;
    private String title;
    private LicenseUtils.INFO_REQUIRED infoRequired = LicenseUtils.INFO_REQUIRED.NO_INFO_REQUIRED;
    private JScrollPane infoPane = null;
    private IPLLicenseHandler iplLicenseHandler = null;
    private InfoTextFieldPanel primaryFirstNamePanel = null;
    private InfoTextFieldPanel primaryLastNamePanel = null;
    private InfoTextFieldPanel primaryContactPhonePanel = null;
    private InfoTextFieldPanel primaryEmailPanel = null;
    private InfoTextFieldPanel techFirstNamePanel = null;
    private InfoTextFieldPanel techLastNamePanel = null;
    private InfoTextFieldPanel techContactPhonePanel = null;
    private InfoTextFieldPanel techEmailPanel = null;
    private InfoTextFieldPanel companyNamePanel = null;
    private InfoTextFieldPanel mailingAddressPanel = null;
    private InfoTextFieldPanel addressSecondPanel = null;
    private InfoTextFieldPanel addressThirdPanel = null;
    private InfoComboBoxPanel addressCountryPanel = null;
    private InfoTextFieldPanel addressCityPanel = null;
    private InfoTextFieldPanel addressPostalCodePanel = null;
    private InfoComboBoxPanel usAddressStateOrProvincePanel = null;
    private InfoComboBoxPanel canadaAddressStateOrProvincePanel = null;
    private InfoTextFieldPanel otherAddressStateOrProvincePanel = null;
    private JPanel stateOrProvinceCardsPanel = null;
    public static final String COUNTRY_CODE_US = "US";
    public static final String COUNTRY_CODE_CANADA = "CA";
    public static final String COUNTRY_STRING_OTHER = "Other";
    private String currentCountryCode = "US";
    private List<InfoInputPanel> infoInputPanelList = new LinkedList<InfoInputPanel>();
    private JCheckBox legalDisclaimerChkButton = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.legalStatementChkBoxStr"));
    private DescriptionTextArea legalDisclaimerDes = new DescriptionTextArea(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.legalStatement"));
    private JCheckBox sameinfoChkButton = new JCheckBox(MSGRES.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLInformationPanel.sameinfoChkBoxStr"));

    public IPLInformationPanel(LicenseUtils.INFO_REQUIRED infoRequired, LicenseActivationWizardDialog parent, IPLLicenseHandler inIPLLicenseHandler) {
        this.parent = parent;
        this.setInfoRequired(infoRequired);
        this.iplLicenseHandler = inIPLLicenseHandler;
        if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == infoRequired) {
            this.initializeCountryMap();
            this.descCompany = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companydescription"));
            this.descPrimaryContact = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companycontactdescription"));
            this.title = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companytitle");
            this.descCompanyLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companydescriptionContent"));
            this.descPrimaryContactLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.primarycontactdescriptionContent"));
            this.allFieldsRequiredCompLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
            this.allFieldsRequiredPrimLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
        } else if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == infoRequired) {
            this.descTechContact = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.technicalcontactdescription"));
            this.title = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.technicalcontacttitle");
            this.descTechnicalContactLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.technicalcontactdescriptionContent"));
            this.allFieldsRequiredTechLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == infoRequired) {
            this.initializeCountryMap();
            this.descCompany = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companydescription"));
            this.descTechContact = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.technicalcontactdescription"));
            this.descPrimaryContact = new DescriptionTextArea(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companycontactdescription"));
            this.title = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.bothinfotitle");
            this.descCompanyLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companydescriptionContent"));
            this.descPrimaryContactLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.primarycontactdescriptionContent"));
            this.descTechnicalContactLabel = new JLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.technicalcontactdescriptionContent"));
            this.allFieldsRequiredTechLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
            this.allFieldsRequiredCompLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
            this.allFieldsRequiredPrimLabel = new HtmlEnabledJLabel(IPLLicenseHandler.getHTMLText(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.allfieldsrequired")));
        }
        this.initPanel(infoRequired);
    }

    private void initPanel(LicenseUtils.INFO_REQUIRED infoRequired) {
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(this.title, "");
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == infoRequired) {
            JPanel infoPanel = new JPanel(new GridBagLayout());
            infoPanel.add((Component)this.descCompany, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descCompanyLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredCompLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getCompanyInfoPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descPrimaryContact, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descPrimaryContactLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredPrimLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getPrimaryContactPanel(), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getLagalDisclaimerPanel(), new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add(Box.createGlue(), new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.infoPane = new JScrollPane(infoPanel, 20, 30);
            this.infoPane.setPreferredSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setMinimumSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setBorder(null);
            this.add((Component)this.infoPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.prepopulateCompanyInfo();
            this.prepopulateCompanyName();
        } else if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == infoRequired) {
            JPanel infoPanel = new JPanel(new GridBagLayout());
            infoPanel.add((Component)this.descTechContact, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descTechnicalContactLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredTechLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getTechnicalContactPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getLagalDisclaimerPanel(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add(Box.createGlue(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.infoPane = new JScrollPane(infoPanel, 20, 30);
            this.infoPane.setPreferredSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setMinimumSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setBorder(null);
            this.add((Component)this.infoPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.prepopulateTechInfo();
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == infoRequired) {
            JPanel infoPanel = new JPanel(new GridBagLayout());
            infoPanel.add((Component)this.descCompany, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descCompanyLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredCompLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getCompanyInfoPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descPrimaryContact, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descPrimaryContactLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredPrimLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getPrimaryContactPanel(), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.sameinfoChkButton, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descTechContact, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.descTechnicalContactLabel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.allFieldsRequiredTechLabel, new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getTechnicalContactPanel(), new GridBagConstraints(0, 12, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add((Component)this.getLagalDisclaimerPanel(), new GridBagConstraints(0, 13, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 10, 25), 0, 0));
            infoPanel.add(Box.createGlue(), new GridBagConstraints(0, 14, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.infoPane = new JScrollPane(infoPanel, 20, 30);
            this.infoPane.setPreferredSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setMinimumSize(LicenseActivationWizardDialog.SCROLL_PANE_DIMENSION);
            this.infoPane.setBorder(null);
            this.add((Component)this.infoPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.prepopulateTechInfo();
            this.prepopulateCompanyInfo();
            this.prepopulateCompanyName();
            this.sameinfoChkButton.setSelected(false);
            this.setTechnicalContactPanelVisible(true);
            ItemListener sameinfoChkButtonItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (IPLInformationPanel.this.isSameinfoChkButtonSelected()) {
                        IPLInformationPanel.this.setTechnicalContactPanelVisible(false);
                    } else {
                        IPLInformationPanel.this.setTechnicalContactPanelVisible(true);
                    }
                }
            };
            this.sameinfoChkButton.addItemListener(sameinfoChkButtonItemListener);
        }
        this.setWizardFont(UIFontUtilities.STANDARD_FONT);
        this.setWizardBigFont(UIFontUtilities.BOLD_FONT);
        this.setWidth(infoRequired);
    }

    public void setInfoPaneViewPosition() {
        this.infoPane.getViewport().setViewPosition(new Point(0, 0));
    }

    private void setTechnicalContactPanelVisible(boolean isVisible) {
        this.descTechContact.setVisible(isVisible);
        this.descTechnicalContactLabel.setVisible(isVisible);
        this.allFieldsRequiredTechLabel.setVisible(isVisible);
        this.techFirstNamePanel.setVisible(isVisible);
        this.techLastNamePanel.setVisible(isVisible);
        this.techContactPhonePanel.setVisible(isVisible);
        this.techEmailPanel.setVisible(isVisible);
        if (isVisible) {
            if (!this.infoInputPanelList.contains(this.techFirstNamePanel)) {
                this.infoInputPanelList.add(this.techFirstNamePanel);
            }
            if (!this.infoInputPanelList.contains(this.techLastNamePanel)) {
                this.infoInputPanelList.add(this.techLastNamePanel);
            }
            if (!this.infoInputPanelList.contains(this.techContactPhonePanel)) {
                this.infoInputPanelList.add(this.techContactPhonePanel);
            }
            if (!this.infoInputPanelList.contains(this.techEmailPanel)) {
                this.infoInputPanelList.add(this.techEmailPanel);
            }
        } else {
            if (this.infoInputPanelList.contains(this.techFirstNamePanel)) {
                this.infoInputPanelList.remove(this.techFirstNamePanel);
            }
            if (this.infoInputPanelList.contains(this.techLastNamePanel)) {
                this.infoInputPanelList.remove(this.techLastNamePanel);
            }
            if (this.infoInputPanelList.contains(this.techContactPhonePanel)) {
                this.infoInputPanelList.remove(this.techContactPhonePanel);
            }
            if (this.infoInputPanelList.contains(this.techEmailPanel)) {
                this.infoInputPanelList.remove(this.techEmailPanel);
            }
        }
        ConsoleLogger.log(String.valueOf(this.infoInputPanelList.size()));
    }

    private void setWidth(LicenseUtils.INFO_REQUIRED infoRequired) {
        Dimension dimension = null;
        if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == infoRequired) {
            dimension = new Dimension(250, this.primaryFirstNamePanel.getJComponent().getPreferredSize().height);
        } else if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == infoRequired) {
            dimension = new Dimension(250, this.techFirstNamePanel.getJComponent().getPreferredSize().height);
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == infoRequired) {
            dimension = new Dimension(250, this.primaryFirstNamePanel.getJComponent().getPreferredSize().height);
        }
        JComponent[] tempLabel = new JLabel[this.infoInputPanelList.size()];
        int i = 0;
        for (InfoInputPanel tempPanel : this.infoInputPanelList) {
            if (tempPanel.getJComponent() != null) {
                tempPanel.getJComponent().setPreferredSize(dimension);
                tempPanel.getJComponent().setMaximumSize(dimension);
            }
            tempLabel[i] = tempPanel.getInputBoxLabel();
            ++i;
        }
        UIUtilities.fitJComponent(tempLabel);
    }

    private void prepopulateCompanyName() {
        if (this.companyNamePanel.getInputText() == null || this.companyNamePanel.getInputText().isEmpty()) {
            this.companyNamePanel.setInputText(LicenseHandler.getCompanyName());
        }
    }

    private void prepopulateTechInfo() {
        IPLTechContactInfo techContactInfo = LicenseHandler.prepopulateTechContactInfo();
        if (techContactInfo != null && techContactInfo.getOptTechContactFirstName() != null && techContactInfo.getOptTechContactLastName() != null && techContactInfo.getOptTechContactEmailAddress() != null && techContactInfo.getOptTechContactPhoneNumber() != null) {
            this.iplLicenseHandler.setTechnicalContactInfo(LicenseUtils.createTechnicalContactInfo((String)techContactInfo.getOptTechContactFirstName(), (String)techContactInfo.getOptTechContactLastName(), (String)techContactInfo.getOptTechContactEmailAddress(), (String)techContactInfo.getOptTechContactPhoneNumber()));
        }
        if (this.iplLicenseHandler.getTechnicalContactInfo() != null) {
            this.techFirstNamePanel.setInputText(this.iplLicenseHandler.getTechnicalContactInfo().getContactName().getFirstName());
            this.techLastNamePanel.setInputText(this.iplLicenseHandler.getTechnicalContactInfo().getContactName().getLastName());
            this.techContactPhonePanel.setInputText(this.iplLicenseHandler.getTechnicalContactInfo().getPhoneNumber());
            this.techEmailPanel.setInputText(this.iplLicenseHandler.getTechnicalContactInfo().getEmailAddress());
        }
    }

    private void prepopulateCompanyInfo() {
        IPLCompanyContactInfo companyContactInfo = LicenseHandler.prepopulateCompanyContactInfo(this.countryMap);
        if (companyContactInfo != null && companyContactInfo.getOptContactFirstName() != null && companyContactInfo.getOptContactLastName() != null && companyContactInfo.getOptCompanyInfoAddress1() != null && companyContactInfo.getOptCompanyInfoAddress2() != null && companyContactInfo.getOptCompanyInfoAddress3() != null && companyContactInfo.getOptCompanyInfoCity() != null && companyContactInfo.getOptCompanyInfoCountry() != null && companyContactInfo.getOptCompanyInfoPostalCode() != null && companyContactInfo.getOptCompanyInfoState() != null && companyContactInfo.getOptCompanyName() != null && companyContactInfo.getOptContactPhoneNumber() != null && companyContactInfo.getOptContactEmailAddress() != null) {
            this.iplLicenseHandler.setCompanyInfo(LicenseUtils.createCompanyInfo((String)companyContactInfo.getOptContactFirstName(), (String)companyContactInfo.getOptContactLastName(), (String)companyContactInfo.getOptCompanyInfoAddress1(), (String)companyContactInfo.getOptCompanyInfoAddress2(), (String)companyContactInfo.getOptCompanyInfoAddress3(), (String)companyContactInfo.getOptCompanyInfoCity(), (String)companyContactInfo.getOptCompanyInfoCountry(), (String)companyContactInfo.getOptCompanyInfoPostalCode(), (String)companyContactInfo.getOptCompanyInfoState(), (String)companyContactInfo.getOptCompanyName(), (String)companyContactInfo.getOptContactPhoneNumber(), (String)companyContactInfo.getOptContactEmailAddress()));
        }
        if (this.iplLicenseHandler.getCompanyInfo() != null) {
            this.primaryFirstNamePanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getContactName().getFirstName());
            this.primaryLastNamePanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getContactName().getLastName());
            this.primaryContactPhonePanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getPhoneNumber());
            this.primaryEmailPanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getEmailAddress());
            this.companyNamePanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getCompanyName());
            this.mailingAddressPanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getStreetAddress().getFirstLine());
            this.addressSecondPanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getStreetAddress().getSecondLine());
            this.addressThirdPanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getStreetAddress().getThirdLine());
            this.addressCityPanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getCity());
            this.addressPostalCodePanel.setInputText(this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getPostalCode());
            String countryCode = this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getCountry();
            String stateStr = this.iplLicenseHandler.getCompanyInfo().getMailingAddress().getStateOrProvince();
            if (this.countryMap.containsKey(countryCode)) {
                this.addressCountryPanel.setInputText(this.countryMap.get(countryCode));
            } else {
                this.addressCountryPanel.setInputText(this.countryMap.get(COUNTRY_CODE_US));
            }
            if (countryCode.equals(COUNTRY_CODE_US)) {
                this.usAddressStateOrProvincePanel.setInputText(stateStr);
            } else if (countryCode.equals(COUNTRY_CODE_CANADA)) {
                this.canadaAddressStateOrProvincePanel.setInputText(stateStr);
            } else {
                this.otherAddressStateOrProvincePanel.setInputText(stateStr);
            }
            this.setCurrentCountryCode(countryCode);
        }
    }

    private void initializeCountryMap() {
        for (int i = 0; i < this.countryStrings.length; ++i) {
            this.countryMap.put(this.countryISOCode[i], this.countryStrings[i]);
        }
    }

    private JPanel getPrimaryContactPanel() {
        JPanel companyinfopanel = new JPanel(new GridBagLayout());
        this.primaryFirstNamePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.contactFirstName") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.FIRST_NAME_FILED_VALIDATION);
        this.primaryLastNamePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.contactLastName") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.LAST_NAME_FILED_VALIDATION);
        this.primaryContactPhonePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.phoneNumber") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.PHONE_NUMBER_FILED_VALIDATION, this);
        this.primaryEmailPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.emailAddress") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.EMAIL_FILED_VALIDATION);
        int y = 0;
        companyinfopanel.add((Component)this.primaryFirstNamePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.primaryLastNamePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.primaryEmailPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.primaryContactPhonePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.infoInputPanelList.add(this.primaryFirstNamePanel);
        this.infoInputPanelList.add(this.primaryLastNamePanel);
        this.infoInputPanelList.add(this.primaryContactPhonePanel);
        this.infoInputPanelList.add(this.primaryEmailPanel);
        return companyinfopanel;
    }

    private JPanel getCompanyInfoPanel() {
        JPanel companyinfopanel = new JPanel(new GridBagLayout());
        this.companyNamePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.companyName") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.COMPANY_NAME_FILED_VALIDATION);
        this.mailingAddressPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressFirstLine") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.ADDRESS_FILED_LINE1_VALIDATION);
        this.addressSecondPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressSecondLine") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.ADDRESS_FILED_LINE2_VALIDATION);
        this.addressThirdPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressThirdLine") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.ADDRESS_FILED_LINE3_VALIDATION);
        this.addressCityPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressCity") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.CITY_FILED_VALIDATION);
        this.addressPostalCodePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressPostalCode") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.POSTAL_CODE_FILED_VALIDATION);
        this.addressCountryPanel = new InfoComboBoxPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressCountry") + ":", this.countryStrings, InfoInputPanel.INPUT_FIELD_VALIDATION.COUNTRY_FILED_VALIDATION, this);
        this.addressCountryPanel.setInputText(this.countryMap.get(COUNTRY_CODE_US));
        this.usAddressStateOrProvincePanel = new InfoComboBoxPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressStateOrProvince") + ":", this.usStateStrings, InfoInputPanel.INPUT_FIELD_VALIDATION.STATEORPROVINCE_FILED_VALIDATION, this);
        this.canadaAddressStateOrProvincePanel = new InfoComboBoxPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressStateOrProvince") + ":", this.canadaStateStrings, InfoInputPanel.INPUT_FIELD_VALIDATION.STATEORPROVINCE_FILED_VALIDATION, this);
        this.otherAddressStateOrProvincePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.addressStateOrProvince") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.STATE_FILED_VALIDATION);
        this.stateOrProvinceCardsPanel = new JPanel(new CardLayout(0, 0));
        this.stateOrProvinceCardsPanel.add((Component)this.usAddressStateOrProvincePanel, this.countryMap.get(COUNTRY_CODE_US));
        this.stateOrProvinceCardsPanel.add((Component)this.canadaAddressStateOrProvincePanel, this.countryMap.get(COUNTRY_CODE_CANADA));
        this.stateOrProvinceCardsPanel.add((Component)this.otherAddressStateOrProvincePanel, COUNTRY_STRING_OTHER);
        ((JComboBox)this.addressCountryPanel.getJComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CardLayout cl = (CardLayout)IPLInformationPanel.this.stateOrProvinceCardsPanel.getLayout();
                String countryStr = (String)evt.getItem();
                String countryCode = IPLInformationPanel.this.iplLicenseHandler.getKeyFromValue(IPLInformationPanel.this.countryMap, countryStr);
                IPLInformationPanel.this.setCurrentCountryCode(countryCode);
                if (countryCode.equals(IPLInformationPanel.COUNTRY_CODE_US)) {
                    cl.show(IPLInformationPanel.this.stateOrProvinceCardsPanel, countryStr);
                } else if (countryCode.equals(IPLInformationPanel.COUNTRY_CODE_CANADA)) {
                    cl.show(IPLInformationPanel.this.stateOrProvinceCardsPanel, countryStr);
                } else {
                    cl.show(IPLInformationPanel.this.stateOrProvinceCardsPanel, IPLInformationPanel.COUNTRY_STRING_OTHER);
                }
                IPLInformationPanel.this.processCardErrorMessage(countryCode);
            }
        });
        int y = 0;
        companyinfopanel.add((Component)this.companyNamePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.mailingAddressPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.addressSecondPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.addressThirdPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.addressCountryPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.stateOrProvinceCardsPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.addressCityPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        companyinfopanel.add((Component)this.addressPostalCodePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.infoInputPanelList.add(this.companyNamePanel);
        this.infoInputPanelList.add(this.mailingAddressPanel);
        this.infoInputPanelList.add(this.addressSecondPanel);
        this.infoInputPanelList.add(this.addressThirdPanel);
        this.infoInputPanelList.add(this.addressCityPanel);
        this.infoInputPanelList.add(this.addressPostalCodePanel);
        this.infoInputPanelList.add(this.addressCountryPanel);
        this.infoInputPanelList.add(this.usAddressStateOrProvincePanel);
        this.infoInputPanelList.add(this.canadaAddressStateOrProvincePanel);
        this.infoInputPanelList.add(this.otherAddressStateOrProvincePanel);
        return companyinfopanel;
    }

    private void processCardErrorMessage(String countryCode) {
        if (this.usAddressStateOrProvincePanel.hasError == 1) {
            this.usAddressStateOrProvincePanel.getInputBoxErrorEditorPane().setVisible(countryCode.equals(COUNTRY_CODE_US));
        }
        if (this.canadaAddressStateOrProvincePanel.hasError == 1) {
            this.canadaAddressStateOrProvincePanel.getInputBoxErrorEditorPane().setVisible(countryCode.equals(COUNTRY_CODE_CANADA));
        }
        if (this.otherAddressStateOrProvincePanel.hasError == 1) {
            this.otherAddressStateOrProvincePanel.getInputBoxErrorEditorPane().setVisible(!countryCode.equals(COUNTRY_CODE_US) && !countryCode.equals(COUNTRY_CODE_CANADA));
        }
    }

    private JPanel getTechnicalContactPanel() {
        JPanel technicalContactPanel = new JPanel(new GridBagLayout());
        this.techFirstNamePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.contactFirstName") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.FIRST_NAME_FILED_VALIDATION);
        this.techLastNamePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.contactLastName") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.LAST_NAME_FILED_VALIDATION);
        this.techContactPhonePanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.phoneNumber") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.PHONE_NUMBER_FILED_VALIDATION, this);
        this.techEmailPanel = new InfoTextFieldPanel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.emailAddress") + ":", InfoInputPanel.INPUT_FIELD_VALIDATION.EMAIL_FILED_VALIDATION);
        int y = 0;
        technicalContactPanel.add((Component)this.techFirstNamePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        technicalContactPanel.add((Component)this.techLastNamePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        technicalContactPanel.add((Component)this.techEmailPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        technicalContactPanel.add((Component)this.techContactPhonePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.infoInputPanelList.add(this.techFirstNamePanel);
        this.infoInputPanelList.add(this.techLastNamePanel);
        this.infoInputPanelList.add(this.techContactPhonePanel);
        this.infoInputPanelList.add(this.techEmailPanel);
        return technicalContactPanel;
    }

    private JPanel getLagalDisclaimerPanel() {
        JPanel legalDisclaimerPanel = new JPanel(new GridBagLayout());
        String legalDisclaimerStr = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.legalStatementText");
        final JTextArea legalDisclaimerTextDes = new JTextArea(legalDisclaimerStr);
        HtmlEnabledJLabel printButton = new HtmlEnabledJLabel(MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.printButtonText"), true);
        MouseAdapter printButtonListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ae) {
                try {
                    legalDisclaimerTextDes.print();
                }
                catch (PrinterException e) {
                    ConsoleLogger.log(e);
                }
            }
        };
        printButton.addMouseListener((MouseListener)printButtonListener);
        printButton.setBorder(BorderFactory.createEmptyBorder());
        this.legalDisclaimerChkButton.setSelected(false);
        ItemListener legalDisclaimerChkButtonItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (IPLInformationPanel.this.isLegalDisclaimerChkButtonSelected()) {
                    IPLInformationPanel.this.parent.enableNetxButton(true);
                } else {
                    IPLInformationPanel.this.parent.enableNetxButton(false);
                }
            }
        };
        this.legalDisclaimerChkButton.addItemListener(legalDisclaimerChkButtonItemListener);
        legalDisclaimerTextDes.setEditable(false);
        legalDisclaimerTextDes.setLineWrap(true);
        legalDisclaimerTextDes.setWrapStyleWord(true);
        legalDisclaimerTextDes.setPreferredSize(IPLLicenseHandler.getPreferredSize(new JLabel(), IPLLicenseHandler.getHTMLText(legalDisclaimerStr), true, 450));
        JScrollPane legalDisclaimerPane = new JScrollPane(legalDisclaimerTextDes);
        legalDisclaimerPane.setHorizontalScrollBarPolicy(31);
        legalDisclaimerPane.setVerticalScrollBarPolicy(21);
        legalDisclaimerPanel.add((Component)this.legalDisclaimerDes, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        legalDisclaimerPanel.add((Component)legalDisclaimerPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> legalDisclaimerPanel.add((Component)printButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0)));
        legalDisclaimerPanel.add((Component)this.legalDisclaimerChkButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        return legalDisclaimerPanel;
    }

    public boolean isLegalDisclaimerChkButtonSelected() {
        return this.legalDisclaimerChkButton.isSelected();
    }

    public boolean isSameinfoChkButtonSelected() {
        return this.sameinfoChkButton.isSelected();
    }

    public boolean isValidated() {
        String firstLine;
        String primaryTelephoneNumber;
        String primaryLastName;
        String primaryFirstName;
        String primaryContactEmailAddress;
        boolean isValid = true;
        int hasError = 0;
        if (!this.isLegalDisclaimerChkButtonSelected()) {
            String msg = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.legalStatementUnselected");
            JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
            ConsoleLogger.log(msg);
            return false;
        }
        for (InfoInputPanel tempPanel : this.infoInputPanelList) {
            FocusListener[] f;
            if (!tempPanel.isVisible()) continue;
            for (FocusListener listener : f = tempPanel.getJComponent().getFocusListeners()) {
                if (!(listener instanceof InfoTextFieldPanel.IPLInfoFocusListener)) continue;
                listener.focusLost(null);
            }
            hasError += tempPanel.hasError;
        }
        if (hasError > 0) {
            String msg = MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.hasError");
            JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, "", true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
            ConsoleLogger.log(msg);
            return false;
        }
        if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == this.infoRequired) {
            primaryContactEmailAddress = this.primaryEmailPanel.getInputText();
            primaryFirstName = this.primaryFirstNamePanel.getInputText();
            primaryLastName = this.primaryLastNamePanel.getInputText();
            primaryTelephoneNumber = this.primaryContactPhonePanel.getInputText();
            String stateOrProvince = null;
            String country = this.addressCountryPanel.getInputText();
            firstLine = this.mailingAddressPanel.getInputText();
            String secondLine = this.addressSecondPanel.getInputText();
            String thirdLine = this.addressThirdPanel.getInputText();
            String city = this.addressCityPanel.getInputText();
            String postalCode = this.addressPostalCodePanel.getInputText();
            String name = this.companyNamePanel.getInputText();
            String countryCode = this.iplLicenseHandler.getKeyFromValue(this.countryMap, country);
            if (this.isStrEmpty(primaryFirstName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryFirstNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryLastName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryLastNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryTelephoneNumber, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryContactPhonePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryContactEmailAddress, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryEmailPanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(name, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_COMPANY_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.companyNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(firstLine, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_IS_MANDATORY.toErrorMessage(), this.mailingAddressPanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(city, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_CITY_FIELD_IS_MANDATORY.toErrorMessage(), this.addressCityPanel)) {
                isValid = false;
            }
            if (countryCode.equals(COUNTRY_CODE_US)) {
                stateOrProvince = this.usAddressStateOrProvincePanel.getInputText();
            } else if (countryCode.equals(COUNTRY_CODE_CANADA)) {
                stateOrProvince = this.canadaAddressStateOrProvincePanel.getInputText();
            } else {
                stateOrProvince = this.otherAddressStateOrProvincePanel.getInputText();
                if (this.isStrEmpty(stateOrProvince, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_STATE_PROVINCE_FIELD_IS_MANDATORY.toErrorMessage(), this.otherAddressStateOrProvincePanel)) {
                    isValid = false;
                }
            }
            if (isValid) {
                this.iplLicenseHandler.setCompanyInfo(LicenseUtils.createCompanyInfo((String)primaryFirstName, (String)primaryLastName, (String)firstLine, (String)secondLine, (String)thirdLine, (String)city, (String)countryCode, (String)postalCode, (String)stateOrProvince, (String)name, (String)primaryTelephoneNumber, (String)primaryContactEmailAddress));
                LicenseHandler.saveCompanyContactInfo(this.iplLicenseHandler.getCompanyInfo(), this.countryMap);
            }
        } else if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == this.infoRequired) {
            String techContactEmailAddress = this.techEmailPanel.getInputText();
            String techFirstName = this.techFirstNamePanel.getInputText();
            String techLastName = this.techLastNamePanel.getInputText();
            String techTelephoneNumber = this.techContactPhonePanel.getInputText();
            if (this.isStrEmpty(techFirstName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.techFirstNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(techLastName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.techLastNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(techTelephoneNumber, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY.toErrorMessage(), this.techContactPhonePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(techContactEmailAddress, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY.toErrorMessage(), this.techEmailPanel)) {
                isValid = false;
            }
            if (isValid) {
                this.iplLicenseHandler.setTechnicalContactInfo(LicenseUtils.createTechnicalContactInfo((String)techFirstName, (String)techLastName, (String)techContactEmailAddress, (String)techTelephoneNumber));
                LicenseHandler.saveTechContactInfo(this.iplLicenseHandler.getTechnicalContactInfo());
            }
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == this.infoRequired) {
            primaryContactEmailAddress = this.primaryEmailPanel.getInputText();
            primaryFirstName = this.primaryFirstNamePanel.getInputText();
            primaryLastName = this.primaryLastNamePanel.getInputText();
            primaryTelephoneNumber = this.primaryContactPhonePanel.getInputText();
            String stateOrProvince = null;
            String country = this.addressCountryPanel.getInputText();
            firstLine = this.mailingAddressPanel.getInputText();
            String secondLine = this.addressSecondPanel.getInputText();
            String thirdLine = this.addressThirdPanel.getInputText();
            String city = this.addressCityPanel.getInputText();
            String postalCode = this.addressPostalCodePanel.getInputText();
            String name = this.companyNamePanel.getInputText();
            String countryCode = this.iplLicenseHandler.getKeyFromValue(this.countryMap, country);
            if (this.isStrEmpty(primaryFirstName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryFirstNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryLastName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryLastNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryTelephoneNumber, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryContactPhonePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(primaryContactEmailAddress, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY.toErrorMessage(), this.primaryEmailPanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(name, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_COMPANY_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.companyNamePanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(firstLine, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_STREET_ADDRESS_FIELD_IS_MANDATORY.toErrorMessage(), this.mailingAddressPanel)) {
                isValid = false;
            }
            if (this.isStrEmpty(city, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_CITY_FIELD_IS_MANDATORY.toErrorMessage(), this.addressCityPanel)) {
                isValid = false;
            }
            if (countryCode.equals(COUNTRY_CODE_US)) {
                stateOrProvince = this.usAddressStateOrProvincePanel.getInputText();
            } else if (countryCode.equals(COUNTRY_CODE_CANADA)) {
                stateOrProvince = this.canadaAddressStateOrProvincePanel.getInputText();
            } else {
                stateOrProvince = this.otherAddressStateOrProvincePanel.getInputText();
                if (this.isStrEmpty(stateOrProvince, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_STATE_PROVINCE_FIELD_IS_MANDATORY.toErrorMessage(), this.otherAddressStateOrProvincePanel)) {
                    isValid = false;
                }
            }
            if (isValid) {
                this.iplLicenseHandler.setCompanyInfo(LicenseUtils.createCompanyInfo((String)primaryFirstName, (String)primaryLastName, (String)firstLine, (String)secondLine, (String)thirdLine, (String)city, (String)countryCode, (String)postalCode, (String)stateOrProvince, (String)name, (String)primaryTelephoneNumber, (String)primaryContactEmailAddress));
                LicenseHandler.saveCompanyContactInfo(this.iplLicenseHandler.getCompanyInfo(), this.countryMap);
            }
            if (!this.isSameinfoChkButtonSelected()) {
                String techContactEmailAddress = this.techEmailPanel.getInputText();
                String techFirstName = this.techFirstNamePanel.getInputText();
                String techLastName = this.techLastNamePanel.getInputText();
                String techTelephoneNumber = this.techContactPhonePanel.getInputText();
                if (this.isStrEmpty(techFirstName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_FIRST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.techFirstNamePanel)) {
                    isValid = false;
                }
                if (this.isStrEmpty(techLastName, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_LAST_NAME_FIELD_IS_MANDATORY.toErrorMessage(), this.techLastNamePanel)) {
                    isValid = false;
                }
                if (this.isStrEmpty(techTelephoneNumber, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_PHONE_NUMBER_FIELD_IS_MANDATORY.toErrorMessage(), this.techContactPhonePanel)) {
                    isValid = false;
                }
                if (this.isStrEmpty(techContactEmailAddress, LicenseUtils.ERROR_MESSAGE.ERROR_MESSAGE_EMAIL_FIELD_IS_MANDATORY.toErrorMessage(), this.techEmailPanel)) {
                    isValid = false;
                }
                if (isValid) {
                    this.iplLicenseHandler.setTechnicalContactInfo(LicenseUtils.createTechnicalContactInfo((String)techFirstName, (String)techLastName, (String)techContactEmailAddress, (String)techTelephoneNumber));
                    LicenseHandler.saveTechContactInfo(this.iplLicenseHandler.getTechnicalContactInfo());
                }
            } else if (isValid) {
                this.iplLicenseHandler.setTechnicalContactInfo(LicenseUtils.createTechnicalContactInfo((String)primaryFirstName, (String)primaryLastName, (String)primaryContactEmailAddress, (String)primaryTelephoneNumber));
                LicenseHandler.saveTechContactInfo(this.iplLicenseHandler.getTechnicalContactInfo());
            }
        }
        return isValid;
    }

    protected void setInputBoxError(IPLUserInputError iPLUserInputError) {
        String msg = null;
        String errorCode = null;
        LicenseUtils.IPL_USERINPUTERROR_TYPE reason = LicenseUtils.IPL_USERINPUTERROR_TYPE.fromValue((int)iPLUserInputError.getIPLUserInputErrorType());
        if (reason != null) {
            switch (reason) {
                case CONTACT_NAME_ERROR: {
                    int nameType = iPLUserInputError.getOptIPLContactNameError().getOptNameType();
                    int infoType = iPLUserInputError.getOptIPLContactNameError().getOptInfoType();
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLContactNameError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLContactNameError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLContactNameError().getOptErrorCode();
                    }
                    if (nameType == LicenseUtils.IPL_NAME_TYPE.FIRST.getValue()) {
                        if (infoType == LicenseUtils.IPL_INFO_TYPE.TECHNICAL_CONTACT.getValue()) {
                            this.techFirstNamePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                            break;
                        }
                        if (infoType == LicenseUtils.IPL_INFO_TYPE.COMPANY.getValue()) {
                            this.primaryFirstNamePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                            break;
                        }
                        ConsoleLogger.log("IPL ContactNameError INFO_TYPE condition: UNKNOWN");
                        ConsoleLogger.log(msg);
                        msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.firstnameFieldInfoTypeUnknown");
                        JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                        ConsoleLogger.log(msg);
                        break;
                    }
                    if (nameType == LicenseUtils.IPL_NAME_TYPE.LAST.getValue()) {
                        if (infoType == LicenseUtils.IPL_INFO_TYPE.TECHNICAL_CONTACT.getValue()) {
                            this.techLastNamePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                            break;
                        }
                        if (infoType == LicenseUtils.IPL_INFO_TYPE.COMPANY.getValue()) {
                            this.primaryLastNamePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                            break;
                        }
                        ConsoleLogger.log("IPL ContactNameError INFO_TYPE condition: UNKNOWN");
                        ConsoleLogger.log(msg);
                        msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.lastnameFieldInfoTypeUnknown");
                        JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                        ConsoleLogger.log(msg);
                        break;
                    }
                    if (infoType == LicenseUtils.IPL_INFO_TYPE.TECHNICAL_CONTACT.getValue()) {
                        ConsoleLogger.log("IPL ContactNameError NAME_TYPE condition: UNKNOWN");
                        ConsoleLogger.log(msg);
                        msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.technicalcontactnameFieldNameTypeUnknown");
                        JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                        ConsoleLogger.log(msg);
                        break;
                    }
                    if (infoType == LicenseUtils.IPL_INFO_TYPE.COMPANY.getValue()) {
                        ConsoleLogger.log("IPL ContactNameError NAME_TYPE condition: UNKNOWN");
                        ConsoleLogger.log(msg);
                        msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.primarycontactnameFieldNameTypeUnknown");
                        JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                        ConsoleLogger.log(msg);
                        break;
                    }
                    ConsoleLogger.log("IPL ContactNameError INFO_TYPE condition: UNKNOWN");
                    ConsoleLogger.log("IPL ContactNameError NAME_TYPE condition: UNKNOWN");
                    ConsoleLogger.log(msg);
                    msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.contactnameFieldNameTypeUnknown");
                    JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                    ConsoleLogger.log(msg);
                    break;
                }
                case CITY_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLCityError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLCityError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLCityError().getOptErrorCode();
                    }
                    this.addressCityPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case POSTAL_CODE_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLPostalCodeError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLPostalCodeError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLPostalCodeError().getOptErrorCode();
                    }
                    this.addressPostalCodePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case COUNTRY_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLCountryError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLCountryError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLCountryError().getOptErrorCode();
                    }
                    this.addressCountryPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case COMPANY_NAME_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLCompanyNameError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLCompanyNameError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLCompanyNameError().getOptErrorCode();
                    }
                    this.companyNamePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case STREET_ADDRESS_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLStreetAddressError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLStreetAddressError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLStreetAddressError().getOptErrorCode();
                    }
                    if (iPLUserInputError.getOptIPLStreetAddressError().getOptLineNumber() == 2) {
                        this.addressSecondPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    if (iPLUserInputError.getOptIPLStreetAddressError().getOptLineNumber() == 3) {
                        this.addressThirdPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    this.mailingAddressPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case EMAIL_ADDRESS_ERROR: {
                    int infoType;
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLEmailAddressError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLEmailAddressError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLEmailAddressError().getOptErrorCode();
                    }
                    if ((infoType = iPLUserInputError.getOptIPLEmailAddressError().getOptInfoType().intValue()) == LicenseUtils.IPL_INFO_TYPE.TECHNICAL_CONTACT.getValue()) {
                        this.techEmailPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    if (infoType == LicenseUtils.IPL_INFO_TYPE.COMPANY.getValue()) {
                        this.primaryEmailPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    ConsoleLogger.log("IPL EmailAddressError INFO_TYPE condition: UNKNOWN");
                    ConsoleLogger.log(msg);
                    msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.emailaddressFieldInfoTypeUnknown");
                    JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                    ConsoleLogger.log(msg);
                    break;
                }
                case PHONE_NUMBER_ERROR: {
                    int infoType;
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLPhoneNumberError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLPhoneNumberError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLPhoneNumberError().getOptErrorCode();
                    }
                    if ((infoType = iPLUserInputError.getOptIPLPhoneNumberError().getOptInfoType().intValue()) == LicenseUtils.IPL_INFO_TYPE.TECHNICAL_CONTACT.getValue()) {
                        this.techContactPhonePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    if (infoType == LicenseUtils.IPL_INFO_TYPE.COMPANY.getValue()) {
                        this.primaryContactPhonePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    ConsoleLogger.log("IPL PhoneNumberError INFO_TYPE condition: UNKNOWN");
                    ConsoleLogger.log(msg);
                    msg = MessageResources.getInstance().getString(ADMINDIALOG, "IPLInformationPanel.phonenumberFieldInfoTypeUnknown");
                    JOptionPane.showMessageDialog(this.parent, IPLLicenseHandler.getHyperLinkEditorPane(msg, errorCode, true, 290), MSGRES.getString(ADMINDIALOG, "IPLInformationPanel.errorTitle"), 0);
                    ConsoleLogger.log(msg);
                    break;
                }
                case STATEORPROVINCE_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLStateOrProvinceError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLStateOrProvinceError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLStateOrProvinceError().getOptErrorCode();
                    }
                    if (this.getCurrentCountryCode().equals(COUNTRY_CODE_US)) {
                        this.usAddressStateOrProvincePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    if (this.getCurrentCountryCode().equals(COUNTRY_CODE_CANADA)) {
                        this.canadaAddressStateOrProvincePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                        break;
                    }
                    this.otherAddressStateOrProvincePanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    break;
                }
                case MAILING_ADDRESS_ERROR: {
                    msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.adminIPLdialog", iPLUserInputError.getOptIPLMailingAddressError().getOptErrorMessageToken());
                    if (iPLUserInputError.getOptIPLMailingAddressError().getOptErrorCode() != null) {
                        errorCode = iPLUserInputError.getOptIPLMailingAddressError().getOptErrorCode();
                    }
                    this.mailingAddressPanel.setInputBoxErrorLabelInfo(true, msg, errorCode);
                    ConsoleLogger.log(msg);
                    break;
                }
            }
        }
    }

    private boolean isStrEmpty(String str, String errorMessage, InfoInputPanel panel) {
        if (str == null || str.length() == 0) {
            if (panel != null) {
                String msg = IPLLicenseHandler.getHTMLText(errorMessage);
                panel.setInputBoxErrorLabelInfo(true, msg, null);
                ConsoleLogger.log(msg);
            }
            return true;
        }
        if (panel != null) {
            panel.setInputBoxErrorLabelInfo(false, null, null);
        }
        return false;
    }

    public void disposeUI() {
    }

    private void setWizardFont(Font font) {
        for (InfoInputPanel tempPanel : this.infoInputPanelList) {
            tempPanel.setPanelFont(font);
        }
        this.sameinfoChkButton.setFont(font);
        if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == this.infoRequired) {
            this.descTechnicalContactLabel.setFont(font);
        } else if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == this.infoRequired) {
            this.descCompanyLabel.setFont(font);
            this.descPrimaryContactLabel.setFont(font);
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == this.infoRequired) {
            this.descCompanyLabel.setFont(font);
            this.descPrimaryContactLabel.setFont(font);
            this.descTechnicalContactLabel.setFont(font);
        }
    }

    private void setWizardBigFont(Font font) {
        this.legalDisclaimerDes.setFont(font);
        if (LicenseUtils.INFO_REQUIRED.TECHNICAL_CONTACT_INFO_REQUIRED == this.infoRequired) {
            this.descTechContact.setFont(font);
        } else if (LicenseUtils.INFO_REQUIRED.COMPANY_INFO_REQUIRED == this.infoRequired) {
            this.descCompany.setFont(font);
            this.descPrimaryContact.setFont(font);
        } else if (LicenseUtils.INFO_REQUIRED.BOTH_INFO_REQUIRED == this.infoRequired) {
            this.descCompany.setFont(font);
            this.descPrimaryContact.setFont(font);
            this.descTechContact.setFont(font);
        }
    }

    String getCurrentCountryCode() {
        return this.currentCountryCode;
    }

    private void setCurrentCountryCode(String currentCountryCode) {
        this.currentCountryCode = currentCountryCode;
    }

    LicenseUtils.INFO_REQUIRED getInfoRequired() {
        return this.infoRequired;
    }

    private void setInfoRequired(LicenseUtils.INFO_REQUIRED infoRequired) {
        this.infoRequired = infoRequired;
    }
}

