/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.PasswordClearUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class VerifyCurrentAdminPWDDlg
extends DialogBase {
    private static final long serialVersionUID = -1059384146229484380L;
    private final MessageResources msgRes = MessageResources.getInstance();
    private JLabel pwdLabel = new JLabel();
    private JPasswordField jTFPwd = new SEPMPasswordField(30);
    private AdminObject adminObjectTobeVerified = null;
    private boolean passwordVerificationThresholdExceeded = false;

    public VerifyCurrentAdminPWDDlg(AdminObject admin, JFrame frame, String title) {
        super(frame, title, true, false);
        this.adminObjectTobeVerified = admin;
        String enterPassword = this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "VerifyCurrentAdminPWDDlg.enterPassword");
        this.pwdLabel.setText(enterPassword);
        this.init();
        this.setDefaultCloseOperation(2);
        UiUtilities.centerComponent((Component)this);
        this.pack();
        this.setVisible(true);
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.pwdLabel);
        panel.add(this.jTFPwd);
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    public boolean isPasswordVerificationThresholdExceeded() {
        return this.passwordVerificationThresholdExceeded;
    }

    public void setPasswordVerificationThresholdExceeded(boolean passwordVerificationThresholdExceeded) {
        this.passwordVerificationThresholdExceeded = passwordVerificationThresholdExceeded;
    }

    @Override
    protected boolean isValidate() {
        char[] currentPwd = this.jTFPwd.getPassword();
        if (currentPwd.length == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.enterCurrentAdminPasssword"), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.error"), 0);
            this.jTFPwd.requestFocus();
            return false;
        }
        String encryptedCurrentPassword = Utility.encryptLatest((char[])currentPwd);
        PasswordClearUtil.clearPasswordInMemory(currentPwd, this.jTFPwd);
        if (!AdminHandler.isValidPasswordForCurrentAdmin(encryptedCurrentPassword)) {
            AdministratorState latestAdminState = null;
            try {
                latestAdminState = DataobjectManager.getInstance().getAdministratorState(DataobjectManager.getInstance().getCurrentAdministrator().getId());
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
            }
            String displayMessage = this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPasswordIsIncorrectWithoutThreshold");
            if (latestAdminState != null) {
                LoginConfigObject loginConfig = this.adminObjectTobeVerified.getLoginConfig(true);
                int currentFailedAttempts = latestAdminState.getOptFailedPasswordVerificationAttemptNumber() != null ? latestAdminState.getOptFailedPasswordVerificationAttemptNumber().intValue() : latestAdminState.getDefFailedPasswordVerificationAttemptNumber().intValue();
                int threshold = loginConfig.getLoginConfig().getDefAttemptThresholdForPasswordVerification();
                int remainingAttempts = threshold - currentFailedAttempts;
                if (remainingAttempts > 0) {
                    displayMessage = MessageFormat.format(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPasswordIsIncorrect"), remainingAttempts);
                } else {
                    displayMessage = this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPasswordIsIncorrectThresholdReached");
                    this.passwordVerificationThresholdExceeded = true;
                }
            }
            ConsoleLogger.log("VerifyCurrentAdminPWDDlg >> isPasswordValid: current password entered is wrong!");
            JOptionPane.showMessageDialog(Manager.getFrame(), displayMessage, this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.error"), 0);
            if (!this.passwordVerificationThresholdExceeded) {
                this.jTFPwd.requestFocus();
            } else {
                this.dispose();
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
            }
            return false;
        }
        return true;
    }
}

