/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DatabasePrivilege;
import com.sygate.scm.common.configobject.schema.EnforcerGroup;
import com.sygate.scm.common.configobject.schema.EnforcerGroupPrivilege;
import com.sygate.scm.common.configobject.schema.EnforcerGroupPrivilegeSet;
import com.sygate.scm.common.configobject.schema.EnforcerGroupTree;
import com.sygate.scm.common.configobject.schema.PrivilegeValue;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.ServerPrivilege;
import com.sygate.scm.common.configobject.schema.ServerPrivilegeSet;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.GenericPrivilegeDropDownList;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.HtmlEnabledJList;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.dlg.SiteMetaDataVO;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SitePrivilegeDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private MessageResources RES = MessageResources.getInstance();
    private String DLG = "com.sygate.scm.console.ui.admin.dlg.admindialog";
    private final String[] enforcerColumnNames = new String[]{this.RES.getString(this.DLG, "SitePrivilegeDlg.enforcerGroupName"), this.RES.getString(this.DLG, "SitePrivilegeDlg.enforcerGroupPrivilege")};
    private final String[] serverColumnNames = new String[]{this.RES.getString(this.DLG, "SitePrivilegeDlg.serverGroupName"), this.RES.getString(this.DLG, "SitePrivilegeDlg.serverGroupPrivilege")};
    private JPanel privilegePanel = null;
    private JPanel siteListPanel = null;
    private JPanel authorizeTypaPanel = null;
    private JPanel layoutedPanel = null;
    private JPanel selectedPanel = null;
    private JPanel serverPrivilegePanel = null;
    private JPanel databasePrivilegePanel = null;
    private JPanel enforcerPrivilegePanel = null;
    private JRadioButton notAuthorized = null;
    private JRadioButton fullAuthorized = null;
    private JRadioButton customAuthorized = null;
    private ButtonGroup siteLevelButtonGroup = new ButtonGroup();
    private HtmlEnabledJList siteList = null;
    private JTable serverList = null;
    private JTable enforcerList = null;
    private DefaultListModel<Object> siteModel = null;
    private DefaultTableModel serversModel = null;
    private DefaultTableModel enforcersModel = null;
    private JComboBox<DropdownItem> databasePrivilegeBox = null;
    private JComboBox<DropdownItem> serverPrivilegeBox = null;
    private JComboBox<DropdownItem> enforcerPrivilegeBox = null;
    private JCheckBox serverCheckBox = null;
    private JCheckBox enforcerCheckBox = null;
    private JLabel dbPrivilegeLabel = null;
    private HtmlEnabledJLabel selectedSite = null;
    private SitePrivilegeSet privilegeSet = null;
    private SemSite currentSite = null;
    private HashMap<String, String> serverMap = new HashMap();
    private HashMap<Integer, String> serverIndexMap = new HashMap();
    private HashMap<String, String> enforcerMap = new HashMap();
    private HashMap<Integer, String> enforcerIndexMap = new HashMap();
    private HashMap<Integer, SitePrivilege> siteMap = new HashMap();
    private SitePrivilege currentSitePrivilege = null;
    private int currentSiteIndex = -1;
    private boolean isDomainAdmin = true;

    public SitePrivilegeDlg(JFrame parent, String title, boolean modal, SitePrivilegeSet privilegeSet, boolean domainAdmin, boolean readOnly) {
        super(parent, title, modal);
        this.readOnly = readOnly;
        this.isDomainAdmin = domainAdmin;
        this.jbInit();
        this.changeStautsForDomainAdmin(domainAdmin);
        this.setSiteRights(privilegeSet);
        this.setReadOnlyStatus();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private JPanel getAuthorizeTypePanel() {
        if (this.authorizeTypaPanel == null) {
            this.authorizeTypaPanel = new JPanel();
            this.authorizeTypaPanel.setLayout(new BorderLayout());
            this.authorizeTypaPanel.add((Component)this.getRadio(1), "North");
            this.authorizeTypaPanel.add((Component)this.getRadio(0), "Center");
            this.authorizeTypaPanel.add((Component)this.getRadio(2), "South");
        }
        return this.authorizeTypaPanel;
    }

    private String getContent(String keyName) {
        return this.RES.getString(this.DLG, keyName);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_access_rights_site_rights";
    }

    private JComboBox<DropdownItem> getDatabasePrivilegeComboBox() {
        if (this.databasePrivilegeBox == null) {
            this.databasePrivilegeBox = this.getRightComboBox();
            this.databasePrivilegeBox.setEditable(false);
            this.databasePrivilegeBox.setPreferredSize(this.databasePrivilegeBox.getPreferredSize());
        }
        return this.databasePrivilegeBox;
    }

    private JPanel getDatabasePrivilegePanel() {
        if (this.databasePrivilegePanel == null) {
            this.databasePrivilegePanel = new JPanel();
            this.databasePrivilegePanel.setBorder(new TitledBorder(this.RES.getString(this.DLG, "SitePrivilegeDlg.databasePrivilegeTitle")));
            this.databasePrivilegePanel.setLayout(new BorderLayout());
            this.databasePrivilegePanel.add((Component)this.getDbPrivilegeLabel(), "West");
            this.databasePrivilegePanel.add(this.getDatabasePrivilegeComboBox(), "East");
        }
        return this.databasePrivilegePanel;
    }

    private JLabel getDbPrivilegeLabel() {
        if (this.dbPrivilegeLabel == null) {
            this.dbPrivilegeLabel = this.getLabel("SitePrivilegeDlg.databasePrivilege");
        }
        return this.dbPrivilegeLabel;
    }

    private JCheckBox getEnforcerCheckBox() {
        if (this.enforcerCheckBox == null) {
            this.enforcerCheckBox = new JCheckBox(this.getContent("SitePrivilegeDlg.enforcerPrivilegeCheckBox"));
        }
        return this.enforcerCheckBox;
    }

    private DefaultTableModel getEnforcerListModel() {
        if (this.enforcersModel == null) {
            this.enforcersModel = new DefaultTableModel();
            this.enforcersModel.setColumnIdentifiers(this.enforcerColumnNames);
        }
        return this.enforcersModel;
    }

    private void initalEnforcerModelWithEnforcersPrivilege(EnforcerGroupPrivilegeSet enforcersPrivilege, SiteMetaDataVO siteVO) {
        this.getEnforcerListModel().getDataVector().clear();
        Set<String> enforcers = this.enforcerMap.keySet();
        Iterator<String> iterate = enforcers.iterator();
        int index = 0;
        while (iterate.hasNext()) {
            String enforcerId = iterate.next();
            this.enforcerIndexMap.put(index++, enforcerId);
            EnforcerGroupPrivilege enforcerPrivilege = null;
            enforcerPrivilege = this.fetchEnforcersPrivilegeFromSitePrivilege(this.currentSitePrivilege, enforcerId);
            if (enforcerPrivilege == null) {
                enforcerPrivilege = new EnforcerGroupPrivilege();
                enforcerPrivilege.setRefEnforcerGroupId(enforcerId);
                enforcerPrivilege.setOptPrivilegeValue(AdminACLUtils.getPrivilegeValue((SitePrivilegeSet)this.privilegeSet, (EnforcerGroup)siteVO.getSemEnforcers().get(enforcerId)));
            }
            this.getEnforcerListModel().addRow(this.makeupTableRow((ConfigObject)enforcerPrivilege));
        }
        this.getEnforcerListTable().updateUI();
        PrivilegeValue value = null;
        if (enforcersPrivilege != null) {
            value = enforcersPrivilege.getOptPrivilegeValue();
        }
        if (value != null) {
            this.enforcerCheckBox.setSelected(true);
            this.enforcerPrivilegeBox.setSelectedIndex(value.getOptPrivilege());
            this.getEnforcerListTable().setEnabled(false);
        } else {
            this.enforcerPrivilegeBox.setEnabled(false);
            this.enforcerPrivilegeBox.setSelectedIndex(1);
        }
    }

    private JTable getEnforcerListTable() {
        if (this.enforcerList == null) {
            this.enforcerList = new PrivilegeTable();
            Dimension size = this.enforcerList.getPreferredScrollableViewportSize();
            this.enforcerList.setPreferredScrollableViewportSize(new Dimension(size.width, (this.enforcerList.getRowHeight() + this.enforcerList.getRowMargin()) * 5 * 2));
            this.enforcerList.setAutoResizeMode(4);
            this.enforcerList.setSelectionMode(0);
            this.enforcerList.setModel(this.getEnforcerListModel());
            this.enforcerList.setVisible(true);
        }
        return this.enforcerList;
    }

    private JScrollPane getScrollEnforcerListTablePane() {
        JScrollPane scrollPane = new JScrollPane(this.getEnforcerListTable());
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        scrollPane.setOpaque(false);
        return scrollPane;
    }

    private JComboBox<DropdownItem> getEnforcerPrivilegeComboBox() {
        if (this.enforcerPrivilegeBox == null) {
            this.enforcerPrivilegeBox = this.getRightComboBox();
            this.enforcerPrivilegeBox.setPreferredSize(this.enforcerPrivilegeBox.getPreferredSize());
        }
        return this.enforcerPrivilegeBox;
    }

    private JPanel getEnforcerPrivilegePanel() {
        if (this.enforcerPrivilegePanel == null) {
            this.enforcerPrivilegePanel = new JPanel();
            this.enforcerPrivilegePanel.setBorder(new TitledBorder(this.RES.getString(this.DLG, "SitePrivilegeDlg.EnforcerPrivilegeTitle")));
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(3);
            this.enforcerPrivilegePanel.setLayout(borderLayout);
            JPanel top = new JPanel();
            top.setLayout(new BorderLayout());
            top.add((Component)this.getEnforcerCheckBox(), "West");
            top.add(this.getEnforcerPrivilegeComboBox(), "East");
            this.enforcerPrivilegePanel.add((Component)top, "North");
            this.enforcerPrivilegePanel.add((Component)this.getScrollEnforcerListTablePane(), "Center");
        }
        return this.enforcerPrivilegePanel;
    }

    private JLabel getLabel(String keyName) {
        String content = this.getContent(keyName);
        JLabel label = new JLabel();
        if (content != null) {
            label.setText(content);
        }
        return label;
    }

    private JPanel getLayoutedPanel() {
        if (this.layoutedPanel == null) {
            this.layoutedPanel = new JPanel();
            this.layoutedPanel.setLayout(new BorderLayout());
            JPanel north = new JPanel();
            north.setLayout(new BorderLayout());
            north.add((Component)this.getSiteListPanel(), "North");
            north.add((Component)this.getAuthorizeTypePanel(), "South");
            this.layoutedPanel.add((Component)north, "North");
            this.layoutedPanel.add((Component)this.getPrivilegePanel(), "Center");
            this.getPrivilegePanel().setVisible(!this.isDomainAdmin);
            this.setListener();
        }
        return this.layoutedPanel;
    }

    private JPanel getPrivilegePanel() {
        if (this.privilegePanel == null) {
            this.privilegePanel = new JPanel();
            this.privilegePanel.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(this.getServerPrivilegePanel());
            panel.add(this.getEnforcerPrivilegePanel());
            if (LicenseObject.getInstance().isSAVOnlyProduct()) {
                this.getEnforcerPrivilegePanel().setVisible(false);
            }
            this.privilegePanel.add((Component)this.getDatabasePrivilegePanel(), "North");
            this.privilegePanel.add((Component)panel, "Center");
        }
        return this.privilegePanel;
    }

    private JRadioButton getRadio(int type) {
        JRadioButton radio = null;
        switch (type) {
            case 1: {
                if (this.notAuthorized == null) {
                    this.notAuthorized = new JRadioButton(this.getContent("SitePrivilegeDlg.notAuthorizedRadioButton"));
                }
                radio = this.notAuthorized;
                break;
            }
            case 0: {
                if (this.fullAuthorized == null) {
                    this.fullAuthorized = new JRadioButton(this.getContent("SitePrivilegeDlg.fullAuthorizedRadioButton"));
                }
                radio = this.fullAuthorized;
                break;
            }
            case 2: {
                if (this.customAuthorized == null) {
                    this.customAuthorized = new JRadioButton(this.getContent("SitePrivilegeDlg.customAuthorizedRadioButton"));
                    this.customAuthorized.setVisible(!this.isDomainAdmin);
                }
                radio = this.customAuthorized;
                break;
            }
        }
        if (radio == null) {
            radio = new JRadioButton();
        }
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == SitePrivilegeDlg.this.notAuthorized) {
                    SitePrivilegeDlg.this.currentSitePrivilege.getOptPrivilegeValue().setOptPrivilege(Integer.valueOf(1));
                    SitePrivilegeDlg.this.enablePrivilegePanel(false);
                } else if (event.getSource() == SitePrivilegeDlg.this.fullAuthorized) {
                    SitePrivilegeDlg.this.currentSitePrivilege.getOptPrivilegeValue().setOptPrivilege(Integer.valueOf(0));
                    SitePrivilegeDlg.this.enablePrivilegePanel(false);
                } else if (event.getSource() == SitePrivilegeDlg.this.customAuthorized) {
                    SitePrivilegeDlg.this.currentSitePrivilege.getOptPrivilegeValue().setOptPrivilege(Integer.valueOf(2));
                    SitePrivilegeDlg.this.enablePrivilegePanel(true);
                }
                SitePrivilegeDlg.this.refreshSelectedSite();
            }
        };
        radio.addActionListener(radioListener);
        this.siteLevelButtonGroup.add(radio);
        return radio;
    }

    private void enablePrivilegePanel(boolean enable) {
        this.databasePrivilegeBox.setEnabled(enable);
        this.serverCheckBox.setEnabled(enable);
        this.enforcerCheckBox.setEnabled(enable);
        if (!enable) {
            this.getServerListTable().setEnabled(false);
            this.serverPrivilegeBox.setEnabled(false);
            this.getEnforcerListTable().setEnabled(false);
            this.enforcerPrivilegeBox.setEnabled(false);
        } else {
            if (this.serverCheckBox.isSelected()) {
                this.getServerListTable().setEnabled(false);
                this.serverPrivilegeBox.setEnabled(true);
            } else {
                this.serverPrivilegeBox.setEnabled(false);
                this.getServerListTable().setEnabled(true);
            }
            if (this.enforcerCheckBox.isSelected()) {
                this.getEnforcerListTable().setEnabled(false);
                this.enforcerPrivilegeBox.setEnabled(true);
            } else {
                this.enforcerPrivilegeBox.setEnabled(false);
                this.getEnforcerListTable().setEnabled(true);
            }
        }
        this.dbPrivilegeLabel.setEnabled(enable);
    }

    private JPanel getSelectedSitePanel() {
        if (this.selectedPanel == null) {
            this.selectedPanel = new JPanel();
            this.selectedPanel.add((Component)this.getSelectedSiteLabel());
        }
        return this.selectedPanel;
    }

    private HtmlEnabledJLabel getSelectedSiteLabel() {
        if (this.selectedSite == null) {
            this.selectedSite = new HtmlEnabledJLabel();
        }
        return this.selectedSite;
    }

    private JCheckBox getServerCheckBox() {
        if (this.serverCheckBox == null) {
            this.serverCheckBox = new JCheckBox(this.getContent("SitePrivilegeDlg.serverPrivilegeCheckBox"));
        }
        return this.serverCheckBox;
    }

    private DefaultTableModel getServersModel() {
        if (this.serversModel == null) {
            this.serversModel = new DefaultTableModel();
            this.serversModel.setColumnIdentifiers(this.serverColumnNames);
        }
        return this.serversModel;
    }

    private void setListener() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() == SitePrivilegeDlg.this.serverCheckBox) {
                    boolean selected = SitePrivilegeDlg.this.serverCheckBox.isSelected();
                    SitePrivilegeDlg.this.serverPrivilegeBox.setEnabled(selected);
                    SitePrivilegeDlg.this.getServerListTable().setEnabled(!selected);
                } else if (e.getItem() == SitePrivilegeDlg.this.enforcerCheckBox) {
                    boolean selected = SitePrivilegeDlg.this.enforcerCheckBox.isSelected();
                    SitePrivilegeDlg.this.enforcerPrivilegeBox.setEnabled(selected);
                    SitePrivilegeDlg.this.getEnforcerListTable().setEnabled(!selected);
                }
            }
        };
        this.getServerCheckBox().addItemListener(listener);
        this.getEnforcerCheckBox().addItemListener(listener);
    }

    private void initalAllServerModelWithSiteIndex(int index) {
        int size = this.getSiteModel().getSize();
        if (index < size) {
            this.serverCheckBox.setSelected(false);
            this.enforcerCheckBox.setSelected(false);
            SitePrivilege site = this.siteMap.get(index);
            this.currentSite = this.fetchSemSiteById(site.getRefSiteId());
            SiteMetaDataVO siteVO = this.fetchServersFromSemSite(this.currentSite);
            this.initalDatabasePrivilege(this.currentSitePrivilege);
            this.initalServerModelWithServersPrivilege(site.getOptServerPrivilegeSet(), siteVO);
            this.initalEnforcerModelWithEnforcersPrivilege(site.getOptEnforcerGroupPrivilegeSet(), siteVO);
        }
    }

    private void initalServerModelWithServersPrivilege(ServerPrivilegeSet serversPrivilege, SiteMetaDataVO siteVO) {
        this.getServersModel().getDataVector().clear();
        Set<String> servers = this.serverMap.keySet();
        Iterator<String> iterate = servers.iterator();
        int index = 0;
        while (iterate.hasNext()) {
            String serverId = iterate.next();
            this.serverIndexMap.put(index++, serverId);
            ServerPrivilege serverPrivilege = this.fetchServerPrivilegeFromSitePrivilege(this.currentSitePrivilege, serverId);
            if (serverPrivilege == null) {
                serverPrivilege = new ServerPrivilege();
                serverPrivilege.setRefServerId(serverId);
                serverPrivilege.setOptPrivilegeValue(AdminACLUtils.getPrivilegeValue((SitePrivilegeSet)this.privilegeSet, (SemServer)siteVO.getSemServers().get(serverId)));
            }
            this.getServersModel().addRow(this.makeupTableRow((ConfigObject)serverPrivilege));
        }
        this.getServerListTable().updateUI();
        PrivilegeValue value = null;
        if (serversPrivilege != null) {
            value = serversPrivilege.getOptPrivilegeValue();
        }
        if (value != null) {
            this.serverCheckBox.setSelected(true);
            this.serverPrivilegeBox.setSelectedIndex(value.getOptPrivilege());
            this.getServerListTable().setEnabled(false);
        } else {
            this.serverPrivilegeBox.setEnabled(false);
            this.serverPrivilegeBox.setSelectedIndex(1);
        }
    }

    private JTable getServerListTable() {
        if (this.serverList == null) {
            this.serverList = new PrivilegeTable();
            Dimension size = this.serverList.getPreferredScrollableViewportSize();
            this.serverList.setPreferredScrollableViewportSize(new Dimension(size.width, (this.serverList.getRowHeight() + this.serverList.getRowMargin()) * 5 * 2));
            this.serverList.setAutoResizeMode(4);
            this.serverList.setSelectionMode(0);
            this.serverList.setModel(this.getServersModel());
            this.serverList.setVisible(true);
        }
        return this.serverList;
    }

    private JScrollPane getScrollServerListTablePane() {
        JScrollPane scrollPane = new JScrollPane(this.getServerListTable());
        scrollPane.setPreferredSize(this.serverList.getPreferredScrollableViewportSize());
        return scrollPane;
    }

    private JComboBox<DropdownItem> getServerPrivilegeComboBox() {
        if (this.serverPrivilegeBox == null) {
            this.serverPrivilegeBox = this.getRightComboBox();
            this.serverPrivilegeBox.setPreferredSize(this.serverPrivilegeBox.getPreferredSize());
        }
        return this.serverPrivilegeBox;
    }

    private JPanel getServerPrivilegePanel() {
        if (this.serverPrivilegePanel == null) {
            this.serverPrivilegePanel = new JPanel();
            this.serverPrivilegePanel.setBorder(new TitledBorder(this.RES.getString(this.DLG, "SitePrivilegeDlg.serverPrivilegeTitle")));
            this.serverPrivilegePanel.setLayout(new BorderLayout());
            JPanel top = new JPanel();
            top.setLayout(new BorderLayout());
            top.add((Component)this.getServerCheckBox(), "West");
            top.add(this.getServerPrivilegeComboBox(), "East");
            this.serverPrivilegePanel.add((Component)top, "North");
            this.serverPrivilegePanel.add((Component)this.getScrollServerListTablePane(), "Center");
        }
        return this.serverPrivilegePanel;
    }

    private JScrollPane getScrollSiteListPane() {
        JScrollPane scrollPane = new JScrollPane((Component)this.getSiteList());
        Dimension dimension = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(dimension);
        return scrollPane;
    }

    private HtmlEnabledJList getSiteList() {
        if (this.siteList == null) {
            this.siteList = new HtmlEnabledJList();
            this.siteList.getSelectionModel().setSelectionMode(0);
            this.siteList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        String currentStatus;
                        int index = SitePrivilegeDlg.this.siteList.getSelectedIndex();
                        String status = (String)SitePrivilegeDlg.this.getSiteModel().get(SitePrivilegeDlg.this.currentSiteIndex);
                        if (!status.equals(currentStatus = SitePrivilegeDlg.this.getSelectedSiteLabel().getText()) && !StringUtilities.isEmpty((String)currentStatus)) {
                            SitePrivilegeDlg.this.getSiteModel().set(SitePrivilegeDlg.this.currentSiteIndex, SitePrivilegeDlg.this.getSelectedSiteLabel().getText());
                        }
                        SitePrivilegeDlg.this.updateCurrentSitePrivilege();
                        SitePrivilegeDlg.this.currentSiteIndex = index;
                        SitePrivilegeDlg.this.refreshSelectedSite();
                        SitePrivilegeDlg.this.initalAllServerModelWithSiteIndex(index);
                        SitePrivilegeDlg.this.changeRadioButtonStatus();
                    }
                }
            });
        }
        return this.siteList;
    }

    private void updateCurrentSitePrivilege() {
        this.updateDataBasePrivilegeToCurrentSite();
        this.updateServersPrivilegeToCurrentSite();
        this.updateEnforcerGroupsPrivilegeToCurrentSite();
        this.privilegeSet.setSitePrivilege(this.currentSiteIndex, this.currentSitePrivilege);
    }

    private void updateDataBasePrivilegeToCurrentSite() {
        if (this.currentSitePrivilege.getOptPrivilegeValue().getOptPrivilege() == 2) {
            PrivilegeValue value;
            DatabasePrivilege databasePrivilege = this.currentSitePrivilege.getOptDatabasePrivilege();
            if (databasePrivilege == null) {
                databasePrivilege = new DatabasePrivilege();
                this.currentSitePrivilege.setOptDatabasePrivilege(databasePrivilege);
            }
            if ((value = databasePrivilege.getOptPrivilegeValue()) == null) {
                value = new PrivilegeValue();
                databasePrivilege.setOptPrivilegeValue(value);
            }
            value.setOptPrivilege(Integer.valueOf(this.databasePrivilegeBox.getSelectedIndex()));
        } else {
            this.currentSitePrivilege.setOptDatabasePrivilege(null);
        }
    }

    private void updateServersPrivilegeToCurrentSite() {
        if (this.currentSitePrivilege.getOptPrivilegeValue().getOptPrivilege() == 2) {
            ServerPrivilegeSet serverSet = this.currentSitePrivilege.getOptServerPrivilegeSet();
            PrivilegeValue allSamePrivilege = null;
            if (serverSet == null) {
                serverSet = new ServerPrivilegeSet();
                this.currentSitePrivilege.setOptServerPrivilegeSet(serverSet);
            }
            if (this.serverCheckBox.isSelected()) {
                allSamePrivilege = serverSet.getOptPrivilegeValue();
                if (allSamePrivilege == null) {
                    allSamePrivilege = new PrivilegeValue();
                    serverSet.setOptPrivilegeValue(allSamePrivilege);
                }
                allSamePrivilege.setOptPrivilege(Integer.valueOf(this.serverPrivilegeBox.getSelectedIndex()));
            } else {
                serverSet.setOptPrivilegeValue(null);
            }
            int count = this.getServersModel().getRowCount();
            for (int i = 0; i < count; ++i) {
                String serverId = this.serverIndexMap.get(i);
                PrivilegeValue value = new PrivilegeValue();
                DropdownItem item = (DropdownItem)this.getServersModel().getValueAt(i, 1);
                value.setOptPrivilege((Integer)item.getValue());
                this.updateServerPrivilege(serverSet, serverId, allSamePrivilege == null ? value : allSamePrivilege);
            }
        } else {
            this.currentSitePrivilege.setOptServerPrivilegeSet(null);
        }
    }

    private void updateServerPrivilege(ServerPrivilegeSet serverSet, String serverId, PrivilegeValue value) {
        if (serverSet == null) {
            return;
        }
        int size = serverSet.getServerPrivilegeCount();
        boolean exist = false;
        for (int i = 0; i < size; ++i) {
            ServerPrivilege server = serverSet.getServerPrivilege(i);
            if (!server.getRefServerId().equals(serverId)) continue;
            PrivilegeValue privilege = server.getOptPrivilegeValue();
            if (privilege == null) {
                server.setOptPrivilegeValue(value);
            } else {
                privilege.setOptPrivilege(value.getOptPrivilege());
            }
            exist = true;
            break;
        }
        if (!exist) {
            ServerPrivilege server = new ServerPrivilege();
            server.setRefServerId(serverId);
            server.setOptPrivilegeValue(value);
            serverSet.addServerPrivilege(server);
        }
    }

    private void updateEnforcerGroupsPrivilegeToCurrentSite() {
        if (!this.getEnforcerPrivilegePanel().isVisible()) {
            return;
        }
        if (this.currentSitePrivilege.getOptPrivilegeValue().getOptPrivilege() == 2) {
            EnforcerGroupPrivilegeSet enforcerSet = this.currentSitePrivilege.getOptEnforcerGroupPrivilegeSet();
            PrivilegeValue allSamePrivilege = null;
            if (enforcerSet == null) {
                enforcerSet = new EnforcerGroupPrivilegeSet();
                this.currentSitePrivilege.setOptEnforcerGroupPrivilegeSet(enforcerSet);
            }
            if (this.enforcerCheckBox.isSelected()) {
                allSamePrivilege = enforcerSet.getOptPrivilegeValue();
                if (allSamePrivilege == null) {
                    allSamePrivilege = new PrivilegeValue();
                    enforcerSet.setOptPrivilegeValue(allSamePrivilege);
                }
                allSamePrivilege.setOptPrivilege(Integer.valueOf(this.enforcerPrivilegeBox.getSelectedIndex()));
            } else {
                enforcerSet.setOptPrivilegeValue(null);
            }
            int count = this.getEnforcerListModel().getRowCount();
            for (int i = 0; i < count; ++i) {
                String enforcerId = this.enforcerIndexMap.get(i);
                PrivilegeValue value = new PrivilegeValue();
                DropdownItem item = (DropdownItem)this.getEnforcerListModel().getValueAt(i, 1);
                value.setOptPrivilege((Integer)item.getValue());
                this.updateEnforcerGroupPrivilege(enforcerSet, enforcerId, allSamePrivilege == null ? value : allSamePrivilege);
            }
        } else {
            this.currentSitePrivilege.setOptEnforcerGroupPrivilegeSet(null);
        }
    }

    private void updateEnforcerGroupPrivilege(EnforcerGroupPrivilegeSet enforcerSet, String enforcerId, PrivilegeValue value) {
        if (enforcerSet == null) {
            return;
        }
        int size = enforcerSet.getEnforcerGroupPrivilegeCount();
        boolean exist = false;
        for (int i = 0; i < size; ++i) {
            EnforcerGroupPrivilege enforcerGroup = enforcerSet.getEnforcerGroupPrivilege(i);
            if (!enforcerGroup.getRefEnforcerGroupId().equals(enforcerId)) continue;
            PrivilegeValue privilege = enforcerGroup.getOptPrivilegeValue();
            if (privilege == null) {
                enforcerGroup.setOptPrivilegeValue(value);
            } else {
                privilege.setOptPrivilege(value.getOptPrivilege());
            }
            exist = true;
            break;
        }
        if (!exist) {
            EnforcerGroupPrivilege enforcerGroup = new EnforcerGroupPrivilege();
            enforcerGroup.setRefEnforcerGroupId(enforcerId);
            enforcerGroup.setOptPrivilegeValue(value);
            enforcerSet.addEnforcerGroupPrivilege(enforcerGroup);
        }
    }

    private JPanel getSiteListPanel() {
        if (this.siteListPanel == null) {
            this.siteListPanel = new JPanel();
            this.siteListPanel.setLayout(new BorderLayout());
            this.siteListPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraint = new GridBagConstraints();
            constraint.gridx = 0;
            constraint.gridy = 0;
            constraint.gridheight = 3;
            constraint.anchor = 11;
            constraint.insets.bottom = 10;
            panel.add((Component)this.getLabel("SitePrivilegeDlg.selectASite"), constraint);
            constraint.gridx = 1;
            panel.add((Component)this.getScrollSiteListPane(), constraint);
            constraint.insets.bottom = 0;
            constraint.gridx = 0;
            constraint.gridy = 4;
            constraint.gridheight = 1;
            constraint.anchor = 17;
            panel.add((Component)this.getLabel("SitePrivilegeDlg.manageSite"), constraint);
            constraint.gridx = 1;
            panel.add((Component)this.getSelectedSitePanel(), constraint);
            this.siteListPanel.add((Component)panel, "West");
        }
        return this.siteListPanel;
    }

    private DefaultListModel<Object> getSiteModel() {
        if (this.siteModel == null) {
            this.siteModel = new DefaultListModel();
        }
        return this.siteModel;
    }

    private void initalSiteModelWithSites() {
        this.siteMap.clear();
        int j = 0;
        for (SitePrivilege sitePrivilege : this.privilegeSet.getSitePrivilege()) {
            String row;
            String siteId;
            String siteName;
            if (sitePrivilege == null || (siteName = this.fetchSiteNameById(siteId = sitePrivilege.getRefSiteId())) == null || (row = this.makeupSiteRow(this.chooseSiteRightIcon(sitePrivilege), siteName, Manager.isLocalSite(siteId))) == null) continue;
            this.getSiteModel().addElement(row);
            this.siteMap.put(j++, sitePrivilege);
            if (this.currentSitePrivilege != null) continue;
            this.currentSitePrivilege = sitePrivilege;
        }
        this.siteList.setModel(this.getSiteModel());
        this.currentSiteIndex = 0;
        if (!this.isDomainAdmin) {
            this.initalAllServerModelWithSiteIndex(this.currentSiteIndex);
        }
        if (this.siteList.isSelectionEmpty()) {
            this.siteList.setSelectedIndex(this.currentSiteIndex);
        }
        this.changeRadioButtonStatus();
    }

    private void initalDatabasePrivilege(SitePrivilege sitePrivilege) {
        this.databasePrivilegeBox.setSelectedIndex(1);
        if (sitePrivilege == null) {
            return;
        }
        DatabasePrivilege privilege = sitePrivilege.getOptDatabasePrivilege();
        if (privilege == null) {
            return;
        }
        PrivilegeValue value = privilege.getOptPrivilegeValue();
        if (value == null) {
            return;
        }
        this.databasePrivilegeBox.setSelectedIndex(value.getOptPrivilege());
    }

    private ServerPrivilege fetchServerPrivilegeFromSitePrivilege(SitePrivilege sitePrivilege, String serverId) {
        ServerPrivilege target;
        block4: {
            target = null;
            if (sitePrivilege == null || serverId == null) {
                return target;
            }
            try {
                ServerPrivilegeSet serverSet = sitePrivilege.getOptServerPrivilegeSet();
                if (serverSet == null) break block4;
                for (ServerPrivilege server : serverSet.getServerPrivilege()) {
                    if (!server.getRefServerId().equals(serverId)) continue;
                    target = server;
                    break;
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return target;
    }

    private EnforcerGroupPrivilege fetchEnforcersPrivilegeFromSitePrivilege(SitePrivilege sitePrivilege, String groupId) {
        EnforcerGroupPrivilege target;
        block4: {
            target = null;
            if (sitePrivilege == null || groupId == null) {
                return target;
            }
            try {
                EnforcerGroupPrivilegeSet enforcerSet = sitePrivilege.getOptEnforcerGroupPrivilegeSet();
                if (enforcerSet == null) break block4;
                Vector serversPrivilege = enforcerSet.getEnforcerGroupPrivilege();
                int size = serversPrivilege.size();
                for (int i = 0; i < size; ++i) {
                    EnforcerGroupPrivilege enforcer = (EnforcerGroupPrivilege)serversPrivilege.get(i);
                    if (!enforcer.getRefEnforcerGroupId().equals(groupId)) continue;
                    target = enforcer;
                    break;
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return target;
    }

    private void jbInit() {
        this.getContentPane().add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getLayoutedPanel()), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    private void refreshSelectedSite() {
        int index = this.getSiteList().getSelectedIndex();
        this.currentSitePrivilege = this.siteMap.get(index);
        if (this.currentSitePrivilege == null) {
            return;
        }
        String icon = this.chooseSiteRightIcon(this.currentSitePrivilege);
        String siteId = this.currentSitePrivilege.getRefSiteId();
        String siteName = this.fetchSiteNameById(siteId);
        String content = this.makeupSiteRow(icon, siteName, Manager.isLocalSite(siteId));
        this.getSelectedSiteLabel().setText(content);
    }

    public void setSiteRights(SitePrivilegeSet privilegeSet) {
        if (privilegeSet == null) {
            return;
        }
        this.privilegeSet = privilegeSet;
        this.initalSiteModelWithSites();
        this.refreshSelectedSite();
    }

    private JComboBox<DropdownItem> getRightComboBox() {
        GenericPrivilegeDropDownList box = new GenericPrivilegeDropDownList();
        box.setEditable(false);
        return box;
    }

    private void changeStautsForDomainAdmin(boolean doaminAdmin) {
        this.customAuthorized.setEnabled(!doaminAdmin);
    }

    private void changeRadioButtonStatus() {
        if (this.currentSitePrivilege != null) {
            PrivilegeValue value = this.currentSitePrivilege.getOptPrivilegeValue();
            this.notAuthorized.setSelected(false);
            this.fullAuthorized.setSelected(false);
            this.customAuthorized.setSelected(false);
            if (value != null) {
                int privilege = value.getOptPrivilege();
                switch (privilege) {
                    case 1: {
                        this.notAuthorized.setSelected(true);
                        this.enablePrivilegePanel(false);
                        break;
                    }
                    case 0: {
                        this.fullAuthorized.setSelected(true);
                        this.enablePrivilegePanel(false);
                        break;
                    }
                    case 2: {
                        this.customAuthorized.setSelected(true);
                        this.enablePrivilegePanel(true);
                        break;
                    }
                    default: {
                        this.notAuthorized.setSelected(true);
                        this.enablePrivilegePanel(false);
                        break;
                    }
                }
            } else if (this.currentSitePrivilege.getOptDatabasePrivilege() != null) {
                this.customAuthorized.setSelected(true);
                this.enablePrivilegePanel(true);
            } else {
                this.notAuthorized.setSelected(true);
                this.enablePrivilegePanel(false);
            }
        }
        this.setReadOnlyStatus();
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    protected void commit() {
        super.commit();
        this.updateCurrentSitePrivilege();
    }

    private String chooseSiteRightIcon(SitePrivilege sitePrivilege) {
        PrivilegeValue privilegeValue = sitePrivilege.getOptPrivilegeValue();
        if (privilegeValue == null) {
            DatabasePrivilege dbPrivilege = sitePrivilege.getOptDatabasePrivilege();
            if (dbPrivilege == null) {
                return this.getImageURL("disabledSite.png");
            }
            return this.getImageURL("customSite.png");
        }
        Integer value = privilegeValue.getOptPrivilege();
        if (value == null) {
            return null;
        }
        if (value == 1) {
            return this.getImageURL("disabledSite.png");
        }
        if (value == 0) {
            return this.getImageURL("enabledSite.png");
        }
        if (value == 2) {
            return this.getImageURL("customSite.png");
        }
        return null;
    }

    private String getImageURL(String iamgeName) {
        URL url = null;
        if (iamgeName != null && iamgeName.trim().length() > 0) {
            url = ConsoleMain.class.getResource(iamgeName);
        }
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    private String makeupSiteRow(String siteRightIcon, String siteName, boolean localSite) {
        if (siteRightIcon == null || siteName == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><table><tr><td><image src=\"");
        buffer.append(siteRightIcon);
        buffer.append("\"/></td><td>");
        buffer.append(siteName);
        buffer.append("</td>");
        if (localSite) {
            buffer.append("<td><b>");
            buffer.append(this.RES.getString(this.DLG, "SitePrivilegeDlg.localSite"));
            buffer.append("</b></td>");
        }
        buffer.append("</tr></table></html>");
        return buffer.toString();
    }

    private Object[] makeupTableRow(ConfigObject obj) {
        String serverId = "";
        PrivilegeValue value = null;
        int privilegeIndex = 0;
        String serverName = null;
        if (obj instanceof ServerPrivilege) {
            serverId = ((ServerPrivilege)obj).getRefServerId();
            value = ((ServerPrivilege)obj).getOptPrivilegeValue();
            serverName = this.serverMap.get(serverId);
        } else if (obj instanceof EnforcerGroupPrivilege) {
            serverId = ((EnforcerGroupPrivilege)obj).getRefEnforcerGroupId();
            value = ((EnforcerGroupPrivilege)obj).getOptPrivilegeValue();
            serverName = this.enforcerMap.get(serverId);
        }
        if (serverName == null) {
            return null;
        }
        if (value != null) {
            privilegeIndex = value.getOptPrivilege();
        }
        Object[] row = new Object[]{serverName, GenericPrivilegeDropDownList.getItemByIndex((int)privilegeIndex)};
        return row;
    }

    private String fetchSiteNameById(String id) {
        String name = null;
        if (this.currentSite != null && this.currentSite.getId().equals(id)) {
            return this.currentSite.getName();
        }
        try {
            SemSite site = this.fetchSemSiteById(id);
            if (site != null) {
                name = site.getName();
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return name;
    }

    private SiteMetaDataVO fetchServersFromSemSite(SemSite site) {
        SiteMetaDataVO siteVo = new SiteMetaDataVO();
        if (site == null) {
            return siteVo;
        }
        this.serverMap.clear();
        this.enforcerMap.clear();
        this.serverIndexMap.clear();
        this.enforcerIndexMap.clear();
        HashMap<String, SemServer> semServers = new HashMap<String, SemServer>();
        for (SemServer server : site.getServerArray().getSemServer()) {
            this.serverMap.put(server.getId(), server.getName());
            semServers.put(server.getId(), server);
        }
        siteVo.setSemServers(semServers);
        EnforcerGroupTree enforcerTree = site.getOptEnforcerGroupTree();
        if (enforcerTree == null) {
            return siteVo;
        }
        EnforcerGroup enforcerGroups = enforcerTree.getEnforcerGroup();
        if (enforcerGroups == null) {
            return siteVo;
        }
        HashMap<String, EnforcerGroup> enforcers = new HashMap<String, EnforcerGroup>();
        for (EnforcerGroup enforcer : enforcerGroups.getEnforcerGroup()) {
            this.enforcerMap.put(enforcer.getId(), enforcer.getName());
            enforcers.put(enforcer.getId(), enforcer);
        }
        siteVo.setSemEnforcers(enforcers);
        return siteVo;
    }

    private SemSite fetchSemSiteById(String siteId) {
        SemSite site;
        block2: {
            site = null;
            try {
                site = DataobjectManager.getInstance().getSemSite(siteId);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
        return site;
    }

    @Override
    protected void setReadOnlyStatus() {
        this.customAuthorized.setEnabled(!this.readOnly);
        this.notAuthorized.setEnabled(!this.readOnly);
        this.fullAuthorized.setEnabled(!this.readOnly);
        if (this.databasePrivilegeBox.isEnabled()) {
            this.databasePrivilegeBox.setEnabled(!this.readOnly);
        }
        if (this.serverPrivilegeBox.isEnabled()) {
            this.serverPrivilegeBox.setEnabled(!this.readOnly);
        }
        if (this.enforcerPrivilegeBox.isEnabled()) {
            this.enforcerPrivilegeBox.setEnabled(!this.readOnly);
        }
        if (this.serverCheckBox.isEnabled()) {
            this.serverCheckBox.setEnabled(!this.readOnly);
        }
        this.enforcerCheckBox.setEnabled(!this.readOnly);
        if (this.getServerListTable().isEnabled()) {
            this.getServerListTable().setEnabled(!this.readOnly);
        }
        if (this.getEnforcerListTable().isEnabled()) {
            this.getEnforcerListTable().setEnabled(!this.readOnly);
        }
    }

    private class PrivilegeTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        PrivilegeTable() {
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            this.setRowSelectionInterval(row, row);
            TableCellEditor editor = null;
            switch (column) {
                case 1: {
                    editor = new DefaultCellEditor(SitePrivilegeDlg.this.getRightComboBox());
                    break;
                }
                default: {
                    editor = this.getDefaultEditor(this.getColumnClass(column));
                }
            }
            return editor;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component comp = super.prepareRenderer(renderer, row, column);
            if (!this.isEnabled()) {
                comp.setForeground(Color.gray);
            } else {
                comp.setForeground(null);
            }
            comp.setEnabled(this.isEnabled());
            return comp;
        }
    }
}

