/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameDomainDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel centerPanel = new JPanel();
    private JLabel adminNameLabel = new JLabel();
    private JTextField tfDomain = new JTextField();
    private boolean isCancelled = true;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    String originalName;
    boolean nameConflict;

    public RenameDomainDlg(DomainObject domain) {
        this(domain.getName(), false);
    }

    public RenameDomainDlg(String domainName, boolean conflict) {
        super(Manager.getFrame(), "", true);
        String fm;
        Object[] obj = new Object[]{domainName};
        this.nameConflict = conflict;
        if (this.nameConflict) {
            fm = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.renameDomainForConflict");
        } else {
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.renameDomain");
            fm = MessageFormat.format(str, obj);
        }
        super.setTitle(fm);
        this.originalName = domainName;
        this.initialize();
    }

    public RenameDomainDlg(String domainName) {
        this(domainName, false);
    }

    public String getDomainName() {
        return this.tfDomain.getText().trim();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    @Override
    protected boolean isValidate() {
        String domainName = this.getDomainName();
        if (domainName.length() == 0) {
            this.tfDomain.requestFocus();
            Object[] obj = new Object[]{Integer.toString(256)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.lengthOfDomainNameShouldBetween_");
            String fm = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(this, fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.error"), 0);
            return false;
        }
        if (!StringUtilities.isEmpty((String)this.originalName) && this.originalName.equals(domainName)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.theNewDomainIsSameAsOld"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.error"), 0);
            this.tfDomain.requestFocus();
            return false;
        }
        if (Utility.isCharDisallowed(null, (char[])domainName.toCharArray(), (String)"\"/\\[]:;|=,+*?<>", (String)domainName, null)) {
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainNameHasInvalidCharactersMsg");
            String fm = MessageFormat.format(message, domainName, "\"/\\[]:;|=,+*?<>");
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.error"), 0);
            this.tfDomain.requestFocus();
            return false;
        }
        if (AdminHandler.isDomainNameExisting(domainName)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.domainNameExist"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.error"), 0);
            this.tfDomain.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.isCancelled = false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_domain_dialog_rename";
    }

    private void initialize() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.pack();
        Dimension size = this.getPreferredSize();
        this.setSize(size.width * (this.nameConflict ? 1 : 2), size.height);
        UiUtilities.centerComponent((Component)this);
    }

    private void jbInit() throws Exception {
        if (this.nameConflict) {
            this.adminNameLabel.setText(MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.renameDomainName"), this.originalName));
        } else {
            this.adminNameLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameDomainDlg.newDomainName"));
        }
        this.adminNameLabel.setHorizontalAlignment(11);
        RestrictedPlainDocument domainNameDoc = new RestrictedPlainDocument(256);
        this.tfDomain.setDocument(domainNameDoc);
        if (!StringUtilities.isEmpty((String)this.originalName)) {
            this.tfDomain.setText(this.originalName);
        }
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.setResizable(true);
        this.setSize(new Dimension(333, 190));
        this.centerPanel.setLayout(this.gridBagLayout1);
        this.centerPanel.add((Component)this.adminNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 30, 0, 30), 0, 0));
        this.centerPanel.add((Component)this.tfDomain, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 32, 20, 30), 0, 0));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }
}

