/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.ui.admin.dlg.AdminPropertiesGeneralPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RenameAdminDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel centerPanel = new JPanel();
    private JLabel adminNameLabel = new JLabel();
    private JTextField adminNameField = new JTextField(30);
    private boolean isCancelled = true;
    private AdminObject admin;

    public RenameAdminDlg(AdminObject admin) {
        super(Manager.getFrame(), "", true);
        Object[] obj = new Object[]{admin.getAdminName()};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameAdminDlg.renameAdminTitle");
        String fm = MessageFormat.format(str, obj);
        super.setTitle(fm);
        this.admin = admin;
        this.initialize();
    }

    public String getAdminName() {
        return this.adminNameField.getText().trim();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    @Override
    protected boolean isValidate() {
        String adminName = this.getAdminName();
        if (this.admin.getAdminName().equals(adminName)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameAdminDlg.newAdminNameIsSameAsOldMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameAdminDlg.error"), 0);
            this.adminNameField.requestFocus();
            return false;
        }
        if (!AdminPropertiesGeneralPanel.validateAdminName(adminName)) {
            this.adminNameField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.isCancelled = false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_rename";
    }

    private void initialize() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void jbInit() throws Exception {
        this.adminNameLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "RenameAdminDlg.newAdminNameTxt"));
        this.adminNameLabel.setHorizontalAlignment(11);
        RestrictedPlainDocument adminNameDoc = new RestrictedPlainDocument(20);
        adminNameDoc.setValidator("\"/\\[]:;|=,+*?<>", false);
        this.adminNameField.setDocument(adminNameDoc);
        if (this.admin != null) {
            this.adminNameField.setText(this.admin.getAdminName());
        }
        this.centerPanel.setLayout(this.gridBagLayout1);
        this.centerPanel.add((Component)this.adminNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 30, 0, 30), 0, 0));
        this.centerPanel.add((Component)this.adminNameField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 32, 20, 30), 0, 0));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }
}

