/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PolicyTypeRightsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] policyPrivilegeTypes = new String[]{"0x22", "0x23", "0x24", "0x25", "0x26", "0x27", "0x28", "0x29", "0x30", "0x31", "0x32"};
    private JLabel descLabel1 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.label.descLabel1"));
    private JCheckBox jckAntivirusAndAntispyware = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckAntivirusAndAntispyware"));
    private JCheckBox jckFirewall = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckFirewall"));
    private JCheckBox jckIntrusionPrevention = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckIntrusionPrevention"));
    private JCheckBox jckApplicationAndDeviceControl = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckApplicationAndDeviceControl"));
    private JCheckBox jckLiveUpdate = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckLiveUpdate"));
    private JCheckBox jckCentralizedExceptions = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckCentralizedExceptions"));
    private JCheckBox jckHostIntegrity = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckHostIntegrity"));
    private JCheckBox jckMEM = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckMEM"));
    private JCheckBox jckIntegrations = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckIntegrations"));
    private JCheckBox jckClientUpgrade = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckClientUpgrade"));
    private JCheckBox jckAdaptive = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "PolicyTypeRightsPanel.checkbox.jckAdaptive"));
    private JPanel m_innerPanel = null;
    protected ArrayList<JCheckBox> addedCheckBoxs = new ArrayList();
    private Object[][] checkBoxsValuePairs = new Object[][]{{this.jckAdaptive, "0x32", LicenseObject.getInstance().isAdaptivePolicy()}, {this.jckAntivirusAndAntispyware, "0x22", LicenseObject.getInstance().isAvPolicy()}, {this.jckFirewall, "0x23", LicenseObject.getInstance().isFirewallPolicy()}, {this.jckIntrusionPrevention, "0x24", LicenseObject.getInstance().isIntrusionPreventionEnabled()}, {this.jckApplicationAndDeviceControl, "0x25", LicenseObject.getInstance().isOSPretectionPolicy()}, {this.jckLiveUpdate, "0x26", Boolean.TRUE}, {this.jckCentralizedExceptions, "0x27", LicenseObject.getInstance().isPolicyOverride()}, {this.jckHostIntegrity, "0x28", LicenseObject.getInstance().isHostIntegrityPolicy()}, {this.jckMEM, "0x29", LicenseObject.getInstance().isMemPolicy()}, {this.jckIntegrations, "0x30", LicenseObject.getInstance().isNtrPolicy()}, {this.jckClientUpgrade, "0x31", LicenseObject.getInstance().isUpgradePolicy()}};
    private boolean readOnly;

    public static String[] getPolicyprivilegetypes() {
        return (String[])policyPrivilegeTypes.clone();
    }

    public PolicyTypeRightsPanel(boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
    }

    public PolicyTypeRightsPanel() {
        this(false);
    }

    protected boolean isValidate() {
        this.addedCheckBoxs.trimToSize();
        for (int i = 0; i < this.addedCheckBoxs.size(); ++i) {
            JCheckBox box = this.addedCheckBoxs.get(i);
            if (!box.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        JPanel jp = new JPanel(new GridLayout(2, 1, 0, 0));
        jp.add(this.descLabel1);
        this.add((Component)jp, "North");
        this.m_innerPanel = this.getInnerPanel();
        this.add((Component)this.m_innerPanel, "Center");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(""));
        this.addedCheckBoxs.clear();
        for (int i = 0; i < this.checkBoxsValuePairs.length; ++i) {
            Boolean licenced = (Boolean)this.checkBoxsValuePairs[i][2];
            if (!licenced.booleanValue()) continue;
            panel.add((Component)((JCheckBox)this.checkBoxsValuePairs[i][0]), new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
            this.addedCheckBoxs.add((JCheckBox)this.checkBoxsValuePairs[i][0]);
        }
        return panel;
    }

    public void setData(ArrayList<?> allowedPolicyTypes) {
        ArrayList<Object> status = new ArrayList();
        if (allowedPolicyTypes != null) {
            status = allowedPolicyTypes;
        }
        for (int i = 0; i < this.checkBoxsValuePairs.length; ++i) {
            JCheckBox checkbox = (JCheckBox)this.checkBoxsValuePairs[i][0];
            boolean allowed = false;
            try {
                String key = (String)this.checkBoxsValuePairs[i][1];
                if (status.contains(key)) {
                    allowed = true;
                }
            }
            catch (Exception exc) {
                ConsoleLogger.log(exc);
            }
            checkbox.setSelected(allowed);
        }
    }

    public ArrayList<String> getAllowedPolicyType() {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        for (int i = 0; i < this.checkBoxsValuePairs.length; ++i) {
            JCheckBox checkbox = (JCheckBox)this.checkBoxsValuePairs[i][0];
            String key = (String)this.checkBoxsValuePairs[i][1];
            if (!checkbox.isSelected()) continue;
            allowedTypes.add(key);
        }
        return allowedTypes;
    }

    private void setReadOnlyStatus() {
        for (int i = 0; i < this.checkBoxsValuePairs.length; ++i) {
            JCheckBox checkbox = (JCheckBox)this.checkBoxsValuePairs[i][0];
            checkbox.setEnabled(!this.readOnly);
        }
    }
}

