/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class InstallPackageConstraintDialog
extends DialogBase {
    private static final long serialVersionUID = -400359994759450488L;
    private JRadioButton readOnlyButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "GenericPrivilegeDropDownList.privilegeReadOnly"));
    private JRadioButton fullAccessButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.common.ui.ui", "GenericPrivilegeDropDownList.privilegeFullAccess"));
    private JLabel topLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.InstallPackageConstraintDialog.borderDesc"));
    private JLabel descLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.InstallPackageConstraintDialog.label.description"));

    public InstallPackageConstraintDialog(Integer packageRight, boolean readOnly) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.InstallPackageConstraintDialog.title"), true, false);
        this.readOnly = readOnly;
        this.initialize();
        this.pack();
        this.setData(packageRight);
        this.setReadOnlyStatus();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getPackageRightPanel()), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    public void setData(Integer packageRight) {
        if (packageRight != null && packageRight.intValue() == SemAdminPrivilege.READ_ONLY.intValue()) {
            this.readOnlyButton.setSelected(true);
            this.readOnlyButton.requestFocusInWindow();
        } else {
            this.fullAccessButton.setSelected(true);
            this.fullAccessButton.requestFocusInWindow();
        }
    }

    private JPanel getPackageRightPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new GridBagLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        group.add(this.fullAccessButton);
        group.add(this.readOnlyButton);
        int row = 0;
        panel.add((Component)this.topLabel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)contentPanel, new GridBagConstraints(0, row++, 1, 3, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        row = 0;
        contentPanel.add((Component)this.descLabel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        contentPanel.add((Component)this.readOnlyButton, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        contentPanel.add((Component)this.fullAccessButton, new GridBagConstraints(2, row++, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    @Override
    protected void setReadOnlyStatus() {
        this.readOnlyButton.setEnabled(!this.readOnly);
        this.fullAccessButton.setEnabled(!this.readOnly);
    }

    public AuthorizationManager.PackagePermission getPackagePrivilege() {
        return this.readOnlyButton.isSelected() ? AuthorizationManager.PackagePermission.READ_ONLY : AuthorizationManager.PackagePermission.FULL_ACCESS;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_access_rights_install_packages_constraints";
    }
}

