/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.PartnerInformation;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.common.ui.PopUpDialogBase;
import com.sygate.scm.common.ui.RestrictedPlainDocument;
import com.sygate.scm.common.util.CommonUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PartnerInformationHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.EmailValidator;
import com.sygate.scm.util.URLUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class EditPartnerDialog
extends PopUpDialogBase {
    private static final long serialVersionUID = 1L;
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.admin.dlg.admindialog");
    private MultiLineLabel descLabel = new MultiLineLabel(MSGRES.getString("EditPartnerDialog.desctText"), 45);
    private JTextField jTFPartnerEmailAddress = new JTextField(30);
    private JTextField jTFCustomerId = new JTextField(30);
    private JTextField jTFPartnerWebsite = new JTextField(30);
    private JLabel partnerEmailAddressLabel = new JLabel(MSGRES.getString("EditPartnerDialog.partnerEmailAddress"));
    private JLabel customerIdLabel = new JLabel(MSGRES.getString("EditPartnerDialog.customerId"));
    private JLabel partnerWebsiteLabel = new JLabel(MSGRES.getString("EditPartnerDialog.partnerWebsite"));

    public EditPartnerDialog() {
        super((JFrame)Manager.getFrame(), MSGRES.getString("EditPartnerDialog.editPartnerInformation"), true);
        this.initialize();
    }

    private String getPartnerEmailAddress() {
        return this.jTFPartnerEmailAddress.getText().trim();
    }

    private String getCustomerId() {
        return this.jTFCustomerId.getText().trim();
    }

    private String getPartnerWebsite() {
        return this.jTFPartnerWebsite.getText().trim();
    }

    private void setPartnerEmailAddress(String emailAddress) {
        if (emailAddress != null && emailAddress.length() > 0) {
            this.jTFPartnerEmailAddress.setText(emailAddress);
        }
    }

    private void setCustomerId(String customerId) {
        if (customerId != null && customerId.length() > 0) {
            this.jTFCustomerId.setText(customerId);
        }
    }

    private void setPartnerWebsite(String partnerWebsite) {
        if (partnerWebsite != null && partnerWebsite.length() > 0) {
            this.jTFPartnerWebsite.setText(partnerWebsite);
        }
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getInnerPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setData();
        this.pack();
        CommonUtilities.centerDlg((Window)((Object)this));
    }

    private JPanel getInnerPanel() {
        RestrictedPlainDocument emailDoc = new RestrictedPlainDocument(256);
        emailDoc.setValidator("!:;`<>/',()+={}[]|?#$%^&* \\\"~", false);
        this.jTFPartnerEmailAddress.setDocument((Document)emailDoc);
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> {
            RestrictedPlainDocument customerIdDoc = new RestrictedPlainDocument(50);
            customerIdDoc.setValidator("\"@`~!^*()#%{}$&[]:;|=,+?'<>/\\\\", false);
            this.jTFCustomerId.setDocument((Document)customerIdDoc);
        });
        RestrictedPlainDocument partnerWebsiteDoc = new RestrictedPlainDocument(256);
        this.jTFPartnerWebsite.setDocument((Document)partnerWebsiteDoc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        panel.add((Component)this.descLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 5, 5), 0, 0));
        panel.add((Component)this.partnerEmailAddressLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 5), 0, 0));
        panel.add((Component)this.jTFPartnerEmailAddress, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
        panel.add((Component)this.customerIdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.jTFCustomerId, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        panel.add((Component)this.partnerWebsiteLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        panel.add((Component)this.jTFPartnerWebsite, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        return panel;
    }

    private void setData() {
        PartnerInformation partnerInfo = PartnerInformationHandler.getPartnerInformation();
        if (partnerInfo != null) {
            this.setPartnerEmailAddress(partnerInfo.getOptPartnerEmailAddress());
            this.setCustomerId(partnerInfo.getOptCustomerId());
            this.setPartnerWebsite(partnerInfo.getOptPartnerWebSite());
        }
    }

    protected boolean checkCustomerId(String customerId) {
        if (customerId != null && customerId.length() > 0) {
            for (char c : customerId.toCharArray()) {
                if ("\"@`~!^*()#%{}$&[]:;|=,+?'<>/\\\\".indexOf(c) < 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isValidate() {
        String partnerEmailAddress = this.getPartnerEmailAddress();
        if (partnerEmailAddress != null && partnerEmailAddress.length() > 0 && !EmailValidator.isValidEmailAddress((String)partnerEmailAddress)) {
            JOptionPane.showMessageDialog((Component)((Object)this), MSGRES.getString("EditPartnerDialog.errorMsgInvalidEmail"), MSGRES.getString("EditPartnerDialog.errorTitle"), 0);
            this.jTFPartnerEmailAddress.requestFocus();
            return false;
        }
        String customerId = this.getCustomerId();
        if (!this.checkCustomerId(customerId)) {
            JOptionPane.showMessageDialog((Component)((Object)this), MSGRES.getString("EditPartnerDialog.errorMsgCustomerId"), MSGRES.getString("EditPartnerDialog.errorTitle"), 0);
            this.jTFCustomerId.requestFocus();
            return false;
        }
        String partnerWebsite = this.getPartnerWebsite();
        if (partnerWebsite != null && partnerWebsite.length() > 0 && (partnerWebsite = URLUtility.validateWebsiteUrl((String)partnerWebsite)) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), MSGRES.getString("EditPartnerDialog.errorMsgInvalidWebsite"), MSGRES.getString("EditPartnerDialog.errorTitle"), 0);
            this.jTFPartnerWebsite.requestFocus();
            return false;
        }
        return true;
    }

    protected void commit() {
        block2: {
            PartnerInformation partnerInfo = new PartnerInformation();
            partnerInfo.setOptPartnerEmailAddress(this.getPartnerEmailAddress());
            partnerInfo.setOptCustomerId(this.getCustomerId());
            partnerInfo.setOptPartnerWebSite(this.getPartnerWebsite());
            try {
                PartnerInformationHandler.updatePartnerInformation(partnerInfo);
            }
            catch (ConsoleException ex) {
                Object[] obj = new Object[]{ex.getMessage()};
                String str = MSGRES.getString("EditPartnerDialog.dataCannotBeUpdated");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MSGRES.getString("EditPartnerDialog.errorTitle"), 0);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }
}

