/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.ui.admin.dlg.DomainInfoPanel;
import com.sygate.scm.console.ui.server.dlg.ServerSecurityPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SGridBagLayoutPanel;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DomainPropsDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.admin.dlg.admindialog");
    private static String INVALID_BANNER_CHARS = "<>&=[]{}\"\\";
    private static String INVALID_BANNER_TITLE_CHARS = "<>&=[]{}\"\\\r\n\t";
    private JCheckBox displayLoginBanner = new JCheckBox(this.res.getString("DomainPropsDlg.loginBannerExplanation"));
    private JTextField loginBannerTitleField = new JTextField();
    private JTextArea loginBannerText = new JTextArea();
    private JTabbedPane tabPane = new JTabbedPane();
    private boolean isCancelled = true;
    private ServerSecurityPanel securityPanel = null;
    private GeneralPanel general = null;
    private LogginBannerPanel loginBanner = new LogginBannerPanel();
    DomainObject domain = null;

    public DomainPropsDlg(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.initialize();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void init(DomainObject domainObj) {
        this.domain = domainObj;
        this.general.setDomainName(this.domain.getName());
        this.general.setCompanyName(this.domain.getCompanyName());
        this.general.setContactList(this.domain.getContactList());
        this.general.setMaxClientIdleDuration(this.domain.getMaxClientIdleTime());
        this.general.setMaxNPVDIClientIdleDuration(this.domain.getMaxNPVDIClientIdleTime());
        this.general.setAutoDeleteIdleClient(this.domain.getAutoDeleteIdleClient());
        this.general.setAutoDeleteIdleNPVDIClient(this.domain.getAutoDeleteIdleNPVDIClient());
        this.general.setCQEnabled(this.domain.isCQEnabled());
        this.displayLoginBanner.setSelected(this.domain.isDisplayLoginBanner());
        this.loginBannerTitleField.setText(this.domain.getLoginBannerTitle());
        this.loginBannerText.setText(this.domain.getLoginBannerText());
        this.loginBannerText.setCaretPosition(0);
        if (this.securityPanel != null) {
            this.securityPanel.setRememberPasswordStatus(this.domain.getSemDomain());
            this.securityPanel.setAllowNeverExpiringPassword(this.domain.getSemDomain());
        }
        this.changeInputFieldStatus(this.displayLoginBanner.isSelected());
        this.displayLoginBanner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainPropsDlg.this.changeInputFieldStatus(DomainPropsDlg.this.displayLoginBanner.isSelected());
            }
        });
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            this.dispose();
        }
        return true;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.dispose();
    }

    @Override
    protected boolean isValidate() {
        return this.general.isValidate();
    }

    @Override
    protected void commit() {
        this.isCancelled = false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component component = this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
        if (component instanceof ServerSecurityPanel) {
            return this.securityPanel.getContentSensitiveHelpToken();
        }
        if (component instanceof LogginBannerPanel) {
            return this.loginBanner.getContentSensitiveHelpToken();
        }
        return this.general.getContentSensitiveHelpToken();
    }

    private void initialize() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void jbInit() throws Exception {
        this.general = new GeneralPanel();
        this.securityPanel = new ServerSecurityPanel(false);
        this.tabPane.addTab(this.res.getString("DomainPropsDlg.generalTab"), this.general);
        this.tabPane.addTab(this.res.getString("DomainPropsDlg.loginBannerTab"), this.loginBanner);
        this.tabPane.addTab(MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SecurityPanel.title.Security"), this.securityPanel);
        this.getContentPane().add(this.tabPane);
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
    }

    public String getLoginBannerTitle() {
        return this.loginBannerTitleField.getText();
    }

    public String getLoginBannerText() {
        return this.loginBannerText.getText();
    }

    public boolean isDisplayLoginBanner() {
        return this.displayLoginBanner.isSelected();
    }

    public boolean getRememberPasswordStatus() {
        return this.securityPanel.getRememberPasswordStatus();
    }

    public boolean getAllowNeverExpiringPasswordStatus() {
        return this.securityPanel.getAllowNeverExpiringPasswordStatus();
    }

    private void changeInputFieldStatus(Boolean status) {
        this.loginBannerText.setEnabled(status);
        this.loginBannerTitleField.setEnabled(status);
    }

    public String getCompanyName() {
        return this.general.getCompanyName();
    }

    public String getContactList() {
        return this.general.getContactList();
    }

    public boolean isAutoDeleteIdleClient() {
        return this.general.isAutoDeleteIdleClient();
    }

    public boolean isCQEnabled() {
        return this.general.isCQEnabled();
    }

    public boolean isAutoDeleteIdleNPVDIClient() {
        return this.general.isAutoDeleteIdleNPVDIClient();
    }

    public int getMaxClientIdleDuration() {
        return this.general.getMaxClientIdleDuration();
    }

    public int getMaxNPVDIClientIdleDuration() {
        return this.general.getMaxNPVDIClientIdleDuration();
    }

    private class LogginBannerPanel
    extends SGridBagLayoutPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 1L;

        public LogginBannerPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 20));
            DomainPropsDlg.this.loginBannerTitleField.setDocument(new RestrictedPlainDocument(256, INVALID_BANNER_TITLE_CHARS, false));
            DomainPropsDlg.this.loginBannerText.setDocument(new RestrictedPlainDocument(2048, INVALID_BANNER_CHARS, false));
            JScrollPane loginBannerTextScrollPane = new JScrollPane();
            loginBannerTextScrollPane.setPreferredSize(new Dimension(280, 90));
            UiUtilities.setupScrollPane((JScrollPane)loginBannerTextScrollPane, (JTextArea)DomainPropsDlg.this.loginBannerText);
            int gridy = 0;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 20));
            this.add((Component)DomainPropsDlg.this.displayLoginBanner, new GridBagConstraints(0, gridy, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
            this.add((Component)new JLabel(DomainPropsDlg.this.res.getString("DomainPropsDlg.loginBannerTitle")), new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
            this.add((Component)DomainPropsDlg.this.loginBannerTitleField, new GridBagConstraints(1, gridy, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
            this.add((Component)new JLabel(DomainPropsDlg.this.res.getString("DomainPropsDlg.loginBannerText")), new GridBagConstraints(0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 10), 0, 0));
            this.add((Component)loginBannerTextScrollPane, new GridBagConstraints(1, gridy, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 10), 0, 0));
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_domain_dialog_properties_login_banner";
        }
    }

    private static class GeneralPanel
    extends DomainInfoPanel
    implements ContentSensitiveHelpPage {
        private static final long serialVersionUID = 5644905732848762179L;

        public GeneralPanel() {
            this.setLayout(new BorderLayout());
            this.initialize();
            this.disableDomainName();
        }

        private void initialize() {
            this.add((Component)this.getDomainInfoPanel(), "Center");
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_domain_dialog_properties";
        }
    }
}

