/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DomainInfoPanel
extends JPanel {
    private static final long serialVersionUID = -9180320280481548197L;
    private MessageResourcesFile res = new MessageResourcesFile("com.sygate.scm.console.ui.admin.dlg.admindialog");
    private JLabel domainNameLabel = new JLabel();
    private JLabel companyNameLabel = new JLabel();
    private JLabel contactLabel = new JLabel();
    private JTextField domainNameField = new JTextField(30);
    private JTextField companyNameField = new JTextField(30);
    private JTextArea contactArea = new JTextArea();
    private JPanel centerPanel = null;
    private JCheckBox autoDeleteIdleClient = new JCheckBox(this.res.getString("AddDomainDlg.stalelabel"));
    private JCheckBox autoDeleteIdleNPVDIClient = new JCheckBox(this.res.getString("AddDomainDlg.delete.NPVDIClients"));
    private JCheckBox enableCQ = new JCheckBox(this.res.getString("AddDomainDlg.EnableCentralQuarantine"));
    private JLabel days = new JLabel(this.res.getString("AddDomainDlg.days"));
    private JLabel daysNPVDI = new JLabel(this.res.getString("AddDomainDlg.days"));
    protected JTextField maxClientIdleDuration = new JTextField(new NumberPlainDocument(9999L), "30", 4);
    protected JTextField maxNPVDIClientIdleDuration = new JTextField(new NumberPlainDocument(1L, 9999L, true), "7", 4);
    private String oldClientIdleDuration = "30";
    private String oldNPVDIClientIdleDuration = "7";

    public DomainInfoPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.init();
        }
    }

    public void init() {
        this.autoDeleteIdleClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainInfoPanel.this.maxClientIdleDuration.setEditable(DomainInfoPanel.this.autoDeleteIdleClient.isSelected());
                DomainInfoPanel.this.autoDeleteIdleNPVDIClient.setEnabled(DomainInfoPanel.this.autoDeleteIdleClient.isSelected());
                DomainInfoPanel.this.maxNPVDIClientIdleDuration.setEditable(DomainInfoPanel.this.autoDeleteIdleClient.isSelected() & DomainInfoPanel.this.autoDeleteIdleNPVDIClient.isSelected());
            }
        });
        this.autoDeleteIdleNPVDIClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainInfoPanel.this.maxNPVDIClientIdleDuration.setEditable(DomainInfoPanel.this.autoDeleteIdleClient.isSelected() & DomainInfoPanel.this.autoDeleteIdleNPVDIClient.isSelected());
            }
        });
        this.domainNameLabel.setText(this.res.getString("DomainPropsDlg.domainNameTxt"));
        this.domainNameLabel.setHorizontalAlignment(11);
        this.companyNameLabel.setText(this.res.getString("DomainPropsDlg.companyNameTxt"));
        this.companyNameLabel.setHorizontalAlignment(11);
        this.contactLabel.setText(this.res.getString("DomainPropsDlg.contactListTxt"));
        this.contactLabel.setHorizontalAlignment(11);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.domainNameLabel.putClientProperty("cssClass", "editDomainLabel");
            this.companyNameLabel.putClientProperty("cssClass", "editDomainLabel");
            this.contactLabel.putClientProperty("cssClass", "editDomainLabel");
        });
        RestrictedPlainDocument domainNameDoc = new RestrictedPlainDocument(256);
        RestrictedPlainDocument companyNameDoc = new RestrictedPlainDocument(1024);
        this.companyNameField.setDocument(companyNameDoc);
        RestrictedPlainDocument contactListDoc = new RestrictedPlainDocument(2048);
        this.contactArea.setFocusTraversalKeys(0, null);
        this.contactArea.setFocusTraversalKeys(1, null);
        this.contactArea.setDocument(contactListDoc);
        this.contactArea.setWrapStyleWord(true);
        this.contactArea.setLineWrap(true);
        this.domainNameField.setDocument(domainNameDoc);
        JScrollPane scrollPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTextArea)this.contactArea);
        scrollPane.setPreferredSize(new Dimension(240, 90));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0);
        this.centerPanel.setLayout(gridBagLayout);
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 10));
        this.centerPanel.add((Component)this.domainNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.centerPanel.add((Component)this.domainNameField, constraints);
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 0);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.centerPanel.add((Component)this.companyNameLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 3;
        constraints.fill = 2;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.centerPanel.add((Component)this.companyNameField, constraints);
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 10, 0);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        this.centerPanel.add((Component)this.contactLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 10, 10, 10);
        this.centerPanel.add((Component)scrollPane, constraints);
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 10, 0);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        this.centerPanel.add((Component)this.autoDeleteIdleClient, constraints);
        constraints.gridx = 2;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 10, 10);
        this.centerPanel.add((Component)this.maxClientIdleDuration, constraints);
        constraints.gridx = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(5, 0, 10, 10);
        this.centerPanel.add((Component)this.days, constraints);
        this.setAutoDeleteIdleClient(true);
        if (!LicenseObject.getInstance().isSBProduct()) {
            constraints.fill = 0;
            constraints.insets = new Insets(2, 30, 10, 0);
            constraints.gridx = 0;
            constraints.gridy = 4;
            constraints.gridwidth = 2;
            constraints.weightx = 0.0;
            this.centerPanel.add((Component)this.autoDeleteIdleNPVDIClient, constraints);
            constraints.gridx = 2;
            constraints.weighty = 1.0;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.insets = new Insets(5, 0, 10, 10);
            this.centerPanel.add((Component)this.maxNPVDIClientIdleDuration, constraints);
            constraints.gridx = 3;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(5, 0, 10, 10);
            this.centerPanel.add((Component)this.daysNPVDI, constraints);
            this.setAutoDeleteIdleNPVDIClient(false);
        }
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 10, 0);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        this.centerPanel.add((Component)this.enableCQ, constraints);
    }

    protected boolean isValidate() {
        String domainName = this.getDomainName();
        if (Utility.isCharDisallowed(null, (char[])domainName.toCharArray(), (String)"\"/\\[]:;|=,+*?<>", (String)domainName, null)) {
            String message = this.res.getString("AddDomainDlg.domainNameHasInvalidCharactersMsg");
            String fm = MessageFormat.format(message, "\"/\\[]:;|=,+*?<>");
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, this.res.getString("AddDomainDlg.error"), 0);
            this.domainNameField.requestFocus();
            return false;
        }
        String contactList = this.getContactList();
        Object[] obj = new Object[]{Integer.toString(2048)};
        String str = this.res.getString("AddDomainDlg.contactListLongerThan_Msg");
        String fm = MessageFormat.format(str, obj);
        if (contactList.length() > 2048) {
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, this.res.getString("DomainPropsDlg.error"), 0);
            this.domainNameField.requestFocus();
            return false;
        }
        if (this.autoDeleteIdleClient.isSelected() && this.getMaxClientIdleDuration() <= 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.error.InvalidDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
            this.maxClientIdleDuration.setText(this.oldClientIdleDuration);
            return false;
        }
        if (this.autoDeleteIdleNPVDIClient.isSelected()) {
            if (this.getMaxNPVDIClientIdleDuration() <= 0) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.error.InvalidDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
                this.maxNPVDIClientIdleDuration.setText(this.oldNPVDIClientIdleDuration);
                return false;
            }
            if (this.getMaxNPVDIClientIdleDuration() > this.getMaxClientIdleDuration()) {
                JOptionPane.showMessageDialog(this, this.res.getString("AddDomainDlg.error.InvalidDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.dlg.serverdialog", "SiteGeneralPanel.title.Error"), 0);
                this.maxNPVDIClientIdleDuration.setText(this.oldNPVDIClientIdleDuration);
                return false;
            }
        }
        return true;
    }

    public void domainNameRequestFocus() {
        this.domainNameField.requestFocus();
    }

    public String getDomainName() {
        return this.domainNameField.getText();
    }

    public String getCompanyName() {
        return this.companyNameField.getText();
    }

    public String getContactList() {
        return this.contactArea.getText();
    }

    public void setDomainName(String name) {
        this.domainNameField.setText(name);
    }

    public void setCompanyName(String name) {
        this.companyNameField.setText(name);
    }

    public void setContactList(String list) {
        this.contactArea.setText(list);
    }

    public void disableDomainName() {
        this.domainNameField.setEnabled(false);
    }

    public void setAutoDeleteIdleClient(boolean status) {
        this.autoDeleteIdleClient.setSelected(status);
        this.maxClientIdleDuration.setEditable(this.autoDeleteIdleClient.isSelected());
        this.autoDeleteIdleNPVDIClient.setEnabled(this.autoDeleteIdleClient.isSelected());
        this.maxNPVDIClientIdleDuration.setEditable(this.autoDeleteIdleClient.isSelected() & this.autoDeleteIdleNPVDIClient.isSelected());
    }

    public void setAutoDeleteIdleNPVDIClient(boolean status) {
        this.autoDeleteIdleNPVDIClient.setSelected(status);
        this.maxNPVDIClientIdleDuration.setEditable(this.autoDeleteIdleClient.isSelected() & this.autoDeleteIdleNPVDIClient.isSelected());
    }

    public boolean isAutoDeleteIdleClient() {
        return this.autoDeleteIdleClient.isSelected();
    }

    public boolean isAutoDeleteIdleNPVDIClient() {
        return this.autoDeleteIdleNPVDIClient.isSelected();
    }

    public void setMaxClientIdleDuration(int duration) {
        this.oldClientIdleDuration = String.valueOf(duration / 3600 / 24);
        this.maxClientIdleDuration.setText(this.oldClientIdleDuration);
    }

    public void setMaxNPVDIClientIdleDuration(int duration) {
        this.oldNPVDIClientIdleDuration = String.valueOf(duration / 3600 / 24);
        this.maxNPVDIClientIdleDuration.setText(this.oldNPVDIClientIdleDuration);
    }

    public int getMaxClientIdleDuration() {
        String daysAsString = this.maxClientIdleDuration.getText().trim();
        int days = 0;
        try {
            days = Integer.parseInt(daysAsString) * 3600 * 24;
        }
        catch (Exception ignore) {
            LoggerUtilities.logException((Throwable)ignore);
        }
        return days;
    }

    public int getMaxNPVDIClientIdleDuration() {
        String daysAsString = this.maxNPVDIClientIdleDuration.getText().trim();
        int days = 0;
        try {
            days = Integer.parseInt(daysAsString) * 3600 * 24;
        }
        catch (Exception ignore) {
            LoggerUtilities.logException((Throwable)ignore);
        }
        return days;
    }

    public JPanel getDomainInfoPanel() {
        return this.centerPanel;
    }

    public boolean isCQEnabled() {
        return this.enableCQ.isSelected();
    }

    public void setCQEnabled(boolean value) {
        this.enableCQ.setSelected(value);
    }
}

