/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.admin.logicobject.CustomClientInstallationFeatureObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CustomFeaturesDialog
extends DialogBase {
    private static final long serialVersionUID = 5564856737893511630L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private static final String COMMONUI = "com.sygate.scm.common.ui.ui";
    public static final String STANDARD_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomStandard");
    public static final String EMAIL_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomEmail");
    public static final String BASIC_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "ClientInstallFeatureSetUtility.CDWCustomBasic");
    public static final String CUSTOM_PROTECTION = MSGRES.getString("com.sygate.scm.common.ui.ui", "CustomFeaturesDialog.descText");
    private CustomClientInstallationFeatureObject ccifObj;
    private JPanel featurePanel = null;
    private DescriptionTextArea titleText = null;
    private JRadioButton standardOption = new JRadioButton(STANDARD_PROTECTION, true);
    private JCheckBox emailChkBox = new JCheckBox(EMAIL_PROTECTION, false);
    private JRadioButton basicOption = new JRadioButton(BASIC_PROTECTION, false);

    public CustomFeaturesDialog(JFrame parent, String title, boolean modal) {
        this(parent, title, modal, null);
    }

    public CustomFeaturesDialog(JFrame parent, String title, boolean modal, CustomClientInstallationFeatureObject ccifObj) {
        super(parent, title, modal, false);
        this.initialize();
        this.ccifObj = ccifObj;
        if (this.ccifObj == null) {
            this.ccifObj = new CustomClientInstallationFeatureObject();
        }
        this.updateData();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_clients_client_deployment_wizard_custom_features";
    }

    private void updateData() {
        if (this.ccifObj.getType() == CustomClientInstallationFeatureObject.ProtectionType.BASIC_PROTECTION) {
            this.basicOption.setSelected(true);
        } else {
            this.standardOption.setSelected(true);
        }
        this.emailChkBox.setSelected(this.ccifObj.isEmailOn());
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getFeaturePanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected void commit() {
        this.saveSettings();
    }

    private void saveSettings() {
        boolean emailOn = false;
        CustomClientInstallationFeatureObject.ProtectionType type = CustomClientInstallationFeatureObject.ProtectionType.STANDARD_PROTECTION;
        if (this.basicOption.isSelected()) {
            type = CustomClientInstallationFeatureObject.ProtectionType.BASIC_PROTECTION;
        }
        emailOn = this.emailChkBox.isSelected();
        this.ccifObj.changeType(type, emailOn);
    }

    @Override
    protected boolean isValidate() {
        boolean allOK = true;
        if (!this.standardOption.isSelected() && !this.basicOption.isSelected()) {
            allOK = false;
        }
        if (!allOK) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.mustSelectOne"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.error"), 0);
        }
        return allOK;
    }

    public DescriptionTextArea getTitleDescription() {
        if (this.titleText == null) {
            this.titleText = new DescriptionTextArea(CUSTOM_PROTECTION);
        }
        return this.titleText;
    }

    public JPanel getFeaturePanel() {
        if (this.featurePanel == null) {
            this.featurePanel = new JPanel(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            this.featurePanel.add((Component)this.getTitleDescription(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 0, 20), 0, 0));
            this.featurePanel.add((Component)this.standardOption, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 25, 0, 20), 0, 0));
            this.featurePanel.add((Component)this.basicOption, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 25, 0, 20), 0, 0));
            this.featurePanel.add((Component)this.emailChkBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 45, 30, 20), 0, 0));
            group.add(this.standardOption);
            group.add(this.basicOption);
        }
        return this.featurePanel;
    }

    public ClientInstallationFeatures getFeatures() {
        return this.ccifObj.getClientInstallationFeatures();
    }
}

