/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.ConstantValue;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ConfigurePasswordRequirementsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCbxUppercase = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.checkbox.uppercase"));
    private JCheckBox jCbxLowercase = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.checkbox.lowercase"));
    private JCheckBox jCbxDigits = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.checkbox.digits"));
    private JCheckBox jCbxSpecial = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.checkbox.special"));
    private JCheckBox jCbxLimitReuse = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.checkbox.limitreuse"));
    private JTextField jTFMinCharacters = new JTextField(new NumberPlainDocument(1L, ConstantValue.MAX_CHARACTERS_CEILING.intValue(), true), "", 5);
    private JTextField jTFMaxCharacters = new JTextField(new NumberPlainDocument(1L, ConstantValue.MAX_CHARACTERS_CEILING.intValue(), true), "", 5);
    private JTextField jTFReuseHistory = new JTextField(new NumberPlainDocument(1L, ConstantValue.HISTORY_COUNT_CEILING.intValue(), true), "", 5);
    private JTextField jTFReuseSpan = new JTextField(new NumberPlainDocument(1L, ConstantValue.HISTORY_SPAN_CEILING.intValue(), true), "", 5);

    public ConfigurePasswordRequirementsPanel() {
        this.initialize();
    }

    public boolean isValidate() {
        return this.validatePasswordSettings();
    }

    public void updatePasswordSettingsData() {
        try {
            SemConfigRoot semConfigRoot = DataobjectManager.getInstance().getSemConfigRoot();
            PasswordSettings passwordSettings = semConfigRoot.getOptPasswordSettings();
            if (passwordSettings == null) {
                passwordSettings = new PasswordSettings();
            }
            passwordSettings.setOptUppercase(Boolean.valueOf(this.jCbxUppercase.isSelected()));
            passwordSettings.setOptLowercase(Boolean.valueOf(this.jCbxLowercase.isSelected()));
            passwordSettings.setOptDigits(Boolean.valueOf(this.jCbxDigits.isSelected()));
            passwordSettings.setOptSpecial(Boolean.valueOf(this.jCbxSpecial.isSelected()));
            passwordSettings.setOptLimitReuse(Boolean.valueOf(this.jCbxLimitReuse.isSelected()));
            passwordSettings.setOptMinCharacters(Integer.valueOf(ConfigurePasswordRequirementsPanel.parseInt(this.jTFMinCharacters)));
            passwordSettings.setOptMaxCharacters(Integer.valueOf(ConfigurePasswordRequirementsPanel.parseInt(this.jTFMaxCharacters)));
            passwordSettings.setOptReuseHistory(Integer.valueOf(ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseHistory)));
            passwordSettings.setOptReuseSpan(Integer.valueOf(ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseSpan)));
            semConfigRoot.setOptPasswordSettings(passwordSettings);
            DataobjectManager.getInstance().updateSemConfigRoot("Merge", semConfigRoot);
            ConsoleLogger.logAdminEvent(4135);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.log((String)"ConfigurePasswordRequirementsPanel >> updatePasswordSettingsData");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel notificationPanel = this.createNotificationPanel();
        UiUtilities.centerComponent((Component)notificationPanel, (Container)this);
        this.add((Component)this.createNotificationPanel(), "Center");
        this.add((Component)this.createPasswordSettingsPanel(), "North");
        this.loadPasswordSettingsData();
        this.toggleComponents();
        this.jCbxLimitReuse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigurePasswordRequirementsPanel.this.toggleComponents();
            }
        });
    }

    private void toggleComponents() {
        if (this.jCbxLimitReuse.isSelected()) {
            this.jTFReuseHistory.setEnabled(true);
            this.jTFReuseSpan.setEnabled(true);
            this.jTFReuseHistory.setEditable(true);
            this.jTFReuseSpan.setEditable(true);
        } else {
            this.jTFReuseHistory.setEnabled(false);
            this.jTFReuseSpan.setEnabled(false);
            this.jTFReuseHistory.setEditable(false);
            this.jTFReuseSpan.setEditable(false);
        }
    }

    private JPanel createPasswordSettingsPanel() {
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.add((Component)this.jCbxUppercase, this.getGridBagConstraint(ConstraintType.CHECKBOX, 0, 1));
        tempPanel.add((Component)this.jCbxLowercase, this.getGridBagConstraint(ConstraintType.CHECKBOX, 0, 2));
        tempPanel.add((Component)this.jCbxDigits, this.getGridBagConstraint(ConstraintType.CHECKBOX, 0, 3));
        tempPanel.add((Component)this.jCbxSpecial, this.getGridBagConstraint(ConstraintType.CHECKBOX, 0, 4));
        tempPanel.add((Component)this.jCbxLimitReuse, this.getGridBagConstraint(ConstraintType.CHECKBOX, 0, 8));
        tempPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.mincharacters.label")), this.getGridBagConstraint(ConstraintType.LABEL, 0, 5));
        tempPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.maxcharacters.label")), this.getGridBagConstraint(ConstraintType.LABEL, 0, 6));
        tempPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.reusehistory.label")), this.getGridBagConstraint(ConstraintType.SUB_LABEL, 0, 9));
        tempPanel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.reusespan.label")), this.getGridBagConstraint(ConstraintType.SUB_LABEL, 0, 10));
        tempPanel.add((Component)this.jTFMinCharacters, this.getGridBagConstraint(ConstraintType.TEXT_FIELD, 1, 5));
        tempPanel.add((Component)this.jTFMaxCharacters, this.getGridBagConstraint(ConstraintType.TEXT_FIELD, 1, 6));
        tempPanel.add((Component)this.jTFReuseHistory, this.getGridBagConstraint(ConstraintType.TEXT_FIELD, 1, 9));
        tempPanel.add((Component)this.jTFReuseSpan, this.getGridBagConstraint(ConstraintType.TEXT_FIELD, 1, 10));
        tempPanel.add((Component)new JSeparator(), this.getGridBagConstraint(ConstraintType.SEPARATOR, 0, 7));
        JPanel passwordSettingsPanel = new JPanel(new BorderLayout());
        passwordSettingsPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.border.title")));
        passwordSettingsPanel.add(tempPanel);
        return passwordSettingsPanel;
    }

    private JPanel createNotificationPanel() {
        JPanel notificationPanel = new JPanel(new FlowLayout());
        notificationPanel.add(new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.label.notice")));
        return notificationPanel;
    }

    private GridBagConstraints getGridBagConstraint(ConstraintType type, int x, int y) {
        switch (type) {
            case CHECKBOX: {
                return new GridBagConstraints(x, y, 1, 1, 0.1, 1.0, 17, 0, new Insets(6, 13, 3, 3), 0, 0);
            }
            case LABEL: {
                return new GridBagConstraints(x, y, 1, 1, 0.1, 1.0, 17, 0, new Insets(6, 18, 3, 3), 0, 0);
            }
            case SUB_LABEL: {
                return new GridBagConstraints(x, y, 1, 1, 0.1, 1.0, 17, 0, new Insets(6, 33, 3, 3), 0, 0);
            }
            case TEXT_FIELD: {
                return new GridBagConstraints(x, y, 1, 1, 0.1, 1.0, 17, 0, new Insets(6, 3, 3, 3), 0, 0);
            }
            case SEPARATOR: {
                return new GridBagConstraints(x, y, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 5, 10), 0, 0);
            }
        }
        return new GridBagConstraints();
    }

    public static int parseInt(JTextField textField) {
        try {
            return Integer.parseInt(textField.getText().trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean validatePasswordSettings() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (ConfigurePasswordRequirementsPanel.parseInt(this.jTFMinCharacters) < ConstantValue.MIN_CHARACTERS_FLOOR || ConfigurePasswordRequirementsPanel.parseInt(this.jTFMinCharacters) > ConstantValue.MAX_CHARACTERS_CEILING) {
            errorMessages.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.mincharacters.error"));
        }
        if (ConfigurePasswordRequirementsPanel.parseInt(this.jTFMaxCharacters) < ConstantValue.MIN_CHARACTERS_FLOOR || ConfigurePasswordRequirementsPanel.parseInt(this.jTFMaxCharacters) > ConstantValue.MAX_CHARACTERS_CEILING) {
            errorMessages.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.maxcharacters.error"));
        }
        if (ConfigurePasswordRequirementsPanel.parseInt(this.jTFMaxCharacters) < ConfigurePasswordRequirementsPanel.parseInt(this.jTFMinCharacters)) {
            errorMessages.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.numcharacters.error"));
        }
        if (this.jCbxLimitReuse.isSelected()) {
            if (ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseHistory) < ConstantValue.HISTORY_COUNT_FLOOR || ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseHistory) > ConstantValue.HISTORY_COUNT_CEILING) {
                errorMessages.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.reusehistory.error"));
            }
            if (ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseSpan) < ConstantValue.HISTORY_SPAN_FLOOR || ConfigurePasswordRequirementsPanel.parseInt(this.jTFReuseSpan) > ConstantValue.HISTORY_SPAN_CEILING) {
                errorMessages.add(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.reusespan.error"));
            }
        }
        if (!errorMessages.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String errorMessage : errorMessages) {
                message.append(errorMessage).append(System.getProperty("line.separator"));
            }
            JOptionPane.showMessageDialog(this, message.toString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ConfigPwdRequirementsPanel.title.error"), 0);
        }
        return errorMessages.isEmpty();
    }

    private void loadPasswordSettingsData() {
        try {
            SemConfigRoot configRoot = DataobjectManager.getInstance().getSemConfigRoot();
            PasswordSettings passwordSettings = configRoot.getOptPasswordSettings();
            if (passwordSettings == null) {
                passwordSettings = new PasswordSettings();
            }
            this.jCbxUppercase.setSelected(Optional.ofNullable(passwordSettings.getOptUppercase()).orElse(passwordSettings.getDefUppercase()));
            this.jCbxLowercase.setSelected(Optional.ofNullable(passwordSettings.getOptLowercase()).orElse(passwordSettings.getDefLowercase()));
            this.jCbxDigits.setSelected(Optional.ofNullable(passwordSettings.getOptDigits()).orElse(passwordSettings.getDefDigits()));
            this.jCbxSpecial.setSelected(Optional.ofNullable(passwordSettings.getOptSpecial()).orElse(passwordSettings.getDefSpecial()));
            this.jCbxLimitReuse.setSelected(Optional.ofNullable(passwordSettings.getOptLimitReuse()).orElse(passwordSettings.getDefLimitReuse()));
            this.jTFMinCharacters.setText(Integer.toString(Optional.ofNullable(passwordSettings.getOptMinCharacters()).orElse(passwordSettings.getDefMinCharacters())));
            this.jTFMaxCharacters.setText(Integer.toString(Optional.ofNullable(passwordSettings.getOptMaxCharacters()).orElse(passwordSettings.getDefMaxCharacters())));
            this.jTFReuseHistory.setText(Integer.toString(Optional.ofNullable(passwordSettings.getOptReuseHistory()).orElse(passwordSettings.getDefReuseHistory())));
            this.jTFReuseSpan.setText(Integer.toString(Optional.ofNullable(passwordSettings.getOptReuseSpan()).orElse(passwordSettings.getDefReuseSpan())));
        }
        catch (ConsoleException ex) {
            LoggerUtilities.log((String)"ConfigurePasswordRequirementsPanel >> loadPasswordSettingsData");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private static enum ConstraintType {
        CHECKBOX,
        LABEL,
        SEPARATOR,
        SUB_LABEL,
        TEXT_FIELD;

    }
}

