/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.CompanyInformation;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.RestrictedPlainDocument;
import com.sygate.scm.console.handler.CompanyInformationHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.util.ConsoleException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class CompanyInformationPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JTextField tfCompanyName = new JTextField(30);
    private JLabel labelCompanyName = null;

    public CompanyInformationPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private String getCompanyName() {
        return this.tfCompanyName.getText().trim();
    }

    private void setCompanyName(String companyName) {
        if (companyName != null && companyName.length() > 0) {
            this.tfCompanyName.setText(companyName);
        }
    }

    private static String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", key);
    }

    private JPanel getInnerPanel() {
        this.labelCompanyName = new JLabel(CompanyInformationPanel.getResourceString("CompanyInformationPanel.companyName"));
        this.tfCompanyName.setColumns(30);
        RestrictedPlainDocument companyNameDoc = new RestrictedPlainDocument(50);
        companyNameDoc.setValidator("\"%<>&/", false);
        this.tfCompanyName.setDocument((Document)companyNameDoc);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.labelCompanyName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        panel.add((Component)this.tfCompanyName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        return panel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_company";
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new CompanyInformationPanel());
        f.pack();
        f.setVisible(true);
    }

    public void setData() {
        this.setCompanyName(CompanyInformationHandler.getCompanyName());
    }

    public boolean isValidate() {
        return true;
    }

    void commitCompanyInformation() {
        block3: {
            String companyName = this.getCompanyName();
            if (!companyName.equals(CompanyInformationHandler.getCompanyName())) {
                try {
                    CompanyInformation companyInfo = new CompanyInformation();
                    companyInfo.setOptCompanyName(companyName);
                    CompanyInformationHandler.updateCompanyInformation(companyInfo);
                }
                catch (ConsoleException ex) {
                    Object[] obj = new Object[]{ex.getMessage()};
                    String str = CompanyInformationPanel.getResourceString("CompanyInformationPanel.dataCannotBeUpdated");
                    String fm = MessageFormat.format(str, obj);
                    String title = CompanyInformationPanel.getResourceString("CompanyInformationPanel.errorTitle");
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, title, 0);
                    if (!ex.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }
}

