/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.ClientInstallationSettings;
import com.sygate.scm.common.configobject.schema.CommunicationOption;
import com.sygate.scm.common.configobject.schema.InstallationOption;
import com.sygate.scm.common.configobject.schema.RebootOptions;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallPoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationSettingObject;
import com.sygate.scm.console.ui.client.dlg.MacClientInstallationSettingsPanel;
import com.sygate.scm.console.ui.client.dlg.SoftwarePackagePropsInstallSettingsPanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NamePanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ClientInstallationSettingsDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private NamePanel namePanel;
    private SoftwarePackagePropsInstallSettingsPanel winSettingPanel;
    private MacClientInstallationSettingsPanel macSettingPanel;
    private JScrollPane centerScrollPane;
    private boolean readOnly;
    private ClientInstallationSettingObject settingObj;
    private JComboBox<String> platformCombo;
    private Integer selectedPlatform = ClientInstallationSettings.WINDOWS;
    private boolean isEdit = false;
    private JLabel macDescription;

    public ClientInstallationSettingsDlg(JFrame owner, String title, boolean modal, boolean _readOnly, boolean isEdit) throws HeadlessException {
        super(owner, title, modal);
        this.readOnly = _readOnly;
        this.isEdit = isEdit;
        this.initialize();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private void initialize() {
        JPanel sppisp = this.getSettingPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getNorthPanel(), "North");
        this.getContentPane().add((Component)this.getCentralScrollPane(sppisp), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JScrollPane getCentralScrollPane(JComponent view) {
        this.centerScrollPane = UIUtilities.createScrollPaneWithoutBoard(view);
        return this.centerScrollPane;
    }

    private JPanel getNorthPanel() {
        JPanel retPanel = new JPanel(new VerticalFlowLayout());
        retPanel.add(this.getPlatformCombPanel());
        retPanel.add(this.getNamePanel());
        return retPanel;
    }

    private int getPlatFormType() {
        return this.selectedPlatform;
    }

    private void setupPlatform() {
        if (this.platformCombo != null) {
            if (ClientInstallationSettings.MAC.equals(this.getPlatFormType())) {
                this.platformCombo.setSelectedIndex(1);
            } else {
                this.platformCombo.setSelectedIndex(0);
            }
        }
    }

    private JPanel getPlatformCombPanel() {
        if (this.platformCombo == null) {
            this.platformCombo = new JComboBox<String>(new String[]{this.getResMsg("PlatformWindows"), this.getResMsg("PlatformMac")});
            this.macDescription = new JLabel(this.getResMsg("MacDescription"));
            this.macDescription.setVisible(false);
            this.setupPlatform();
            this.platformCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        String selectedOS = (String)ClientInstallationSettingsDlg.this.platformCombo.getSelectedItem();
                        if (ClientInstallationSettingsDlg.this.getResMsg("PlatformWindows").equals(selectedOS)) {
                            ClientInstallationSettingsDlg.this.macDescription.setVisible(false);
                            ClientInstallationSettingsDlg.this.switchToPlatformSettings(ClientInstallationSettings.WINDOWS);
                        } else if (ClientInstallationSettingsDlg.this.getResMsg("PlatformMac").equals(selectedOS)) {
                            ClientInstallationSettingsDlg.this.macDescription.setVisible(true);
                            ClientInstallationSettingsDlg.this.switchToPlatformSettings(ClientInstallationSettings.MAC);
                        }
                        ClientInstallationSettingsDlg.this.pack();
                    }
                }
            });
        }
        this.platformCombo.setEnabled(!this.isEdit);
        JPanel innerComboPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(5, 2, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        String platformLabelTxt = this.getResMsg("PlatformType");
        JLabel label = new JLabel(platformLabelTxt);
        label.setLabelFor(this.platformCombo);
        innerComboPanel.add((Component)label, c);
        c.insets = new Insets(5, 20, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        innerComboPanel.add(this.platformCombo, c);
        c.insets = new Insets(5, 20, 0, 0);
        c.gridx = 2;
        c.gridy = 0;
        innerComboPanel.add((Component)this.macDescription, c);
        JPanel retPanel = new JPanel(new FlowLayout(0));
        retPanel.add(innerComboPanel);
        return retPanel;
    }

    private void switchToPlatformSettings(Integer platform) {
        this.selectedPlatform = platform;
        this.getContentPane().remove(this.centerScrollPane);
        this.getContentPane().add((Component)this.getCentralScrollPane(this.getSettingPanel()), "Center");
        this.pack();
    }

    private String getResMsg(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSettingsDlg." + key);
    }

    @Override
    protected void commit() {
        this.settingObj.setPlatform(this.getPlatFormType());
        String name = this.namePanel.getName();
        this.settingObj.setName(name);
        String desc = this.namePanel.getDescription();
        this.settingObj.setDescription(desc);
        if (ClientInstallationSettings.WINDOWS.equals(this.getPlatFormType())) {
            InstallationOption install = this.winSettingPanel.generateInstallationOption();
            this.settingObj.setInstallationOption(install);
            this.settingObj.setCommunicationOption(this.winSettingPanel.generateCommunicationOption());
            RebootOptions ro = this.winSettingPanel.generateRebootOptions();
            this.settingObj.setOptRebootOptions(ro);
        } else {
            InstallationOption install = this.macSettingPanel.generateInstallationOption();
            this.settingObj.setInstallationOption(install);
            this.settingObj.setCommunicationOption(this.macSettingPanel.generateCommunicationOption());
            RebootOptions ro = this.macSettingPanel.generateRebootOptions();
            this.settingObj.setOptRebootOptions(ro);
        }
    }

    @Override
    protected boolean isValidate() {
        String curId = this.settingObj.getId();
        try {
            return this.namePanel.isValidate(ClientInstallPoolObject.getAllNames(curId)) && this.winSettingPanel.isValidate();
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            return false;
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return ClientInstallationSettings.MAC.equals(this.getPlatFormType()) ? "sesm_admin_install_packages_dialog_add_mac_installation_setting" : "sesm_admin_install_packages_dialog_add_installation_setting";
    }

    private JPanel getSettingPanel() {
        if (ClientInstallationSettings.WINDOWS.equals(this.getPlatFormType())) {
            if (this.winSettingPanel == null) {
                this.winSettingPanel = new SoftwarePackagePropsInstallSettingsPanel(this.readOnly);
            }
            return this.winSettingPanel;
        }
        if (this.macSettingPanel == null) {
            this.macSettingPanel = new MacClientInstallationSettingsPanel(this.readOnly);
        }
        return this.macSettingPanel;
    }

    private NamePanel getNamePanel() {
        if (this.namePanel == null) {
            this.namePanel = new NamePanel(this.readOnly);
            this.namePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 15));
        }
        return this.namePanel;
    }

    public void setObject(ClientInstallationSettingObject sObj, boolean readOnly) {
        this.settingObj = sObj;
        this.setPanel();
        if (readOnly) {
            this.disableAllComponents();
        }
    }

    private void setPanel() {
        this.selectedPlatform = this.settingObj.getPlatform();
        this.setupPlatform();
        this.namePanel.setData(this.settingObj.getName(), this.settingObj.getDescription());
        InstallationOption install = this.settingObj.getInstallationOption();
        CommunicationOption com = this.settingObj.getCommunicationOption();
        RebootOptions ro = null;
        try {
            ro = this.settingObj.getOptRebootOptions();
            if (ro == null) {
                ro = new RebootOptions();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ClientInstallationSettings.WINDOWS.equals(this.getPlatFormType())) {
            this.winSettingPanel.setData(install, com, ro);
        } else {
            this.macSettingPanel.setData(install, com, ro);
        }
        if (this.settingObj.isSystemObject()) {
            this.disableAllComponents();
        }
        this.pack();
    }

    private void disableAllComponents() {
        UIUtilities.setContainerStatus(this.getSettingPanel(), false);
        UIUtilities.setContainerStatus(this.namePanel, false);
        if (ClientInstallationSettings.WINDOWS.equals(this.getPlatFormType())) {
            this.winSettingPanel.setTabPaneEnabled(true);
        } else {
            this.macSettingPanel.setTabPaneEnabled(true);
        }
        this.jBOk.setEnabled(false);
        this.platformCombo.setEnabled(false);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (ClientInstallationSettings.WINDOWS.equals(this.getPlatFormType())) {
            this.winSettingPanel.setTabPaneEnabled(true);
            this.winSettingPanel.setReadOnly(readOnly);
        } else {
            this.macSettingPanel.setTabPaneEnabled(true);
            this.macSettingPanel.setReadOnly(readOnly);
        }
        this.platformCombo.setEnabled(!readOnly);
        this.jBOk.setEnabled(!this.readOnly);
    }
}

