/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.ClientFeature;
import com.sygate.scm.common.configobject.schema.ClientInstallationFeatures;
import com.sygate.scm.common.configobject.schema.EnabledClientFeatures;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.ClientInstallFeatureSetUtility;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.admin.dlg.FilteredDisplayComboRenderer;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallFeaturePoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.client.wizard.ClientInstallFeaturePanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NamePanel;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ClientInstallationSAVFeaturesDlg
extends DialogBase
implements ClientInstallFeaturePanel.ClientInstallFeaturePanelListener {
    private static final long serialVersionUID = 3486516356439816835L;
    private NamePanel namePanel;
    private JPanel centerPanel = null;
    private Map<String, ClientInstallFeaturePanel> featureTreeMap = new HashMap<String, ClientInstallFeaturePanel>();
    private JPanel featureTreePanel = null;
    private JPanel mapControlPanel = null;
    private DescriptionTextArea jlblAutoMapDesc = null;
    JCheckBox jCbxAautoMap = null;
    private boolean keepAutoMapping = true;
    JComboBox<String> versionCombo = null;
    private JLabel versionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.comboVersionTitle"));
    private String selectedVersion = "14.3.5000.0";
    private String clientFeatureSetName = null;
    private ClientInstallationFeatureObject settingObj;

    public ClientInstallationSAVFeaturesDlg(JFrame owner, String title, boolean modal, boolean readOnly, String name) throws HeadlessException {
        super(owner, title, modal);
        this.readOnly = readOnly;
        this.clientFeatureSetName = name;
        this.initialize();
        if (readOnly) {
            this.setReadOnly();
        }
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getNamePanel(), "North");
        this.getContentPane().add((Component)this.getCenterPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new GridBagLayout());
            this.centerPanel.add((Component)this.getMapControlPanel(), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 15, 2, 0), 0, 0));
            this.centerPanel.add((Component)this.getFeatureTreePanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 15, 2, 0), 0, 0));
        }
        return this.centerPanel;
    }

    private JPanel getMapControlPanel() {
        if (this.mapControlPanel == null) {
            this.mapControlPanel = new JPanel(new GridBagLayout());
            this.jlblAutoMapDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.AutoMapDesc"));
            JScrollPane jScrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)jScrollPane, (JTextArea)this.jlblAutoMapDesc);
            this.jCbxAautoMap = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.checkboxAutoMap"), true);
            this.mapControlPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 2, 10), 0, 0));
            this.mapControlPanel.add((Component)this.versionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 2, 0), 0, 0));
            this.mapControlPanel.add(this.getVersionCombo(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 2, 0), 0, 0));
            this.versionLabel.setLabelFor(this.versionCombo);
            this.mapControlPanel.add((Component)this.jCbxAautoMap, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 2, 0), 0, 0));
            this.jCbxAautoMap.setVisible(false);
            this.jCbxAautoMap.addActionListener(e -> this.flipAutoMap());
        }
        return this.mapControlPanel;
    }

    protected void flipAutoMap() {
        boolean isAutomapped = this.jCbxAautoMap.isSelected();
        this.setKeepAutoMapping(isAutomapped);
        ClientInstallationFeatures cif = this.settingObj.getClientInstallationFeatures();
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.findFeatureVersionFromFeatureSet((String)this.getSelectedVersion(), (ClientInstallationFeatures)cif, (boolean)false);
        if (this.getSelectedVersion().compareToIgnoreCase("14.3.5000.0") != 0) {
            ecf.setOptEditable(Boolean.valueOf(!isAutomapped));
            this.setTreeMode(isAutomapped, this.getSelectedVersion());
            if (isAutomapped) {
                this.handleAutoConvert("14.3.5000.0", this.getSelectedVersion());
            }
        }
    }

    private JPanel getFeatureTreePanel() {
        if (this.featureTreePanel == null) {
            ClientInstallFeaturePanel cip14_3RU4;
            ClientInstallFeaturePanel cip14_2RU1;
            ClientInstallFeaturePanel cip14_2;
            ClientInstallFeaturePanel cip12_5;
            this.featureTreePanel = new JPanel(new CardLayout());
            List verList = ClientInstallFeatureSetUtility.getVersionList();
            int count = verList.size();
            this.getFeatureObject().setName(this.clientFeatureSetName);
            for (int i = 0; i < count; ++i) {
                ClientInstallFeaturePanel panel = this.getSettingPanel(this.getFeatureObject().getClientInstallationFeatures(), ((String)verList.get(i)).toString());
                this.getFeatureTreeMap().put(((String)verList.get(i)).toString(), panel);
                this.featureTreePanel.add((Component)panel, ((String)verList.get(i)).toString());
            }
            ClientInstallFeaturePanel cip12_1 = this.featureTreeMap.get("12.1.0.0");
            if (cip12_1 != null) {
                cip12_1.addClientInstallFeaturePanelListener(this);
            }
            if ((cip12_5 = this.featureTreeMap.get("12.1.2000.0")) != null) {
                cip12_5.addClientInstallFeaturePanelListener(this);
            }
            if ((cip14_2 = this.featureTreeMap.get("14.2.0000.0")) != null) {
                cip14_2.addClientInstallFeaturePanelListener(this);
            }
            if ((cip14_2RU1 = this.featureTreeMap.get("14.2.1000.0")) != null) {
                cip14_2RU1.addClientInstallFeaturePanelListener(this);
            }
            if ((cip14_3RU4 = this.featureTreeMap.get("14.3.4000.0")) != null) {
                cip14_3RU4.addClientInstallFeaturePanelListener(this);
            }
        }
        return this.featureTreePanel;
    }

    private ClientInstallationFeatureObject getFeatureObject() {
        if (this.settingObj == null) {
            this.settingObj = new ClientInstallationFeatureObject();
            ClientInstallationFeatures cif = ClientInstallFeatureSetUtility.createNewFeatureSet();
            this.settingObj.setClientInstallationFeatures(cif);
        }
        return this.settingObj;
    }

    JComboBox<String> getVersionCombo() {
        if (this.versionCombo == null) {
            this.versionCombo = new JComboBox(new Vector(ClientInstallFeatureSetUtility.getVersionList()));
            FilteredDisplayComboRenderer renderer = new FilteredDisplayComboRenderer();
            this.versionCombo.setRenderer(renderer);
            this.versionCombo.addActionListener(e -> this.versionChanged());
        }
        return this.versionCombo;
    }

    protected void versionChanged() {
        if (this.getNewVersionSelected() != null) {
            String newVersion;
            String previousVersion = this.getSelectedVersion();
            if (previousVersion.compareToIgnoreCase(newVersion = this.getNewVersionSelected().toString()) == 0) {
                return;
            }
            this.flipFeatureSetView(newVersion);
            this.checkAutoMap(newVersion);
            if (Utility.compareVersion((String)newVersion, (String)"14.3.5000.0") < 0) {
                EnabledClientFeatures enabledClientFeatures = this.settingObj.getEnabledFeaturesByVersion(this.getSelectedVersion());
                if (enabledClientFeatures != null) {
                    boolean editable = enabledClientFeatures.getOptEditable();
                    this.jCbxAautoMap.setSelected(!editable);
                    this.setKeepAutoMapping(!editable);
                    this.setTreeMode(!editable, this.getSelectedVersion());
                    if (this.isKeepAutoMapping()) {
                        this.handleAutoConvert(previousVersion, newVersion);
                    }
                }
            } else {
                this.setTreeMode(true, this.getSelectedVersion());
            }
        }
    }

    @Override
    public void featureTreeSelectionChanged(ClientInstallFeaturePanel source) {
        if (this.isKeepAutoMapping() && "14.3.4000.0".equals(source.getCurrentVersion())) {
            List<ClientFeature> features = source.getSelectedFeatureList();
            for (Map.Entry<String, ClientInstallFeaturePanel> entry : this.featureTreeMap.entrySet()) {
                if ("14.3.4000.0".equals(entry.getKey())) continue;
                EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.autoConvertFeatures(features, (String)entry.getKey(), (boolean)false);
                entry.getValue().handleAutoConvert(ecf, entry.getKey());
            }
        }
    }

    void handleAutoConvert(String currentVersion, String version) {
        List<ClientFeature> features = this.featureTreeMap.get(currentVersion).getSelectedFeatureList();
        EnabledClientFeatures ecf = ClientInstallFeatureSetUtility.autoConvertFeatures(features, (String)version, (boolean)false);
        this.featureTreeMap.get(version).handleAutoConvert(ecf, version);
    }

    private void flipFeatureSetView(String version) {
        this.setSelectedVersion(version);
        CardLayout cl = (CardLayout)this.getFeatureTreePanel().getLayout();
        cl.show(this.getFeatureTreePanel(), version);
    }

    public void checkAutoMap(String version) {
        String currentVersion = "14.3.5000.0";
        boolean visible = Utility.compareVersion((String)version, (String)currentVersion) < 0;
        this.jCbxAautoMap.setVisible(visible);
    }

    @Override
    protected void commit() {
        String name = this.namePanel.getName();
        this.settingObj.setName(name);
        String desc = this.namePanel.getDescription();
        this.settingObj.setDescription(desc);
        this.saveSettings();
    }

    void saveSettings() {
        int count = this.getVersionCombo().getItemCount();
        for (int i = 0; i < count; ++i) {
            String version = this.getVersionCombo().getItemAt(i);
            if (Utility.compareVersion((String)version, (String)"14.3.5000.0") < 0 && this.featureTreeMap.get(version).getMode() != 1) {
                this.handleAutoConvert("14.3.5000.0", version);
            }
            this.featureTreeMap.get(version).save();
        }
    }

    @Override
    protected boolean isValidate() {
        String curId = this.settingObj.getId();
        boolean allOK = true;
        try {
            allOK = this.namePanel.isValidate(ClientInstallFeaturePoolObject.getAllNames(curId));
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            allOK = false;
        }
        if (allOK) {
            ArrayList<ClientInstallFeaturePanel> listPane = new ArrayList<ClientInstallFeaturePanel>(this.featureTreeMap.values());
            Collections.sort(listPane, new Comparator<ClientInstallFeaturePanel>(){

                @Override
                public int compare(ClientInstallFeaturePanel cifp1, ClientInstallFeaturePanel cifp2) {
                    return cifp2.getCurrentVersion().compareTo(cifp1.getCurrentVersion());
                }
            });
            for (ClientInstallFeaturePanel cifp : listPane) {
                allOK = cifp.isValidate();
                if (allOK) continue;
                this.versionCombo.setSelectedItem(cifp.getCurrentVersion());
                String messageKey = null;
                messageKey = Utility.compareVersion((String)cifp.getCurrentVersion(), (String)"14.3.5000.0") >= 0 ? "ClientInstallationSAVFeatureDlg.reduceLevelWarning" : "ClientInstallationSAVFeatureDlg.legacy.clients.reduceLevelWarning";
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", messageKey), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ClientInstallationSAVFeatureDlg.reduceLevelWarningTitle"), 2);
                break;
            }
            allOK = true;
        }
        return allOK;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_install_packages_dialog_add_installation_feature";
    }

    private ClientInstallFeaturePanel getSettingPanel(ClientInstallationFeatures cif, String ver) {
        ClientInstallFeaturePanel settingPanel = new ClientInstallFeaturePanel(cif, ver);
        return settingPanel;
    }

    private NamePanel getNamePanel() {
        if (this.namePanel == null) {
            this.namePanel = new NamePanel(128, this.readOnly);
            this.namePanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        }
        return this.namePanel;
    }

    public void setObject(ClientInstallationFeatureObject sObj) {
        this.settingObj = sObj;
        this.setPanel();
    }

    private void setPanel() {
        this.namePanel.setData(this.settingObj.getName(), this.settingObj.getDescription());
        int count = this.getVersionCombo().getItemCount();
        for (int i = 0; i < count; ++i) {
            String version = this.getVersionCombo().getItemAt(i);
            this.featureTreeMap.get(version).setObject(this.settingObj.getClientInstallationFeatures(), version);
        }
        if (this.settingObj.isSystemObject()) {
            this.setReadOnly();
        }
    }

    private void setTreeMode(boolean tf, String version) {
        if (Utility.compareVersion((String)version, (String)"12.1.0.0") >= 0) {
            this.featureTreeMap.get(version).setMode(1);
        } else if (!tf) {
            this.featureTreeMap.get(version).setMode(1);
        } else {
            this.featureTreeMap.get(version).setMode(0);
        }
    }

    private void setReadOnly() {
        this.versionCombo.setEnabled(false);
        this.featureTreeMap.get(this.getSelectedVersion()).setMode(0);
        if (this.namePanel != null) {
            this.namePanel.setReadOnly();
        }
        this.jBOk.setEnabled(!this.readOnly);
    }

    public void setSelectedVersion(String selectedVersion) {
        this.selectedVersion = selectedVersion;
    }

    public String getSelectedVersion() {
        return this.selectedVersion;
    }

    public Object getNewVersionSelected() {
        return this.versionCombo.getSelectedItem();
    }

    public Map<String, ClientInstallFeaturePanel> getFeatureTreeMap() {
        return this.featureTreeMap;
    }

    public void setKeepAutoMapping(boolean keepAutoMapping) {
        this.keepAutoMapping = keepAutoMapping;
    }

    public boolean isKeepAutoMapping() {
        return this.keepAutoMapping;
    }
}

