/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.PasswordSettingsHelper;
import com.sygate.scm.common.ui.PasswordWidget;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.ui.util.PasswordClearUtil;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.PasswordSettingsUtil;
import com.sygate.scm.console.util.PasswordUtil;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChangePasswordPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPasswordField jTFCurrentPwd = null;
    private JPasswordField jTFPwd = null;
    private PasswordWidget jLPwdStatus = null;
    private JPasswordField jTFPwdCfm = null;
    private final MessageResources msgRes = MessageResources.getInstance();
    private final JLabel currentPwdLabel = new JLabel(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPwdLabel"));
    private final JLabel newPwdLabel = new JLabel(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.newPwdLabel"));
    private final JLabel verifyPwdLabel = new JLabel(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.verifyPwdLabel"));
    private final JLabel blankPwdLabel = new JLabel(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.blankPwdLabel"));
    private final JCheckBox jCbxPwdNeverExpires = new JCheckBox(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.PasswordNeverExpires"));
    private boolean showNeverExpiringCtrl = false;
    private boolean isAddNewAdmin = false;
    private boolean isChangePasswordTask = false;
    private boolean passwordVerificationThresholdExceeded = false;
    private boolean isSmartCardUser = false;
    private final GridBagLayout gridBagLayout3 = new GridBagLayout();

    public ChangePasswordPanel(boolean showNeverExpiringCtrl) {
        this(showNeverExpiringCtrl, false, false);
    }

    public ChangePasswordPanel(boolean showNeverExpiringCtrl, boolean isAddNewAdmin) {
        this(showNeverExpiringCtrl, isAddNewAdmin, false);
    }

    public int getCurrentAdminLoginType() {
        return AdminObject.retrieveCurrentAdminObject().getSemAdmin().getOptAuthenticationMethod();
    }

    public ChangePasswordPanel(boolean showNeverExpiringCtrl, boolean isAddNewAdmin, boolean isChangePasswordTask) {
        this.showNeverExpiringCtrl = showNeverExpiringCtrl;
        this.isAddNewAdmin = isAddNewAdmin;
        this.isChangePasswordTask = isChangePasswordTask;
        this.isSmartCardUser = SemAdministrator.SMARTCARD.equals(this.getCurrentAdminLoginType());
        this.getInner();
        this.changeDocumentCount(1024);
        this.addListener();
    }

    private PasswordWidget getJLPwdStatus() {
        if (this.jLPwdStatus == null) {
            this.jLPwdStatus = new PasswordWidget(true, false);
        }
        return this.jLPwdStatus;
    }

    public JPasswordField getTFCurrentPwd() {
        if (this.jTFCurrentPwd == null) {
            this.jTFCurrentPwd = new SEPMPasswordField(32);
        }
        return this.jTFCurrentPwd;
    }

    public JPasswordField getTFPwd() {
        if (this.jTFPwd == null) {
            this.jTFPwd = new SEPMPasswordField(32);
            this.jTFPwd.setPreferredSize(new Dimension(120, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        }
        return this.jTFPwd;
    }

    public JPasswordField getTFPwdCfm() {
        if (this.jTFPwdCfm == null) {
            this.jTFPwdCfm = new SEPMPasswordField(32);
            this.jTFPwdCfm.setPreferredSize(this.jTFPwdCfm.getPreferredSize());
        }
        return this.jTFPwdCfm;
    }

    public char[] getCurrentPwd() {
        return this.jTFCurrentPwd.getPassword();
    }

    public char[] getNewPwd() {
        return this.getTFPwd().getPassword();
    }

    public char[] getVerifyPwd() {
        return this.jTFPwdCfm.getPassword();
    }

    public void getInner() {
        this.setLayout(this.gridBagLayout3);
        this.blankPwdLabel.setFont(this.blankPwdLabel.getFont().deriveFont(2));
        int row = 0;
        if (!this.isAddNewAdmin && !this.isSmartCardUser) {
            this.add((Component)this.blankPwdLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
            this.add((Component)this.currentPwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
            this.add((Component)this.getTFCurrentPwd(), new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
        }
        if (this.isAddNewAdmin) {
            this.newPwdLabel.setText(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.pwdLabel"));
            this.verifyPwdLabel.setText(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.pwdConfirmLabel"));
        }
        this.add((Component)this.newPwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.add((Component)this.getTFPwd(), new GridBagConstraints(1, row++, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.verifyPwdLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.add((Component)this.getTFPwdCfm(), new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.getJLPwdStatus(), new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        if (this.showNeverExpiringCtrl) {
            this.add((Component)this.jCbxPwdNeverExpires, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 10, 10), 0, 0));
        }
        if (!this.isChangePasswordTask) {
            String title = "";
            title = this.isAddNewAdmin ? this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.setPwdTitle") : this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.changePwdTitle");
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title)));
        }
    }

    private void addListener() {
        this.getTFPwd().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                ChangePasswordPanel.this.handleListenerEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                ChangePasswordPanel.this.handleListenerEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
    }

    private void handleListenerEvent() {
        PasswordSettingsUtil.handlePassword(this.getTFPwd(), this.getJLPwdStatus());
    }

    public void changeDocumentCount(int count) {
        this.getTFCurrentPwd().setDocument(new RestrictedPlainDocument(count));
        this.getTFPwd().setDocument(new RestrictedPlainDocument(count));
        this.getTFPwdCfm().setDocument(new RestrictedPlainDocument(count));
    }

    public Collection<JComponent> getAllItems(boolean isSmartCardUser) {
        if (isSmartCardUser) {
            return this.getAllItemsForSmartCardUser();
        }
        return this.getAllItemsForNonSmartCardUser();
    }

    public Collection<JComponent> getAllItemsForNonSmartCardUser() {
        return Stream.concat(List.of(this.currentPwdLabel, this.getTFCurrentPwd()).stream(), this.getAllItemsForSmartCardUser().stream()).distinct().collect(Collectors.toList());
    }

    public Collection<JComponent> getAllItemsForSmartCardUser() {
        return List.of(this.newPwdLabel, this.verifyPwdLabel, this.getTFPwd(), this.getTFPwdCfm(), this.blankPwdLabel);
    }

    public void enableAllItems(boolean needEnabled) {
        this.getAllItems(this.isSmartCardUser).forEach(component -> component.setEnabled(needEnabled));
    }

    public void enableCurrentPassword(boolean needEnabled) {
        this.currentPwdLabel.setVisible(needEnabled);
        this.getTFCurrentPwd().setVisible(needEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordValid(AdminObject admin, boolean isDefaultAuthenticationModeBefore, boolean isFromChangePasswordPanel) {
        char[] currentPassword = this.getCurrentPwd();
        char[] newPassword = this.getNewPwd();
        char[] newPasswordConfirm = this.getVerifyPwd();
        boolean isPwdChecksNecessary = this.isPasswordValidationRequired(this.isAddNewAdmin, isFromChangePasswordPanel, currentPassword, newPassword, newPasswordConfirm);
        try {
            if (!isPwdChecksNecessary && isDefaultAuthenticationModeBefore || this.isSmartCardUser) {
                boolean bl = true;
                return bl;
            }
            if (!this.isAddNewAdmin && currentPassword.length == 0) {
                this.showErrorMessage(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.enterCurrentAdminPasssword"));
                boolean bl = false;
                return bl;
            }
            if (!Arrays.equals(newPassword, newPasswordConfirm)) {
                this.showErrorMessage(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.pwdNotMatch"));
                boolean bl = false;
                return bl;
            }
            String encryptedCurrentPassword = Utility.encryptLatest((char[])currentPassword);
            if (encryptedCurrentPassword == null) {
                ConsoleLogger.log("ChangePasswordPanel:isPasswordValid(): Error encrypting current password");
                boolean bl = false;
                return bl;
            }
            if (!this.validateCurrentPassword(admin, encryptedCurrentPassword)) {
                boolean bl = false;
                return bl;
            }
            PasswordSettings passwordSettings = PasswordSettingsUtil.getPasswordSettings();
            int result = PasswordSettingsHelper.checkRequirements((PasswordSettings)passwordSettings, (char[])newPassword);
            if (result != 0) {
                String passwordErrors = PasswordSettingsHelper.getPasswordErrorMessages((PasswordSettings)passwordSettings, (int)result, (boolean)true);
                this.showErrorMessage(passwordErrors);
                boolean bl = false;
                return bl;
            }
            boolean alreadyUsed = PasswordSettingsUtil.isPasswordInHistory(admin, this.getTFPwd().getPassword());
            if (alreadyUsed) {
                this.showErrorMessage(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.tooRecent"));
                boolean bl = false;
                return bl;
            }
            String encryptedNewPassword = Utility.encryptLatest((char[])newPassword);
            if (!this.isAddNewAdmin && Manager.isCurrentAdmin(admin.getId()) && StringUtilities.isEqual((String)encryptedCurrentPassword, (String)encryptedNewPassword)) {
                ConsoleLogger.log("AdminAuthenticationPanel>> setAdminPwd: same password so no need to change!");
                this.showErrorMessage(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.samePassword"));
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Arrays.fill(currentPassword, '0');
            Arrays.fill(newPassword, '0');
            Arrays.fill(newPasswordConfirm, '0');
            this.getTFCurrentPwd().requestFocus();
        }
        return true;
    }

    private boolean isPasswordValidationRequired(boolean isNewAdmin, boolean isFromChangePasswordPanel, char[] currentPassword, char[] newPassword, char[] newPasswordConfirm) {
        boolean result;
        boolean bl = result = !isNewAdmin && (currentPassword.length != 0 || newPassword.length != 0 || newPasswordConfirm.length != 0 || isFromChangePasswordPanel);
        if (isNewAdmin && !isFromChangePasswordPanel && currentPassword.length == 0) {
            result = true;
        }
        return result;
    }

    private void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(Manager.getFrame(), message, this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.error"), 0);
    }

    private boolean validateCurrentPassword(AdminObject admin, String encryptedCurrentPassword) {
        if (!this.isAddNewAdmin && !AdminHandler.isValidPasswordForCurrentAdmin(encryptedCurrentPassword)) {
            AdministratorState latestAdminState = null;
            try {
                latestAdminState = DataobjectManager.getInstance().getAdministratorState(DataobjectManager.getInstance().getCurrentAdministrator().getId());
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            if (latestAdminState != null) {
                String displayMessage;
                LoginConfigObject loginConfig = admin.getLoginConfig(false);
                int currentFailedAttempts = latestAdminState.getOptFailedPasswordVerificationAttemptNumber() != null ? latestAdminState.getOptFailedPasswordVerificationAttemptNumber().intValue() : latestAdminState.getDefFailedPasswordVerificationAttemptNumber().intValue();
                int threshold = loginConfig.getLoginConfig().getDefAttemptThresholdForPasswordVerification();
                int remainingAttempts = threshold - currentFailedAttempts;
                if (remainingAttempts > 0) {
                    displayMessage = MessageFormat.format(this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPasswordIsIncorrect"), remainingAttempts);
                } else {
                    displayMessage = this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.currentPasswordIsIncorrectThresholdReached");
                    this.passwordVerificationThresholdExceeded = true;
                }
                ConsoleLogger.log("ChangePasswordPanel>> isPasswordValid: current password entered is wrong!");
                this.showErrorMessage(displayMessage);
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isPasswordVerificationThresholdExceeded() {
        return this.passwordVerificationThresholdExceeded;
    }

    public void setPasswordVerificationThresholdExceeded(boolean passwordVerificationThresholdExceeded) {
        this.passwordVerificationThresholdExceeded = passwordVerificationThresholdExceeded;
    }

    public boolean isPasswordValid(AdminObject admin, boolean isCheckForAllBlank) {
        return this.isPasswordValid(admin, true, isCheckForAllBlank);
    }

    public void updateNewPwdlabel(String adminName) {
        if (adminName != null && adminName.trim().length() > 0) {
            String content = this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "ChangePasswordPanel.adminsNewPwdLabel");
            Object[] obj = new Object[]{adminName};
            this.newPwdLabel.setText(MessageFormat.format(content, obj));
        }
    }

    public void setData(AdminObject admin) {
        SemAdministrator semAdmin = admin.getSemAdmin();
        this.updateNewPwdlabel(semAdmin.getName());
        if (this.showNeverExpiringCtrl) {
            boolean isNeverExpire = admin.hasNeverExpiringPwd();
            this.jCbxPwdNeverExpires.setSelected(isNeverExpire);
            this.jCbxPwdNeverExpires.setVisible(isNeverExpire || AdminHandler.isNeverExpiringPwdAllowedForCurrentDomain());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAdminPwd(AdminObject admin) {
        char[] pwd = this.getNewPwd();
        char[] pwdcfm = this.getVerifyPwd();
        if (pwd.length != 0 || pwdcfm.length != 0 || this.getCurrentPwd().length != 0) {
            String newPwdHashed = PasswordUtil.createPKDBF2PasswordHash(new String(pwd));
            try {
                PasswordSettingsUtil.addPasswordToHistory(admin, pwd);
                AbstractAdminHandler handler = AbstractAdminHandler.getInstance(admin);
                AbstractAdminHandler.ActionType type = this.isAddNewAdmin ? AbstractAdminHandler.ActionType.CREATE : AbstractAdminHandler.ActionType.UPDATE;
                handler.updatePassword(admin, newPwdHashed, type, false);
                if (Manager.isCurrentAdmin(admin.getId())) {
                    DataobjectManager.getInstance().setCurrentAdminPassword(Utility.encryptLatest((char[])pwd));
                }
                ConsoleLogger.log("AdminAuthenticationPanel>> setAdminPwd: OK!");
                boolean bl = true;
                return bl;
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
            }
            catch (Exception ex) {
                ConsoleLogger.log("AdminAuthenticationPanel>> setAdminPwd: Exception...");
                LoggerUtilities.logException((Throwable)ex);
            }
            finally {
                char[] currentPwd;
                if (pwd.length > 0) {
                    PasswordClearUtil.clearPasswordInMemory(pwd, this.getTFPwd());
                }
                if (pwdcfm != null && pwdcfm.length > 0) {
                    PasswordClearUtil.clearPasswordInMemory(pwdcfm, this.jTFPwdCfm);
                }
                if ((currentPwd = this.getCurrentPwd()) != null && currentPwd.length > 0) {
                    PasswordClearUtil.clearPasswordInMemory(currentPwd, this.jTFCurrentPwd);
                }
            }
        }
        return false;
    }

    public boolean modifyAdmin(AdminObject admin) {
        boolean modified = this.setAdminPwd(admin);
        if (this.showNeverExpiringCtrl) {
            modified = this.jCbxPwdNeverExpires.isSelected() ? (modified |= admin.setNeverExpiringPwd()) : (modified |= admin.setPasswordAge(null));
        }
        return modified;
    }
}

