/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.MultiLineLabel;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.validator.MultipleIpv4Validator;
import com.sygate.scm.util.validator.ValidatorResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdminReportingConstraintPanel
extends JPanel {
    static final char ASTERISK = '*';
    private static final char PERCENT_SIGN = '%';
    private static final long serialVersionUID = -4626452274344427646L;
    public static final int TYPE_DOMAIN = 0;
    public static final int TYPE_LIMITED = 1;
    private int type = 0;
    private MultiLineLabel descLabel1 = new MultiLineLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.reportingPrivilegesTxt1"));
    private MultiLineLabel descLabel2 = new MultiLineLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.reportingPrivilegesTxt2"));
    private final JLabel m_lblComputer = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.label.computerList"));
    private final JLabel m_lblIP = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.label.ipList"));
    private JTextField jTFComputer = new JTextField("", 30);
    final JTextField jTFIP = new JTextField("", 30);
    private JPanel m_innerPanel = null;
    private boolean readOnly;

    public AdminReportingConstraintPanel(int intype, boolean readOnly) {
        this.type = intype;
        this.readOnly = readOnly;
        this.initialize();
        this.setReadOnlyStatus();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jp = new JPanel(new GridLayout(2, 1, 0, 5));
        jp.add((Component)this.descLabel1);
        jp.add((Component)this.descLabel2);
        this.add((Component)jp, "North");
        this.m_innerPanel = this.getInnerPanel();
        this.add((Component)this.m_innerPanel, "Center");
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        if (this.type != 0) {
            panel.add((Component)this.m_lblComputer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
            RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(512);
            nameDoc.setValidator("~!@#$^&()+{}|:\"<>`=[]\\;'/", false);
            this.jTFComputer.setDocument(nameDoc);
            panel.add((Component)this.jTFComputer, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
            panel.add((Component)this.m_lblIP, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
            RestrictedPlainDocument ipDoc = new RestrictedPlainDocument(512);
            ipDoc.setValidator(",*?.0123456789", true);
            this.jTFIP.setDocument(ipDoc);
            panel.add((Component)this.jTFIP, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 10), 0, 0));
        }
        return panel;
    }

    public void setType(int type) {
        boolean bVisible = type == 1;
        this.m_lblComputer.setVisible(bVisible);
        this.jTFComputer.setVisible(bVisible);
        this.m_lblIP.setVisible(bVisible);
        this.jTFIP.setVisible(bVisible);
        if (type == 1) {
            this.descLabel1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.LimitedReportingPrivilegesTxt1"));
        }
    }

    public void setData(AdminPrivilegeObject adminPrivilegeObj) {
        String value = adminPrivilegeObj.getAllowedComputer();
        if (value != null) {
            this.jTFComputer.setText(value.replace('%', '*'));
        }
        if ((value = adminPrivilegeObj.getAllowedIP()) != null) {
            this.jTFIP.setText(value.replace('%', '*'));
        }
    }

    public void modifyAdminPrivilege(AdminPrivilegeObject adminPrivilegeObj) {
        adminPrivilegeObj.setAllowedComputer(this.jTFComputer.getText().replace('*', '%'));
        adminPrivilegeObj.setAllowedIP(this.jTFIP.getText().replace('*', '%'));
    }

    private void setReadOnlyStatus() {
        this.jTFComputer.setEnabled(!this.readOnly);
        this.jTFIP.setEnabled(!this.readOnly);
    }

    boolean validateInput() {
        return 0 == this.type ? true : this.validateIPAddress();
    }

    boolean validateIPAddress() {
        if (String.valueOf('*').equals(this.jTFIP.getText().trim()) || "".equals(this.jTFIP.getText().trim())) {
            return true;
        }
        ValidatorResult result = MultipleIpv4Validator.newInstance((String)this.jTFIP.getText().trim()).validate();
        if (result.hasError()) {
            String errorIps = result.getResult().keySet().toString();
            String errorText = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminReportingConstraintPanel.msg.IncorrectIPAddress");
            UIUtilities.showErrorDialog(errorText + errorIps);
        }
        return !result.hasError();
    }
}

