/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.ui.admin.dlg.AdmPropertiesDlg;
import com.sygate.scm.console.ui.admin.dlg.ChangePasswordPanel;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SGridBagLayoutPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.EmailValidator;
import com.sygate.scm.util.ErrorMsg;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class AdminPropertiesGeneralPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JPanel securityPanel = new JPanel();
    private JCheckBox jcbLockAfter = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.checkbox.lockAfter"));
    private JLabel jlbLockFor = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.checkbox.lockFor"));
    private JCheckBox chbAlertOnLoginFailure = new JCheckBox();
    private JSpinner jspMinute = new JSpinner(new SpinnerNumberModel(1, 1, 60, 1));
    private JSpinner jspAttempTimes = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
    private JPanel profilePanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JTextField tfEmail = new JTextField();
    private JLabel emailLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.emailAddressLabel"));
    private JTextField tfFullName = new JTextField();
    private JLabel fullNameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.fullNameLabel"));
    private JTextField tfUserName = new JTextField();
    private JLabel userNameLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.userNameLabel"));
    private final MessageResources msgRes = MessageResources.getInstance();
    private ChangePasswordPanel pwdPanel = null;
    private boolean readOnly = false;
    private boolean isAddNewAdmin = false;

    public AdminPropertiesGeneralPanel(AdmPropertiesDlg parent, boolean readOnly, boolean isAddNewAdmin) {
        this.readOnly = readOnly;
        this.isAddNewAdmin = isAddNewAdmin;
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.getInnerPanel(), "North");
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.setReadOnlyStatus();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_general";
    }

    private JPanel getInnerPanel() throws Exception {
        SGridBagLayoutPanel panel = new SGridBagLayoutPanel();
        RestrictedPlainDocument adminNameDoc = new RestrictedPlainDocument(64);
        adminNameDoc.setValidator("\"/\\[]:;|=,+*?<>", false);
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(50);
        nameDoc.setValidator("\"%<>&/", false);
        RestrictedPlainDocument emailDoc = new RestrictedPlainDocument(256);
        emailDoc.setValidator("!:;`<>/',()+={}[]|?#$%^&* \\\"~", false);
        this.chbAlertOnLoginFailure.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.sendEmailWhenLockedTxt"));
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>();
        this.jcbLockAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminPropertiesGeneralPanel.this.chbLock_actionPerformed(e);
            }
        });
        JLabel lowLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.lowLabel"));
        ht.put(1, lowLabel);
        ht.put(2, new JLabel("2"));
        ht.put(3, new JLabel("3"));
        JLabel besideLabel = new JLabel("4");
        ht.put(4, besideLabel);
        JLabel mediumLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.mediumLabel"));
        ht.put(5, mediumLabel);
        ht.put(6, new JLabel("6"));
        ht.put(7, new JLabel("7"));
        ht.put(8, new JLabel("8"));
        ht.put(9, new JLabel("9"));
        JLabel highLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.highLabel"));
        ht.put(10, highLabel);
        UIUtilities.enableOnlyValidEdits(this.jspMinute);
        UIUtilities.enableOnlyValidEdits(this.jspAttempTimes);
        this.profilePanel.setLayout(this.gridBagLayout2);
        this.profilePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.profileTitle"))));
        this.tfEmail.setDocument(emailDoc);
        this.tfFullName.setDocument(nameDoc);
        this.tfUserName.setDocument(adminNameDoc);
        this.tfUserName.setEditable(false);
        this.profilePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.securityTitle"))));
        this.profilePanel.add((Component)this.tfUserName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 10), 0, 0));
        this.profilePanel.add((Component)this.userNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.profilePanel.add((Component)this.tfFullName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.profilePanel.add((Component)this.fullNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.profilePanel.add((Component)this.tfEmail, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 10), 0, 0));
        this.profilePanel.add((Component)this.emailLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        GridBagConstraints securityConstraint = new GridBagConstraints();
        securityConstraint.gridx = 0;
        securityConstraint.gridy = 0;
        securityConstraint.gridwidth = 1;
        securityConstraint.gridheight = 1;
        securityConstraint.anchor = 17;
        securityConstraint.fill = 2;
        securityConstraint.insets = new Insets(10, 20, 5, 5);
        securityConstraint.weightx = 0.0;
        securityConstraint.weighty = 0.0;
        securityConstraint.ipadx = 0;
        securityConstraint.ipady = 0;
        this.securityPanel.setLayout(new GridBagLayout());
        this.securityPanel.setBorder(BorderFactory.createEmptyBorder());
        this.securityPanel.add((Component)this.jcbLockAfter, securityConstraint);
        securityConstraint.gridx = 1;
        securityConstraint.ipadx = 30;
        securityConstraint.insets.left = 0;
        securityConstraint.fill = 0;
        securityConstraint.weightx = 0.75;
        this.securityPanel.add((Component)this.jspAttempTimes, securityConstraint);
        securityConstraint.gridy = 1;
        securityConstraint.fill = 2;
        securityConstraint.gridx = 0;
        securityConstraint.insets.left = 35;
        this.securityPanel.add((Component)this.jlbLockFor, securityConstraint);
        securityConstraint.gridx = 1;
        securityConstraint.ipadx = 30;
        securityConstraint.insets.left = 0;
        securityConstraint.fill = 0;
        securityConstraint.weightx = 0.75;
        this.securityPanel.add((Component)this.jspMinute, securityConstraint);
        securityConstraint.gridy = 2;
        securityConstraint.gridx = 0;
        securityConstraint.gridwidth = 3;
        securityConstraint.insets.left = 30;
        this.securityPanel.add((Component)this.chbAlertOnLoginFailure, securityConstraint);
        Insets insets = new Insets(0, 5, 0, 5);
        panel.addComponentEx(this.profilePanel, insets, 2, 11, 0.0);
        if (LicenseObject.getInstance().isSBProduct()) {
            this.pwdPanel = new ChangePasswordPanel(true, this.isAddNewAdmin);
            panel.addComponentEx(this.pwdPanel, insets, 2, 11, 0.0);
        } else {
            panel.addComponentEx(this.securityPanel, insets, 0, 17, 1.0);
        }
        return panel;
    }

    String getUserName() {
        if (this.tfUserName.getText() == null) {
            return this.tfUserName.getText();
        }
        return this.tfUserName.getText().trim();
    }

    public String getFullName() {
        return this.tfFullName.getText();
    }

    public String getEmail() {
        return this.tfEmail.getText();
    }

    public boolean isEmailAlertWhenFailureEnabled() {
        return this.chbAlertOnLoginFailure.isSelected();
    }

    private boolean doesLockAccountUponAlert() {
        return this.jcbLockAfter.isSelected();
    }

    public int getAttemptThreshold() {
        int value = 0;
        if (this.jcbLockAfter.isSelected()) {
            Object o = this.jspAttempTimes.getValue();
            if (o instanceof Integer) {
                value = (Integer)o;
            } else {
                try {
                    value = Integer.parseInt(o.toString());
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        } else {
            return value;
        }
        return value;
    }

    public int getLockTimeInMinutes() {
        int value = 0;
        Object o = this.jspMinute.getValue();
        if (o instanceof Integer) {
            value = (Integer)o;
        } else {
            try {
                value = Integer.parseInt(o.toString());
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        return value;
    }

    public void setData(AdminObject admin) {
        if (this.pwdPanel != null) {
            this.pwdPanel.setData(admin);
        }
        if (!this.isAddNewAdmin) {
            this.tfUserName.setEditable(Manager.isLoginAsSysAdmin());
        } else {
            this.tfUserName.setEditable(true);
        }
        this.tfUserName.setText(admin.getAdminName());
        this.tfFullName.setText(admin.getFullName());
        this.tfEmail.setText(admin.getEmail());
        LoginConfigObject loginConfig = admin.getLoginConfig(true);
        this.chbAlertOnLoginFailure.setSelected(loginConfig.isEmailAlertWhenFailureEnabled());
        int attempts = loginConfig.getAttemptThresholdBeforeAlert();
        this.jcbLockAfter.setSelected(attempts != 0);
        boolean lockEnabled = loginConfig.doesLockAccountUponAlert();
        this.chbAlertOnLoginFailure.setEnabled(lockEnabled);
        this.jspMinute.setEnabled(lockEnabled);
        this.jspAttempTimes.setValue(loginConfig.getAttemptThresholdBeforeAlert() == 0 ? loginConfig.getDefAttemptThresholdBeforeAlert() : loginConfig.getAttemptThresholdBeforeAlert());
        this.jspMinute.setValue(loginConfig.getLockTimeInMinutes());
        this.changeCheckBoxStatus();
        this.setReadOnlyStatus();
    }

    public boolean validateData(AdminObject admin) throws ConsoleException {
        String adminName = this.getUserName();
        if (!AdminPropertiesGeneralPanel.validateAdminName(adminName)) {
            this.tfUserName.requestFocus();
            return false;
        }
        String email = this.getEmail();
        if (email == null || email.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.emailCannotBeEmpty"), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.error"), 0);
            this.tfEmail.requestFocus();
            return false;
        }
        if (email.length() > 0 && !EmailValidator.isValidEmailAddress((String)email)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.invalidEmailMsg"), this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesGeneralPanel.invalidEmailTitle"), 0);
            this.tfEmail.requestFocus();
            return false;
        }
        if (this.pwdPanel != null) {
            return this.pwdPanel.isPasswordValid(admin, false);
        }
        return true;
    }

    public static boolean validateAdminName(String adminName) {
        try {
            AdminHandler.validateAdminName(adminName);
        }
        catch (ConsoleException ex) {
            String errorMsg = ex.getMessageString();
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.error"), 0);
            return false;
        }
        if (0 == adminName.toLowerCase().compareTo("bridge_v1")) {
            String errorMsg = ErrorMsg.getMessage((int)270);
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.error"), 0);
            return false;
        }
        return true;
    }

    public boolean modifyAdmin(AdminObject admin) throws ConsoleException {
        String email;
        String fullName;
        boolean modified = false;
        if (this.renameAdmin(admin)) {
            modified = true;
        }
        if (this.pwdPanel != null) {
            modified |= this.pwdPanel.modifyAdmin(admin);
        }
        if (!(fullName = this.getFullName()).equals(admin.getFullName())) {
            admin.setFullName(fullName);
            modified = true;
        }
        if (!(email = this.getEmail()).equals(admin.getEmail())) {
            admin.setEmail(email);
            modified = true;
        }
        boolean isEmailAlertWhenFailureEnabled = this.isEmailAlertWhenFailureEnabled();
        boolean doesLockAccountUponAlert = this.doesLockAccountUponAlert();
        int lockTimeInMinutes = this.getLockTimeInMinutes();
        int attemptThresholdBeforeAlert = this.getAttemptThreshold();
        if (admin.setLoginConfigProps(isEmailAlertWhenFailureEnabled, attemptThresholdBeforeAlert, doesLockAccountUponAlert, lockTimeInMinutes)) {
            modified = true;
        }
        return modified;
    }

    private void chbLock_actionPerformed(ActionEvent e) {
        this.changeCheckBoxStatus();
    }

    private void changeCheckBoxStatus() {
        boolean lockEnabled = this.jcbLockAfter.isSelected();
        this.jlbLockFor.setEnabled(lockEnabled);
        this.jspAttempTimes.setEnabled(lockEnabled);
        this.chbAlertOnLoginFailure.setEnabled(lockEnabled);
        this.jspMinute.setEnabled(lockEnabled);
        boolean lockFor = this.jlbLockFor.isEnabled();
        if (this.jspMinute.isEnabled()) {
            this.jspMinute.setEnabled(lockFor);
        }
    }

    private boolean renameAdmin(AdminObject admin) throws ConsoleException {
        String oldAdminName = admin.getAdminName();
        String newAdminName = this.getUserName();
        if (!this.isAddNewAdmin && oldAdminName.equals(newAdminName)) {
            System.out.println("AdminPropertiesGeneralPanel>> renameAdmin: same admin name so no need to change!");
            return false;
        }
        try {
            String currentAdminId;
            boolean isSysAdmin = Manager.isSystemAdmin(admin.getSemAdmin());
            String domainGUID = Manager.getCurrentDomainId();
            AbstractAdminHandler.getInstance(admin).checkExistence(newAdminName);
            admin.setAdminName(newAdminName);
            if (!this.isAddNewAdmin) {
                AdminHandler.logEventForAdminRenaming(admin, oldAdminName);
            }
            if ((currentAdminId = Manager.getCurrentAdminId()) != null && currentAdminId.equals(admin.getId())) {
                Manager.getFrame().updateTitle();
            }
            System.out.println("AdminPropertiesGeneralPanel>> renameAdmin: OK!");
            return true;
        }
        catch (ConsoleException e) {
            throw e;
        }
        catch (Exception ex) {
            System.out.println("AdminPropertiesGeneralPanel>> renameAdmin: Exception...");
            LoggerUtilities.logException((Throwable)ex);
            return true;
        }
    }

    private void setReadOnlyStatus() {
        if (this.tfUserName.isEnabled()) {
            this.tfUserName.setEnabled(!this.readOnly);
        }
        this.jcbLockAfter.setEnabled(!this.readOnly);
        this.chbAlertOnLoginFailure.setEnabled(!this.readOnly);
        if (this.jspMinute.isEnabled()) {
            this.jspMinute.setEnabled(!this.readOnly);
        }
        if (this.jspAttempTimes.isEnabled()) {
            this.jspAttempTimes.setEnabled(!this.readOnly);
        }
    }

    public void focusOnDefaultComponent() {
        if (this.isAddNewAdmin) {
            this.tfUserName.requestFocus();
        }
    }
}

