/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilege;
import com.sygate.scm.common.configobject.schema.SitePrivilegeSet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.dlg.AdminGroupConstraintPanel;
import com.sygate.scm.console.ui.admin.dlg.AdminReportingConstraintPanel;
import com.sygate.scm.console.ui.admin.dlg.InstallPackageConstraintDialog;
import com.sygate.scm.console.ui.admin.dlg.PolicyTypeRightsPanel;
import com.sygate.scm.console.ui.admin.dlg.SitePrivilegeDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.IntegerSet;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AdminPrivilegePanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 807768207083728039L;
    private JRadioButton jrbsystem = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.radiobutton.systemAdmin"));
    private JRadioButton jrbdomain = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.radiobutton.domainAdmin"));
    private JRadioButton jrblimited = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.radiobutton.limitedAdmin"));
    private JCheckBox jcbxviewreports = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.viewReports"));
    private JCheckBox jcbxviewsiterights = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.viewSiteRights"));
    private JCheckBox jcbxcomputeruser = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.computerUser"));
    private JCheckBox jcbxreadsetpolicy = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.readSetPolicy"));
    private JCheckBox jcbxinstalloackagerights = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.installPackages"));
    private JCheckBox jcbxeditablepolicy = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.readOnlyPolicy"));
    private JCheckBox jcbxremotecommandforreadonlygroup = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.remoteCommandForReadonlyGroup"));
    private boolean bgroupconstraintdialoghasbeenopened = false;
    private AdminPrivilegeObject privilegeObj;
    private SitePrivilegeSet privilegeSet;
    private AdminObject adminObj;
    private JCheckBox jcbxexecutingcommands = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.checkbox.executingCommands"));
    private JButton commandConstraintButton = new JButton(UIText.get(1540));
    private DescriptionTextArea sysadminDesc;
    private DescriptionTextArea adminDesc;
    private DescriptionTextArea limitedDesc;
    private DescriptionTextArea privilegeLimDesc;
    private DescriptionTextArea privilegeDomainDesc;
    private JLabel privilegeWarningLimitLabel = null;
    private JPanel privilegeLimitDescPanel = null;
    private JPanel privilegeDomainDescPanel = null;
    private JButton groupConstraintButton = new JButton(UIText.get(1539));
    private JButton reportingConstraintLimitedButton = new JButton(UIText.get(4357));
    private JButton siteRightsLimitButton = new JButton(UIText.get(4624));
    private JButton siteRightsDomainButton = new JButton(UIText.get(4624));
    private JButton policyTypeRightsButton = new JButton(UIText.get(3846));
    private JButton installPackageConstraintLimitedButton = new JButton(UIText.get(4361));
    private ArrayList<String> allowedPolictTypes = null;
    private HashMap<String, SitePrivilege> authorizedPrivilegeMap = new HashMap();
    private boolean readOnly;
    private boolean promoteDemote = true;
    private Boolean noRightToAnySite = null;
    private boolean isAddNewAdmin = false;

    public AdminPrivilegePanel(boolean isAddNewAdmin, boolean readOnly) {
        this.readOnly = readOnly;
        this.isAddNewAdmin = isAddNewAdmin;
        this.initialize();
    }

    public void setFocus() {
        if (this.jrblimited.isSelected()) {
            this.jrblimited.requestFocusInWindow();
        } else if (this.jrbdomain.isSelected()) {
            this.jrbdomain.requestFocusInWindow();
        } else if (this.jrbsystem.isSelected()) {
            this.jrbsystem.requestFocusInWindow();
        }
    }

    public void setData(AdminObject adminObj) {
        this.adminObj = adminObj;
        this.privilegeObj = adminObj.getAdminPrivilege();
        if (!this.privilegeObj.hasPrivilege()) {
            this.jrblimited.setSelected(true);
            this.jrblimited.doClick();
        } else {
            this.jrbsystem.setVisible(false);
            if (this.sysadminDesc != null) {
                this.sysadminDesc.setVisible(false);
            }
            try {
                IntegerSet set = this.privilegeObj.getAllowedPaneIntegerSet();
                if (this.privilegeObj.isDomainAdminPrivilege()) {
                    this.jrbdomain.setSelected(true);
                } else if (set.contains("0x50", 16)) {
                    this.jrbdomain.setSelected(true);
                } else {
                    this.jrblimited.setSelected(true);
                    this.jcbxviewreports.setSelected(set.contains("0x10", 16));
                    this.jcbxcomputeruser.setSelected(set.contains("0x30", 16));
                    this.jcbxreadsetpolicy.setSelected(set.contains("0x20", 16));
                    this.jcbxviewsiterights.setSelected(set.contains("0x40", 16));
                    this.jcbxinstalloackagerights.setSelected(set.contains("0x60", 16));
                    String disallowed = this.privilegeObj.getDisallowedFeature();
                    if (disallowed != null) {
                        set = new IntegerSet(disallowed);
                        this.jcbxeditablepolicy.setSelected(!set.contains("0x21", 16));
                    }
                    this.jcbxremotecommandforreadonlygroup.setSelected(this.privilegeObj.getAllowReadOnlyRunCommands());
                    this.setLimitedReportingConstraintsButton();
                    this.setLimitedGroupConstraintsButton();
                    this.setPolicyTypeRightsButton();
                    this.setLimitedSiteRightsConstraintsButton();
                    this.setLimitedInstallPackageConstraintsButton();
                    boolean hasRight = this.privilegeObj.hasExecuteCommandRights();
                    if (hasRight && this.jcbxcomputeruser.isSelected()) {
                        this.jcbxexecutingcommands.setSelected(true);
                    }
                    this.setLimitedExecutingCommandsCheckBoxStatus();
                }
            }
            catch (BadFormatException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        this.setLimitedCommandConstraintsButton();
        this.setRemoteCommandsForReadOnlyGroupChk();
        this.setSiteRightsButtonsStatus();
        this.privilegeSet = AdminHandler.getDisplaySitePrivilegeSet(AdminObject.retrieveCurrentAdminObject(), adminObj, this.authorizedPrivilegeMap, this.privilegeSet, true);
        this.promoteDemote = AdminHandler.isDemoteOrPromoteAllowed(AdminObject.retrieveCurrentAdminObject(), adminObj, true);
        this.setPrivilegeDescStatus(this.promoteDemote, adminObj.isDomainSysAdmin());
        this.setReadOnlyStatus();
    }

    public AdminPrivilegeObject getAdminPrivilegeObject() {
        String value;
        if (this.readOnly) {
            return null;
        }
        if (this.jrbsystem.isSelected()) {
            return null;
        }
        if (this.jrbdomain.isSelected()) {
            AdminPrivilegeObject domainAdmin = AdminPrivilegeObject.newInstanceForDomainAdmin();
            String value2 = this.privilegeObj.getAllowedLegacyDomain();
            this.adminObj.setAdminPrivilege(this.privilegeObj.getSemAdminPrivilege());
            AdminHandler.mergeAdminPrivilege(this.adminObj, this.privilegeSet);
            domainAdmin.setAllowedLegacyDomain(value2 == null || value2.trim().length() == 0 ? "%" : value2);
            domainAdmin.getSemAdminPrivilege().setOptSitePrivilegeSet(this.adminObj.getAdminPrivilege().getSitePrivilegeSet());
            return domainAdmin;
        }
        if (!this.privilegeObj.hasPrivilege()) {
            this.privilegeObj = AdminPrivilegeObject.newInstanceForLimitedAdmin();
        }
        if (!this.bgroupconstraintdialoghasbeenopened) {
            AdminGroupConstraintPanel groupPanel = new AdminGroupConstraintPanel();
            groupPanel.setData(this.privilegeObj);
            groupPanel.modifyAdminPrivilege(this.privilegeObj);
        }
        if ((value = this.privilegeObj.getAllowedLegacyDomain()) == null || value.trim().length() == 0) {
            this.privilegeObj.setAllowedLegacyDomain("%");
        }
        if ((value = this.privilegeObj.getAllowedLegacyGroup()) == null || value.trim().length() == 0) {
            this.privilegeObj.setAllowedLegacyGroup("%");
        }
        if ((value = this.privilegeObj.getAllowedLegacyServer()) == null || value.trim().length() == 0) {
            this.privilegeObj.setAllowedLegacyServer("%");
        }
        if ((value = this.privilegeObj.getAllowedComputer()) == null || value.trim().length() == 0) {
            this.privilegeObj.setAllowedComputer("%");
        }
        if ((value = this.privilegeObj.getAllowedIP()) == null || value.trim().length() == 0) {
            this.privilegeObj.setAllowedIP("%");
        }
        IntegerSet set = new IntegerSet();
        if (this.jcbxviewreports.isSelected()) {
            set.add("0x10", 16);
        }
        if (this.jcbxcomputeruser.isSelected()) {
            set.add("0x30", 16);
        }
        if (this.jcbxreadsetpolicy.isSelected()) {
            set.add("0x20", 16);
        }
        if (this.jcbxviewsiterights.isSelected()) {
            set.add("0x40", 16);
        }
        if (this.jcbxinstalloackagerights.isSelected()) {
            set.add("0x60", 16);
        }
        this.privilegeObj.setAllowedPane(set.toString());
        IntegerSet disallowedSet = this.privilegeObj.getDisallowedPaneIntegerSet();
        if (this.jcbxeditablepolicy.isSelected()) {
            disallowedSet.delete(new IntegerRange("0x21", 16));
        } else {
            disallowedSet.add("0x21", 16);
        }
        String test = this.privilegeObj.getDisallowedFeature();
        System.out.println(">>>>>AdminPrivilegePanel getting disallowed feature:" + test);
        this.privilegeObj.setDisallowedFeature(disallowedSet.toString());
        if (!this.jcbxexecutingcommands.isSelected()) {
            this.privilegeObj.setAllCommandPrivilege(false);
            this.privilegeObj.setAllowReadOnlyRunCommands(false);
        } else {
            this.privilegeObj.setAllowReadOnlyRunCommands(this.isAllowReadOnlyRunCommands());
        }
        this.modifyPolicyTypePrivilege();
        this.adminObj.setAdminPrivilege(this.privilegeObj.getSemAdminPrivilege());
        AdminHandler.mergeAdminPrivilege(this.adminObj, this.privilegeSet);
        return this.privilegeObj;
    }

    private boolean isAllowReadOnlyRunCommands() {
        return this.jcbxremotecommandforreadonlygroup.isSelected();
    }

    private void modifyPolicyTypePrivilege() {
        String[] types;
        for (String type : types = PolicyTypeRightsPanel.getPolicyprivilegetypes()) {
            if (this.allowedPolictTypes == null) continue;
            if (this.allowedPolictTypes.contains(type)) {
                AdminPrivilegePanel.deleteDisallowedPolicyPrivilege(this.privilegeObj, type);
                continue;
            }
            AdminPrivilegePanel.addDisallowedPolicyPrivilege(this.privilegeObj, type);
        }
    }

    private JLabel getPrivilegeWarningLimitLabel() {
        if (this.privilegeWarningLimitLabel == null) {
            this.privilegeWarningLimitLabel = new JLabel(ConsoleMain.warningIcon16);
        }
        return this.privilegeWarningLimitLabel;
    }

    private static void addDisallowedPolicyPrivilege(AdminPrivilegeObject adminPrivilegeObject, String policyType) {
        AdminPrivilegePanel.setDisallowedPolicyPrivilege(adminPrivilegeObject, policyType, true);
    }

    private static void deleteDisallowedPolicyPrivilege(AdminPrivilegeObject adminPrivilegeObject, String policyType) {
        AdminPrivilegePanel.setDisallowedPolicyPrivilege(adminPrivilegeObject, policyType, false);
    }

    private static void setDisallowedPolicyPrivilege(AdminPrivilegeObject adminPrivilegeObject, String policyType, boolean isAdd) {
        if (adminPrivilegeObject == null || policyType == null || policyType.trim().length() == 0) {
            return;
        }
        IntegerSet set = adminPrivilegeObject.getDisallowedPaneIntegerSet();
        if (isAdd) {
            if (!set.contains(policyType, 16)) {
                set.add(policyType, 16);
            }
        } else if (set.contains(policyType, 16)) {
            set.delete(new IntegerRange(policyType, 16));
        }
        adminPrivilegeObject.setDisallowedFeature(set.toString());
    }

    public void modifyAdmin(AdminObject adminObj) {
        AdminPrivilegeObject privObj;
        if (this.isAddNewAdmin) {
            if (this.jrbsystem.isEnabled() && this.jrbsystem.isSelected()) {
                adminObj.setAdminType(AdminObject.AdminType.SYS_ADMIN);
            } else if (this.jrbdomain.isEnabled() && this.jrbdomain.isSelected()) {
                adminObj.setAdminType(AdminObject.AdminType.DOMAIN_ADMIN);
            } else if (this.jrblimited.isEnabled() && this.jrblimited.isSelected()) {
                adminObj.setAdminType(AdminObject.AdminType.LIMITED_ADMIN);
            }
        }
        if ((privObj = this.getAdminPrivilegeObject()) != null) {
            adminObj.setEnabled(privObj);
            adminObj.setAdminPrivilege(privObj.getSemAdminPrivilege());
        }
    }

    public boolean isValidate() {
        if (this.isAllPermissionDisabled() && 0 != JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAccessRightPanel.noPanelIsSelectedMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAccessRightPanel.adminPropertiesMsg"), 0)) {
            return false;
        }
        if (this.checkReportAndGroupPermission()) {
            UIUtilities.showInfoDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAccessRightPanel.msg.allGroupNoAccess"));
        }
        return true;
    }

    AdminObject.AdminType getSelectedType() {
        if (this.jrblimited.isSelected()) {
            return AdminObject.AdminType.LIMITED_ADMIN;
        }
        if (this.jrbdomain.isSelected()) {
            return AdminObject.AdminType.DOMAIN_ADMIN;
        }
        return AdminObject.AdminType.SYS_ADMIN;
    }

    private boolean isAllPermissionDisabled() {
        return this.jrblimited.isSelected() && !this.jcbxviewreports.isSelected() && !this.jcbxcomputeruser.isSelected() && !this.jcbxexecutingcommands.isSelected() && !this.jcbxreadsetpolicy.isSelected() && !this.jcbxinstalloackagerights.isSelected() && !this.jcbxviewsiterights.isSelected();
    }

    private boolean checkReportAndGroupPermission() {
        if (!this.jrblimited.isSelected() || !this.jcbxviewreports.isSelected()) {
            return false;
        }
        if (!this.jcbxcomputeruser.isSelected()) {
            return true;
        }
        if (this.privilegeObj == null) {
            return false;
        }
        AuthorizationManager manager = AuthorizationManager.getInstance();
        PrivilegeContext context = PrivilegeContext.newInstance((SemAdminPrivilege)this.privilegeObj.getSemAdminPrivilege());
        return manager.checkPermission(context, (Permission)AuthorizationManager.SpecialPermission.ALL_GROUP_NO_ACCESS);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_access_rights";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        ItemListener radioButtonListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent excep) {
                AdminPrivilegePanel.this.administratorTypeChanged();
            }
        };
        this.jrbdomain.addItemListener(radioButtonListener);
        this.jrblimited.addItemListener(radioButtonListener);
        this.jrblimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                if (AdminPrivilegePanel.this.jrblimited.isSelected() && !AdminPrivilegePanel.this.privilegeObj.hasPrivilege()) {
                    AdminPrivilegePanel.this.privilegeObj = AdminPrivilegeObject.newInstanceForLimitedAdmin();
                    AdminPrivilegePanel.this.privilegeObj.grantTypeOfLimitedAdminPrivilege();
                }
                if (AdminPrivilegePanel.this.adminObj.isDomainSysAdmin() && !AdminPrivilegePanel.this.promoteDemote) {
                    AdminPrivilegePanel.this.jrbdomain.setSelected(true);
                    AdminPrivilegePanel.this.jrblimited.setSelected(false);
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAccessRightPanel.failToDemote"));
                }
            }
        });
        this.jrbdomain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                if (AdminPrivilegePanel.this.jrbdomain.isSelected() && !AdminPrivilegePanel.this.privilegeObj.hasPrivilege()) {
                    AdminPrivilegePanel.this.privilegeObj = AdminPrivilegeObject.newInstanceForLimitedAdmin();
                }
                if (!AdminPrivilegePanel.this.adminObj.isDomainSysAdmin() && !AdminPrivilegePanel.this.promoteDemote) {
                    AdminPrivilegePanel.this.jrbdomain.setSelected(false);
                    AdminPrivilegePanel.this.jrblimited.setSelected(true);
                    UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAccessRightPanel.failToPromote"));
                }
                if (AdminPrivilegePanel.this.promoteDemote) {
                    AdminPrivilegePanel.this.privilegeSet = AdminHandler.promotePrivilegeSetForAuthorizedAdmin(AdminPrivilegePanel.this.adminObj);
                }
            }
        });
        this.jcbxreadsetpolicy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent excep) {
                AdminPrivilegePanel.this.readSetPolicyChanged();
                AdminPrivilegePanel.this.setPolicyTypeRightsButton();
            }
        });
        this.jcbxviewreports.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                AdminPrivilegePanel.this.setLimitedReportingConstraintsButton();
            }
        });
        this.jcbxviewsiterights.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                AdminPrivilegePanel.this.setLimitedSiteRightsConstraintsButton();
            }
        });
        this.jcbxexecutingcommands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                if (AdminPrivilegePanel.this.privilegeObj == null) {
                    return;
                }
                AdminPrivilegePanel.this.setLimitedCommandConstraintsButton();
                AdminPrivilegePanel.this.setRemoteCommandsForReadOnlyGroupChk();
                if (AdminPrivilegePanel.this.jcbxexecutingcommands.isSelected()) {
                    AdminPrivilegePanel.this.privilegeObj.setDefaultCommandPrivilege();
                } else {
                    AdminPrivilegePanel.this.privilegeObj.setAllCommandPrivilege(false);
                    AdminPrivilegePanel.this.jcbxremotecommandforreadonlygroup.setSelected(false);
                }
            }
        });
        this.jcbxcomputeruser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent excep) {
                AdminPrivilegePanel.this.setLimitedGroupConstraintsButton();
                AdminPrivilegePanel.this.setLimitedExecutingCommandsCheckBoxStatus();
                AdminPrivilegePanel.this.setLimitedCommandConstraintsButton();
                AdminPrivilegePanel.this.setRemoteCommandsForReadOnlyGroupChk();
                AuthorizationManager manager = AuthorizationManager.getInstance();
                PrivilegeContext context = PrivilegeContext.newInstance((SemAdminPrivilege)AdminPrivilegePanel.this.privilegeObj.getSemAdminPrivilege());
                if (AdminPrivilegePanel.this.jcbxcomputeruser.isEnabled() && AdminPrivilegePanel.this.jcbxcomputeruser.isSelected()) {
                    manager.addPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_GROUPS);
                } else if (AdminPrivilegePanel.this.jcbxcomputeruser.isEnabled() && !AdminPrivilegePanel.this.jcbxcomputeruser.isSelected()) {
                    manager.removePermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_GROUPS);
                }
                if (!AdminPrivilegePanel.this.jcbxcomputeruser.isSelected()) {
                    AdminPrivilegePanel.this.jcbxexecutingcommands.setSelected(false);
                    AdminPrivilegePanel.this.jcbxremotecommandforreadonlygroup.setSelected(false);
                }
            }
        });
        this.jcbxinstalloackagerights.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent excep) {
                AdminPrivilegePanel.this.setLimitedInstallPackageConstraintsButton();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrbsystem);
        group.add(this.jrbdomain);
        group.add(this.jrblimited);
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        if (Manager.isLoginAsSysAdmin()) {
            this.sysadminDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.sysAdminDesc"));
            panel.add((Component)this.jrbsystem, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
            panel.add((Component)this.sysadminDesc, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 10, 10), 0, 0));
            ++row;
        }
        this.adminDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.adminDesc"));
        this.limitedDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.limitedAdminDesc"));
        this.privilegeLimDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.privilegeLimDesc"));
        this.privilegeDomainDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.privilegeDomainDesc"));
        if (!LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)this.jrbdomain, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
            panel.add((Component)this.adminDesc, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
            panel.add((Component)this.siteRightsDomainButton, new GridBagConstraints(1, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            ++row;
        }
        if (!this.isAddNewAdmin && LicenseObject.getInstance().isSBProduct()) {
            panel.add((Component)this.limitedDesc, new GridBagConstraints(1, row, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 25, 0, 10), 0, 0));
        } else {
            panel.add((Component)this.jrblimited, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)this.limitedDesc, new GridBagConstraints(1, row, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 10), 0, 0));
        }
        ++row;
        int rowForAccessPanel = 0;
        JPanel accessPanel = new JPanel();
        accessPanel.setLayout(new GridBagLayout());
        accessPanel.add((Component)this.jcbxviewreports, new GridBagConstraints(0, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.reportingConstraintLimitedButton, new GridBagConstraints(1, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.jcbxcomputeruser, new GridBagConstraints(0, ++rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.groupConstraintButton, new GridBagConstraints(1, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.jcbxexecutingcommands, new GridBagConstraints(0, ++rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        accessPanel.add((Component)this.commandConstraintButton, new GridBagConstraints(1, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.jcbxremotecommandforreadonlygroup, new GridBagConstraints(0, ++rowForAccessPanel, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 50, 0, 0), 0, 0));
        ++rowForAccessPanel;
        if (!LicenseObject.getInstance().isSBProduct()) {
            accessPanel.add((Component)this.jcbxviewsiterights, new GridBagConstraints(0, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            accessPanel.add((Component)this.siteRightsLimitButton, new GridBagConstraints(1, rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            accessPanel.add((Component)this.jcbxinstalloackagerights, new GridBagConstraints(0, ++rowForAccessPanel, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            accessPanel.add((Component)this.installPackageConstraintLimitedButton, new GridBagConstraints(1, rowForAccessPanel, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            ++rowForAccessPanel;
        }
        accessPanel.add((Component)this.jcbxreadsetpolicy, new GridBagConstraints(0, rowForAccessPanel, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        accessPanel.add((Component)this.policyTypeRightsButton, new GridBagConstraints(1, rowForAccessPanel, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        ++rowForAccessPanel;
        if (!LicenseObject.getInstance().isSBProduct()) {
            accessPanel.add((Component)this.jcbxeditablepolicy, new GridBagConstraints(0, rowForAccessPanel, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        }
        UIUtilities.fitJComponent(new JComponent[]{this.reportingConstraintLimitedButton, this.groupConstraintButton, this.commandConstraintButton, this.policyTypeRightsButton, this.installPackageConstraintLimitedButton, this.siteRightsLimitButton});
        this.setupAuthenticationButtons();
        JPanel privilegePanel = new JPanel(new BorderLayout());
        privilegePanel.add((Component)accessPanel, "West");
        privilegePanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.label.access")));
        panel.add((Component)privilegePanel, new GridBagConstraints(0, row, 3, 1, 1.0, 1.0, 17, 2, new Insets(5, 22, 10, 10), 0, 0));
        panel.add((Component)this.getPrivilegeLimitDescPanel(), new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.administratorTypeChanged();
        return panel;
    }

    private JPanel getPrivilegeLimitDescPanel() {
        if (this.privilegeLimitDescPanel == null) {
            this.privilegeLimitDescPanel = new JPanel();
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.privilegeLimitDescPanel.setLayout(layout);
            this.privilegeLimitDescPanel.add((Component)this.getPrivilegeWarningLimitLabel(), "West");
            if (this.privilegeLimDesc == null) {
                this.privilegeLimDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.privilegeLimDesc"));
            }
            this.privilegeLimitDescPanel.add((Component)this.privilegeLimDesc, "Center");
        }
        return this.privilegeLimitDescPanel;
    }

    private JPanel getPrivilegeDomainDescPanel() {
        if (this.privilegeDomainDescPanel == null) {
            this.privilegeDomainDescPanel = new JPanel();
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.privilegeDomainDescPanel.setLayout(layout);
            if (this.privilegeDomainDesc == null) {
                this.privilegeDomainDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.privilegeDomainDesc"));
            }
        }
        return this.privilegeDomainDescPanel;
    }

    private void setupAuthenticationButtons() {
        this.groupConstraintButton.setEnabled(false);
        this.reportingConstraintLimitedButton.setEnabled(false);
        this.commandConstraintButton.setEnabled(false);
        this.policyTypeRightsButton.setEnabled(false);
        UIUtilities.fitJComponent(new JButton[]{this.groupConstraintButton, this.reportingConstraintLimitedButton, this.commandConstraintButton, this.siteRightsLimitButton, this.siteRightsDomainButton});
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                InstallPackageConstraintDialog installPackageDlg;
                if (ae.getSource() == AdminPrivilegePanel.this.groupConstraintButton) {
                    System.out.println("You are here in actionPerformed 1");
                    new AdminGroupConstraintDialog(AdminPrivilegePanel.this.readOnly);
                } else if (ae.getSource() == AdminPrivilegePanel.this.reportingConstraintLimitedButton) {
                    System.out.println("You are here in actionPerformed 2");
                    new AdminReportingConstraintDialog(1, AdminPrivilegePanel.this.readOnly);
                } else if (ae.getSource() == AdminPrivilegePanel.this.commandConstraintButton) {
                    new AdminCommandConstraintDialog(AdminPrivilegePanel.this.readOnly);
                } else if (ae.getSource() == AdminPrivilegePanel.this.policyTypeRightsButton) {
                    System.out.println("You are here in actionPerformed 2");
                    new PolicyTypeRightsDlg(AdminPrivilegePanel.this.readOnly);
                } else if (ae.getSource() == AdminPrivilegePanel.this.siteRightsLimitButton || ae.getSource() == AdminPrivilegePanel.this.siteRightsDomainButton) {
                    AdminPrivilegePanel.this.privilegeSet = AdminHandler.getDisplaySitePrivilegeSet(AdminObject.retrieveCurrentAdminObject(), AdminPrivilegePanel.this.adminObj, AdminPrivilegePanel.this.authorizedPrivilegeMap, AdminPrivilegePanel.this.privilegeSet, true);
                    SitePrivilegeSet copyOfPrivilegeSet = (SitePrivilegeSet)AdminPrivilegePanel.this.privilegeSet.clone();
                    SitePrivilegeDlg sitePrivilegeDlg = new SitePrivilegeDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "SitePrivilegeDlg.title"), true, copyOfPrivilegeSet, AdminPrivilegePanel.this.jrbdomain.isSelected(), AdminPrivilegePanel.this.readOnly);
                    if (sitePrivilegeDlg.isOk()) {
                        AdminPrivilegePanel.this.privilegeSet = copyOfPrivilegeSet;
                    }
                } else if (ae.getSource() == AdminPrivilegePanel.this.installPackageConstraintLimitedButton && (installPackageDlg = new InstallPackageConstraintDialog(AdminPrivilegePanel.this.privilegeObj.getPackagePrivilege(), AdminPrivilegePanel.this.readOnly)).isOk()) {
                    AuthorizationManager manager = AuthorizationManager.getInstance();
                    PrivilegeContext context = PrivilegeContext.newInstance((SemAdminPrivilege)AdminPrivilegePanel.this.privilegeObj.getSemAdminPrivilege());
                    manager.addPermission(context, (Permission)installPackageDlg.getPackagePrivilege());
                }
            }
        };
        this.groupConstraintButton.addActionListener(buttonListener);
        this.reportingConstraintLimitedButton.addActionListener(buttonListener);
        this.commandConstraintButton.addActionListener(buttonListener);
        this.policyTypeRightsButton.addActionListener(buttonListener);
        this.siteRightsDomainButton.addActionListener(buttonListener);
        this.siteRightsLimitButton.addActionListener(buttonListener);
        this.installPackageConstraintLimitedButton.addActionListener(buttonListener);
    }

    private void administratorTypeChanged() {
        boolean isSelected = this.jrblimited.isSelected();
        this.jcbxviewreports.setEnabled(isSelected);
        this.jcbxviewsiterights.setEnabled(isSelected);
        this.setSiteRightsButtonsStatus();
        this.jcbxcomputeruser.setEnabled(isSelected);
        this.jcbxreadsetpolicy.setEnabled(isSelected);
        this.jcbxexecutingcommands.setEnabled(false);
        this.jcbxinstalloackagerights.setEnabled(isSelected);
        this.jcbxremotecommandforreadonlygroup.setEnabled(isSelected);
        this.readSetPolicyChanged();
        this.setSiteRightsConstraintsDomainButton();
        this.setLimitedGroupConstraintsButton();
        this.setLimitedReportingConstraintsButton();
        this.setLimitedSiteRightsConstraintsButton();
        this.setLimitedCommandConstraintsButton();
        this.setRemoteCommandsForReadOnlyGroupChk();
        this.setLimitedInstallPackageConstraintsButton();
        this.setPolicyTypeRightsButton();
    }

    private void setPolicyTypeRightsButton() {
        this.policyTypeRightsButton.setEnabled(this.jcbxreadsetpolicy.isSelected() && this.jcbxreadsetpolicy.isEnabled());
    }

    private void readSetPolicyChanged() {
        this.jcbxeditablepolicy.setEnabled(this.jcbxreadsetpolicy.isEnabled() && this.jcbxreadsetpolicy.isSelected());
    }

    private void setRemoteCommandsForReadOnlyGroupChk() {
        this.jcbxremotecommandforreadonlygroup.setEnabled(this.jcbxexecutingcommands.isSelected() && this.jcbxexecutingcommands.isEnabled());
    }

    private void setLimitedGroupConstraintsButton() {
        this.groupConstraintButton.setEnabled(this.jcbxcomputeruser.isSelected() && this.jcbxcomputeruser.isEnabled());
    }

    private void setLimitedCommandConstraintsButton() {
        this.commandConstraintButton.setEnabled(this.jcbxexecutingcommands.isSelected() && this.jcbxexecutingcommands.isEnabled());
    }

    private void setLimitedExecutingCommandsCheckBoxStatus() {
        this.jcbxexecutingcommands.setEnabled(this.jcbxcomputeruser.isSelected() && this.jcbxcomputeruser.isEnabled());
    }

    private void setLimitedReportingConstraintsButton() {
        this.reportingConstraintLimitedButton.setEnabled(this.jcbxviewreports.isSelected() && this.jcbxviewreports.isEnabled());
    }

    private void setLimitedSiteRightsConstraintsButton() {
        if (this.noRightToAnySite != null && !this.noRightToAnySite.booleanValue()) {
            this.siteRightsLimitButton.setEnabled(this.jcbxviewsiterights.isSelected() && this.jcbxviewsiterights.isEnabled());
        }
    }

    private void setLimitedInstallPackageConstraintsButton() {
        this.installPackageConstraintLimitedButton.setEnabled(this.jcbxinstalloackagerights.isSelected() && this.jcbxinstalloackagerights.isEnabled());
    }

    private void setSiteRightsConstraintsDomainButton() {
        if (this.noRightToAnySite != null && !this.noRightToAnySite.booleanValue()) {
            this.siteRightsDomainButton.setEnabled(this.jrbdomain.isSelected() && this.jrbdomain.isEnabled());
        }
    }

    private void setSiteRightsButtonsStatus() {
        AdminObject current = AdminObject.retrieveCurrentAdminObject();
        if (current.isSysAdmin()) {
            this.noRightToAnySite = Boolean.FALSE;
            return;
        }
        SitePrivilegeSet tempPrivilegeSet = null;
        tempPrivilegeSet = AdminHandler.getDisplaySitePrivilegeSet(current, this.adminObj == null ? current : this.adminObj, this.authorizedPrivilegeMap, tempPrivilegeSet, true);
        this.noRightToAnySite = tempPrivilegeSet.getSitePrivilegeCount() == 0 ? Boolean.TRUE : Boolean.FALSE;
        if (this.noRightToAnySite != null && this.noRightToAnySite.booleanValue()) {
            this.siteRightsDomainButton.setEnabled(false);
            this.siteRightsLimitButton.setEnabled(false);
            this.jcbxviewsiterights.setEnabled(false);
        }
    }

    private void setPrivilegeDescStatus(boolean promoteDemoteAllowed, boolean domainAdmin) {
        AdminObject current = AdminObject.retrieveCurrentAdminObject();
        if (current.isSysAdmin()) {
            this.getPrivilegeDomainDescPanel().setVisible(false);
            this.getPrivilegeLimitDescPanel().setVisible(false);
        } else if (current.isDomainSysAdmin()) {
            if (promoteDemoteAllowed) {
                this.getPrivilegeDomainDescPanel().setVisible(false);
                this.getPrivilegeLimitDescPanel().setVisible(false);
            } else if (domainAdmin) {
                this.jrblimited.setEnabled(false);
                this.limitedDesc.setEnabled(false);
                this.getPrivilegeDomainDescPanel().setVisible(false);
            } else {
                this.jrbdomain.setEnabled(false);
                this.adminDesc.setEnabled(false);
                this.getPrivilegeLimitDescPanel().setVisible(false);
            }
        } else if (promoteDemoteAllowed) {
            this.getPrivilegeDomainDescPanel().setVisible(false);
            this.getPrivilegeLimitDescPanel().setVisible(false);
        }
    }

    private void setReadOnlyStatus() {
        if (this.readOnly) {
            this.jrbsystem.setEnabled(false);
            this.jrbdomain.setEnabled(false);
            this.jrblimited.setEnabled(false);
            this.jcbxviewreports.setEnabled(false);
            this.jcbxcomputeruser.setEnabled(false);
            this.jcbxreadsetpolicy.setEnabled(false);
            this.jcbxinstalloackagerights.setEnabled(false);
            this.jcbxexecutingcommands.setEnabled(false);
            this.jcbxviewsiterights.setEnabled(false);
            this.jcbxeditablepolicy.setEnabled(false);
            this.jcbxremotecommandforreadonlygroup.setEnabled(false);
        }
    }

    private class PolicyTypeRightsDlg
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        private PolicyTypeRightsPanel rightsPanel;

        public PolicyTypeRightsDlg(boolean readOnly) {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.PolicyTypeRightsDlg.title"), true);
            this.rightsPanel = null;
            this.readOnly = readOnly;
            this.rightsPanel = new PolicyTypeRightsPanel(readOnly);
            this.rightsPanel.setData(this.getData());
            this.getContentPane().add((Component)this.rightsPanel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.pack();
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        @Override
        public boolean isResizable() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            if (this.rightsPanel != null && !this.rightsPanel.isValidate()) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.PolicyTypeRightsDlg.ValidatorError"));
                return false;
            }
            return true;
        }

        private ArrayList<String> getData() {
            if (null == AdminPrivilegePanel.this.allowedPolictTypes) {
                AdminPrivilegePanel.this.allowedPolictTypes = AdminPrivilegeObject.getAllowedPolictTypes(AdminPrivilegePanel.this.privilegeObj);
            }
            return AdminPrivilegePanel.this.allowedPolictTypes;
        }

        @Override
        protected void commit() {
            AdminPrivilegePanel.this.allowedPolictTypes = this.rightsPanel.getAllowedPolicyType();
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_admin_dialog_properties_access_rights_policy_type_rights";
        }
    }

    private class AdminCommandConstraintDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        DescriptionTextArea commandRightsDesc;
        private JCheckBox jcbxscan;
        private JCheckBox jcbxupdateontent;
        private JCheckBox jcbxrestartcomputers;
        private JCheckBox jcbxenableautoprotect;
        private JCheckBox jcbxenablenetworkthreatprotect;
        private JCheckBox jcbxdisablenetworkthreatprotect;
        private JCheckBox jcbxenabledownloadadvisor;
        private JCheckBox jcbxdisabledownloadadvisor;
        private JCheckBox jcbxdisabledeletefromquarantine;
        private JCheckBox jcbxpowereraserscan;
        private JCheckBox jcbxcollectfilefingerprintlist;

        public AdminCommandConstraintDialog(boolean readOnly) {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.title"), true);
            this.commandRightsDesc = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.desc"));
            this.jcbxscan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.scan"));
            this.jcbxupdateontent = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.updateContent"));
            this.jcbxrestartcomputers = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.restartComputers"));
            this.jcbxenableautoprotect = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.enableAutoProtect"));
            this.jcbxenablenetworkthreatprotect = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.enableNetworkThreatProtect"));
            this.jcbxdisablenetworkthreatprotect = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.disableNetworkThreatProtect"));
            this.jcbxenabledownloadadvisor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.enableDownloadAdvisor"));
            this.jcbxdisabledownloadadvisor = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.disableDownloadAdvisor"));
            this.jcbxdisabledeletefromquarantine = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.disableDeleteFromQuarantine"));
            this.jcbxpowereraserscan = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.powerEraserScan"));
            this.jcbxcollectfilefingerprintlist = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.checkbox.collectFileFingerprintList"));
            this.readOnly = readOnly;
            this.initialize();
            this.setData();
            this.setReadOnlyStatus();
            this.pack();
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        private void initialize() {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.getCommandPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
        }

        private JPanel getCommandPanel() {
            boolean isNotSnacOnlyProduct = !LicenseObject.getInstance().isSNACOnlyProduct();
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.commandConstraintsDialog.borderDesc")));
            int row = 0;
            if (isNotSnacOnlyProduct) {
                panel.add((Component)this.jcbxscan, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxpowereraserscan, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            }
            panel.add((Component)this.jcbxupdateontent, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.jcbxrestartcomputers, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            if (isNotSnacOnlyProduct) {
                panel.add((Component)this.jcbxenableautoprotect, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxenablenetworkthreatprotect, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxdisablenetworkthreatprotect, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxenabledownloadadvisor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxdisabledownloadadvisor, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxdisabledeletefromquarantine, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
                panel.add((Component)this.jcbxcollectfilefingerprintlist, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            }
            JPanel commandPanel = new JPanel(new BorderLayout(0, 0));
            commandPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            commandPanel.add((Component)this.commandRightsDesc, "North");
            commandPanel.add((Component)panel, "Center");
            return commandPanel;
        }

        @Override
        public boolean isResizable() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            boolean hasSelected;
            boolean bl = hasSelected = this.jcbxscan.isSelected() || this.jcbxupdateontent.isSelected() || this.jcbxrestartcomputers.isSelected() || this.jcbxenableautoprotect.isSelected() || this.jcbxenablenetworkthreatprotect.isSelected() || this.jcbxdisablenetworkthreatprotect.isSelected() || this.jcbxpowereraserscan.isSelected() || this.jcbxenabledownloadadvisor.isSelected() || this.jcbxdisabledownloadadvisor.isSelected() || this.jcbxdisabledeletefromquarantine.isSelected() || this.jcbxcollectfilefingerprintlist.isSelected();
            if (!hasSelected && AdminPrivilegePanel.this.jcbxexecutingcommands.isSelected()) {
                UIUtilities.showErrorDialog(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.CommandTypeRightsDlg.ValidatorError"));
                return false;
            }
            return true;
        }

        public void setData() {
            this.jcbxscan.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF1"));
            this.jcbxupdateontent.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF2"));
            this.jcbxrestartcomputers.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF4"));
            this.jcbxenableautoprotect.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF5"));
            this.jcbxenablenetworkthreatprotect.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF6"));
            this.jcbxdisablenetworkthreatprotect.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF7"));
            this.jcbxenabledownloadadvisor.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF9"));
            this.jcbxdisabledownloadadvisor.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xFA"));
            this.jcbxdisabledeletefromquarantine.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF8"));
            this.jcbxpowereraserscan.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF10"));
            this.jcbxcollectfilefingerprintlist.setSelected(AdminPrivilegePanel.this.privilegeObj.getCommandPrivilege("0xF12"));
        }

        @Override
        protected void commit() {
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF1", this.jcbxscan.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF2", this.jcbxupdateontent.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF4", this.jcbxrestartcomputers.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF5", this.jcbxenableautoprotect.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF6", this.jcbxenablenetworkthreatprotect.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF7", this.jcbxdisablenetworkthreatprotect.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF9", this.jcbxenabledownloadadvisor.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xFA", this.jcbxdisabledownloadadvisor.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF8", this.jcbxdisabledeletefromquarantine.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF10", this.jcbxpowereraserscan.isSelected());
            AdminPrivilegePanel.this.privilegeObj.setCommandPrivilege("0xF12", this.jcbxcollectfilefingerprintlist.isSelected());
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_admin_dialog_properties_access_rights_command_rights";
        }

        @Override
        protected void setReadOnlyStatus() {
            this.jcbxscan.setEnabled(!this.readOnly);
            this.jcbxupdateontent.setEnabled(!this.readOnly);
            this.jcbxrestartcomputers.setEnabled(!this.readOnly);
            this.jcbxenableautoprotect.setEnabled(!this.readOnly);
            this.jcbxenablenetworkthreatprotect.setEnabled(!this.readOnly);
            this.jcbxdisablenetworkthreatprotect.setEnabled(!this.readOnly);
            this.jcbxenabledownloadadvisor.setEnabled(!this.readOnly);
            this.jcbxdisabledownloadadvisor.setEnabled(!this.readOnly);
            this.jcbxdisabledeletefromquarantine.setEnabled(!this.readOnly);
            this.jcbxpowereraserscan.setEnabled(!this.readOnly);
            this.jcbxcollectfilefingerprintlist.setEnabled(!this.readOnly);
        }
    }

    private class AdminReportingConstraintDialog
    extends DialogBase {
        private static final long serialVersionUID = -3375754292984186845L;
        static final int LIMITED = 1;
        private AdminReportingConstraintPanel reportingPanel;

        public AdminReportingConstraintDialog(int type, boolean readOnly) {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.reportingConstraintsDialog.title"), true);
            this.readOnly = readOnly;
            this.reportingPanel = new AdminReportingConstraintPanel(type, readOnly);
            this.reportingPanel.setData(AdminPrivilegePanel.this.privilegeObj);
            this.reportingPanel.setType(type);
            this.getContentPane().add((Component)this.reportingPanel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.pack();
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        @Override
        public boolean isResizable() {
            return false;
        }

        @Override
        protected boolean isValidate() {
            return this.reportingPanel.validateInput();
        }

        @Override
        protected void commit() {
            this.reportingPanel.modifyAdminPrivilege(AdminPrivilegePanel.this.privilegeObj);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_admin_dialog_properties_access_rights_reporting_constraints";
        }
    }

    private class AdminGroupConstraintDialog
    extends DialogBase {
        private static final long serialVersionUID = 1L;
        private AdminGroupConstraintPanel groupPanel;

        public AdminGroupConstraintDialog(boolean readOnly) {
            super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPrivilegePanel.groupConstraintsDialog.title"), true);
            this.groupPanel = new AdminGroupConstraintPanel();
            this.readOnly = readOnly;
            AdminPrivilegePanel.this.bgroupconstraintdialoghasbeenopened = true;
            this.groupPanel.setData(AdminPrivilegePanel.this.privilegeObj);
            this.getContentPane().add((Component)this.groupPanel, "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            if (readOnly) {
                this.groupPanel.setReadOnlyStatus();
                this.resetOKButton(!readOnly);
            }
            this.pack();
            this.setSize(500, 400);
            UiUtilities.centerComponent((Component)this);
            this.setVisible(true);
        }

        @Override
        public boolean isResizable() {
            return true;
        }

        @Override
        protected void commit() {
            this.groupPanel.modifyAdminPrivilege(AdminPrivilegePanel.this.privilegeObj);
        }

        @Override
        public String getContentSensitiveHelpToken() {
            return "sesm_admin_admin_dialog_properties_access_rights_group_constraints";
        }
    }
}

