/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.GenericPrivilegeDropDownList;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class AdminGroupConstraintPanel
extends JPanel {
    private static final long serialVersionUID = -5189341539693764983L;
    private GroupConstraintTree groupTree = new GroupConstraintTree();

    public AdminGroupConstraintPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.groupPrivilegesTxt")), "North");
        this.add((Component)new JScrollPane(this.groupTree), "Center");
    }

    public void setData(AdminPrivilegeObject adminPrivilegeObj) {
        this.groupTree.setData(adminPrivilegeObj);
    }

    public void setReadOnlyStatus() {
        this.groupTree.setEditable(false);
        this.groupTree.setEnabled(false);
    }

    public void modifyAdminPrivilege(AdminPrivilegeObject adminPrivilegeObj) {
        this.groupTree.modifyAdminPrivilege(adminPrivilegeObj);
    }

    public void updateAccessLists() {
        this.groupTree.updateAccessList();
    }

    private static class GroupConstraintComboBox
    extends GenericPrivilegeDropDownList {
        private static final long serialVersionUID = 1L;
        private GroupObject groupObj;

        public GroupObject getGroupObject() {
            return this.groupObj;
        }

        public void setGroupObject(GroupObject g) {
            this.groupObj = g;
        }
    }

    private static class GroupConstraintPanel
    extends JPanel
    implements TreeCellRenderer,
    TreeCellEditor,
    ItemListener {
        private static final long serialVersionUID = 1L;
        private GroupConstraintComboBox jCmbAccess = new GroupConstraintComboBox();
        private JLabel jLName = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("client_group_16.png"))));
        private JTree tree;

        public GroupConstraintPanel(JTree tree) {
            this.tree = tree;
            this.setLayout(new FlowLayout(3));
            this.setOpaque(false);
            this.add(this.jLName);
            this.add((Component)((Object)this.jCmbAccess));
            this.setToolTipText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.moreChoicesWillAppear"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.init(((DefaultMutableTreeNode)value).getUserObject(), sel, false);
            return this;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.init(((DefaultMutableTreeNode)value).getUserObject(), isSelected, true);
            return this;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.jCmbAccess && e.getStateChange() == 1) {
                this.jCmbAccess.getGroupObject().setAccessConstraint(this.jCmbAccess.getSelectedIndex());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(node);
            }
        }

        private void init(Object o, boolean selected, boolean isUseAsEditor) {
            if (!(o instanceof GroupObject)) {
                return;
            }
            GroupObject obj = (GroupObject)o;
            if (isUseAsEditor) {
                this.jCmbAccess.setGroupObject(obj);
                this.jCmbAccess.removeItemListener(this);
                this.jCmbAccess.setSelectedIndex(obj.getAccessConstraint());
                this.jCmbAccess.addItemListener(this);
            } else {
                this.jCmbAccess.setSelectedIndex(obj.getAccessConstraint());
            }
            this.jLName.setText(obj.getName());
            this.jLName.setFont(this.tree.getFont());
            this.jLName.setForeground(selected ? UIManager.getColor("Tree.textSelectionColor") : UIManager.getColor("Tree.textNonSelectionColor"));
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Point location = this.jLName.getLocation();
            Dimension bounds = this.jLName.getPreferredSize();
            this.jLName.setBounds(location.x, location.y, bounds.width + 3, bounds.height);
        }
    }

    private static class NodeSelectionListener
    extends MouseAdapter {
        private JTree tree;

        public NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                this.tree.setSelectionRow(selRow);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                GroupObject group = (GroupObject)node.getUserObject();
                if (this.tree.isEditable()) {
                    this.setupPopupMenu(group).show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private JPopupMenu setupPopupMenu(GroupObject group) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.fullAccessAndSubgroups"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.menuActionPerformed(e);
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.noAccessAndSubgroups"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.menuActionPerformed(e);
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.readOnlyAndSubgroups"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.menuActionPerformed(e);
                }
            });
            popup.add(menuItem);
            return popup;
        }

        private void menuActionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            String item = source.getText();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.fullAccessAndSubgroups").equals(item)) {
                this.constraintChanged(node, 0);
            } else if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.noAccessAndSubgroups").equals(item)) {
                this.constraintChanged(node, 1);
            } else if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminGroupConstraintPanel.menu.readOnlyAndSubgroups").equals(item)) {
                this.constraintChanged(node, 2);
            }
            this.tree.cancelEditing();
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
            UIUtilities.expandNodeAndChildrenInTree(this.tree, node);
        }

        private void constraintChanged(DefaultMutableTreeNode node, int constraint) {
            GroupObject groupObject = (GroupObject)node.getUserObject();
            groupObject.setAccessConstraint(constraint);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                this.constraintChanged(child, constraint);
            }
        }
    }

    private class GroupConstraintTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        private AdminPrivilegeObject adminPrivilegeObj;
        private ArrayList<String> fullAccessList;
        private ArrayList<String> noAccessList;
        private ArrayList<String> readOnlyAccessList;

        public GroupConstraintTree() {
            this.setEditable(true);
            this.setCellRenderer(new GroupConstraintPanel(this));
            this.setCellEditor(new GroupConstraintPanel(this));
            this.addMouseListener(new NodeSelectionListener(this));
            this.setShowsRootHandles(true);
            this.putClientProperty("JTree.lineStyle", "Angled");
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.setRowHeight(30));
        }

        public void setData(AdminPrivilegeObject adminPrivilegeObj) {
            this.adminPrivilegeObj = adminPrivilegeObj;
            try {
                DefaultMutableTreeNode rootNode = GroupHandler.getGroups(false, Manager.getCurrentDomainId(), false, false);
                this.setModel(new DefaultTreeModel(rootNode));
                this.setGroupConstraint();
                UIUtilities.expandAllNodesInTree(AdminGroupConstraintPanel.this.groupTree);
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }

        public void modifyAdminPrivilege(AdminPrivilegeObject adminPrivilegeObj) {
            this.updateAccessList();
            adminPrivilegeObj.setAllowedClientGroupList(this.fullAccessList);
            adminPrivilegeObj.setDisallowedClientGroupList(this.noAccessList);
            adminPrivilegeObj.setReadOnlyClientGroupList(this.readOnlyAccessList);
        }

        public void updateAccessList() {
            this.fullAccessList = new ArrayList();
            this.noAccessList = new ArrayList();
            this.readOnlyAccessList = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
            this.updateAccessList(root, -1);
        }

        private void setGroupConstraint() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
            this.setGroupConstraint(node, 0);
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        }

        private void setGroupConstraint(DefaultMutableTreeNode node, int constraint) {
            if (node == null) {
                return;
            }
            GroupObject group = (GroupObject)node.getUserObject();
            constraint = this.adminPrivilegeObj.getGroupConstraint(group.getId(), constraint);
            group.setAccessConstraint(constraint);
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getChildAt(i);
                this.setGroupConstraint(nodeChild, constraint);
            }
        }

        private void updateAccessList(DefaultMutableTreeNode node, int parentFlag) {
            GroupObject group = (GroupObject)node.getUserObject();
            int currentFlag = group.getAccessConstraint();
            switch (currentFlag) {
                case 0: {
                    if (parentFlag != -1 && parentFlag == 0) break;
                    this.fullAccessList.add(group.getId());
                    break;
                }
                case 1: {
                    if (parentFlag != -1 && parentFlag == 1) break;
                    this.noAccessList.add(group.getId());
                    break;
                }
                case 2: {
                    if (parentFlag != -1 && parentFlag == 2) break;
                    this.readOnlyAccessList.add(group.getId());
                    break;
                }
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                this.updateAccessList(child, currentFlag);
            }
        }
    }
}

