/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.BasicPermission;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.acl.SitePermission;
import com.sygate.scm.common.configobject.schema.DirectoryAuthentication;
import com.sygate.scm.common.configobject.schema.DirectoryServer;
import com.sygate.scm.common.configobject.schema.DirectoryServerIntegration;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemServer;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.configobject.schema.ServerArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.util.CertificateUtil;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServerHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.SmartCardStatusPanel;
import com.sygate.scm.console.ui.admin.dlg.ChangePasswordPanel;
import com.sygate.scm.console.ui.admin.dlg.VerifyCurrentAdminPWDDlg;
import com.sygate.scm.console.ui.dlg.SwingWorkerProgressDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DirectoryServersDlg;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.SGridBagConstraints;
import com.sygate.scm.console.ui.util.SGridBagLayoutPanel;
import com.sygate.scm.console.ui.util.SearchableComboBox;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class AdminAuthenticationPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -7416484721014103003L;
    private JRadioButton defaultAuthentication = null;
    private JRadioButton rsaAuthentication = null;
    private JRadioButton directoryAuthentication = null;
    private JRadioButton smartCardAuthentication = null;
    private JComboBox<String> directoryServer = null;
    private JButton btADServers = null;
    private JTextField directoryAccountName = null;
    private JCheckBox enableVip = null;
    private JRadioButton rbPwdNeverExpires = null;
    private JRadioButton rbPwdExpires = null;
    private JTextField tfPwdAge = null;
    private JLabel labelPwdNeverExpires = null;
    private JLabel labelPwdExpires = null;
    private JLabel labelPwdDays = null;
    private JButton testButton = null;
    private ChangePasswordPanel pwdPanel = null;
    private boolean isRsaSupported = false;
    private boolean isVipSupported = false;
    private JTextField jtfFile = new JTextField(20);
    String jtfFileString = "";
    private JButton jbFileBrowse = new JButton(UIText.get(257));
    private VerifyCurrentAdminPWDDlg verifyCurrentAdminPWDDlg = null;
    private boolean isAddNewAdmin = false;
    private Integer previousAuthenticationMode = SemAdministrator.DEFAULT;
    private boolean previousVipMode = false;
    private boolean adminHasNeverExpiringPassword = false;
    private boolean hasNeverExpiresPanel = false;
    private boolean hasSitePermission = false;
    private SmartCardStatusPanel smartCardStatusPanel = new SmartCardStatusPanel();

    public VerifyCurrentAdminPWDDlg getVerifyCurrentAdminPWDDlg() {
        return this.verifyCurrentAdminPWDDlg;
    }

    public ChangePasswordPanel getPwdPanel() {
        return this.pwdPanel;
    }

    public void setPwdPanel(ChangePasswordPanel pwdPanel) {
        this.pwdPanel = pwdPanel;
    }

    public AdminAuthenticationPanel() {
        this(false, true);
    }

    public AdminAuthenticationPanel(boolean adminHasNeverExpiringPwd, boolean isPasswordPanelNeed) {
        this.getSupportedAuthMethods();
        this.adminHasNeverExpiringPassword = adminHasNeverExpiringPwd;
        this.isAddNewAdmin = isPasswordPanelNeed;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getInnerPanel(), "North");
        this.hasSitePermission = this.checkSitePermission();
    }

    private static String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", key);
    }

    private JPanel getInnerPanel() {
        Vector<String> directoryServers = this.getDirectoryServers();
        this.pwdPanel = new ChangePasswordPanel(false, this.isAddNewAdmin);
        this.defaultAuthentication = new JRadioButton(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.defaultAuthentication"));
        this.rsaAuthentication = new JRadioButton(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.rsaAuthentication"));
        this.directoryAuthentication = new JRadioButton(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.directoryAuthentication"));
        this.smartCardAuthentication = new JRadioButton(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.smartcardAuthentication"));
        this.defaultAuthentication.setFont(this.defaultAuthentication.getFont().deriveFont(0));
        this.rsaAuthentication.setFont(this.rsaAuthentication.getFont().deriveFont(0));
        this.directoryAuthentication.setFont(this.directoryAuthentication.getFont().deriveFont(0));
        this.smartCardAuthentication.setFont(this.smartCardAuthentication.getFont().deriveFont(0));
        this.directoryAuthentication.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                AdminAuthenticationPanel.this.directoryAuthChanged();
            }
        });
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.defaultAuthentication);
        bgroup.add(this.rsaAuthentication);
        bgroup.add(this.directoryAuthentication);
        bgroup.add(this.smartCardAuthentication);
        bgroup.setSelected(this.defaultAuthentication.getModel(), true);
        DescriptionTextArea defalutAuthLabel = new DescriptionTextArea(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.defaultAuthenticationDescription"));
        SGridBagLayoutPanel panel = new SGridBagLayoutPanel();
        panel.addComponent(this.defaultAuthentication);
        Insets insets = new Insets(0, 20, 0, 0);
        panel.addComponentEx(defalutAuthLabel, insets, 0, 17, 0.0);
        this.rbPwdExpires = new JRadioButton();
        this.rbPwdExpires.setFont(this.defaultAuthentication.getFont().deriveFont(0));
        this.enableVip = new JCheckBox(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.enableVIP"));
        this.labelPwdExpires = new JLabel(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.PasswordWillExpireIn"));
        this.labelPwdDays = new JLabel(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.Days"));
        ButtonGroup bgPwd = new ButtonGroup();
        bgPwd.add(this.rbPwdExpires);
        this.rbPwdExpires.setSelected(true);
        this.tfPwdAge = new JTextField();
        NumberPlainDocument doc = new NumberPlainDocument(0L, 9999L, true);
        this.tfPwdAge.setDocument(doc);
        this.tfPwdAge.setPreferredSize(new Dimension(40, (int)this.tfPwdAge.getPreferredSize().getHeight()));
        if (AdminHandler.isNeverExpiringPwdAllowedForCurrentDomain()) {
            this.hasNeverExpiresPanel = true;
            this.rbPwdExpires.setVisible(true);
            panel.addComponent(this.createNeverExpiresPanel(bgPwd), new Insets(0, 30, 0, 0));
        } else if (this.adminHasNeverExpiringPassword) {
            this.hasNeverExpiresPanel = true;
            this.rbPwdExpires.setVisible(true);
            panel.addComponent(this.createNeverExpiresPanel(bgPwd), new Insets(0, 30, 0, 0));
            this.rbPwdNeverExpires.setSelected(true);
            this.rbPwdNeverExpires.setEnabled(false);
            this.tfPwdAge.setText(String.valueOf(AdminStateObject.getDefaultPasswordAgeDays()));
        } else {
            this.rbPwdExpires.setSelected(true);
            this.rbPwdExpires.setVisible(false);
            this.setNeverExpirePanelVisable(false);
        }
        panel.addComponent(this.createExpiresPanel(), new Insets(0, 30, 0, 0));
        this.defaultAuthentication.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                AdminAuthenticationPanel.this.setPwdItemsStatus();
            }
        });
        this.rbPwdExpires.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                AdminAuthenticationPanel.this.setPwdItemsStatus();
            }
        });
        Insets insetsJ = new Insets(0, 20, 0, 0);
        panel.addComponentEx(this.pwdPanel, insetsJ, 1, 11, 0.0);
        panel.addComponentEx(this.enableVip, insetsJ, 1, 11, 0.0);
        panel.addComponent(this.rsaAuthentication);
        DescriptionTextArea rsaAuthLabel = new DescriptionTextArea(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.rsaAuthenticationDescription"));
        panel.addComponentEx(rsaAuthLabel, insetsJ, 0, 17, 0.0);
        panel.addComponent(this.directoryAuthentication);
        SGridBagLayoutPanel ldapParameterPanel = new SGridBagLayoutPanel();
        DescriptionTextArea directoryAuthLabel = new DescriptionTextArea(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.directoryAuthenticationDescription"));
        ldapParameterPanel.addComponent(directoryAuthLabel);
        this.directoryServer = new SearchableComboBox<String>(directoryServers);
        this.directoryServer.setPreferredSize(new Dimension(200, 20));
        this.directoryServer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev1) {
                AdminAuthenticationPanel.this.directoryServerChanged();
            }
        });
        this.directoryServer.setRenderer(new ToolTipComboBoxRenderer());
        this.directoryAccountName = new JTextField();
        this.directoryAccountName.setPreferredSize(new Dimension(200, 20));
        this.directoryAccountName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                AdminAuthenticationPanel.this.directoryServerChanged();
            }
        });
        ldapParameterPanel.addLabelAndComponent(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.DirectoryServer"), this.directoryServer);
        this.btADServers = new JButton(AdminAuthenticationPanel.getResourceString("AdminAuthenticationPanel.DirectoryServers"));
        this.btADServers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminAuthenticationPanel.this.editADServers();
            }
        });
        this.btADServers.setEnabled(this.hasSitePermission);
        ldapParameterPanel.addHorizontalComponentInPrevRow(this.btADServers);
        ldapParameterPanel.addLabelAndComponent(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.AccountName"), this.directoryAccountName);
        this.testButton = new JButton(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.TestAccount"));
        ldapParameterPanel.addHorizontalComponentInPrevRow(this.testButton);
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!AdminAuthenticationPanel.this.isValidate()) {
                    return;
                }
                SwingWorkerProgressDialog dlg = new SwingWorkerProgressDialog(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.TestAccount"), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.DirectoryAccountTest")){
                    boolean isOK;
                    {
                        this.isOK = false;
                    }

                    @Override
                    public void run(ActionEvent ex) {
                        AdminAuthenticationPanel.this.testButton.setEnabled(false);
                        this.isOK = AdminAuthenticationPanel.this.isADUserExists();
                    }

                    @Override
                    public void doCancelled() {
                        AdminAuthenticationPanel.this.testButton.setEnabled(true);
                        ConsoleLogger.log("Directory authentication process has been canceled.");
                    }

                    @Override
                    public void doFinished() {
                        AdminAuthenticationPanel.this.testButton.setEnabled(true);
                        if (this.isOK) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.DirectoryAccountTestPass"), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.TestAccount"), 1, null);
                        } else {
                            JOptionPane.showMessageDialog(Manager.getFrame(), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.DirectoryAccountNotExist"), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.TestFailed"), 0);
                        }
                    }
                };
                dlg.start();
            }
        });
        panel.addComponentEx(ldapParameterPanel, insets, 1, 17, 0.0);
        panel.addComponent(this.smartCardAuthentication);
        DescriptionTextArea smartcardAuthLabel = new DescriptionTextArea(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.smartcardAuthenticationDescription"));
        panel.addComponentEx(smartcardAuthLabel, insetsJ, 0, 17, 0.0);
        this.jbFileBrowse.setEnabled(false);
        this.jtfFile.setEnabled(false);
        this.smartCardAuthentication.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ae) {
                if (ae.getStateChange() == 1) {
                    AdminAuthenticationPanel.this.jbFileBrowse.setEnabled(true);
                    AdminAuthenticationPanel.this.jtfFile.setEnabled(true);
                } else if (ae.getStateChange() == 2) {
                    AdminAuthenticationPanel.this.jbFileBrowse.setEnabled(false);
                    AdminAuthenticationPanel.this.jtfFile.setEnabled(false);
                }
            }
        });
        this.jbFileBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AdminAuthenticationPanel.this.getCertFile();
                AdminAuthenticationPanel.this.smartCardStatusPanel.updateStatus(SmartCardStatusPanel.Status.NONE);
            }
        });
        ComponentUtils.setFileOpener((JComponent)this.jbFileBrowse, (FileOpener)new FileOpener(){

            public void openFile(File arg0) {
                AdminAuthenticationPanel.this.jtfFileString = arg0.getAbsolutePath();
                AdminAuthenticationPanel.this.jtfFile.setText(AjaxSwingUtil.getDisplayFileName(arg0));
            }
        });
        panel.addComponentEx(this.getSmartCardPanel(), new Insets(0, 16, 0, 0), 2, 17, 0.0);
        this.rsaAuthentication.setEnabled(this.isRsaSupported);
        rsaAuthLabel.setEnabled(this.isRsaSupported);
        return panel;
    }

    JPanel getSmartCardPanel() {
        SGridBagLayoutPanel panel = new SGridBagLayoutPanel();
        int indexY = 0;
        DescriptionTextArea certFileSelect = new DescriptionTextArea(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.certificate.label.CertFile"), 60);
        panel.add((Component)certFileSelect, new GridBagConstraints(0, indexY, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jtfFile, new GridBagConstraints(0, ++indexY, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.smartCardStatusPanel, new GridBagConstraints(0, ++indexY, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.jbFileBrowse, new GridBagConstraints(1, indexY, 0, 0, 0.0, 0.0, 13, 0, new Insets(7, 0, 0, 0), 0, 0));
        return panel;
    }

    private void getCertFile() {
        File selection;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.certificate.title.SelectCertFile"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new CertificateFileFilter());
        if (0 == fileChooser.showOpenDialog(Manager.getFrame()) && (selection = fileChooser.getSelectedFile()) != null) {
            this.jtfFileString = selection.getAbsolutePath();
            this.jtfFile.setText(AjaxSwingUtil.getDisplayFileName(selection));
        }
    }

    private void setNeverExpirePanelVisable(boolean enable) {
        if (this.rbPwdExpires != null) {
            this.rbPwdExpires.setVisible(enable);
        }
        if (this.rbPwdNeverExpires != null) {
            this.rbPwdNeverExpires.setVisible(enable);
        }
        if (this.labelPwdNeverExpires != null) {
            this.labelPwdNeverExpires.setVisible(enable);
        }
    }

    private void updateDirectoryServerComb(String name) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.directoryServer.getModel();
        Object selectedItem = model.getSelectedItem();
        model.removeAllElements();
        Vector<String> directoryServers = this.getDirectoryServers();
        for (String anObject : directoryServers) {
            if (null != name && anObject.toString().toLowerCase().indexOf(name.toLowerCase()) <= -1) continue;
            model.addElement(anObject);
        }
        if (directoryServers.contains(selectedItem)) {
            model.setSelectedItem(selectedItem);
        }
    }

    public void editADServers() {
        PrivilegeContext context;
        ServerObject server = this.getServerFromLoalSite();
        if (null == server) {
            return;
        }
        AuthorizationManager manager = AuthorizationManager.getInstance();
        boolean readOnly = !manager.checkPermission(context = DataobjectManager.getInstance().getCurrentPrivilegeContext(), (Permission)new SitePermission(server.getSemServer(), BasicPermission.AccessAction.FULL_ACCESS));
        DirectoryServersDlg dlg = new DirectoryServersDlg(server, readOnly, false);
        if (dlg.isOk()) {
            this.updateDirectoryServerComb(null);
        }
    }

    private ServerObject getServerFromLoalSite() {
        ServerObject server = null;
        try {
            String serverGUID = DataobjectManager.getInstance().getLoginInformation().getServerGUID();
            server = ServerHandler.getSBServerByGUID(serverGUID);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            UIUtilities.showErrorDialog(AdminAuthenticationPanel.getResourceString("AdminAuthenticationPanel.errorLoadingServer"));
        }
        return server;
    }

    private void setPwdItemsStatus() {
        if (this.defaultAuthentication.isSelected()) {
            if (this.hasNeverExpiresPanel) {
                this.rbPwdNeverExpires.setEnabled(true);
                this.labelPwdNeverExpires.setEnabled(true);
            }
            this.rbPwdExpires.setEnabled(true);
            this.labelPwdExpires.setEnabled(true);
            this.labelPwdDays.setEnabled(true);
            this.tfPwdAge.setEnabled(this.rbPwdExpires.isSelected());
            this.tfPwdAge.setEditable(this.rbPwdExpires.isSelected());
            this.pwdPanel.enableAllItems(true);
            this.enableVip.setEnabled(this.isVipSupported);
        } else {
            if (this.hasNeverExpiresPanel) {
                this.rbPwdNeverExpires.setEnabled(false);
                this.labelPwdNeverExpires.setEnabled(false);
            }
            this.rbPwdExpires.setEnabled(false);
            this.tfPwdAge.setEnabled(false);
            this.labelPwdExpires.setEnabled(false);
            this.labelPwdDays.setEnabled(false);
            this.pwdPanel.enableAllItems(false);
            this.enableVip.setEnabled(false);
        }
        if (this.tfPwdAge.getText() == null || this.tfPwdAge.getText().trim().length() == 0) {
            this.tfPwdAge.setText(String.valueOf(AdminStateObject.getDefaultPasswordAgeDays()));
        }
    }

    private JPanel createNeverExpiresPanel(ButtonGroup bgPwdExpiringOptions) {
        JPanel panel = new JPanel();
        GridBagLayout bag = new GridBagLayout();
        panel.setLayout(bag);
        this.rbPwdNeverExpires = new JRadioButton();
        this.rbPwdNeverExpires.setFont(this.defaultAuthentication.getFont().deriveFont(0));
        bgPwdExpiringOptions.add(this.rbPwdNeverExpires);
        this.rbPwdNeverExpires.setSelected(false);
        this.rbPwdNeverExpires.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                AdminAuthenticationPanel.this.setPwdItemsStatus();
            }
        });
        SGridBagConstraints constraints = new SGridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(2, 2, 2, 0);
        bag.setConstraints(this.rbPwdNeverExpires, constraints);
        panel.add(this.rbPwdNeverExpires);
        this.labelPwdNeverExpires = new JLabel(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.PasswordNeverExpires"));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 0, 2, 2);
        bag.setConstraints(this.labelPwdNeverExpires, constraints);
        panel.add(this.labelPwdNeverExpires);
        return panel;
    }

    private JPanel createExpiresPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.rbPwdExpires, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 0), 0, 0));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        panel2.add((Component)this.labelPwdExpires, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        panel2.add((Component)this.tfPwdAge, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 2), 0, 0));
        panel2.add((Component)this.labelPwdDays, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 2, 2), 0, 0));
        panel.add((Component)panel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 0, 2, 2), 0, 0));
        return panel;
    }

    private void getSupportedAuthMethods() {
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot configRoot = data.getSemConfigRoot();
            SemSiteArray siteArray = configRoot.getSemSiteArray();
            for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
                ObjReference objReference = siteArray.getObjReference(i);
                SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
                ServerArray serverArray = semSite.getServerArray();
                for (int j = 0; j < serverArray.getSemServerCount(); ++j) {
                    SemServer server = serverArray.getSemServer(j);
                    if (!this.isRsaSupported && server.getOptHasSecurId() != null && server.getOptHasSecurId().booleanValue()) {
                        this.isRsaSupported = true;
                    }
                    if (this.isVipSupported || server.getOptHasVipAuth() == null || !server.getOptHasVipAuth().booleanValue()) continue;
                    this.isVipSupported = true;
                }
            }
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_properties_authentication";
    }

    private Vector<String> getDirectoryServers() {
        Vector<String> retVector = new Vector<String>();
        retVector.add("");
        try {
            SemSite site = this.getLocalSite();
            if (site != null) {
                ServerArray serverArray = site.getServerArray();
                for (int i = 0; i < serverArray.getSemServerCount(); ++i) {
                    SemServer server = serverArray.getSemServer(i);
                    DirectoryServerIntegration directoryServers = server.getOptDirectoryServerIntegration();
                    if (directoryServers == null) continue;
                    for (int j = 0; j < directoryServers.getDirectoryServerCount(); ++j) {
                        DirectoryServer directoryserver = directoryServers.getDirectoryServer(j);
                        retVector.add(directoryserver.getName());
                    }
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return retVector;
    }

    private SemSite getLocalSite() throws ConsoleException {
        SemSite retValue = null;
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        for (int i = 0; i < siteArray.getObjReferenceCount(); ++i) {
            ObjReference objReference = siteArray.getObjReference(i);
            SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
            if (!Manager.isLocalSite(semSite.getId())) continue;
            retValue = semSite;
        }
        return retValue;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("sds");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new AdminAuthenticationPanel());
        frame.pack();
        frame.setVisible(true);
    }

    public void modifyAdmin(AdminObject admin) {
        SemAdministrator semAdmin = admin.getSemAdmin();
        if (this.defaultAuthentication.isSelected()) {
            if (this.enableVip.isSelected()) {
                semAdmin.setOptAuthenticationMethod(SemAdministrator.VIP);
            } else {
                semAdmin.setOptAuthenticationMethod(SemAdministrator.DEFAULT);
            }
            if (this.hasNeverExpiresPanel && this.rbPwdNeverExpires.isSelected()) {
                admin.setNeverExpiringPwd();
            } else {
                try {
                    Integer age = Integer.parseInt(this.tfPwdAge.getText());
                    semAdmin.setOptPasswordAge(age);
                }
                catch (Exception ex) {
                    ConsoleLogger.log(ex);
                    semAdmin.setOptPasswordAge(Integer.valueOf(AdminStateObject.getDefaultPasswordAgeDays()));
                }
            }
            this.pwdPanel.setAdminPwd(admin);
            semAdmin.setOptDirectoryAuthentication(null);
            semAdmin.setOptCertificateIssuerAndSubject(null);
            semAdmin.setOptSmartCardCertChainValid(null);
            semAdmin.setOptSmartCardChainValidationTime(null);
            semAdmin.setOptSmartCardCertificate(null);
        }
        if (this.rsaAuthentication.isSelected()) {
            semAdmin.setOptAuthenticationMethod(SemAdministrator.SECURID);
            semAdmin.setOptCertificateIssuerAndSubject(null);
            semAdmin.setOptSmartCardCertChainValid(null);
            semAdmin.setOptSmartCardChainValidationTime(null);
            semAdmin.setOptSmartCardCertificate(null);
        }
        if (this.directoryAuthentication.isSelected()) {
            semAdmin.setOptAuthenticationMethod(SemAdministrator.DIRECTORY);
            DirectoryAuthentication directoryAuthentication = new DirectoryAuthentication();
            directoryAuthentication.setOptServer((String)this.directoryServer.getSelectedItem());
            directoryAuthentication.setOptAccountName(this.directoryAccountName.getText());
            semAdmin.setOptDirectoryAuthentication(directoryAuthentication);
            semAdmin.setOptCertificateIssuerAndSubject(null);
            semAdmin.setOptSmartCardCertChainValid(null);
            semAdmin.setOptSmartCardChainValidationTime(null);
            semAdmin.setOptSmartCardCertificate(null);
        }
        if (this.smartCardAuthentication.isSelected()) {
            semAdmin.setOptAuthenticationMethod(SemAdministrator.SMARTCARD);
            X509Certificate x509Cert = CertificateUtil.getCertificateFromFilePath((String)this.jtfFileString);
            semAdmin.setOptCertificateIssuerAndSubject(Optional.ofNullable(CertificateUtil.getIssuerAndSubject((X509Certificate)x509Cert)).orElse(semAdmin.getOptCertificateIssuerAndSubject()));
            String encodedCertificate = null;
            try {
                encodedCertificate = CertificateUtil.x509CertToPem((X509Certificate)x509Cert);
            }
            catch (CertificateEncodingException ex) {
                ConsoleLogger.log("AdminAuthenticationPanel> modifyAdmin>> Error while encoding certificate. Exception: " + ex.getMessage());
                ConsoleLogger.log(ex);
            }
            semAdmin.setOptSmartCardCertificate(encodedCertificate);
            semAdmin.setOptSmartCardCertChainValid(semAdmin.getDefSmartCardCertChainValid());
            semAdmin.setOptSmartCardChainValidationTime(semAdmin.getDefSmartCardChainValidationTime());
            semAdmin.setOptPasswordAge(null);
            semAdmin.setOptPasswordHash(null);
        }
    }

    public String getCertificatePem() throws ConsoleException {
        try {
            X509Certificate x509Cert = CertificateUtil.getCertificateFromFilePath((String)this.jtfFileString);
            return CertificateUtil.x509CertToPem((X509Certificate)x509Cert);
        }
        catch (CertificateException exc) {
            throw new ConsoleException(exc);
        }
    }

    public boolean isSmartCardAuthentication() {
        return this.smartCardAuthentication.isSelected();
    }

    public void setData(AdminObject admin) {
        DirectoryAuthentication directoryAuthentication;
        SemAdministrator semAdmin = admin.getSemAdmin();
        Boolean useSecurId = semAdmin.getOptUseSecurId();
        if (useSecurId == null) {
            useSecurId = semAdmin.getDefUseSecurId();
        }
        if (useSecurId != null && useSecurId.booleanValue()) {
            this.rsaAuthentication.setSelected(true);
            this.previousAuthenticationMode = SemAdministrator.SECURID;
        } else {
            this.defaultAuthentication.setSelected(true);
        }
        if (SemAdministrator.DEFAULT.equals(semAdmin.getOptAuthenticationMethod()) || SemAdministrator.VIP.equals(semAdmin.getOptAuthenticationMethod())) {
            this.defaultAuthentication.setSelected(true);
            if (SemAdministrator.VIP.equals(semAdmin.getOptAuthenticationMethod())) {
                this.enableVip.setSelected(true);
                this.previousVipMode = true;
            } else {
                this.enableVip.setSelected(false);
                this.previousVipMode = false;
            }
            this.pwdPanel.enableCurrentPassword(true);
            if (admin.hasNeverExpiringPwd() && this.hasNeverExpiresPanel) {
                this.rbPwdNeverExpires.setSelected(true);
                this.rbPwdExpires.setSelected(false);
                this.tfPwdAge.setText(String.valueOf(AdminStateObject.getDefaultPasswordAgeDays()));
            } else {
                if (this.hasNeverExpiresPanel) {
                    this.rbPwdNeverExpires.setSelected(false);
                }
                this.rbPwdExpires.setSelected(true);
                this.tfPwdAge.setText(String.valueOf(admin.getPasswordAge()));
            }
            this.previousAuthenticationMode = SemAdministrator.DEFAULT;
        }
        if (SemAdministrator.SECURID.equals(semAdmin.getOptAuthenticationMethod())) {
            this.rsaAuthentication.setSelected(true);
            this.previousAuthenticationMode = SemAdministrator.SECURID;
        }
        if (SemAdministrator.DIRECTORY.equals(semAdmin.getOptAuthenticationMethod())) {
            this.directoryAuthentication.setSelected(true);
            this.previousAuthenticationMode = SemAdministrator.DIRECTORY;
        }
        if (SemAdministrator.SMARTCARD.equals(semAdmin.getOptAuthenticationMethod())) {
            this.smartCardAuthentication.setSelected(true);
            this.previousAuthenticationMode = SemAdministrator.SMARTCARD;
        }
        if ((directoryAuthentication = semAdmin.getOptDirectoryAuthentication()) != null) {
            String server;
            String accountName = directoryAuthentication.getOptAccountName();
            if (accountName != null) {
                this.directoryAccountName.setText(accountName);
            }
            if ((server = directoryAuthentication.getOptServer()) != null) {
                this.directoryServer.setSelectedItem(server);
            }
        }
        this.directoryAuthChanged();
        this.setPwdItemsStatus();
        this.pwdPanel.updateNewPwdlabel(semAdmin.getName());
    }

    private void directoryAuthChanged() {
        boolean enable = this.directoryAuthentication.isEnabled() && this.directoryAuthentication.isSelected();
        this.directoryServer.setEnabled(enable);
        this.directoryAccountName.setEnabled(enable);
        this.testButton.setEnabled(this.isNeedEnableTestButton());
        if (this.hasSitePermission) {
            this.btADServers.setEnabled(enable);
        }
    }

    private void directoryServerChanged() {
        this.testButton.setEnabled(this.isNeedEnableTestButton());
    }

    public int getCurrentAdminLoginType() {
        return AdminObject.retrieveCurrentAdminObject().getSemAdmin().getOptAuthenticationMethod();
    }

    public boolean isPasswordValidated(AdminObject admin) {
        if (this.defaultAuthentication.isSelected()) {
            boolean valid = false;
            valid = this.pwdPanel.isPasswordValid(admin, this.isDefaultAuthenticationMode(), false);
            if (valid && this.isDefaultAuthenticationMode() && this.enableVip.isSelected() != this.previousVipMode && !this.isAddNewAdmin && this.pwdPanel.getTFCurrentPwd().getPassword().length == 0) {
                this.verifyCurrentAdminPWDDlg = new VerifyCurrentAdminPWDDlg(admin, Manager.getFrame(), AdminAuthenticationPanel.getResourceString("VerifyCurrentAdminPWDDlg.title"));
                if (!this.verifyCurrentAdminPWDDlg.isOk()) {
                    valid = false;
                }
            }
            return valid;
        }
        if (this.isAuthenticationTypeChanged()) {
            int currentAdminType = this.getCurrentAdminLoginType();
            if (SemAdministrator.SMARTCARD.equals(currentAdminType)) {
                return true;
            }
            if (this.smartCardAuthentication.isSelected() && StringUtilities.isEmpty((String)this.jtfFile.getText())) {
                return true;
            }
            this.verifyCurrentAdminPWDDlg = new VerifyCurrentAdminPWDDlg(admin, Manager.getFrame(), AdminAuthenticationPanel.getResourceString("VerifyCurrentAdminPWDDlg.title"));
            if (!this.verifyCurrentAdminPWDDlg.isOk()) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidate() {
        if (this.directoryAuthentication.isSelected()) {
            String adServer = (String)this.directoryServer.getSelectedItem();
            String adUser = this.directoryAccountName.getText();
            if (adServer == null || adServer.trim().length() == 0 || adUser == null || adUser.trim().length() == 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.requiredInfo"), AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.InvalidInput"), 0);
                this.directoryAccountName.selectAll();
                return false;
            }
            if (!this.isADServerExist(adServer)) {
                String msg = MessageFormat.format(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.ADServer.notExit"), adServer);
                String title = AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.InvalidInput");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 0);
                this.directoryAccountName.selectAll();
                return false;
            }
        }
        return true;
    }

    public boolean validateSmartCardCert(AdminObject admin) {
        if (this.isSmartCardAuthentication()) {
            File certFile;
            boolean invalidCertFile = false;
            if (!(StringUtilities.isEmpty((String)this.jtfFileString) || (certFile = new File(this.jtfFileString)).exists() && !certFile.isDirectory())) {
                invalidCertFile = true;
            }
            String certificateErrorMsg = AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.certificate.Invalid.Error");
            String certificateErrorTitle = AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.ConfigurationFailure.Title");
            X509Certificate certificate = CertificateUtil.getCertificateFromFilePath((String)this.jtfFileString);
            if (certificate == null) {
                invalidCertFile = true;
                ConsoleLogger.log("AdminAuthenticationPanel> validateSmartCardCert>> Certificate is null. Invalid certificate.");
            } else {
                try {
                    int certificateSize = certificate.getEncoded().length;
                    int maxAllowedSize = ScmProperties.getSmartCardCertificateMaximumAllowedSizeInBytes();
                    if (certificateSize > maxAllowedSize) {
                        invalidCertFile = true;
                        ConsoleLogger.log("AdminAuthenticationPanel> validateSmartCardCert>> Certificate size (" + certificateSize + ") is greater than maximum allowed size (" + maxAllowedSize + "). You can change the maximum allowed size in conf.properties.");
                        certificateErrorMsg = MessageFormat.format(AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.certificate.size.Invalid.Error"), maxAllowedSize);
                    }
                }
                catch (CertificateEncodingException ce) {
                    invalidCertFile = true;
                    ConsoleLogger.log("AdminAuthenticationPanel> validateSmartCardCert>> Invalid certificate. Exception: " + ce.getMessage());
                }
            }
            if (!invalidCertFile && StringUtilities.isEmpty((String)CertificateUtil.getIssuerAndSubject((X509Certificate)certificate))) {
                ConsoleLogger.log("AdminAuthenticationPanel> validateSmartCardCert>> Failed to get issuer and subject, Existing Admin issuer and subject: " + Optional.ofNullable(admin).map(AdminObject::getSemAdmin).map(SemAdministrator::getOptCertificateIssuerAndSubject).orElse(""));
                invalidCertFile = true;
            }
            if (invalidCertFile) {
                JOptionPane.showMessageDialog(Manager.getFrame(), certificateErrorMsg, certificateErrorTitle, 0);
                return false;
            }
        }
        return true;
    }

    private boolean isADServerExist(String adServer) {
        return this.getDirectoryServers().contains(adServer);
    }

    private boolean isADUserExists() {
        String adServer = (String)this.directoryServer.getSelectedItem();
        String adUser = this.directoryAccountName.getText();
        return GUIManager.authenticateADUser(adUser, adServer);
    }

    private boolean isNeedEnableTestButton() {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            if (this.directoryServer == null || this.directoryAccountName == null) {
                return false;
            }
            boolean isSelectEnabled = this.directoryServer.isEnabled() && this.directoryAccountName.isEditable();
            String adServer = (String)this.directoryServer.getSelectedItem();
            String adUser = this.directoryAccountName.getText();
            return isSelectEnabled && !StringUtilities.isEmpty((String)adServer) && !StringUtilities.isEmpty((String)adUser);
        }
        if (this.directoryServer == null) {
            return false;
        }
        boolean isSelectEnabled = this.directoryServer.isEnabled() && this.directoryAccountName.isEditable();
        String adServer = (String)this.directoryServer.getSelectedItem();
        return isSelectEnabled && !StringUtilities.isEmpty((String)adServer);
    }

    private boolean isDefaultAuthenticationMode() {
        return SemAdministrator.DEFAULT.equals(this.previousAuthenticationMode);
    }

    private boolean isAuthenticationTypeChanged() {
        if (this.defaultAuthentication.isSelected() && SemAdministrator.DEFAULT.equals(this.previousAuthenticationMode)) {
            return false;
        }
        if (this.rsaAuthentication.isSelected() && SemAdministrator.SECURID.equals(this.previousAuthenticationMode)) {
            return false;
        }
        if (this.directoryAuthentication.isSelected() && SemAdministrator.DIRECTORY.equals(this.previousAuthenticationMode)) {
            return false;
        }
        return !this.smartCardAuthentication.isSelected() || !this.isAddNewAdmin;
    }

    private boolean checkSitePermission() {
        boolean hasSitePermission = false;
        try {
            PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
            hasSitePermission = AuthorizationManager.getInstance().checkPermission(context, (Permission)new SitePermission(this.getLocalSite(), BasicPermission.AccessAction.FULL_ACCESS));
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return hasSitePermission;
    }

    public SmartCardStatusPanel getSmartCardStatusPanel() {
        return this.smartCardStatusPanel;
    }

    static class CertificateFileFilter
    extends FileFilter {
        CertificateFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".crt") || file.getName().toLowerCase().endsWith(".cer") || file.getName().toLowerCase().endsWith(".der");
        }

        @Override
        public String getDescription() {
            return AdminAuthenticationPanel.getResourceString("AdminPropertiesAuthenticationPanel.certificate.Desc.CertFiles");
        }
    }
}

