/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.SmartCardStatusPanel;
import com.sygate.scm.console.ui.admin.dlg.AdminAuthenticationPanel;
import com.sygate.scm.console.ui.admin.dlg.AdminPrivilegePanel;
import com.sygate.scm.console.ui.admin.dlg.AdminPropertiesGeneralPanel;
import com.sygate.scm.console.ui.admin.dlg.CompanyInformationPanel;
import com.sygate.scm.console.ui.admin.dlg.VerifyCurrentAdminPWDDlg;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.ErrorMsg;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdmPropertiesDlg
extends DialogBase
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private final AdminObject admin;
    private AdminPropertiesGeneralPanel panelGeneral = null;
    private AdminPrivilegePanel panelPrivilege = null;
    private AdminAuthenticationPanel panelAuthentication = null;
    private CompanyInformationPanel panelCompany = null;
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private boolean isCancelled = true;
    private boolean isAddNewAdmin = false;
    private final MessageResources msgRes = MessageResources.getInstance();
    private JScrollPane scrollabelPanelPrivilege = null;
    private JScrollPane scrollabelPanelAuthentication = null;
    private JScrollPane scrollabelPanelCompany = null;
    private JScrollPane scrollablePanelGeneral = null;
    private HashMap<Component, Boolean> componentStatus = new HashMap();

    public AdmPropertiesDlg(AdminObject admin, JFrame frame, String title, boolean modal, boolean readOnly, boolean isAddNewAdmin) {
        super(frame, title, modal);
        this.admin = admin;
        this.readOnly = readOnly;
        this.isAddNewAdmin = isAddNewAdmin;
        this.initialize();
        if (this.panelGeneral != null) {
            this.panelGeneral.focusOnDefaultComponent();
        }
        this.tabbedPane.addChangeListener(this);
    }

    public AdmPropertiesDlg(AdminObject admin, JFrame frame, String title, boolean modal) {
        this(admin, frame, title, modal, false, false);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        boolean isClickCompanyInfoPanel = false;
        Component selectedTab = pane.getSelectedComponent();
        if (selectedTab instanceof JScrollPane) {
            Component childComp = ((JScrollPane)selectedTab).getViewport().getView();
            if (childComp instanceof CompanyInformationPanel) {
                this.jBHelp.setVisible(false);
                isClickCompanyInfoPanel = true;
            }
            if (this.isAddNewAdmin && childComp instanceof AdminPrivilegePanel) {
                ((AdminPrivilegePanel)childComp).setFocus();
            }
        }
        if (!isClickCompanyInfoPanel) {
            this.jBHelp.setVisible(true);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setData() {
        this.panelGeneral.setData(this.admin);
        if (this.panelPrivilege != null) {
            this.panelPrivilege.setData(this.admin);
        }
        if (this.panelAuthentication != null) {
            this.panelAuthentication.setData(this.admin);
        }
        if (this.panelCompany != null) {
            this.panelCompany.setData();
        }
        this.pack();
    }

    public boolean modifyAdmin() {
        boolean ret = true;
        if (this.panelPrivilege != null) {
            this.panelPrivilege.modifyAdmin(this.admin);
        }
        try {
            this.panelGeneral.modifyAdmin(this.admin);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (ex.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            ret = false;
        }
        if (!LicenseObject.getInstance().isSBProduct() && this.panelAuthentication != null) {
            this.panelAuthentication.modifyAdmin(this.admin);
        }
        if (this.panelCompany != null) {
            this.panelCompany.commitCompanyInformation();
        }
        return ret;
    }

    public AdminPrivilegeObject getAdminPrivilegeObject() {
        if (this.panelPrivilege != null) {
            return this.panelPrivilege.getAdminPrivilegeObject();
        }
        return null;
    }

    void disableUiForCertValidation() {
        if (this.panelAuthentication.isSmartCardAuthentication()) {
            this.componentStatus.clear();
            this.disableUiForCertValidation(this.panelAuthentication);
            this.componentStatus.put(this.jBOk, this.jBOk.isEnabled());
            this.componentStatus.put(this.tabbedPane, this.tabbedPane.isEnabled());
            this.jBOk.setEnabled(false);
            this.tabbedPane.setEnabled(false);
        }
    }

    void disableUiForCertValidation(JPanel panel) {
        Component[] components;
        for (Component component : components = panel.getComponents()) {
            if (component instanceof SmartCardStatusPanel) continue;
            if (component instanceof JPanel) {
                this.disableUiForCertValidation((JPanel)component);
                continue;
            }
            this.componentStatus.put(component, component.isEnabled());
            component.setEnabled(false);
        }
    }

    void resetUiForCertValidation() {
        if (this.panelAuthentication.isSmartCardAuthentication()) {
            this.resetUiForCertValidation(this.panelAuthentication);
            this.jBOk.setEnabled(this.componentStatus.get(this.jBOk));
            this.tabbedPane.setEnabled(this.componentStatus.get(this.tabbedPane));
        }
    }

    void resetUiForCertValidation(JPanel panel) {
        Component[] components;
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JPanel) {
                this.resetUiForCertValidation((JPanel)component);
            }
            Optional.ofNullable(this.componentStatus.get(component)).ifPresent(v -> component.setEnabled(this.componentStatus.get(component)));
        }
    }

    private void validateCertChain() throws ConsoleException {
        try {
            this.tabbedPane.setSelectedComponent(this.scrollabelPanelAuthentication);
            this.disableUiForCertValidation();
            this.panelAuthentication.getSmartCardStatusPanel().updateStatus(SmartCardStatusPanel.Status.RUNNING);
            GUIManager.doSmartCardCertificateValidation(this.panelAuthentication.getCertificatePem(), null);
            this.panelAuthentication.getSmartCardStatusPanel().updateStatus(SmartCardStatusPanel.Status.SUCCEEDED);
            Utility.threadSleep((int)2);
        }
        catch (ConsoleException exc) {
            this.panelAuthentication.getSmartCardStatusPanel().updateStatus(SmartCardStatusPanel.Status.FAILED);
            throw exc;
        }
    }

    public Object okWorkerConstruct() {
        this.isOk = false;
        try {
            if (this.panelAuthentication.isSmartCardAuthentication()) {
                this.validateCertChain();
            }
            if (!this.isCancelled()) {
                this.commit();
                this.isOk = true;
            } else {
                ConsoleLogger.log("AdmPropertiesDialog >> okWorkerConstruct >> The thread is canceled!");
            }
        }
        catch (ConsoleException ex) {
            if (!this.isCancelled()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessageString(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdminPropertiesAuthenticationPanel.ConfigurationFailure.Title"), 0);
            }
            ConsoleLogger.log("AdmPropertiesDialog >> okWorkerConstruct >> The thread is canceled!");
        }
        return null;
    }

    public void okWorkerFinish() {
        this.resetUiForCertValidation();
        if (this.isOk()) {
            this.dispose();
        } else {
            boolean doLogout = false;
            if (this.panelAuthentication.getPwdPanel().isPasswordVerificationThresholdExceeded()) {
                doLogout = true;
            } else {
                VerifyCurrentAdminPWDDlg verifyCurrentAdminPWDDlg = this.panelAuthentication.getVerifyCurrentAdminPWDDlg();
                if (verifyCurrentAdminPWDDlg != null && verifyCurrentAdminPWDDlg.isPasswordVerificationThresholdExceeded()) {
                    doLogout = true;
                }
            }
            if (doLogout) {
                Manager.getFrame().logOutAndShowLoginPage();
            }
        }
    }

    @Override
    public boolean isOk() {
        return this.isOk;
    }

    @Override
    protected boolean ok() {
        this.isCancelled = false;
        if (!this.isValidate()) {
            return false;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return AdmPropertiesDlg.this.okWorkerConstruct();
            }

            public void finished() {
                AdmPropertiesDlg.this.okWorkerFinish();
            }
        };
        worker.start();
        return false;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.isCancelled = true;
        this.dispose();
    }

    @Override
    protected boolean isValidate() {
        try {
            if (!this.panelGeneral.validateData(this.admin)) {
                this.tabbedPane.setSelectedComponent(this.scrollablePanelGeneral);
                return false;
            }
            if (!(this.panelAuthentication == null || this.panelAuthentication.validateSmartCardCert(this.admin) && this.panelAuthentication.isPasswordValidated(this.admin) && this.panelAuthentication.isValidate())) {
                this.tabbedPane.setSelectedComponent(this.scrollabelPanelAuthentication);
                return false;
            }
            if (this.panelPrivilege != null && !this.panelPrivilege.isValidate()) {
                this.tabbedPane.setSelectedComponent(this.scrollabelPanelPrivilege);
                return false;
            }
            if (this.panelCompany != null && !this.panelCompany.isValidate()) {
                this.tabbedPane.setSelectedComponent(this.scrollabelPanelCompany);
                return false;
            }
            return !this.checkDuplicateAdminName(this.admin);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return false;
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        Component childComp;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof ContentSensitiveHelpPage) {
            return ((ContentSensitiveHelpPage)((Object)component)).getContentSensitiveHelpToken();
        }
        if (component instanceof JScrollPane && (childComp = ((JScrollPane)component).getViewport().getView()) instanceof ContentSensitiveHelpPage) {
            return ((ContentSensitiveHelpPage)((Object)childComp)).getContentSensitiveHelpToken();
        }
        return this.panelGeneral.getContentSensitiveHelpToken();
    }

    public AdminAuthenticationPanel getPanelAuthentication() {
        return this.panelAuthentication;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void initialize() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        this.pack();
        Dimension size = this.getPreferredSize();
        if (!this.isAddNewAdmin) {
            this.setPreferredSize(new Dimension((int)((double)size.width * 1.2), size.height));
        } else {
            this.setPreferredSize(new Dimension((int)((double)size.width * 1.05), size.height));
        }
        UiUtilities.centerComponent((Component)this);
    }

    private void jbInit() {
        this.getContentPane().setLayout(this.borderLayout1);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.panelGeneral = new AdminPropertiesGeneralPanel(this, this.readOnly, this.isAddNewAdmin);
        this.scrollablePanelGeneral = UIUtilities.createScrollPaneWithoutBoard(this.panelGeneral);
        this.tabbedPane.add((Component)this.scrollablePanelGeneral, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdmPropertiesDlg.generalMsg"));
        if (this.isAddNewAdmin || !this.admin.isSysAdmin()) {
            this.panelPrivilege = new AdminPrivilegePanel(this.isAddNewAdmin, this.readOnly);
            this.scrollabelPanelPrivilege = UIUtilities.createScrollPaneWithoutBoard(this.panelPrivilege);
            this.tabbedPane.add((Component)this.scrollabelPanelPrivilege, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdmPropertiesDlg.accessRightsMsg"));
        }
        this.panelAuthentication = new AdminAuthenticationPanel(this.admin.hasNeverExpiringPwd(), this.isAddNewAdmin);
        this.scrollabelPanelAuthentication = UIUtilities.createScrollPaneWithoutBoard(this.panelAuthentication);
        this.tabbedPane.add((Component)this.scrollabelPanelAuthentication, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdmPropertiesDlg.authenticationMsg"));
        if (!this.isAddNewAdmin && this.admin.isSysAdmin()) {
            this.panelCompany = new CompanyInformationPanel();
            this.scrollabelPanelCompany = UIUtilities.createScrollPaneWithoutBoard(this.panelCompany);
            this.tabbedPane.add((Component)this.scrollabelPanelCompany, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AdmPropertiesDlg.company"));
        }
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        UiUtilities.centerComponent((Component)this);
    }

    private boolean checkDuplicateAdminName(AdminObject admin) throws ConsoleException {
        if (this.panelGeneral == null || this.panelPrivilege == null) {
            return false;
        }
        if (admin != null && admin.getAdminName() != null && admin.getAdminName().equalsIgnoreCase(this.panelGeneral.getUserName())) {
            return false;
        }
        AbstractAdminHandler handler = AbstractAdminHandler.getInstance(this.panelPrivilege.getSelectedType());
        if (handler.checkExistence(this.panelGeneral.getUserName())) {
            String message = ErrorMsg.getMessage((int)12);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, this.msgRes.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.consoleError"), 0);
            return true;
        }
        return false;
    }
}

