/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin.dlg;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.admin.dlg.DomainInfoPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUID;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddDomainDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private DomainInfoPanel upPanel = null;
    private JPanel titlePanel = new JPanel(new GridBagLayout());
    private MessageResources msg = MessageResources.getInstance();
    private DescriptionTextArea desc = new DescriptionTextArea(this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.titleDescText"));
    private JLabel domainIDLabel = new JLabel(this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainIDLabel"));
    protected JTextField domainIDField = new JTextField();
    private JPanel advancedPanel;
    JButton jBAdvanced = new JButton(UIText.get(3077));

    public AddDomainDlg(String title) {
        super(Manager.getFrame(), title, true);
        this.initialize();
        this.setVisible(true);
    }

    public String getDomainID() {
        return this.domainIDField.getText().trim();
    }

    public String getDomainName() {
        return this.upPanel.getDomainName();
    }

    public String getCompanyName() {
        return this.upPanel.getCompanyName();
    }

    public String getContactList() {
        return this.upPanel.getContactList();
    }

    public boolean isAutoDeleteIdleClient() {
        return this.upPanel.isAutoDeleteIdleClient();
    }

    public boolean isCentralQurantineEnabled() {
        return this.upPanel.isCQEnabled();
    }

    public boolean isAutoDeleteIdleNPVDIClient() {
        return this.upPanel.isAutoDeleteIdleNPVDIClient();
    }

    public int getMaxClientIdleDuration() {
        return this.upPanel.getMaxClientIdleDuration();
    }

    public int getMaxNPVDIClientIdleDuration() {
        return this.upPanel.getMaxNPVDIClientIdleDuration();
    }

    @Override
    protected boolean isValidate() {
        String domainID;
        if (this.advancedPanel.getParent() != null && (domainID = this.getDomainID()) != null && domainID.length() != 0) {
            try {
                new GUID(domainID);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainIDNotValidMsg"), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.error"), 0);
                this.domainIDField.requestFocus();
                return false;
            }
        }
        if (!this.upPanel.isValidate()) {
            return false;
        }
        String domainName = this.getDomainName();
        String domainId = this.getDomainID();
        int validationCode = AdminHandler.validateDomainInfo(domainId, domainName);
        if (validationCode == -2) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainNameShouldNotEmptyMsg"), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.error"), 0);
            this.upPanel.domainNameRequestFocus();
            return false;
        }
        if (validationCode == -4) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainNameExistMsg"), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.error"), 0);
            this.upPanel.domainNameRequestFocus();
            return false;
        }
        if (validationCode == -3) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.domainIdExistMsg"), this.msg.getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddDomainDlg.error"), 0);
            this.domainIDField.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_admin_dialog_add_domain";
    }

    private void initialize() {
        if (this.upPanel == null) {
            this.upPanel = new DomainInfoPanel();
        }
        this.upPanel.getDomainInfoPanel().add((Component)this.jBAdvanced, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 10), 0, 0));
        this.advancedPanel = this.getAdvancedPanel();
        this.jBAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddDomainDlg.this.advancedChanged();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.titlePanel.putClientProperty("cssClass", "AddDomainDlgtitlePanel");
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(20, 15, 0, 20));
        this.titlePanel.add((Component)this.desc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.upPanel.getDomainInfoPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getAdvancedPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraint = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 10, 0), 0, 0);
        panel.add((Component)this.domainIDLabel, constraint);
        constraint.gridx = 1;
        constraint.gridwidth = 2;
        constraint.fill = 2;
        constraint.insets = new Insets(0, 28, 10, 10);
        constraint.weightx = 1.0;
        panel.add((Component)this.domainIDField, constraint);
        return panel;
    }

    private void advancedChanged() {
        this.advancedPanel.putClientProperty("cssClass", "AddDomainDlgadvancedPanel");
        if (this.advancedPanel.getParent() != null) {
            this.advancedPanel.getParent().remove(this.advancedPanel);
            this.jBAdvanced.setText(UIText.get(3077));
            this.domainIDField.setText("");
        } else {
            this.upPanel.getDomainInfoPanel().add((Component)this.advancedPanel, new GridBagConstraints(0, 6, 4, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jBAdvanced.setText(UIText.get(3078));
        }
        this.validate();
        this.pack();
    }

    public DomainInfoPanel getDomainInfoPanel() {
        return this.upPanel;
    }
}

