/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.admin.AdminBasePanel;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.admin.LicenseDetailPanel;
import com.sygate.scm.console.ui.admin.LicenseHelpPanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class LicenseStatusPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private String panelName;
    private ElsLicenseObject currentLicense;
    private LicenseChainObject currentChain;
    private TrialwareLicenseObject currentTwLicense;
    private UpgradeLicenseObject currentUpgradeLicense;
    protected static final int DELETE = 2;
    protected static final int INPRODUCTACTIVATE = 8;
    protected static final int LICENSERENEW = 9;
    protected static final int RECOVER_LICENSE = 10;
    protected static final int PURCHASE_ADDITIONAL_LICENSES = 11;
    protected static final int EDIT_PARTNER_INFORMATION = 12;
    private Component contentPanel;
    private LicenseDetailPanel detailPanel;
    private LicenseHelpPanel helpPanel;

    protected LicenseHelpPanel getHelpPanel() {
        if (this.helpPanel == null) {
            this.helpPanel = new LicenseHelpPanel(this);
            this.helpPanel.setExpanded(true);
        }
        return this.helpPanel;
    }

    @Override
    protected Component getContentPanel() {
        if (this.contentPanel == null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.getStatusPanel(), "Center");
            panel.add((Component)this.getHelpPanel(), "South");
            panel.putClientProperty("cssClass", "licStatusPContentPanel");
            this.contentPanel = panel;
        }
        return this.contentPanel;
    }

    protected LicenseDetailPanel getStatusPanel() {
        if (this.detailPanel == null) {
            this.detailPanel = new LicenseDetailPanel();
        }
        return this.detailPanel;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_licenses";
    }

    @Override
    protected String getPanelName(Object item) {
        this.panelName = item != null && item instanceof ElsLicenseObject ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.licenseManagement") : (item != null && item instanceof LicenseChainObject ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.licenseChainManagement") : (item != null && item instanceof TrialwareLicenseObject ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.trialwareLicenseManagement") : ""));
        return this.panelName;
    }

    @Override
    protected String getLeftTableContent(Object item) {
        return "";
    }

    @Override
    public void setSelectedItem(Object item) {
        super.setSelectedItem(item);
        this.currentLicense = null;
        this.currentChain = null;
        this.currentTwLicense = null;
        this.currentUpgradeLicense = null;
        if (item != null && item instanceof ElsLicenseObject && ((ElsLicenseObject)item).getId() != null) {
            this.currentLicense = (ElsLicenseObject)item;
            this.getStatusPanel().setLicense(this.currentLicense);
            this.getHelpPanel().setType(0);
        } else if (item != null && item instanceof LicenseChainObject && ((LicenseChainObject)item).getId() != null) {
            this.currentChain = (LicenseChainObject)item;
            this.getStatusPanel().setLicense(this.currentChain);
            this.getHelpPanel().setType(0);
        } else if (item != null && item instanceof TrialwareLicenseObject && ((TrialwareLicenseObject)item).getId() != null) {
            this.currentTwLicense = (TrialwareLicenseObject)item;
            this.getStatusPanel().setLicense(this.currentTwLicense);
            this.getHelpPanel().setType(1);
        } else if (item != null && item instanceof UpgradeLicenseObject && ((UpgradeLicenseObject)item).getId() != null) {
            this.currentUpgradeLicense = (UpgradeLicenseObject)item;
            this.getStatusPanel().setLicense(this.currentUpgradeLicense);
            this.getHelpPanel().setType(2);
        } else {
            this.getStatusPanel().setEmpty();
            this.getHelpPanel().setType(0);
        }
    }

    @Override
    protected String getRightTableContent(Object item) {
        return "";
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
    }

    public void handleException(Exception ex) {
        if (ex instanceof ConsoleException) {
            int errorCode = ((ConsoleException)ex).getErrorCode();
            if (((ConsoleException)ex).needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.err_consoleError"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            if (errorCode == 0x16010000) {
                Object[] obj = new Object[1];
                if (this.currentLicense != null) {
                    obj[0] = this.currentLicense.getName();
                }
                if (this.currentChain != null) {
                    obj[0] = this.currentChain.getName();
                }
                if (this.currentTwLicense != null) {
                    obj[0] = this.currentTwLicense.getName();
                }
                if (this.currentUpgradeLicense != null) {
                    obj[0] = this.currentUpgradeLicense.getName();
                }
                String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.err_LicenseNotExist");
                String fm = MessageFormat.format(msg, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.err_consoleError"), 0);
                this.getAdminPanel().removeSelectedNode();
                return;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.err_consoleError"), 0);
        } else {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        AdminPanel adminPanel = this.getAdminPanel();
        if (!LicenseActivationHandler.checkLicenseValidState(this)) {
            return;
        }
        switch (taskIndex) {
            case 2: {
                adminPanel.deleteLicense();
                break;
            }
            case 8: {
                adminPanel.inproductactivationLicense();
                break;
            }
            case 10: {
                adminPanel.recoverLicense();
                break;
            }
            case 11: {
                adminPanel.purchaseAdditionalLicense();
                break;
            }
            case 12: {
                adminPanel.editPartnerInformation();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public List<List<TaskObject>> getTaskList(TreeItem item) {
        ArrayList<List<TaskObject>> taskList = new ArrayList<List<TaskObject>>();
        if (this.currentLicense != null || this.currentChain != null) {
            ArrayList<TaskObject> group1 = new ArrayList<TaskObject>();
            taskList.add(group1);
            group1.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.delete"), 2, this.deleteIcon));
        }
        ArrayList<TaskObject> group2 = new ArrayList<TaskObject>();
        taskList.add(group2);
        group2.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.activatelicense"), 8, this.addLicenseIcon));
        group2.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.editPartnerInformation"), 12, this.editAdminIcon));
        ArrayList<ElsLicenseObject> recoverableLicenses = null;
        try {
            recoverableLicenses = LicenseActivationHandler.getRecoverableLicenses();
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
        }
        if (recoverableLicenses != null && recoverableLicenses.size() > 0) {
            group2.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.licenseReactivation"), 10, this.addLicenseIcon));
        }
        group2.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.purchaseLicense"), 11, this.purchaseLicenseLicenseIcon));
        return taskList;
    }
}

