/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.LicenseStatusPanel;
import com.sygate.scm.console.ui.util.ImageButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class LicenseHelpPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    protected static final Image BUTTON_IMAGE_NORMAL = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellowButtonNormal.png"));
    protected static final Image BUTTON_IMAGE_PRESSED = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellowButtonPressed.png"));
    protected static final Image BUTTON_IMAGE_ROLLOVER = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("yellowButtonOver.png"));
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_TRIALWARE = 1;
    public static final int TYPE_UPGRADE = 2;
    protected int mType = 0;
    protected boolean mExpanded = false;
    protected LicenseStatusPanel mStatusPanel;
    protected JPanel mSmallPanel;
    protected JPanel mLargePanel;
    protected JPanel mLargeNormalPanel;
    protected JPanel mLargeTrialwarePanel;
    protected HtmlEnabledJLabel mExpand;
    protected HtmlEnabledJLabel mCollapseTrialware;
    protected HtmlEnabledJLabel mTrialwarePurchaseLink;

    public LicenseHelpPanel() {
        this.init();
    }

    public LicenseHelpPanel(LicenseStatusPanel statusPanel) {
        this.mStatusPanel = statusPanel;
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(UIColorUtilities.CONTROL_BACKGROUND));
        this.initSmallPanel();
        this.initLargePanel();
        this.updateType();
        this.updateExpanded();
    }

    protected void initSmallPanel() {
        this.mSmallPanel = new JPanel(new FlowLayout());
        this.mSmallPanel.setOpaque(false);
        this.mSmallPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel prompt = new JLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.smallText"));
        this.mSmallPanel.add(prompt);
        this.mExpand = this.createLinkLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.expand"));
        this.mSmallPanel.add((Component)this.mExpand);
        this.mExpand.addMouseListener((MouseListener)this);
        this.mSmallPanel.putClientProperty("cssClass", "licHelpPanelmSmallPanel");
    }

    protected void initLargePanel() {
        this.mLargePanel = new JPanel(new BorderLayout());
        this.mLargePanel.setOpaque(false);
        this.initTrialwarePanel();
        this.initNormalPanel();
        this.mLargePanel.putClientProperty("cssClass", "licHelpPanelmLargePanel");
    }

    protected void initTrialwarePanel() {
        this.mLargeTrialwarePanel = new JPanel(new BorderLayout());
        this.mLargeTrialwarePanel.setOpaque(false);
        this.mLargeTrialwarePanel.putClientProperty("cssClass", "licenseHelpmLargeTrialware");
        JPanel collapsePanel = new JPanel(new BorderLayout());
        this.mLargeTrialwarePanel.add((Component)collapsePanel, "North");
        collapsePanel.setOpaque(false);
        collapsePanel.putClientProperty("cssClass", "licenseHelpCollapsePanel");
        this.mCollapseTrialware = this.createLinkLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.collapse"));
        collapsePanel.add((Component)this.mCollapseTrialware, "East");
        this.mCollapseTrialware.addMouseListener((MouseListener)this);
        JPanel bodyPanel = new JPanel(new BorderLayout(5, 5));
        this.mLargeTrialwarePanel.add((Component)bodyPanel, "Center");
        bodyPanel.setOpaque(false);
        bodyPanel.setBorder(BorderFactory.createEmptyBorder(5, 25, 10, 25));
        bodyPanel.putClientProperty("cssClass", "licenseHelpBodyPanel");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.putClientProperty("cssClass", "licenseHelpPanelheaderPanel");
        bodyPanel.add((Component)headerPanel, "North");
        headerPanel.setOpaque(false);
        JLabel headerLabel = new JLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.header"));
        headerPanel.add((Component)headerLabel, "West");
        headerLabel.setFont(headerLabel.getFont().deriveFont(1));
        headerLabel.putClientProperty("cssClass", "licenseHelpHeaderLabel");
        JPanel stepsPanel = new JPanel();
        bodyPanel.add((Component)stepsPanel, "Center");
        stepsPanel.setOpaque(false);
        stepsPanel.setLayout(new BoxLayout(stepsPanel, 1));
        stepsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        stepsPanel.putClientProperty("cssClass", "licenseHelpStepsPanel");
        JPanel step1Panel = new JPanel(new BorderLayout(10, 10));
        stepsPanel.add(step1Panel);
        step1Panel.setOpaque(false);
        step1Panel.putClientProperty("cssClass", "licenseHelpStep1Panel");
        JPanel step1Center = new JPanel(new BorderLayout(2, 2));
        step1Panel.add((Component)step1Center, "Center");
        step1Center.setOpaque(false);
        step1Center.putClientProperty("cssClass", "licenseHelpStep1Center");
        JPanel step1CenterNorth = new JPanel(new BorderLayout());
        step1Center.add((Component)step1CenterNorth, "North");
        step1CenterNorth.setOpaque(false);
        step1CenterNorth.putClientProperty("cssClass", "licenseHelpStep1CenterNorth");
        JLabel registerSerialNoLabel1 = new JLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.step1"));
        step1CenterNorth.add((Component)registerSerialNoLabel1, "West");
        registerSerialNoLabel1.setFont(registerSerialNoLabel1.getFont().deriveFont(1));
        registerSerialNoLabel1.putClientProperty("cssClass", "licenseHelpPanelregisterSerialNoLabel1");
        JTextArea step1Text = this.createBodyArea(LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.step1Text"));
        step1Center.add((Component)step1Text, "Center");
        step1Text.putClientProperty("cssClass", "licenseHelpStep1Text");
        stepsPanel.add(Box.createVerticalStrut(15));
        JPanel step2Panel = new JPanel(new BorderLayout(10, 10));
        stepsPanel.add(step2Panel);
        step2Panel.setOpaque(false);
        step2Panel.putClientProperty("cssClass", "licenseHelpStep2Panel");
        JPanel step2Center = new JPanel(new BorderLayout(2, 2));
        step2Panel.add((Component)step2Center, "Center");
        step2Center.setOpaque(false);
        step2Center.putClientProperty("cssClass", "licenseHelpStep2Center");
        JPanel step2CenterNorth = new JPanel(new BorderLayout());
        step2Center.add((Component)step2CenterNorth, "North");
        step2CenterNorth.setOpaque(false);
        step2CenterNorth.putClientProperty("cssClass", "licenseHelpStep2CenterNorth");
        JLabel slfLabel1 = new JLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.step2"));
        step2CenterNorth.add((Component)slfLabel1, "West");
        slfLabel1.setFont(slfLabel1.getFont().deriveFont(1));
        slfLabel1.putClientProperty("cssClass", "licenseHelpSlfLabel1");
        JTextArea step2Text = this.createBodyArea(LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.step2Text"));
        step2Center.add((Component)step2Text, "Center");
        step2Text.putClientProperty("cssClass", "licenseHelpStep2Text");
        JPanel footerPanel = new JPanel(new BorderLayout(5, 5));
        bodyPanel.add((Component)footerPanel, "South");
        footerPanel.setOpaque(false);
        footerPanel.putClientProperty("cssClass", "licenseHelpFooterPanel");
        JPanel footerSouth = new JPanel(new BorderLayout(5, 5));
        footerPanel.add((Component)footerSouth, "South");
        footerSouth.setOpaque(false);
        footerSouth.putClientProperty("cssClass", "licenseHelpFooterSouth");
        footerSouth.add((Component)new JLabel(LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.footer1")), "West");
        JPanel footerSouthCenter = new JPanel(new BorderLayout(5, 5));
        footerSouth.add((Component)footerSouthCenter, "Center");
        footerSouthCenter.setOpaque(false);
        footerSouthCenter.putClientProperty("cssClass", "licenseHelpFooterSouthCenter");
        String link = LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.footer1LinkEE");
        if (LicenseObject.getInstance().isSBProduct()) {
            link = LicenseHelpPanel.getResourceString("LicenseHelpPanel.trial.footer1Link");
        }
        this.mTrialwarePurchaseLink = this.createLinkLabel(link);
        footerSouthCenter.add((Component)this.mTrialwarePurchaseLink, "West");
        this.mTrialwarePurchaseLink.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.mTrialwarePurchaseLink.addMouseListener((MouseListener)this);
    }

    protected void initNormalPanel() {
        this.mLargeNormalPanel = this.mLargeTrialwarePanel;
        if (this.mLargeNormalPanel == null) {
            this.mLargeNormalPanel = new JPanel();
        }
    }

    protected HtmlEnabledJLabel createLinkLabel(String text) {
        HtmlEnabledJLabel link = new HtmlEnabledJLabel(text, true);
        link.putClientProperty((Object)"cssClass", (Object)"licenseHelpPanelLink");
        link.putClientProperty((Object)"mouseEventListener", (Object)"onClick");
        return link;
    }

    protected JTextArea createBodyArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setEditable(false);
        textArea.setBorder(null);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setOpaque(false);
        return textArea;
    }

    protected ImageButton createActionButton(String text) {
        ImageButton button = new ImageButton(text);
        button.setNormalImage(BUTTON_IMAGE_NORMAL, new Insets(0, 0, 3, 0));
        button.setRolloverImage(BUTTON_IMAGE_ROLLOVER, new Insets(0, 0, 3, 0));
        button.setPressedImage(BUTTON_IMAGE_PRESSED, new Insets(1, 0, 2, 0));
        button.setMinimumSize(new Dimension(BUTTON_IMAGE_NORMAL.getWidth(null), BUTTON_IMAGE_NORMAL.getHeight(null)));
        return button;
    }

    protected void sharePreferredWidths(List<Component> components) {
        int maxWidth = 0;
        for (Component c : components) {
            maxWidth = Math.max(maxWidth, c.getPreferredSize().width);
        }
        for (Component c : components) {
            c.setPreferredSize(new Dimension(maxWidth, c.getPreferredSize().height));
        }
    }

    public void setType(int type) {
        if (type == this.mType) {
            return;
        }
        this.mType = type;
        this.updateType();
    }

    protected void updateType() {
        this.mLargePanel.removeAll();
        if (this.mType == 1) {
            this.mLargePanel.add((Component)this.mLargeTrialwarePanel, "Center");
        } else {
            this.mLargePanel.add((Component)this.mLargeNormalPanel, "Center");
        }
        this.mLargePanel.invalidate();
        this.mLargePanel.revalidate();
        this.mLargePanel.repaint();
    }

    public void setExpanded(boolean expanded) {
        if (this.mExpanded == expanded) {
            return;
        }
        this.mExpanded = expanded;
        this.updateExpanded();
    }

    protected void updateExpanded() {
        this.removeAll();
        if (this.mExpanded) {
            this.add((Component)this.mLargePanel, "Center");
        } else {
            this.add((Component)this.mSmallPanel, "Center");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    protected void doPurchaseAction() {
        HelpUtil.showPurchaseAction();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.mExpand)) {
            this.setExpanded(true);
            this.mExpand.unhighlightLink();
        } else if (e.getSource().equals(this.mCollapseTrialware)) {
            this.setExpanded(false);
            this.mCollapseTrialware.unhighlightLink();
        } else if (e.getSource().equals(this.mTrialwarePurchaseLink)) {
            this.doPurchaseAction();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected static String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", key);
    }
}

