/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.configobject.rpc.LicenseStatusInfo;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class LicenseDetailPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JTable table;
    protected DefaultTableModel tableModel;
    private static final ImageIcon licenseWarningIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("licenseExpiring16.png")));
    private ArrayList<Boolean> expiryStates = new ArrayList();
    private LicenseChainObject licenses = null;
    private String licenseRenewalURL_text = null;
    private static String ACTION_COLUMN_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "LicenseStatusPanel.licenseAction");

    public LicenseDetailPanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.table = new StripesTable(true, true){
            private static final long serialVersionUID = 1L;

            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.licenseRenewalURL_text = LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseRenew");
        this.setModel();
        this.table.setDefaultRenderer(Object.class, new LicenseTableCellRenderer(this.table));
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setShowGrid(false);
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(10);
        }
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    String value;
                    Point p = new Point(event.getX(), event.getY());
                    int col = LicenseDetailPanel.this.table.columnAtPoint(p);
                    int row = LicenseDetailPanel.this.table.rowAtPoint(p);
                    String colName = LicenseDetailPanel.this.table.getColumnName(col);
                    if (colName.equalsIgnoreCase(ACTION_COLUMN_NAME) && (value = (String)LicenseDetailPanel.this.table.getValueAt(row, col)) != null && value.trim().length() > 0) {
                        Rectangle rec = LicenseDetailPanel.this.table.getCellRect(row, col, false);
                        Component comp = LicenseDetailPanel.this.table.getComponentAt(p);
                        int x = rec.x + comp.getFontMetrics(comp.getFont()).stringWidth(value);
                        if (event.getPoint().x <= x) {
                            HelpUtil.showLicenseRenewal(LicenseDetailPanel.this.licenses);
                        }
                    }
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    ConsoleLogger.log(ex.getMessage());
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
        this.table.putClientProperty("cssClass", "licDetailPaneltable");
        this.add((Component)this.table.getTableHeader(), "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void setModel() {
        this.tableModel = new DefaultTableModel();
        this.table.setModel(this.tableModel);
        this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseSerialNum"));
        this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseType"));
        this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseCount"));
        this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseStart"));
        this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseExpire"));
        String licenseState = DataobjectManager.getInstance().getLoginInformation().getOptLicenseState();
        try {
            LicenseStatusInfo licenseStatusInfo = LicenseHandler.getLicenseStatusForSAV();
            if (licenseStatusInfo == null) {
                licenseStatusInfo = LicenseHandler.getLicenseStatusForSNAC();
            }
            if (licenseStatusInfo != null) {
                licenseState = licenseStatusInfo.getlicenseState();
            }
        }
        catch (ConsoleException e1) {
            LoggerUtilities.logException((Throwable)e1);
        }
        if (licenseState != null && licenseState.indexOf("PAID") > -1) {
            this.tableModel.addColumn(LicenseDetailPanel.getResourceString("LicenseStatusPanel.associatedLicenses"));
        }
        this.tableModel.addColumn(ACTION_COLUMN_NAME);
    }

    public void setLicense(ElsLicenseObject license) {
        this.tableModel.setRowCount(0);
        this.expiryStates.clear();
        String licenseType = LicenseDetailPanel.getResourceString("LicenseStatusPanel.chainInitialLicense");
        this.tableModel.addRow(this.getRow(license, licenseType));
        this.expiryStates.add(license.getWarnDate() <= new Date().getTime());
    }

    public void setLicense(LicenseChainObject licenses) {
        this.setModel();
        this.tableModel.setRowCount(0);
        this.expiryStates.clear();
        String licenseTypeTemplate = LicenseDetailPanel.getResourceString("LicenseStatusPanel.chainInitialLicense");
        String licenseType = null;
        int row = -1;
        Calendar cal = Utility.getCalendarInstance();
        cal.setTimeInMillis(licenses.getWarnDate());
        cal.add(6, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 1);
        this.licenses = System.currentTimeMillis() > cal.getTimeInMillis() ? licenses : null;
        for (ElsLicenseObject license : licenses.getLicenses()) {
            if (++row == 1) {
                licenseTypeTemplate = LicenseDetailPanel.getResourceString("LicenseStatusPanel.chainRenewalLicense");
            }
            licenseType = MessageFormat.format(licenseTypeTemplate, row);
            this.tableModel.addRow(this.getRow(license, licenseType));
            this.expiryStates.add(license.getWarnDate() <= new Date().getTime());
        }
    }

    public void setLicense(TrialwareLicenseObject license) {
        this.tableModel.setRowCount(0);
        this.expiryStates.clear();
        this.tableModel.addRow(this.getRow(license));
        this.expiryStates.add(license.getWarnDate() <= new Date().getTime());
    }

    public void setLicense(UpgradeLicenseObject license) {
        this.tableModel.setRowCount(0);
        this.expiryStates.clear();
        this.tableModel.addRow(this.getRow(license));
        this.expiryStates.add(license.getWarnDate() <= new Date().getTime());
    }

    public void setEmpty() {
        this.tableModel.setRowCount(0);
    }

    protected String[] getRow(ElsLicenseObject license, String type) {
        String actionText = null;
        if (this.licenses != null) {
            actionText = this.licenseRenewalURL_text;
        }
        return new String[]{license.getSerialNumber(), type, Integer.toString(license.getCount()), this.getDateStr(license.getStartDate()), this.getDateStr(license.getExpireDate()), license.getElsLicense().getOptAssociatedLicenses(), actionText};
    }

    protected String[] getRow(TrialwareLicenseObject license) {
        Object actionText = null;
        return new String[]{license.getSerialNumber(), LicenseDetailPanel.getResourceString("LicenseStatusPanel.trialwareLicense"), LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseType.na"), this.getDateStr(license.getStartDate()), this.getDateStr(license.getExpireDate()), actionText};
    }

    protected String[] getRow(UpgradeLicenseObject license) {
        Object actionText = null;
        return new String[]{license.getSerialNumber(), LicenseDetailPanel.getResourceString("LicenseStatusPanel.upgradeLicense"), LicenseDetailPanel.getResourceString("LicenseStatusPanel.licenseType.na"), this.getDateStr(license.getStartDate()), this.getDateStr(license.getExpireDate()), actionText};
    }

    private String getDateStr(long date) {
        return LicenseUtils.getDateStrInyyyy((long)date, (TimeZone)TimeZone.getDefault());
    }

    private static String getResourceString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", key);
    }

    public class LicenseTableCellRenderer
    extends DefaultTableCellRenderer
    implements MouseInputListener {
        private static final long serialVersionUID = 1L;
        private HtmlEnabledJLabel label = new HtmlEnabledJLabel();
        private int highlightC = -1;
        private int highlightR = -1;

        public LicenseTableCellRenderer(JTable table) {
            this.label.setOpaque(true);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.label.putClientProperty((Object)"cssClass", (Object)"licDetailPanelContainer2");
            table.addMouseMotionListener(this);
            table.addMouseListener(this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel original = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            original.putClientProperty("cssClass", "licenseDetailPanelOriginal");
            this.label.setText(original.getText());
            this.label.setForeground(original.getForeground());
            this.label.setLink(false);
            this.label.setFont(original.getFont());
            String colName = table.getColumnName(column);
            if (column == 4 && row == table.getRowCount() - 1 && LicenseDetailPanel.this.expiryStates.size() > row && LicenseDetailPanel.this.expiryStates.get(row).booleanValue()) {
                this.label.setIcon((Icon)licenseWarningIcon);
            } else if (colName.equalsIgnoreCase(ACTION_COLUMN_NAME)) {
                if (table instanceof StripesTable) {
                    this.label.setIcon(null);
                    this.label.setLink(true);
                    if (this.highlightC == column && this.highlightR == row) {
                        HTMLUtilities.highlightHyperLink((JComponent)this.label);
                    } else if (this.highlightC != column && this.highlightR != row) {
                        HTMLUtilities.enableHyperLink((JComponent)this.label);
                    }
                }
            } else {
                this.label.setIcon(null);
            }
            this.label.setBorder(original.getBorder());
            this.label.setBackground(original.getBackground());
            this.label.setToolTipText((String)table.getValueAt(row, column));
            return this.label;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.highlightR = -1;
            this.highlightC = -1;
            LicenseDetailPanel.this.table.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Point p = new Point(event.getX(), event.getY());
            int col = LicenseDetailPanel.this.table.columnAtPoint(p);
            int row = LicenseDetailPanel.this.table.rowAtPoint(p);
            String colName = LicenseDetailPanel.this.table.getColumnName(col);
            LicenseDetailPanel.this.table.setCursor(Cursor.getDefaultCursor());
            if (colName.equalsIgnoreCase(ACTION_COLUMN_NAME)) {
                String value = (String)LicenseDetailPanel.this.table.getValueAt(row, col);
                if (value != null && value.trim().length() > 0) {
                    Rectangle rec = LicenseDetailPanel.this.table.getCellRect(row, col, false);
                    Component comp = LicenseDetailPanel.this.table.getComponentAt(p);
                    int x = rec.x + comp.getFontMetrics(comp.getFont()).stringWidth(value);
                    if (event.getPoint().x <= x) {
                        LicenseDetailPanel.this.table.setCursor(Cursor.getPredefinedCursor(12));
                        this.highlightC = col;
                        this.highlightR = row;
                    }
                }
                LicenseDetailPanel.this.table.repaint();
            } else if (this.highlightR != -1 || this.highlightC != -1) {
                this.highlightC = -1;
                this.highlightR = -1;
                LicenseDetailPanel.this.table.repaint();
            }
        }
    }
}

