/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainArray;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.admin.AdminBasePanel;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class DomainStatusPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.admin.admin");
    private String panelName = MSGRES.getString("DomainStatusPanel.domainManagement");
    private AdminPanel adminPanel = null;
    private boolean domainEnabled = false;
    private static final int EDIT = 1;
    private static final int RENAME = 2;
    private static final int DELETE = 3;
    private static final int DISABLE = 4;
    private static final int ENABLE = 5;
    protected static final int ADD_DOMAIN = 6;
    private static final int SWITCH = 7;
    private static final int EXPORT = 8;
    private static final int IMPORT = 9;

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_domains";
    }

    @Override
    protected String getPanelName(Object item) {
        return this.panelName;
    }

    @Override
    protected String getLeftTableContent(Object item) {
        Object[] obj = new Object[]{this.getEnableDisableString((DomainObject)item)};
        String str = MSGRES.getString("DomainStatusPanel._domain");
        String fm = MessageFormat.format(str, obj);
        String[] strs = new String[]{MSGRES.getString("DomainStatusPanel.addAdmini"), MSGRES.getString("DomainStatusPanel.editDomainProperties"), MSGRES.getString("DomainStatusPanel.deleteDomain"), MSGRES.getString("DomainStatusPanel.renameDomain"), fm, MSGRES.getString("DomainStatusPanel.adminThisDomain")};
        return "<TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#ADDADM'>" + strs[0] + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#PROP'>" + strs[1] + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#DEL'>" + strs[2] + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#REN'>" + strs[3] + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#DOMAIN_ENABLE_STR'>" + strs[4] + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#SWITCH'>" + strs[5] + "</A></TD></TR>";
    }

    @Override
    protected String getRightTableContent(Object item) {
        DomainObject domain = (DomainObject)item;
        String[] strs = new String[]{MSGRES.getString("DomainStatusPanel.domainName"), MSGRES.getString("DomainStatusPanel.company"), MSGRES.getString("DomainStatusPanel.contactList"), MSGRES.getString("DomainStatusPanel.creationTime"), MSGRES.getString("DomainStatusPanel.enabledStatus"), MSGRES.getString("DomainStatusPanel.numberOfAdmin"), MSGRES.getString("DomainStatusPanel.DomainID")};
        return this.trWithBackground() + "  <TD>" + strs[0] + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)domain.getName()) + "</TD></TR><TR>  <TD>" + strs[1] + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)domain.getCompanyName()) + "</TD></TR>" + this.trWithBackground() + "  <TD>" + strs[2] + "</TD><TD>" + HTMLUtilities.filter((String)domain.getContactList()) + "</TD></TR><TR>  <TD>" + strs[3] + "</TD><TD>" + domain.getCreationTimeDisplayString() + "</TD></TR>" + this.trWithBackground() + "  <TD>" + strs[4] + "</TD><TD>" + domain.getEnableStatusDisplayString() + "</TD></TR><TR>  <TD>" + strs[5] + "</TD><TD>" + this.getAdministratorCount(domain) + "</TD></TR>" + this.trWithBackground() + "  <TD>" + strs[6] + "</TD><TD>" + domain.getId() + "</TD></TR>";
    }

    private String getEnableDisableString(DomainObject domain) {
        this.domainEnabled = domain.isEnabled();
        return this.domainEnabled ? MSGRES.getString("DomainStatusPanel.disable") : MSGRES.getString("DomainStatusPanel.enable");
    }

    private String getAdministratorCount(DomainObject domain) {
        try {
            return Integer.toString(AdminHandler.getAdministratorCount(domain.getId()));
        }
        catch (Exception e) {
            this.handleException(e, domain);
            return "";
        }
    }

    private void handleException(Exception ex, DomainObject domain) {
        if (ex instanceof ConsoleException) {
            int errorCode = ((ConsoleException)ex).getErrorCode();
            if (((ConsoleException)ex).needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("DomainStatusPanel.consoleError"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            if (errorCode == 0x16010000) {
                Object[] obj = new Object[]{domain.getName()};
                String str = MSGRES.getString("DomainStatusPanel.domainNotExist");
                String fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MSGRES.getString("DomainStatusPanel.consoleError"), 0);
                this.getAdminPanel().removeSelectedNode();
                return;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("DomainStatusPanel.consoleError"), 0);
        } else {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        this.adminPanel = this.getAdminPanel(e);
        if (this.adminPanel != null) {
            if ("ADD".equals(e.getURL().getRef())) {
                this.adminPanel.addDomain();
            } else if ("DEL".equals(e.getURL().getRef())) {
                this.adminPanel.delDomain();
            } else if ("REN".equals(e.getURL().getRef())) {
                this.adminPanel.renameDomain();
            } else if ("DOMAIN_ENABLE_STR".equals(e.getURL().getRef())) {
                this.adminPanel.setDomainEnabled(!this.domainEnabled);
            } else if ("SWITCH".equals(e.getURL().getRef())) {
                this.adminPanel.switchToDomain();
            } else if ("ADDADM".equals(e.getURL().getRef())) {
                this.adminPanel.addAdmin();
            } else if ("PROP".equals(e.getURL().getRef())) {
                this.adminPanel.editDomain();
            }
        }
    }

    @Override
    public List<List<TaskObject>> getTaskList(TreeItem item) {
        DomainObject domain = (DomainObject)item;
        String currentDomainId = Manager.getCurrentDomainId();
        boolean isMultiDomain = AdminHandler.getDomainCount() > 1;
        Icon action = SideBar.getActionIcon();
        ArrayList<TaskObject> firstList = new ArrayList<TaskObject>();
        firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.renameDomain"), 2, this.renameIcon));
        firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.editDomainProperties"), 1, this.editDomainIcon));
        if (isMultiDomain) {
            DomainObject cloudEnrolledDomain = CloudUtil.getEnrolledDomain();
            if (cloudEnrolledDomain != null && domain.getId().equals(cloudEnrolledDomain.getId())) {
                firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.deleteDomain"), 3, this.deleteDomainIcon, null, null, false, MSGRES.getString("DomainStatusPanel.enrolledDomainCannotBeDeleted")));
            } else {
                firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.deleteDomain"), 3, this.deleteDomainIcon));
            }
        }
        if (domain.isEnabled()) {
            if (isMultiDomain) {
                DataobjectManager data = DataobjectManager.getInstance();
                int enabledCount = 0;
                try {
                    SemConfigRoot semConfigRoot = data.getSemConfigRoot();
                    SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
                    for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                        DomainObject domainObject;
                        SemDomain semDomain;
                        ObjReference reference = domainArray.getObjReference(i);
                        if (reference == null || (semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId())) == null || !(domainObject = new DomainObject(semDomain)).isEnabled()) continue;
                        ++enabledCount;
                    }
                }
                catch (ConsoleException e1) {
                    LoggerUtilities.logException((Throwable)e1);
                }
                if (enabledCount > 1) {
                    firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.disable_domain"), 4, this.disableDomainIcon));
                }
            }
        } else {
            firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.enable_domain"), 5, action));
        }
        if (!domain.getId().equals(currentDomainId)) {
            firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.adminThisDomain"), 7, this.switchDomainIcon));
        }
        firstList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.exportDomain"), 8, this.exportAction));
        ArrayList<TaskObject> secondList = new ArrayList<TaskObject>();
        secondList.add(new TaskObject(MSGRES.getString("AdmStatusPanel.add_new_domain"), 6, this.addDomainIcon));
        secondList.add(new TaskObject(MSGRES.getString("DomainStatusPanel.importDomain"), 9, this.importAction));
        ArrayList<List<TaskObject>> taskList = new ArrayList<List<TaskObject>>();
        taskList.add(firstList);
        taskList.add(secondList);
        return taskList;
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        this.adminPanel = this.getAdminPanel();
        switch (taskIndex) {
            case 2: {
                this.adminPanel.renameDomain();
                break;
            }
            case 7: {
                this.adminPanel.switchToDomain();
                break;
            }
            case 3: {
                this.adminPanel.delDomain();
                break;
            }
            case 1: {
                this.adminPanel.editDomain();
                break;
            }
            case 5: {
                this.adminPanel.setDomainEnabled(true);
                break;
            }
            case 4: {
                this.adminPanel.setDomainEnabled(false);
                break;
            }
            case 6: {
                this.adminPanel.addDomain();
                break;
            }
            case 8: {
                this.adminPanel.exportDomain();
                break;
            }
            case 9: {
                this.adminPanel.importDomain();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }
}

