/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.configobject.schema.SemAdminPrivilege;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.admin.TaskList;
import com.sygate.scm.console.ui.admin.dlg.ClientInstallationSAVFeaturesDlg;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallFeaturePoolObject;
import com.sygate.scm.console.ui.admin.logicobject.ClientInstallationFeatureObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClientInstallationFeaturesPanel
extends JPanel
implements TabbedPageModel,
TaskPanel,
TaskList,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = -401854696135071134L;
    private static String[] TABLE_COLUMN = new String[]{ClientInstallationFeaturesPanel.getString("ClientInstallationSettingsPanel.Name"), ClientInstallationFeaturesPanel.getString("ClientInstallationSettingsPanel.Description")};
    private static float[] COLUMN_SIZE = new float[]{0.3f, 0.7f};
    private static final int ADD = 1;
    private static final int DELETE = 2;
    private static final int EDIT = 3;
    private MyRightPanel rightPanel;
    private JScrollPane sPane;
    private JTable settingTable;
    private SortableTableModel settingTableModel;
    private String titleString;
    private TaskObject addTask;
    private TaskObject deleteTask;
    private TaskObject editTask;
    private String currentVersion = "14.3.5000.0";
    private ClientInstallFeaturePoolObject settingPoolObj;
    private JPopupMenu popupMenu;
    private JMenuItem addMenu;
    private JMenuItem deleteMenu;
    private JMenuItem editMenu;
    protected boolean readOnly = AdminPrivilegeObject.getCurrentAdminPackagePrivilege().intValue() == SemAdminPrivilege.READ_ONLY.intValue();

    public ClientInstallationFeaturesPanel(ListSelectionListener tableListener) {
        this.initialize();
        this.getTable().getSelectionModel().addListSelectionListener(tableListener);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_install_packages_client_installation_features";
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add(this.getRightPanel());
    }

    private MyRightPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new MyRightPanel();
        }
        return this.rightPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.sPane == null) {
            this.sPane = new JScrollPane();
            this.sPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    ClientInstallationFeaturesPanel.this.showPopup(event);
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    ClientInstallationFeaturesPanel.this.showPopup(event);
                }
            });
            this.sPane.getViewport().add(this.getTable());
        }
        this.sPane.putClientProperty("cssClass", "clientInstallFeaturessPane");
        return this.sPane;
    }

    private JTable getTable() {
        if (this.settingTable == null) {
            SortableTableModel model = this.getTableModel();
            this.settingTable = new StripesTable(model, true, true);
            this.settingTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    ClientInstallationFeaturesPanel.this.showPopup(event);
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    ClientInstallationFeaturesPanel.this.showPopup(event);
                }

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() >= 2) {
                        ClientInstallationFeaturesPanel.this.editInstallationSetting();
                    }
                }
            });
            this.settingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e1) {
                    ClientInstallationFeaturesPanel.this.tableSelectionChanged();
                }
            });
            model.addMouseListenerToHeaderInTable(this.settingTable);
            this.settingTable.setSelectionMode(0);
            UIUtilities.setTableColumnWidth(this.settingTable, COLUMN_SIZE, this.settingTable.getPreferredScrollableViewportSize().width);
        }
        this.settingTable.putClientProperty("cssClass", "clientInstallFeaturesSettingTable");
        return this.settingTable;
    }

    protected void tableSelectionChanged() {
        boolean selected;
        int index = this.getTable().getSelectedRow();
        boolean bl = selected = index != -1;
        if (this.editMenu != null) {
            this.editMenu.setEnabled(selected);
        }
        if (this.deleteMenu != null) {
            if (this.readOnly) {
                this.deleteMenu.setEnabled(false);
            } else {
                this.deleteMenu.setEnabled(selected);
            }
        }
    }

    protected void showPopup(MouseEvent event) {
        Point p1 = event.getPoint();
        int row = this.getTable().rowAtPoint(p1);
        if (row != -1) {
            this.getTable().setRowSelectionInterval(row, row);
        } else {
            this.getTable().clearSelection();
        }
        if (event.isPopupTrigger()) {
            this.getPopupMenu().show(event.getComponent(), event.getX(), event.getY());
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.editMenu = !this.readOnly ? new JMenuItem(ClientInstallationFeaturesPanel.getString("Edit")) : new JMenuItem(ClientInstallationFeaturesPanel.getString("View"));
            this.editMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e1) {
                    ClientInstallationFeaturesPanel.this.editInstallationSetting();
                }
            });
            this.deleteMenu = new JMenuItem(ClientInstallationFeaturesPanel.getString("Delete"));
            this.deleteMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e1) {
                    ClientInstallationFeaturesPanel.this.deleteInstallationSetting();
                }
            });
            this.addMenu = new JMenuItem(ClientInstallationFeaturesPanel.getString("Add"));
            this.addMenu.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e1) {
                    ClientInstallationFeaturesPanel.this.addInstallationSetting();
                }
            });
            this.popupMenu.add(this.addMenu);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.editMenu);
            this.popupMenu.add(this.deleteMenu);
            this.tableSelectionChanged();
            if (this.readOnly) {
                this.addMenu.setEnabled(false);
                this.deleteMenu.setEnabled(false);
            }
        }
        return this.popupMenu;
    }

    private SortableTableModel getTableModel() {
        if (this.settingTableModel == null) {
            this.settingTableModel = new SortableTableModel();
            this.settingTableModel.setColumnNames(TABLE_COLUMN);
        }
        return this.settingTableModel;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", key);
    }

    @Override
    public List<List<TaskObject>> getTaskList(TreeItem item) {
        ArrayList<List<TaskObject>> taskList = new ArrayList<List<TaskObject>>();
        int index = this.getTable().getSelectedRow();
        if (index != -1) {
            ArrayList<TaskObject> first = new ArrayList<TaskObject>();
            first.add(this.getEditAction());
            if (!this.readOnly) {
                first.add(this.getDeleteAction());
            }
            taskList.add(first);
        }
        if (!this.readOnly) {
            ArrayList<TaskObject> second = new ArrayList<TaskObject>();
            second.add(this.getAddAction());
            taskList.add(second);
        }
        return taskList;
    }

    private TaskObject getAddAction() {
        if (this.addTask == null) {
            ImageIcon addAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
            this.addTask = new TaskObject(ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Add"), 1, addAction);
        }
        return this.addTask;
    }

    private TaskObject getDeleteAction() {
        if (this.deleteTask == null) {
            ImageIcon deleteAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
            this.deleteTask = new TaskObject(ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Delete"), 2, deleteAction);
        }
        return this.deleteTask;
    }

    private TaskObject getEditAction() {
        if (this.editTask == null) {
            ImageIcon editAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
            this.editTask = !this.readOnly ? new TaskObject(ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Edit"), 3, editAction) : new TaskObject(ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.View"), 3, editAction);
        }
        return this.editTask;
    }

    private String getTitleString() {
        if (this.titleString == null) {
            this.titleString = ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Title");
        }
        return this.titleString;
    }

    @Override
    public void setSelectedItem(Object item) {
        block2: {
            this.getRightPanel().setTitle(this.getTitleString());
            try {
                this.refreshTable();
            }
            catch (ConsoleException e1) {
                LoggerUtilities.logException((Throwable)e1);
                if (!e1.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void refreshTable() throws ConsoleException {
        this.settingPoolObj = new ClientInstallFeaturePoolObject();
        Vector<TableRow> tableData = new Vector<TableRow>(this.settingPoolObj.getAllObjects());
        this.getTableModel().setDataVector(tableData);
        this.getTableModel().fireTableDataChanged();
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        switch (taskIndex) {
            case 1: {
                this.addInstallationSetting();
                break;
            }
            case 2: {
                this.deleteInstallationSetting();
                break;
            }
            case 3: {
                this.editInstallationSetting();
                break;
            }
        }
    }

    private void editInstallationSetting() {
        block5: {
            int index = this.getTable().getSelectedRow();
            if (index == -1) {
                return;
            }
            ClientInstallationFeatureObject settingObj = (ClientInstallationFeatureObject)this.getTableModel().getRow(index);
            ClientInstallationFeatureObject newSettingObj = null;
            String oldDesc = null;
            try {
                newSettingObj = settingObj.getCopy();
                String title = "";
                title = !this.readOnly ? ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.edit_install") : ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.view_install");
                oldDesc = newSettingObj.getDescription();
                ClientInstallationSAVFeaturesDlg dlg = new ClientInstallationSAVFeaturesDlg(Manager.getFrame(), title, true, newSettingObj.isSystemObject() ? true : this.readOnly, newSettingObj.getName());
                dlg.setObject(newSettingObj);
                dlg.setVisible(true);
                if (dlg.isOk()) {
                    this.settingPoolObj.updateClientInstallationSetting(newSettingObj);
                    this.refreshTable();
                    this.reselectTable(newSettingObj);
                }
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), ClientInstallationFeaturesPanel.getString("AdminPanel.error"), 0);
                LoggerUtilities.logException((Throwable)e);
                if (newSettingObj != null) {
                    newSettingObj.setDescription(oldDesc);
                }
                if (!e.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void reselectTable(ClientInstallationFeatureObject newSettingObj) {
        List<TableRow> allData = this.getTableModel().getAllRows();
        int idx = -1;
        Iterator<TableRow> it = allData.iterator();
        while (it.hasNext()) {
            ++idx;
            ClientInstallationFeatureObject obj = (ClientInstallationFeatureObject)it.next();
            if (!obj.getId().equals(newSettingObj.getId())) continue;
            break;
        }
        if (idx != -1) {
            this.getTable().setRowSelectionInterval(idx, idx);
        }
    }

    private void deleteInstallationSetting() {
        block6: {
            int index = this.getTable().getSelectedRow();
            if (index == -1) {
                return;
            }
            ClientInstallationFeatureObject settingObj = (ClientInstallationFeatureObject)this.getTableModel().getRow(index);
            if (settingObj.isSystemObject()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.system_object"), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Error"), 0);
                return;
            }
            if (settingObj.getClientInstallationFeatures().getOptRefCount() != null && settingObj.getClientInstallationFeatures().getOptRefCount() > 0) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.in_use_feature"), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.Error"), 0);
                return;
            }
            int ret = JOptionPane.showConfirmDialog(Manager.getFrame(), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.are_you_sure_delete_install_setting"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "ClientInstallationFeaturesPanel.confirmDeletion"), 0);
            if (ret != 0) {
                return;
            }
            try {
                this.settingPoolObj.deleteClientInstallationFeatures(settingObj);
                this.refreshTable();
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                if (!e.needRelogin()) break block6;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void addInstallationSetting() {
        block3: {
            ClientInstallationFeatureObject settingObj = new ClientInstallationFeatureObject();
            settingObj.setFeature("OutlookSnapin", false);
            settingObj.setFeature("NotesSnapin", false);
            ClientInstallationSAVFeaturesDlg dlg = new ClientInstallationSAVFeaturesDlg(Manager.getFrame(), ClientInstallationFeaturesPanel.getString("ClientInstallationFeaturesPanel.add_setting"), true, this.readOnly, "");
            dlg.setObject(settingObj);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                try {
                    this.settingPoolObj.addClientInstallationSettingObject(settingObj);
                    this.refreshTable();
                    this.reselectTable(settingObj);
                }
                catch (ConsoleException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), ClientInstallationFeaturesPanel.getString("AdminPanel.error"), 0);
                    LoggerUtilities.logException((Throwable)e);
                    if (!e.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public void refresh() {
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    class MyRightPanel
    extends TaskPanelBase {
        private static final long serialVersionUID = 1L;

        MyRightPanel() {
        }

        @Override
        protected Component getContentPanel() {
            return ClientInstallationFeaturesPanel.this.getScrollPane();
        }

        @Override
        protected String getTitleName() {
            return "Client Installation Features";
        }
    }
}

