/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.SchemaContainer;
import com.sygate.scm.common.configobject.schema.LicenseChain;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.GenericTreeObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.admin.AdmStatusPanel;
import com.sygate.scm.console.ui.admin.ClientInstallationFeaturesPanel;
import com.sygate.scm.console.ui.admin.ClientInstallationSettingsPanel;
import com.sygate.scm.console.ui.admin.DomainEmptyPanel;
import com.sygate.scm.console.ui.admin.DomainStatusPanel;
import com.sygate.scm.console.ui.admin.ExportFileFilter;
import com.sygate.scm.console.ui.admin.LicenseStatusPanel;
import com.sygate.scm.console.ui.admin.TaskList;
import com.sygate.scm.console.ui.admin.dlg.AddDomainDlg;
import com.sygate.scm.console.ui.admin.dlg.AdmPropertiesDlg;
import com.sygate.scm.console.ui.admin.dlg.ConfigurePasswordRequirementsDlg;
import com.sygate.scm.console.ui.admin.dlg.DomainPropsDlg;
import com.sygate.scm.console.ui.admin.dlg.EditPartnerDialog;
import com.sygate.scm.console.ui.admin.dlg.RenameAdminDlg;
import com.sygate.scm.console.ui.admin.dlg.RenameDomainDlg;
import com.sygate.scm.console.ui.admin.dlg.SetAdminPwdDlg;
import com.sygate.scm.console.ui.admin.iplLicense.IPLLicenseHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.admin.iplLicense.RecoverDeletedLicenseDialog;
import com.sygate.scm.console.ui.client.CurrentPackagePanel;
import com.sygate.scm.console.ui.client.RecycleBinPanel;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.ActionConfirmationDlg;
import com.sygate.scm.console.ui.util.OutlookButton;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.PasswordClearUtil;
import com.sygate.scm.console.ui.util.SideBarPanel;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.CloudUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.PasswordSettingsUtil;
import com.sygate.scm.console.util.PasswordUtil;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AdminPanel
extends PagePanel {
    private static final long serialVersionUID = -7813547362173904680L;
    public static final String ADMIN_TITLE_FOREGROUND = "ff6600";
    public static final String ADMINISTRATORS = "Administrators";
    public static final String SERVERS = "Servers";
    public static final String DOMAINS = "Domains";
    protected static final String EXCEPTION_PREFIX = "' Exception message: ";
    public static final String INSTALL_PACKAGES = "Install Packages";
    public static final String LICENSES = "Licenses";
    public static final int SELECT_ADMINS = 0;
    public static final int SELECT_SERVERS = 1;
    public static final int SELECT_DOMAINS = 2;
    public static final int SELECT_INSTALL = 3;
    public static final int SELECT_LICENSES = 4;
    AdmStatusPanel adminPanel = null;
    private JButton refreshBtn = new JButton();
    private JTree tree = new JTree();
    private JPanel blankPanel = new JPanel();
    private HashMap<Integer, TabbedPageModel> panelMap = new HashMap();
    String[] option = new String[]{UIText.get(519)};
    ServersPanel serverPanel = new ServersPanel();
    PagePanel currentOutlookPanel = this;
    MessageResources msgRes = MessageResources.getInstance();
    SideBarPanel sideBarPanel;
    private String lastOutlookButton;
    private String selectedAdminId;
    private String selectedDomainId;
    private int selectedPackageItemType;
    private String selectedLicenseId;
    private DomainEmptyPanel emptyDomainPanel;
    JFileChooser chooser = null;
    boolean completed = false;

    public AdminPanel() {
        AdminPanel.msg("constructor");
        this.setOutlookButton();
    }

    @Override
    public void initPanel() {
        AdminPanel.msg("initPanel");
        this.initialize();
        this.setName(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.admins"));
        Image refreshImage = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("refresh.gif"));
        this.refreshBtn.setIcon(new ImageIcon(refreshImage));
        this.refreshBtn.setHorizontalAlignment(0);
        this.refreshBtn.setVerticalAlignment(0);
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminPanel.this.refreshBtnActionPerformed(event);
            }
        });
        JButton[] buttons = new JButton[]{this.refreshBtn};
        this.setImageButton(buttons);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                this.maybeShowPopup(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                this.maybeShowPopup(event);
            }

            private void maybeShowPopup(MouseEvent event) {
                int selRow = AdminPanel.this.tree.getRowForLocation(event.getX(), event.getY());
                if (selRow == -1) {
                    return;
                }
                AdminPanel.this.tree.setSelectionRow(selRow);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AdminPanel.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (event.isPopupTrigger()) {
                    JPopupMenu popup;
                    block7: {
                        TreeItem treeItem = (TreeItem)node.getUserObject();
                        if (treeItem == null) {
                            return;
                        }
                        popup = null;
                        try {
                            popup = AdminPanel.this.setupPopupMenu(treeItem);
                        }
                        catch (ConsoleException ex) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                            if (!ex.needRelogin()) break block7;
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                    if (popup != null) {
                        popup.show(event.getComponent(), event.getX(), event.getY());
                    }
                }
            }
        });
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                AdminPanel.this.treeValueChanged(event);
            }
        });
        this.sideBarPanel = new SideBarPanel(this);
        this.setSideBarViews(this.sideBarPanel);
        this.serverPanel.resetSlideComponent(this.sideBar, this.rightComponent);
        this.isInitialized = true;
    }

    @Override
    public void selectItemIndex(int index) {
        AdminPanel.msg("selectItemIndex");
        ((OutlookButton)this.outlookButtonList.get(index)).doClick();
        this.refreshTaskBarViews();
    }

    @Override
    public synchronized void refreshTaskBarViews() {
        AdminPanel.msg("refreshTaskBarViews");
        TimeCounter counter = new TimeCounter();
        counter.start();
        System.out.println("admin: Begin setupScrollPane...");
        this.resetSideBar(this.getCurrentOutlookButtonKey());
        counter.stop();
        System.out.println("admin: Done setupScrollPane, elapsed time=" + counter.getDuration() + " (" + counter.getDuration() / 1000L + "s)");
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        Component component;
        AdminPanel.msg("valueChanged");
        if (!event.getValueIsAdjusting() && (component = this.getCurrentTaskPanel()) != null) {
            if (component instanceof CurrentPackagePanel) {
                CurrentPackagePanel subPanel = (CurrentPackagePanel)component;
                this.setSideBarTasks(subPanel.getTaskList(null));
            } else if (component instanceof RecycleBinPanel) {
                RecycleBinPanel subPanel = (RecycleBinPanel)component;
                this.setSideBarTasks(subPanel.getTaskList(null));
            } else if (component instanceof TaskList) {
                this.setSideBarTasks(((TaskList)((Object)component)).getTaskList(this.sideBarPanel.getCurrentSelection()));
            }
        }
    }

    @Override
    public void refresh() {
        AdminPanel.msg("refresh");
        this.refreshTaskBarViews();
    }

    public void refreshAndExpand() {
        this.refresh();
    }

    public void addAdmin() {
        boolean ret;
        AdminPanel.msg("addAdmin");
        AdminObject admin = AdminObject.createAdminObject();
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.title");
        AdmPropertiesDlg dlg = new AdmPropertiesDlg(admin, Manager.getFrame(), title, true, Manager.isCurrentAdmin(admin.getId()), true);
        dlg.setData();
        dlg.setVisible(true);
        if (dlg.isOk() && (ret = dlg.modifyAdmin()) && admin != null) {
            block3: {
                try {
                    AdminHandler.addAdministrator(admin, dlg.getAdminPrivilegeObject());
                }
                catch (ConsoleException ex) {
                    Object[] obj = new Object[]{ex.getMessageString()};
                    String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.dataCannotBeUpdated");
                    String fm = MessageFormat.format(str, obj);
                    JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "AddAdminDlg.consoleError"), 0);
                    if (!ex.needRelogin()) break block3;
                    Manager.getFrame().showLoginPanel();
                }
            }
            this.refreshAdmin();
            int index = AdminHandler.getIndexOfAdmin(admin.getId(), this.sideBarPanel.getCurrentContentList());
            this.sideBarPanel.selectIndex(index);
        }
        dlg.dispose();
    }

    public void editAdmin() {
        AdminPanel.msg("editAdmin");
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        AdminObject copyOfAdmin = null;
        try {
            boolean newAdminEnabled;
            int retCode;
            boolean needLogoff;
            copyOfAdmin = AdminHandler.getCopyOfAdminObject(admin);
            boolean modified = false;
            boolean isSysAdmin = Manager.isSystemAdmin(copyOfAdmin.getSemAdmin());
            boolean oldAdminEnabled = copyOfAdmin.isEnabled();
            boolean isDomainAdminBefore = copyOfAdmin.isDomainSysAdmin();
            modified = this.editAdminDomain(copyOfAdmin);
            if (!modified) {
                System.out.println("AdminPanel>> editAdmin: no change!");
                return;
            }
            boolean isDomainAdminAfter = copyOfAdmin.isDomainSysAdmin();
            boolean bl = needLogoff = Manager.isCurrentAdmin(copyOfAdmin.getId()) && isDomainAdminBefore != isDomainAdminAfter;
            if (needLogoff && (retCode = UIUtilities.confirmYesNoOptionDialog(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.editingSelf"), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.warning"))) != 0) {
                return;
            }
            admin.setNameDirty(copyOfAdmin.getName());
            AdminHandler.updateAdminObject(admin, copyOfAdmin);
            AdminHandler.updateAdmin(admin, true);
            AdminHandler.logEventForAdminChangingProperties(admin);
            if (!isSysAdmin && oldAdminEnabled != (newAdminEnabled = admin.isEnabled())) {
                Object[] objs = new Object[]{admin.getName(), newAdminEnabled ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.enabled") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disabled")};
                String msg = "";
                msg = admin.isDomainSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.thePropertiesOfDomainAdmin_was_") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.thePropertiesOfLimitedAdmin_was_");
                String description = MessageFormat.format(msg, objs);
                ConsoleLogger.logAdminEvent(newAdminEnabled ? 4103 : 4102, description);
            }
            this.tree.updateUI();
            this.refreshAdminWithSelection(admin);
            try {
                AdmStatusPanel panelAdminStatus = (AdmStatusPanel)this.getCurrentTaskPanel();
                panelAdminStatus.setSelectedItem(admin);
            }
            catch (Exception ex) {
                System.out.println("AdminPanel>> editAdmin: Failed to retrieve AdmStatusPanel! class=" + this.getCurrentTaskPanel().getClass().getName());
                ConsoleLogger.log(ex);
            }
            System.out.println("AdminPanel>> editAdmin: OK!");
            if (needLogoff) {
                Manager.getFrame().showLoginPanel();
            }
        }
        catch (ConsoleException event) {
            JOptionPane.showMessageDialog(Manager.getFrame(), event.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (event.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception e) {
            System.out.println("AdminPanel>> editAdmin: Exception...");
            ConsoleLogger.log(e);
        }
    }

    public void delAdmin() {
        AdminPanel.msg("delAdmin");
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        if (Manager.isCurrentAdmin(admin.getId())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.youCannotDeleteyou"), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.warning"), 2);
            return;
        }
        if (Manager.isBuildInAdmin(admin.getId())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.youCannotDeleteBuildinAccount"), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.warning"), 2);
            return;
        }
        boolean isSystemAdmin = Manager.isSystemAdmin(admin.getSemAdmin());
        Object[] obj1 = new Object[]{""};
        obj1[0] = admin.isSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.System") : (admin.isDomainSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Domain") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Limit"));
        String msg1 = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.areYouSureToDelete_Admin");
        String description1 = MessageFormat.format(msg1, obj1);
        Object[] obj2 = new Object[]{admin.getAdminName()};
        String msg2 = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.deleteAdmin_");
        String description2 = MessageFormat.format(msg2, obj2);
        if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), description1, description2, 0)) {
            return;
        }
        try {
            if (GUIManager.adminHasReportNotification(admin.getId())) {
                boolean changOwner = false;
                String msgKeepReport = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.areYouSureToKeepReports_Admin");
                Object[] objKeepReport = new Object[]{admin.getAdminName()};
                String descriptionKeepReport = MessageFormat.format(msgKeepReport, objKeepReport);
                int option = JOptionPane.showConfirmDialog(Manager.getFrame(), descriptionKeepReport, description2, 0);
                if (option == -1) {
                    return;
                }
                if (option == 0) {
                    changOwner = true;
                }
                GUIManager.updateReportNotificationOwner(admin.getId(), admin.getName(), changOwner);
            }
            if (isSystemAdmin) {
                AdminHandler.delSysAdmin(admin.getId());
            } else if (AdminHandler.isDemoteOrPromoteAllowed(AdminObject.retrieveCurrentAdminObject(), admin, true)) {
                AdminHandler.delAdmin(admin);
            } else {
                UIUtilities.showErrorDialog(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.youCannotDeleteMorePrivilegeAdmin"));
            }
            this.refreshAndExpand();
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Throwable ex) {
            Object[] obj = new Object[]{admin.getName()};
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.internalErrorFailedToDelete_");
            String description = MessageFormat.format(msg, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error"), 0);
            ConsoleLogger.log(ex);
            this.refreshAdmin();
        }
    }

    public void renameAdmin() {
        String newAdminName;
        AdminPanel.msg("renameAdmin");
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        RenameAdminDlg dlg = new RenameAdminDlg(admin);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        String oldAdminName = admin.getAdminName();
        if (oldAdminName.equals(newAdminName = dlg.getAdminName())) {
            System.out.println("AdminPanel>> renameAdmin: same admin name so no need to change!");
            return;
        }
        try {
            boolean isSysAdmin = Manager.isSystemAdmin(admin.getSemAdmin());
            String domainGUID = Manager.getCurrentDomainId();
            admin.setAdminName(newAdminName);
            if (isSysAdmin) {
                admin = new AdminObject(AdminHandler.updateAdmin(admin, true));
                this.sideBarPanel.setCurrentObject(admin);
            } else {
                AdminHandler.updateAdmin(admin);
            }
            this.refreshAdminWithSelection(admin);
            Object[] obj = new Object[]{"", oldAdminName, admin.getName()};
            obj[0] = admin.isSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.System") : (admin.isDomainSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Domain") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Limit"));
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel._admin_wasRenamedTo_");
            String description = MessageFormat.format(msg, obj);
            ConsoleLogger.logAdminEvent(4106, description);
            this.tree.updateUI();
            String currentAdminId = Manager.getCurrentAdminId();
            if (currentAdminId != null && currentAdminId.equals(admin.getId())) {
                Manager.getFrame().updateTitle();
            }
            try {
                AdmStatusPanel panelAdminStatus = (AdmStatusPanel)this.getCurrentTaskPanel();
                panelAdminStatus.setSelectedItem(admin);
            }
            catch (Exception ex) {
                System.out.println("AdminPanel>> renameAdmin: Failed to retrieve AdmStatusPanel! class=" + this.getCurrentTaskPanel().getClass().getName());
                ConsoleLogger.log(ex);
            }
            System.out.println("AdminPanel>> renameAdmin: OK!");
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception e) {
            System.out.println("AdminPanel>> renameAdmin: Exception...");
            ConsoleLogger.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminPwd() {
        AdminPanel.msg("setAdminPwd");
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        Object[] obj = new Object[]{admin.getAdminName()};
        String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.setPasswrod_");
        String description = MessageFormat.format(msg, obj);
        SetAdminPwdDlg dlg = new SetAdminPwdDlg((JFrame)Manager.getFrame(), description, admin, true);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        char[] pwd = dlg.getPassword();
        if (pwd == null) {
            return;
        }
        String passwordString = new String(pwd);
        if (admin.isEqualPassword(passwordString)) {
            System.out.println("AdminPanel>> setAdminPwd: same password so no need to change!");
            return;
        }
        String newPwdHashed = PasswordUtil.createPKDBF2PasswordHash(passwordString);
        try {
            PasswordSettingsUtil.addPasswordToHistory(admin, pwd);
            AbstractAdminHandler handler = AbstractAdminHandler.getInstance(admin);
            SemAdministrator updatedAdmin = handler.updatePassword(admin, newPwdHashed, AbstractAdminHandler.ActionType.UPDATE, true);
            if (admin.isSysAdmin()) {
                this.sideBarPanel.setCurrentObject(new AdminObject(updatedAdmin));
            }
            DataobjectManager.getInstance().setCurrentAdminPassword(Utility.encryptLatest((String)passwordString));
            System.out.println("AdminPanel>> setAdminPwd: OK!");
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception e) {
            System.out.println("AdminPanel>> setAdminPwd: Exception...");
            ConsoleLogger.log(e);
        }
        finally {
            PasswordClearUtil.clearPasswordInMemory(pwd, dlg.getCenterPanel().getTFPwd());
            PasswordClearUtil.clearPasswordInMemory(dlg.getCenterPanel().getTFPwdCfm().getPassword(), dlg.getCenterPanel().getTFPwdCfm());
            PasswordClearUtil.clearPasswordInMemory(dlg.getCenterPanel().getTFCurrentPwd().getPassword(), dlg.getCenterPanel().getTFCurrentPwd());
        }
    }

    public void configurePasswordRequirements() {
        String title = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.configurePasswordRequirements");
        ConfigurePasswordRequirementsDlg dialog = new ConfigurePasswordRequirementsDlg.DialogBuilder(Manager.getFrame(), title, true).build();
        dialog.setVisible(true);
    }

    public void resetAdminLock() {
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        try {
            AdminHandler.setAdminLocked(admin, false);
            Object[] obj = new Object[]{admin.getName()};
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.admin_IsUnlocked");
            String description = MessageFormat.format(msg, obj);
            JOptionPane.showOptionDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 0, 1, null, this.option, this.option[0]);
            try {
                AdmStatusPanel panelAdminStatus = (AdmStatusPanel)this.getCurrentTaskPanel();
                panelAdminStatus.setSelectedItem(admin);
                this.setSideBarTasks(panelAdminStatus.getTaskList(admin));
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
            System.out.println("AdminPanel>> resetAdminLock: OK!");
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            this.refreshAndExpand();
        }
    }

    public void resetReminder() {
        AdminPanel.msg("resetReminder");
        AdminObject admin = this.getCurrentAdminObject();
        if (admin == null) {
            return;
        }
        try {
            admin.setDisableCopyPolicyReminder(false);
            AdminHandler.updateAdmin(admin);
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.success.admin_ResetPolicyCopyReminder");
            JOptionPane.showOptionDialog(Manager.getFrame(), msg, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 0, 1, null, this.option, this.option[0]);
            System.out.println("AdminPanel>> reset policy copy reminder: OK!");
            try {
                AdmStatusPanel panelAdminStatus = (AdmStatusPanel)this.getCurrentTaskPanel();
                panelAdminStatus.setSelectedItem(admin);
                this.setSideBarTasks(panelAdminStatus.getTaskList(admin));
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.failed.admin_ResetPolicyCopyReminder");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            }
            this.refreshAndExpand();
        }
    }

    public void addDomain() {
        AdminPanel.msg("addDomain");
        try {
            if (DOMAINS.equals(this.getCurrentOutlookButtonKey())) {
                this.getCurrentDomainObject();
            } else {
                AdminHandler.getDomainList();
            }
            AddDomainDlg dlg = new AddDomainDlg(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addDomain"));
            if (dlg.isOk()) {
                final String domainID = dlg.getDomainID();
                final String domainName = dlg.getDomainName();
                final String companyName = dlg.getCompanyName();
                final String contactList = dlg.getContactList();
                final boolean autoDeleteClient = dlg.isAutoDeleteIdleClient();
                final boolean isCQEnabled = dlg.isCentralQurantineEnabled();
                final boolean autoDeleteNPVDIClient = dlg.isAutoDeleteIdleNPVDIClient();
                final int maxClientIdleDuration = dlg.getMaxClientIdleDuration();
                final int maxNPVDIClientIdleDuration = dlg.getMaxNPVDIClientIdleDuration();
                SwingWorker worker = new SwingWorker(){
                    private DomainObject newDomainObj = null;
                    private SimpleProgressDlg progressDlg = null;
                    private Exception exception = null;

                    public Object construct() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addDomain"), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addingNewDomain"), true);
                                progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                                progressDlg.setVisible(true);
                                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                            }
                        });
                        try {
                            this.newDomainObj = AdminHandler.addDomain(domainID, domainName, companyName, contactList, autoDeleteClient, maxClientIdleDuration, autoDeleteNPVDIClient, maxNPVDIClientIdleDuration, isCQEnabled);
                        }
                        catch (Exception e) {
                            this.exception = e;
                        }
                        return this.progressDlg;
                    }

                    public void finished() {
                        AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                        if (this.exception != null) {
                            if (this.exception instanceof ConsoleException) {
                                JOptionPane.showMessageDialog(Manager.getFrame(), this.exception.getMessage(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                                if (((ConsoleException)this.exception).needRelogin()) {
                                    Manager.getFrame().showLoginPanel();
                                } else {
                                    AdminPanel.this.refreshAndExpand();
                                }
                            } else {
                                ConsoleLogger.log(this.exception);
                            }
                        } else if (this.newDomainObj != null) {
                            if (AdminPanel.DOMAINS.equals(AdminPanel.this.getCurrentOutlookButtonKey())) {
                                AdminPanel.this.refreshDomain();
                            } else {
                                AdminPanel.this.selectOutlookButton(AdminPanel.DOMAINS);
                            }
                            int index = AdminHandler.getIndexOfDomain(this.newDomainObj.getId(), AdminPanel.this.sideBarPanel.getCurrentContentList());
                            AdminPanel.this.sideBarPanel.selectIndex(index);
                        }
                        if (this.progressDlg != null) {
                            this.progressDlg.setCursor(Cursor.getDefaultCursor());
                            this.progressDlg.dispose();
                        }
                        try {
                            Manager.getFrame().updateTitle();
                        }
                        catch (Exception e) {
                            ConsoleLogger.log(e);
                            Manager.getFrame().showLoginPanel();
                        }
                    }
                };
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)5);
                worker.start();
            }
            dlg.dispose();
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
        }
    }

    public void delDomain() {
        DomainObject domain = this.getCurrentDomainObject();
        if (domain == null) {
            return;
        }
        String currentDomainId = Manager.getCurrentDomainId();
        final boolean deleteCurrentDomain = currentDomainId != null && currentDomainId.equals(domain.getId());
        ActionConfirmationDlg dlg = new ActionConfirmationDlg(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.deleteDomain"), domain.getName(), 1);
        if (dlg.isOk()) {
            final DomainObject domainObj = domain;
            SwingWorker worker = new SwingWorker(){
                private SimpleProgressDlg progressDlg = null;
                private Exception exception = null;

                public Object construct() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.deleteDomain"), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.deletingDomain"), true);
                            progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                            progressDlg.setVisible(true);
                            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                        }
                    });
                    try {
                        AdminHandler.delDomain(domainObj);
                    }
                    catch (Exception e) {
                        this.exception = e;
                    }
                    return this.progressDlg;
                }

                public void finished() {
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                    if (this.exception != null) {
                        if (this.exception instanceof ConsoleException) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), this.exception.getMessage(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error"), 0);
                            if (((ConsoleException)this.exception).needRelogin()) {
                                Manager.getFrame().showLoginPanel();
                            } else {
                                AdminPanel.this.refreshAndExpand();
                            }
                        } else {
                            System.out.println("AdminPanel>> Exception...");
                            ConsoleLogger.log(this.exception);
                        }
                    } else if (deleteCurrentDomain) {
                        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> Utility.exitSystem((int)0));
                        Manager.getFrame().showLoginPanel();
                    } else {
                        AdminPanel.this.refreshAndExpand();
                    }
                    if (this.progressDlg != null) {
                        this.progressDlg.setCursor(Cursor.getDefaultCursor());
                        this.progressDlg.dispose();
                    }
                    try {
                        Manager.getFrame().updateTitle();
                    }
                    catch (Exception e) {
                        ConsoleLogger.log(e);
                        Manager.getFrame().showLoginPanel();
                    }
                }
            };
            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)5);
            worker.start();
        }
        dlg.dispose();
    }

    public void renameDomain() {
        String newDomainName;
        DomainObject domain = this.getCurrentDomainObject();
        if (domain == null) {
            return;
        }
        RenameDomainDlg dlg = new RenameDomainDlg(domain);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        String oldDomainName = domain.getName();
        if (oldDomainName.equals(newDomainName = dlg.getDomainName())) {
            System.out.println("AdminPanel>> renameDomain: same domain name so no need to change!");
            return;
        }
        try {
            domain.setName(newDomainName);
            AdminHandler.updateDomain(domain);
            Object[] obj = new Object[]{oldDomainName, newDomainName};
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domain_WasRenamedTo_");
            String description = MessageFormat.format(msg, obj);
            ConsoleLogger.logAdminEvent(4130, description);
            this.refreshDomainWithSelection(domain);
            String currentDomainId = Manager.getCurrentDomainId();
            if (currentDomainId != null && currentDomainId.equals(domain.getId())) {
                Manager.getFrame().updateTitle();
            }
            try {
                DomainStatusPanel panelDomainStatus = (DomainStatusPanel)this.getCurrentTaskPanel();
                panelDomainStatus.setSelectedItem(domain);
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
            if (CloudUtil.isCloudEnrolled(currentDomainId)) {
                AdminHandler.deleteAccessToken(AdminObject.retrieveCurrentAdminObject().getAdminId());
                GUIManager.getAccessToken();
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
        }
    }

    public void switchToDomain() {
        AdminPanel.msg("switchToDomain");
        DomainObject domain = this.getCurrentDomainObject();
        if (domain == null) {
            return;
        }
        String prevCurrentDomainId = Manager.getCurrentDomainId();
        if (prevCurrentDomainId != null && prevCurrentDomainId.equals(domain.getId())) {
            System.out.println("AdminPanel>> switchToDomain: Same domain! No need to switch!");
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.youAreAlreadyAdministratingThisDomain"), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.switchTo..."), 2);
            return;
        }
        String domainName = domain.getName();
        if (!domain.isEnabled()) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domainIsDisabled"), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.switchTo..."), 2);
            return;
        }
        Object[] obj = new Object[]{domainName};
        String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.areYouSureToAdmiThisDomain");
        String description = MessageFormat.format(msg, obj);
        if (0 != JOptionPane.showConfirmDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.admiThisDomain"), 0)) {
            return;
        }
        try {
            String domainId = domain.getId();
            AdminHandler.switchToDomain(domainId);
            String currentDomainId = Manager.getCurrentDomainId();
            if (!domainId.equals(currentDomainId)) {
                boolean needLogout = false;
                if (currentDomainId == null || currentDomainId.length() < 1) {
                    needLogout = prevCurrentDomainId != null && prevCurrentDomainId.length() > 0;
                } else {
                    boolean bl = needLogout = !currentDomainId.equals(prevCurrentDomainId);
                }
                if (needLogout) {
                    Object[] obj2 = new Object[]{domainName};
                    msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.cannotAdminThisDomainYouNeedToLogin");
                    description = MessageFormat.format(msg, obj2);
                    JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 1);
                    Manager.getFrame().showLoginPanel();
                    return;
                }
                Object[] obj2 = new Object[]{domainName};
                msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.cannotAdminThisDomainItIsDisabled");
                description = MessageFormat.format(msg, obj2);
                JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 1);
                this.refreshAndExpand();
                return;
            }
            if (prevCurrentDomainId == null && currentDomainId != null) {
                MainPanel main = (MainPanel)Manager.getFrame().getPanel();
                main.insertDomainRelatedPanels("server");
            }
            Manager.getFrame().updateTitle();
            this.setComponent(domain);
            Object[] obj2 = new Object[]{domainName};
            msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.theCurrentDomainIs_");
            description = MessageFormat.format(msg, obj2);
            JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 1);
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
        }
    }

    public void editDomain() {
        AdminPanel.msg("editDomain");
        DomainObject domain = this.getCurrentDomainObject();
        if (domain == null) {
            return;
        }
        Object[] obj = new Object[]{domain.getName()};
        String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.editDomainPropertiesFor_");
        String description = MessageFormat.format(msg, obj);
        DomainPropsDlg dlg = new DomainPropsDlg(Manager.getFrame(), description, true);
        dlg.init(domain);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return;
        }
        try {
            domain.setCompanyName(dlg.getCompanyName());
            domain.setContactList(dlg.getContactList());
            domain.setLoginBannerTitle(dlg.getLoginBannerTitle());
            domain.setLoginBannerText(dlg.getLoginBannerText());
            domain.setDisplayLoginBanner(dlg.isDisplayLoginBanner());
            domain.setOptRememberPassword(dlg.getRememberPasswordStatus());
            domain.setOptAllowNeverExpiringPassword(dlg.getAllowNeverExpiringPasswordStatus());
            domain.setOptAutoDeleteIdleClient(dlg.isAutoDeleteIdleClient());
            domain.setOptMaxClientIdleTime(dlg.getMaxClientIdleDuration());
            domain.setOptAutoDeleteIdleNPVDIClient(dlg.isAutoDeleteIdleNPVDIClient());
            domain.setOptMaxNPVDIClientIdleTime(dlg.getMaxNPVDIClientIdleDuration());
            domain.setCQEnabled(dlg.isCQEnabled());
            AdminHandler.updateDomain(domain);
            Object[] obj1 = new Object[]{domain.getName()};
            msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.thePropertiesOfDomain_wasChanged");
            description = MessageFormat.format(msg, obj1);
            ConsoleLogger.logAdminEvent(4111, description);
            this.sideBarPanel.revalidate();
            try {
                DomainStatusPanel panelDomainStatus = (DomainStatusPanel)this.getCurrentTaskPanel();
                panelDomainStatus.setSelectedItem(domain);
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            if (e.needRelogin()) {
                Manager.getFrame().showLoginPanel();
            } else {
                this.refreshAndExpand();
            }
        }
        catch (Exception e) {
            ConsoleLogger.log(e);
        }
    }

    public void exportDomain() {
        DomainObject domain = this.getCurrentDomainObject();
        if (domain == null) {
            return;
        }
        String domainName = domain.getName();
        String domainID = domain.getId();
        String title = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.exportDomain.title");
        Object filePath = this.getClientExportFilePath(domainName, title);
        if (filePath == null) {
            return;
        }
        File exportFile = new File((String)filePath);
        if (!Utility.validateExportFilePath((JFrame)Manager.getFrame(), (File)exportFile, (String)title, (String)".dat", (boolean)AjaxSwingCommonUtil.isAjaxSwingRunning())) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private SimpleProgressDlg progressDlg = null;

            public Object construct() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.exportDomain"), AdminPanel.this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.exportingDomain"), true);
                        progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                        progressDlg.setVisible(true);
                        AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                    }
                });
                while (!AdminPanel.this.completed) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.progressDlg;
            }

            public void finished() {
                AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                if (this.progressDlg != null) {
                    this.progressDlg.setCursor(Cursor.getDefaultCursor());
                    this.progressDlg.dispose();
                }
                AdminPanel.this.completed = false;
            }
        };
        AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)5);
        worker.start();
        try {
            InputStream inputStream = GUIManager.exportDomain(domainName, domainID);
            boolean exportFileHasPostfix = false;
            String exportFileName = exportFile.getName().toLowerCase(Locale.ENGLISH);
            exportFileHasPostfix = exportFileName.endsWith(".dat");
            if (!exportFileHasPostfix) {
                filePath = (String)filePath + ".dat";
            }
            Utility.saveFile((InputStream)inputStream, (String)filePath);
            this.completed = true;
            String description = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.exportDomainDesc");
            String fm = MessageFormat.format(description, domainName);
            ConsoleLogger.logAdminEvent(4134, fm);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.error.FailedToExportDomain") + e.getMessage());
            ConsoleLogger.log(e);
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.exportDomainSuccessMsg")));
    }

    protected String getClientExportFilePath(String domainName, String title) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new ExportFileFilter());
        Object path = domainName + ".dat";
        fc.setSelectedFile(new File((String)path));
        fc.setDialogTitle(title);
        fc.setApproveButtonText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.button.Export"));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            fc.setDialogType(1);
            fc.setSelectedFile(new File((String)path));
            fc.updateUI();
            if (0 != fc.showSaveDialog(Manager.getFrame())) {
                return null;
            }
        } else if (0 != fc.showOpenDialog(Manager.getFrame())) {
            return null;
        }
        if (fc.getSelectedFile() == null) {
            return null;
        }
        path = fc.getSelectedFile().getAbsolutePath();
        if (path == null || ((String)path).trim().length() == 0) {
            return null;
        }
        return path;
    }

    public void importDomain() {
        this.chooser = this.getExportFileChooser();
        final MessageResources msgRes = MessageResources.getInstance();
        this.chooser.setApproveButtonText(UIText.get(2048));
        this.chooser.setDialogTitle(msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.ImportDomain"));
        this.chooser.updateUI();
        int retCode = this.chooser.showDialog(Manager.getFrame(), null);
        if (1 == retCode) {
            return;
        }
        final File f = this.chooser.getSelectedFile();
        try {
            List<String> domainInfo = this.getDomainInformationsFromZipFile(f.toPath());
            if (domainInfo.size() != 2) {
                throw new ConsoleException(369229824, 55);
            }
            final String domainID = domainInfo.get(0);
            final String domainName = this.validateDomainName(domainInfo.get(1));
            if (domainName == null) {
                return;
            }
            boolean needWash = false;
            try {
                GUIManager.getObject("SemDomain", domainID);
                needWash = true;
            }
            catch (ConsoleException ce) {
                needWash = false;
            }
            final boolean washID = needWash;
            SwingWorker worker = new SwingWorker(){
                DomainObject newDomainObj = null;
                SimpleProgressDlg progressDlg = null;
                Exception exception = null;

                public Object construct() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDlg = new SimpleProgressDlg((Frame)Manager.getFrame(), msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importDomain"), msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importingDomain"), true);
                            progressDlg.setCursor(Cursor.getPredefinedCursor(3));
                            progressDlg.setVisible(true);
                            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true);
                        }
                    });
                    try {
                        GUIManager.importDomain(f.getCanonicalPath(), domainName, domainID, washID);
                        String description = msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importDomainDesc");
                        String fm = MessageFormat.format(description, domainName);
                        ConsoleLogger.logAdminEvent(4133, fm);
                        this.newDomainObj = AdminHandler.getDomainObjByName(domainName, true);
                    }
                    catch (Exception e) {
                        this.exception = e;
                    }
                    return this.progressDlg;
                }

                public void finished() {
                    AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)0);
                    if (this.exception != null) {
                        if (this.exception instanceof ConsoleException) {
                            JOptionPane.showMessageDialog(Manager.getFrame(), this.exception.getMessage(), msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                            if (((ConsoleException)this.exception).needRelogin()) {
                                Manager.getFrame().showLoginPanel();
                            } else {
                                AdminPanel.this.refreshAndExpand();
                            }
                        } else {
                            ConsoleLogger.log(this.exception);
                        }
                    } else {
                        if (AdminPanel.DOMAINS.equals(AdminPanel.this.getCurrentOutlookButtonKey())) {
                            AdminPanel.this.refreshDomain();
                        } else {
                            AdminPanel.this.selectOutlookButton(AdminPanel.DOMAINS);
                        }
                        int index = AdminHandler.getIndexOfDomain(this.newDomainObj.getId(), AdminPanel.this.sideBarPanel.getCurrentContentList());
                        AdminPanel.this.sideBarPanel.selectIndex(index);
                    }
                    if (this.progressDlg != null) {
                        this.progressDlg.setCursor(Cursor.getDefaultCursor());
                        this.progressDlg.dispose();
                    }
                    try {
                        Manager.getFrame().updateTitle();
                    }
                    catch (Exception e) {
                        ConsoleLogger.log(e);
                        Manager.getFrame().showLoginPanel();
                    }
                }
            };
            AjaxSwingCommonUtil.updateSwingAgentBrowser((boolean)true, (int)5);
            worker.start();
            System.out.println("AdminPanel>> importDomain: Done!");
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importDomainSuccessMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.importDomain.title"), 1);
        }
        catch (ConsoleException e) {
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
                if (!f.delete()) {
                    System.err.println("AdminPanel: importDomain: Error-> Failed to delete file:" + f.getPath());
                }
            });
            this.showImportDomainErrorDialog(msgRes, e);
        }
    }

    protected List<String> getDomainInformationsFromZipFile(Path file) throws ConsoleException {
        List<String> list;
        block10: {
            if (!Files.exists(file, new LinkOption[0])) {
                ConsoleLogger.log("importDomain: Error-> File does NOT exist! file=" + file.normalize());
                throw new ConsoleException(-535756800, 134);
            }
            if (!Files.isReadable(file)) {
                ConsoleLogger.log("importDomain: Error-> File is NOT readable! file=" + file.normalize());
                throw new ConsoleException(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domainFileNoPrivilege"));
            }
            InputStream reader = Files.newInputStream(file, new OpenOption[0]);
            try {
                list = this.getDomainInformationsFromZip(reader);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ConsoleLogger.logError("AdminPanel: getDomainInformationsFromZipFile: Error-> IOException, file: '" + file + EXCEPTION_PREFIX + e.getMessage());
                    throw new ConsoleException(-535691264, 135);
                }
            }
            reader.close();
        }
        return list;
    }

    protected List<String> getDomainInformationsFromZip(InputStream zipdata) throws ConsoleException {
        AdminPanel.msg("getDomainInformationsFromZip");
        ArrayList<String> domainInfo = new ArrayList<String>();
        String domainID = null;
        try (ZipInputStream zipIn = new ZipInputStream(zipdata);){
            ZipEntry zipEntry = null;
            int count = -1;
            byte[] data = new byte[2048];
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                String path = zipEntry.getName();
                int begin = path.indexOf("BASIC_METADATA");
                if (begin <= 0) continue;
                if (StringUtilities.isEmpty(domainID)) {
                    begin = begin + "BASIC_METADATA".length() + 1;
                    int end = path.indexOf(System.getProperty("file.separator"), begin);
                    if (end > 0) {
                        domainID = path.substring(begin, end);
                    }
                    if (!StringUtilities.isEmpty(domainID)) {
                        domainInfo.add(domainID);
                    }
                }
                if (!StringUtilities.isEmpty(domainID)) {
                    if (!path.endsWith(domainID)) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((count = zipIn.read(data, 0, 2048)) != -1) {
                        baos.write(data, 0, count);
                    }
                    String content = baos.toString("UTF-8");
                    if (content != null && content.indexOf("-->") != -1) {
                        content = content.substring(content.indexOf("-->") + 3);
                    }
                    try {
                        AbstractSchema schema = SchemaContainer.readXML((byte[])content.getBytes("UTF-8"));
                        if (!(schema instanceof SemDomain)) continue;
                        domainInfo.add(((SemDomain)schema).getName());
                        break;
                    }
                    catch (RuntimeException e) {
                        throw new ConsoleException(369229824);
                    }
                    catch (Exception e) {
                        throw new ConsoleException(369229824);
                    }
                }
                throw new ConsoleException(369229824);
            }
        }
        catch (IOException e) {
            ConsoleLogger.logError("AdminPanel: getDomainInformationsFromZip: Error-> IOException: '' Exception message: " + e.getMessage());
            throw new ConsoleException(-535691264, 135);
        }
        catch (ConsoleException e) {
            ConsoleLogger.logError("AdminPanel: getDomainInformationsFromZip: Error-> ConsoleException: '' Exception message: " + e.getMessage());
            throw e;
        }
        return domainInfo;
    }

    private String validateDomainName(String name) {
        AdminPanel.msg("validateDomainName");
        if (name == null) {
            return null;
        }
        String newName = name;
        int validationCode = AdminHandler.validateDomainInfo(null, name);
        if (validationCode == -4 || validationCode == -2) {
            RenameDomainDlg dlg = new RenameDomainDlg(name, true);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                newName = dlg.getDomainName();
                this.validateDomainName(newName);
            }
            if (dlg.isCancelled()) {
                return null;
            }
        }
        return newName;
    }

    protected void showImportDomainErrorDialog(MessageResources msgRes, Exception e) {
        String errMsg = e.getMessage();
        if (StringUtilities.isEmpty((String)errMsg)) {
            System.err.println("AdminPanel: importDomain: Import Domain Failed. No error message, displaying default error message.");
            UIUtilities.showErrorDialog(msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.failedToImportDomain"));
        } else {
            System.err.println(errMsg);
            UIUtilities.showErrorDialog(errMsg);
        }
    }

    private JFileChooser getExportFileChooser() {
        AjaxSwingCommonUtil.executeIfInWebConsoleOrAny(() -> {
            this.chooser = new JFileChooser();
            this.chooser.setAcceptAllFileFilterUsed(false);
        }, (Boolean[])new Boolean[]{this.chooser == null});
        this.chooser.setFileFilter(new ExportFileFilter());
        return this.chooser;
    }

    public void deleteLicense() {
        AdminPanel.msg("deleteLicense");
        LicenseChainObject deleteTarget = this.getCurrentLicenseChainObject();
        if (deleteTarget.getLicenseCategory() == 6) {
            UIUtilities.showInfoDialog(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.noDeleteAWSLicenseMsg"));
            return;
        }
        try {
            String msg = null;
            msg = LicenseHandler.getLicenseChains().size() > 1 ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.confirmDeleteLicenseMsg") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.confirmDeleteLastLicenseMsg");
            int dlgResult = UIUtilities.confirmYesNoOptionDialog(msg, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.confirmDeleteLicense"));
            if (dlgResult != 0) {
                return;
            }
            LicenseHandler.removeLicenseChainFromSystem(deleteTarget);
        }
        catch (ConsoleException e) {
            ConsoleLogger.log(e);
            Object msg = e.getMessage();
            if (e.getErrorCode() == 306184192) {
                msg = e.getMessage() + MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLLicenseHandler.invalidOrCorruptedLicense");
            }
            JOptionPane.showMessageDialog(this, IPLLicenseHandler.getHyperLinkEditorPane((String)msg, "", true, 290), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.dlg.admindialog", "IPLLicenseHandler.error"), 0);
        }
        this.refreshLicenses();
        this.refreshAndExpand();
    }

    public void inproductactivationLicense() {
        new LicenseActivationWizardDialog();
        this.refreshLicenses();
    }

    public void recoverLicense() {
        new RecoverDeletedLicenseDialog();
        this.refreshLicenses();
    }

    public void purchaseAdditionalLicense() {
        HelpUtil.showPurchaseAdditionalLicenses();
    }

    public void expand(DefaultMutableTreeNode node, boolean focused) {
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        if (focused) {
            this.tree.setSelectionPath(path);
        }
    }

    public void expand(ArrayList<String> listPathStr, boolean focused) {
        AdminPanel.msg("expand list");
        if (listPathStr == null || listPathStr.size() == 0) {
            return;
        }
        TimeCounter counter = new TimeCounter();
        counter.start();
        System.out.println(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.beginExpand..."));
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        TreeItem treeItem = null;
        DefaultMutableTreeNode currentNode = node;
        int i = 0;
        int size = listPathStr.size();
        while (i < size) {
            treeItem = (TreeItem)node.getUserObject();
            if (treeItem != null && treeItem.getName().equals(listPathStr.get(i))) {
                this.expand(node, false);
                currentNode = node;
                ++i;
                if (node.getChildCount() == 0) break;
                node = (DefaultMutableTreeNode)node.getFirstChild();
                continue;
            }
            if ((node = node.getNextSibling()) != null) continue;
        }
        if (focused) {
            TreePath path = new TreePath(currentNode.getPath());
            this.tree.setSelectionPath(path);
        }
        counter.stop();
    }

    public void removeSelectedNode() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        UIUtilities.removeTreeNode(this.tree, node, true);
    }

    @Override
    protected int getDefaultDividerLocation() {
        return 220;
    }

    @Override
    protected String getSideBarViewPaneTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.view");
    }

    public void removeSelectedAdmin(String adminName) {
        try {
            List<AdminObject> adminList = AdminHandler.getAdminList();
            for (int i = 0; i < adminList.size(); ++i) {
                AdminObject aObj = adminList.get(i);
                if (aObj.getAdminName().equals(adminName)) {
                    adminList.remove(aObj);
                    continue;
                }
                System.out.println("admin Type : " + aObj.getAdminType());
            }
            this.sideBarPanel.setButtonList(adminList);
            this.setSideBarViews(this.sideBarPanel);
            if (this.selectedAdminId != null) {
                int index = AdminHandler.getIndexOfAdmin(this.selectedAdminId, adminList);
                this.sideBarPanel.selectIndex(index);
            } else {
                this.sideBarPanel.selectIndex(0);
            }
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.viewAdmins"));
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    public void refreshAdmin() {
        try {
            AdminHandler.refreshCurrentAdmin();
            List<AdminObject> adminList = AdminHandler.getAdminList();
            this.sideBarPanel.setButtonList(adminList);
            this.setSideBarViews(this.sideBarPanel);
            if (this.selectedAdminId != null) {
                int index = AdminHandler.getIndexOfAdmin(this.selectedAdminId, adminList);
                this.sideBarPanel.selectIndex(index);
            } else {
                this.sideBarPanel.selectIndex(0);
            }
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.viewAdmins"));
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    @Override
    protected void resetSideBar(String actionCommand) {
        AdminPanel.msg("resetSideBar");
        TreeItem selected = this.sideBarPanel.getCurrentSelection();
        if (ADMINISTRATORS.equals(this.lastOutlookButton)) {
            if (selected != null && selected instanceof AdminObject) {
                this.selectedAdminId = selected.getId();
            }
        } else if (DOMAINS.equals(this.lastOutlookButton)) {
            if (selected != null && selected instanceof DomainObject) {
                this.selectedDomainId = selected.getId();
            }
        } else if (INSTALL_PACKAGES.equals(this.lastOutlookButton)) {
            if (selected != null && selected instanceof GenericTreeObject) {
                this.selectedPackageItemType = ((GenericTreeObject)selected).getItemType();
            }
        } else if (LICENSES.equals(this.lastOutlookButton) && selected != null) {
            this.selectedLicenseId = selected.getId();
        }
        if (!SERVERS.equals(actionCommand)) {
            this.serverPanel.switchOut();
        }
        if (ADMINISTRATORS.equals(actionCommand)) {
            this.refreshAdmin();
            this.currentOutlookPanel = this;
        } else if (DOMAINS.equals(actionCommand)) {
            this.refreshDomain();
            this.currentOutlookPanel = this;
        } else if (SERVERS.equals(actionCommand)) {
            this.serverPanel.refreshTaskBarViews();
            this.serverPanel.switchIn();
            this.currentOutlookPanel = this.serverPanel;
        } else if (INSTALL_PACKAGES.equals(actionCommand)) {
            this.refreshAdmin();
            this.refreshInstallPackages();
            this.currentOutlookPanel = this;
        } else if (LICENSES.equals(actionCommand)) {
            this.refreshLicenses();
            this.currentOutlookPanel = this;
        }
        this.lastOutlookButton = actionCommand;
    }

    protected void tabStateChanged(ChangeEvent e) {
    }

    private static void msg(String s) {
        ConsoleLogger.log("&&&&&" + new Date().toString() + " AdminPanel >" + s);
    }

    private void setOutlookButton() {
        AdminPanel.msg("setOutlookButton");
        AuthorizationManager manager = null;
        PrivilegeContext context = null;
        boolean isSystemAdmin = false;
        boolean hasPackagePrivilege = false;
        boolean hasSitePermission = false;
        manager = AuthorizationManager.getInstance();
        context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        isSystemAdmin = Manager.isSystemAdmin(DataobjectManager.getInstance().getCurrentAdministrator());
        hasPackagePrivilege = AdminPrivilegeObject.isCurrentAdminHasPackagePrivilege();
        hasSitePermission = manager.checkPermission(context, (Permission)AuthorizationManager.TopLevelPermission.MANAGE_SITES);
        this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Administrators"), ADMINISTRATORS));
        if (!LicenseObject.getInstance().isSBProduct()) {
            if (isSystemAdmin) {
                this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Domains"), DOMAINS));
            }
            if (hasSitePermission) {
                this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Servers.ee"), SERVERS));
            }
        } else if (isSystemAdmin) {
            this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Servers.sb"), SERVERS));
        }
        if (hasPackagePrivilege && !LicenseObject.getInstance().isSBProduct()) {
            this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.InstallPackages"), INSTALL_PACKAGES));
        }
        if (isSystemAdmin) {
            this.outlookButtonItemList.add(new PagePanel.OutlookButtonObject(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.Licenses"), LICENSES));
        }
    }

    private JPopupMenu setupPopupMenu(TreeItem item) throws ConsoleException {
        JPopupMenu popup = null;
        JMenuItem menuItem = null;
        switch (item.getItemType()) {
            case 6: {
                break;
            }
            case 5: {
                popup = new JPopupMenu();
                menuItem = Manager.isSystemAdmin(DataobjectManager.getInstance().getCurrentAdministrator()) ? new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addSystemAdmin")) : new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addAdministrator"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                break;
            }
            case 39: {
                popup = new JPopupMenu();
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addDomain"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                break;
            }
            case 40: {
                popup = new JPopupMenu();
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addAdministrator"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.delete"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.rename"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                DomainObject domain = (DomainObject)item;
                boolean isDomainEnabled = domain.isEnabled();
                menuItem = new JMenuItem(isDomainEnabled ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disable") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.enable"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.administerThisDomain"));
                menuItem.setEnabled(isDomainEnabled);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                popup.add(new JSeparator());
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.properties"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                break;
            }
            case 20: {
                popup = new JPopupMenu();
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.delete"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.rename"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.setPassword"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.resetLock"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                AdminObject admin = (AdminObject)item;
                menuItem.setEnabled(admin.retrieveState().isLocked());
                popup.add(menuItem);
                popup.add(new JSeparator());
                menuItem = new JMenuItem(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.properties"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AdminPanel.this.menuActionPerformed(e);
                    }
                });
                popup.add(menuItem);
                break;
            }
        }
        return popup;
    }

    private void refreshInstallPackages() {
        AdminPanel.msg("refreshInstallPackages");
        try {
            GenericTreeObject currentPackageNode = new GenericTreeObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.client", "ClientPanel.currentPackagesTxt"), 50);
            GenericTreeObject installationSettingNode = new GenericTreeObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "ClientPanel.installationSetting"), 150);
            GenericTreeObject installationFeatureNode = new GenericTreeObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "ClientPanel.installationFeature"), 151);
            installationFeatureNode.setShowWinIcon(true);
            ArrayList<GenericTreeObject> installPackagesList = new ArrayList<GenericTreeObject>();
            installPackagesList.add(currentPackageNode);
            installPackagesList.add(installationSettingNode);
            LicenseObject lo = LicenseObject.getInstance();
            if (!lo.isSNACOnlyProduct()) {
                installPackagesList.add(installationFeatureNode);
            }
            this.sideBarPanel.setButtonList(installPackagesList);
            this.setSideBarViews(this.sideBarPanel);
            int index = 0;
            if (this.selectedPackageItemType == 150) {
                index = 1;
            } else if (this.selectedPackageItemType == 151) {
                index = 2;
            }
            this.sideBarPanel.selectIndex(index);
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.viewPackages"));
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void refreshLicenses() {
        AdminPanel.msg("refreshLicenses");
        try {
            UpgradeLicenseObject uLicense;
            ArrayList<AbstractUIObject> licenses = new ArrayList<AbstractUIObject>();
            ArrayList<LicenseChainObject> allLicenseChainObjects = LicenseHandler.getLicenseChains(true);
            TrialwareLicenseObject twLicense = LicenseHandler.getTrialwareLicense(false);
            if (twLicense != null) {
                licenses.add(twLicense);
            }
            if ((uLicense = LicenseHandler.getUpgradeLicense(false)) != null) {
                licenses.add(uLicense);
            }
            licenses.addAll(allLicenseChainObjects);
            this.sideBarPanel.setButtonList(licenses);
            this.setSideBarViews(this.sideBarPanel);
            int index = -1;
            if (this.selectedLicenseId != null) {
                index = LicenseHandler.getIndexOfLicense(this.selectedLicenseId, licenses);
            }
            if (licenses.size() > 0 && index < 0) {
                index = 0;
            }
            if (index >= 0) {
                this.sideBarPanel.selectIndex(index);
            } else {
                LicenseChainObject dummyChain = new LicenseChainObject(new LicenseChain());
                this.setComponent(dummyChain);
                this.getTabbedPage(dummyChain.getItemType()).setSelectedItem(null);
            }
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.viewLicenses"));
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
        }
    }

    private void refreshDomain() {
        AdminPanel.msg("refreshDomain");
        try {
            List<DomainObject> domainList = AdminHandler.getDomainList();
            this.sideBarPanel.setButtonList(domainList);
            this.setSideBarViews(this.sideBarPanel);
            if (this.selectedDomainId != null) {
                int index = AdminHandler.getIndexOfDomain(this.selectedDomainId, domainList);
                this.sideBarPanel.selectIndex(index);
            } else if (!this.sideBarPanel.isEmpty()) {
                this.sideBarPanel.selectIndex(0);
            } else {
                this.setComponent(null);
            }
            this.setViewPaneTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.title.viewDomains"));
            Manager.getFrame().updateTitle();
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private AdminObject getCurrentAdminObject() {
        AdminPanel.msg("getCurrentAdminObject");
        try {
            AdminObject curAdminObj = (AdminObject)this.sideBarPanel.getCurrentSelection();
            List<AdminObject> adminList = AdminHandler.getAdminList();
            this.sideBarPanel.setButtonList(adminList);
            this.setSideBarViews(this.sideBarPanel);
            String currentAdminId = Manager.getCurrentAdminId();
            int i = AdminHandler.getIndexOfAdmin(currentAdminId, adminList);
            if (i < 0) {
                String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.curAdmin_doesnotExist");
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                if (Manager.isCurrentAdmin(currentAdminId)) {
                    Manager.getFrame().showLoginPanel();
                }
                return null;
            }
            int index = AdminHandler.getIndexOfAdmin(curAdminObj.getId(), adminList);
            if (index >= 0) {
                this.sideBarPanel.selectIndex(index);
                return (AdminObject)this.sideBarPanel.getCurrentSelection();
            }
            Object[] obj = new Object[]{curAdminObj.getName()};
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.theAdminDoesnotExist");
            String description = MessageFormat.format(msg, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            return null;
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
            return null;
        }
    }

    private DomainObject getCurrentDomainObject() {
        AdminPanel.msg("getCurrentDomainObject");
        try {
            DomainObject curDomainObj = null;
            if (!this.sideBarPanel.isEmpty()) {
                curDomainObj = (DomainObject)this.sideBarPanel.getCurrentSelection();
            }
            List<DomainObject> domainList = AdminHandler.getDomainList();
            this.sideBarPanel.setButtonList(domainList);
            this.setSideBarViews(this.sideBarPanel);
            if (curDomainObj != null) {
                int index = AdminHandler.getIndexOfDomain(curDomainObj.getId(), domainList);
                if (index >= 0) {
                    this.sideBarPanel.selectIndex(index);
                    curDomainObj = (DomainObject)this.sideBarPanel.getCurrentSelection();
                    return curDomainObj;
                }
                Object[] obj = new Object[]{curDomainObj.getName()};
                String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.theDomain_doesnotExist");
                String description = MessageFormat.format(msg, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                return null;
            }
            if (!this.sideBarPanel.isEmpty()) {
                this.sideBarPanel.selectIndex(0);
            }
        }
        catch (ConsoleException e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return null;
    }

    private LicenseChainObject getCurrentLicenseChainObject() {
        AdminPanel.msg("getCurrentLicenseChainObject");
        TreeItem selection = this.sideBarPanel.getCurrentSelection();
        if (selection != null && selection instanceof LicenseChainObject) {
            return (LicenseChainObject)selection;
        }
        return null;
    }

    private void refreshBtnActionPerformed(ActionEvent e) {
        this.refreshAndExpand();
    }

    private boolean editAdminDomain(AdminObject admin) {
        Object[] obj = new Object[]{admin.getAdminName()};
        String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.adminPropertiesFor_");
        String description = MessageFormat.format(msg, obj);
        AdmPropertiesDlg dlg = new AdmPropertiesDlg(admin, Manager.getFrame(), description, true, Manager.isCurrentAdmin(admin.getId()) && !admin.isSysAdmin(), false);
        try {
            dlg.setData();
            dlg.setVisible(true);
            if (dlg.isCancelled()) {
                return false;
            }
            return dlg.modifyAdmin();
        }
        catch (Exception ex) {
            ConsoleLogger.log(ex);
            return false;
        }
    }

    private void refreshAdminWithSelection(AdminObject admin) {
        AdminPanel.msg("refreshAdminWithSelection");
        this.refreshAdmin();
        int index = AdminHandler.getIndexOfAdmin(admin.getId(), this.sideBarPanel.getCurrentContentList());
        this.sideBarPanel.selectIndex(index);
    }

    private void refreshDomainWithSelection(DomainObject domain) {
        this.refreshDomain();
        int index = AdminHandler.getIndexOfDomain(domain.getId(), this.sideBarPanel.getCurrentContentList());
        this.sideBarPanel.selectIndex(index);
    }

    private void menuActionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String item = source.getText();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addSystemAamin").equals(item)) {
            this.addAdmin();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addAdmin").equals(item)) {
            this.addAdmin();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disable").equals(item)) {
            this.setDomainEnabled(false);
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.enable").equals(item)) {
            this.setDomainEnabled(true);
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.adminThisDomain").equals(item)) {
            this.switchToDomain();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.addDomain").equals(item)) {
            this.addDomain();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.delete").equals(item)) {
            TreeItem treeItem = (TreeItem)node.getUserObject();
            if (treeItem.getItemType() == 40) {
                this.delDomain();
            } else if (treeItem.getItemType() == 20) {
                this.delAdmin();
            }
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.rename").equals(item)) {
            TreeItem treeItem = (TreeItem)node.getUserObject();
            if (treeItem.getItemType() == 40) {
                this.renameDomain();
            } else if (treeItem.getItemType() == 20) {
                this.renameAdmin();
            }
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.setPassword").equals(item)) {
            this.setAdminPwd();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.resetLock").equals(item)) {
            this.resetAdminLock();
        } else if (this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.properties").equals(item)) {
            TreeItem treeItem = (TreeItem)node.getUserObject();
            if (treeItem.getItemType() == 40) {
                this.editDomain();
            } else if (treeItem.getItemType() == 20) {
                this.editAdmin();
            }
        }
    }

    private void treeValueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item != null) {
            this.setComponent(item);
            this.setSideBarTasks(null);
        }
    }

    private void setComponent(TreeItem item) {
        AdminPanel.msg("setComponent");
        TreeItem componentItem = item;
        AdminPanel.msg("start setComponent threaded");
        TabbedPageModel tabbedPage = componentItem == null ? this.getEmptyDomainPanel() : this.getTabbedPage(componentItem.getItemType());
        if (tabbedPage != null) {
            tabbedPage.setSelectedItem(componentItem);
            this.setCurrentTaskPanel((Component)((Object)tabbedPage));
        } else {
            this.setCurrentTaskPanel(this.blankPanel);
        }
        if (tabbedPage instanceof TaskList) {
            TaskList subPanel = (TaskList)((Object)tabbedPage);
            this.setSideBarTasks(subPanel.getTaskList(componentItem));
        } else if (tabbedPage instanceof CurrentPackagePanel) {
            CurrentPackagePanel subPanel = (CurrentPackagePanel)tabbedPage;
            this.setSideBarTasks(subPanel.getTaskList(componentItem));
        } else if (tabbedPage instanceof RecycleBinPanel) {
            RecycleBinPanel subPanel = (RecycleBinPanel)tabbedPage;
            this.setSideBarTasks(subPanel.getTaskList(componentItem));
        } else {
            this.setSideBarTasks(new ArrayList<List<TaskObject>>());
        }
        AdminPanel.msg("end setComponent threaded");
    }

    private TabbedPageModel getEmptyDomainPanel() {
        if (this.emptyDomainPanel == null) {
            this.emptyDomainPanel = new DomainEmptyPanel();
        }
        return this.emptyDomainPanel;
    }

    private TabbedPageModel getTabbedPage(int itemType) {
        TabbedPageModel panel = this.panelMap.get(itemType);
        if (panel == null) {
            switch (itemType) {
                case 40: {
                    panel = new DomainStatusPanel();
                    break;
                }
                case 20: 
                case 140: 
                case 141: {
                    panel = new AdmStatusPanel();
                    break;
                }
                case 50: {
                    panel = new CurrentPackagePanel(this);
                    break;
                }
                case 52: {
                    panel = new RecycleBinPanel(this);
                    break;
                }
                case 150: {
                    panel = new ClientInstallationSettingsPanel(this);
                    break;
                }
                case 151: {
                    panel = new ClientInstallationFeaturesPanel(this);
                    break;
                }
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    panel = new LicenseStatusPanel();
                    break;
                }
            }
            this.panelMap.put(itemType, panel);
        }
        return panel;
    }

    @Override
    public Component getCurrentTaskPanel() {
        if (null != this.lastOutlookButton && this.lastOutlookButton.equals(SERVERS)) {
            return this.serverPanel.getCurrentTaskPanel();
        }
        return super.getCurrentTaskPanel();
    }

    @Override
    public int getItemIndex(int index) {
        if (LicenseObject.getInstance().isSBProduct()) {
            switch (index) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
            }
        } else {
            switch (index) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
        }
        return 0;
    }

    public void setDomainEnabled(boolean enabled) {
        block10: {
            ActionConfirmationDlg dlg;
            DomainObject domain = this.getCurrentDomainObject();
            if (domain == null) {
                return;
            }
            if (!enabled && !(dlg = new ActionConfirmationDlg(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disableDomain"), domain.getName(), 0)).isOk()) {
                return;
            }
            try {
                domain.setEnabled(enabled);
                AdminHandler.updateDomain(domain);
                if (!enabled && AdminHandler.isCurrentDomain(domain)) {
                    Manager.getFrame().showLoginPanel();
                    break block10;
                }
                Object[] obj = new Object[]{domain.getName(), enabled ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.enabled") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disabled")};
                String msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domain_was_");
                String description = MessageFormat.format(msg, obj);
                ConsoleLogger.logAdminEvent(enabled ? 4129 : 4128, description);
                Object[] obj1 = new Object[]{domain.getName(), domain.isEnabled() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.enabled") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.disabled")};
                msg = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.domain_is_");
                description = MessageFormat.format(msg, obj1);
                JOptionPane.showMessageDialog(Manager.getFrame(), description, this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.information"), 1);
                this.refresh();
                this.tree.updateUI();
                try {
                    DomainStatusPanel panelDomainStatus = (DomainStatusPanel)this.getCurrentTaskPanel();
                    panelDomainStatus.setSelectedItem(domain);
                }
                catch (Exception ex) {
                    ConsoleLogger.log(ex);
                }
                Manager.getFrame().updateTitle();
            }
            catch (ConsoleException e) {
                JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminPanel.consoleError"), 0);
                if (e.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                } else {
                    this.refreshAndExpand();
                }
            }
            catch (Exception e) {
                ConsoleLogger.log(e);
            }
        }
    }

    @Override
    public void setCurrentSelection(TreeItem item) {
        this.setComponent(item);
    }

    public ServersPanel getServersPanel() {
        return this.serverPanel;
    }

    public PagePanel getCurrentOutlookPanel() {
        return this.currentOutlookPanel;
    }

    public void editPartnerInformation() {
        new EditPartnerDialog().setVisible(true);
    }
}

