/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.DomainObject;
import com.sygate.scm.console.logicobject.ElsLicenseObject;
import com.sygate.scm.console.logicobject.LicenseChainObject;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.admin.TaskList;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseDisplayStringHelper;
import com.sygate.scm.console.ui.util.TabbedPageModel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.TaskPanelBase;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class AdminBasePanel
extends JPanel
implements TabbedPageModel,
TaskPanel,
TaskList,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    protected static final URL URL_ACTION = ConsoleMain.class.getResource("run_command.png");
    protected static final URL URL_RENAME_ACTION = ConsoleMain.class.getResource("rename.png");
    protected static final URL URL_PWD_ACTION = ConsoleMain.class.getResource("setPassword.png");
    protected static final URL URL_CONFIGURE = ConsoleMain.class.getResource("config.png");
    Icon renameIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("rename.png")));
    Icon pwdIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("setPassword.png")));
    Icon addDomainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    Icon editDomainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
    Icon deleteDomainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
    Icon disableDomainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("disable.png")));
    Icon switchDomainIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("switchDomain.png")));
    Icon addAdminIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("add.png")));
    Icon editAdminIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("edit.png")));
    Icon deleteIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("delete.png")));
    Icon unlockIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("unlock_admin.gif")));
    Icon resetReminderIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("resetCPreminder.png")));
    Icon addLicenseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("importLicenseIcon.png")));
    Icon addLicenseRenewalIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("importLicenseIcon.png")));
    Icon purchaseLicenseLicenseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("purchaseLicenseIcon.png")));
    Icon downloadLicenseIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("downloadLicenseIcon.gif")));
    Icon importAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("import.png")));
    Icon exportAction = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("export.png")));
    transient Icon configIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("config.png")));
    private JEditorPane statusEditor = null;
    private int pageId;
    private JScrollPane sPane;
    private AdminTaskPane rightPanel;
    protected List<List<TaskObject>> taskList;
    MessageResources msgRes = MessageResources.getInstance();

    public AdminBasePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.rightPanel = new AdminTaskPane();
        this.rightPanel.putClientProperty("cssClass", "adminBasePanelrightPanel");
        this.add((Component)this.rightPanel, "Center");
    }

    @Override
    public void refresh() {
    }

    protected JScrollPane getScrollPane() {
        if (this.sPane == null) {
            this.sPane = new JScrollPane((Component)this.getStatusEditor());
            this.sPane.setBorder(null);
        }
        this.sPane.putClientProperty("cssClass", "adminBasePanelsPane");
        return this.sPane;
    }

    protected Component getContentPanel() {
        return this.getScrollPane();
    }

    protected String getContentText(Object item) {
        String text = HTMLUtilities.HTML_DOCUMENT_BEGIN + "<TABLE class='adminBasePanelcontentText' width=100% border='0' valign='top'><TD>" + this.getRightTable(item) + "</TD></TR></TABLE></BODY></HTML>";
        return text;
    }

    protected AdminPanel getAdminPanel(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            return (AdminPanel)MainPanel.getCurrentPanel();
        }
        return null;
    }

    protected AdminPanel getAdminPanel() {
        return (AdminPanel)MainPanel.getCurrentPanel();
    }

    protected String trWithBackground() {
        return " <TR bgcolor='" + UIColorUtilities.colorToString((Color)UIColorUtilities.TABLE_STRIPE) + "'>";
    }

    protected String getTimeString(String time) {
        if (time.length() == 0) {
            return "";
        }
        try {
            return Utility.getFullDateLongTimeString((long)Long.parseLong(time), null);
        }
        catch (NumberFormatException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return "";
        }
    }

    protected abstract String getPanelName(Object var1);

    protected abstract String getLeftTableContent(Object var1);

    protected abstract String getRightTableContent(Object var1);

    protected abstract void linkActivated(HyperlinkEvent var1);

    private JEditorPane getStatusEditor() {
        if (this.statusEditor == null) {
            this.statusEditor = new JEditorPane();
            this.statusEditor.setContentType("text/html");
            this.statusEditor.setEditable(false);
            this.statusEditor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    AdminBasePanel.this.linkActivated(e);
                }
            });
        }
        this.statusEditor.putClientProperty((Object)"cssClass", (Object)"adminBasePanelStatusEditor");
        return this.statusEditor;
    }

    private String getRightTable(Object item) {
        return "<TABLE width=100% border='0' valign='middle'>" + this.getRightTableContent(item) + "</TABLE>";
    }

    @Override
    public void setSelectedItem(Object item) {
        this.getStatusEditor().setText(this.getContentText(item));
        this.getStatusEditor().setCaretPosition(0);
        if (item != null && item instanceof AdminObject) {
            AdminObject admin = (AdminObject)item;
            Object[] obj1 = new Object[]{admin.getName()};
            String msg1 = null;
            msg1 = admin.isSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.system_admin_title") : (admin.isDomainSysAdmin() ? this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.domain_admin_title") : this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.limit_admin_title"));
            String description1 = MessageFormat.format(msg1, obj1);
            this.rightPanel.setTitle(description1);
            this.rightPanel.setSubTitle(null);
        } else if (item != null && item instanceof DomainObject) {
            String description1;
            DomainObject domain = (DomainObject)item;
            String currentDomainId = Manager.getCurrentDomainId();
            if (domain.getId().equals(currentDomainId)) {
                Object[] obj1 = new Object[]{domain.getName()};
                String msg1 = this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.domain_title");
                description1 = MessageFormat.format(msg1, obj1);
            } else {
                description1 = domain.getName();
            }
            this.rightPanel.setTitle(description1);
            this.rightPanel.setSubTitle(null);
        } else if (item != null && (item instanceof ElsLicenseObject || item instanceof LicenseChainObject)) {
            this.rightPanel.setTitle(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.license_title"));
            String productName = "";
            if (item instanceof ElsLicenseObject) {
                productName = LicenseDisplayStringHelper.getLicenseDisplayString((ElsLicenseObject)item);
            }
            if (item instanceof LicenseChainObject && ((LicenseChainObject)item).getLicenseCount() > 0) {
                productName = LicenseDisplayStringHelper.getLicenseDisplayString((LicenseChainObject)item);
            }
            this.rightPanel.setSubTitle(productName);
        } else if (item != null && item instanceof TrialwareLicenseObject) {
            this.rightPanel.setTitle(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.trialwarelicense_title"));
            this.rightPanel.setSubTitle(LicenseDisplayStringHelper.getLicenseDisplayString((TrialwareLicenseObject)item));
        } else if (item != null && item instanceof UpgradeLicenseObject) {
            this.rightPanel.setTitle(this.msgRes.getString("com.sygate.scm.console.ui.admin.admin", "AdminBasePanel.upgradelicense_title"));
            this.rightPanel.setSubTitle(LicenseDisplayStringHelper.getLicenseDisplayString((UpgradeLicenseObject)item));
        } else {
            this.rightPanel.setTitle("    ");
            this.rightPanel.setSubTitle(null);
        }
    }

    public int getPageId() {
        return this.pageId;
    }

    class AdminTaskPane
    extends TaskPanelBase {
        private static final long serialVersionUID = -6480933299424276091L;

        @Override
        protected Component getContentPanel() {
            return AdminBasePanel.this.getContentPanel();
        }

        protected String getTitleIconName() {
            return "global.gif";
        }

        @Override
        protected String getTitleName() {
            return "Admin";
        }
    }
}

