/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.admin;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.CompanyInformationHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.LoginConfigObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.admin.AdminBasePanel;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionListener;

public class AdmStatusPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    private static final MessageResources MRS = MessageResources.getInstance();
    private String panelName;
    private AdminPanel adminPanel;
    private AdminObject admin;
    private static final int EDIT = 1;
    private static final int RENAME = 2;
    private static final int DELETE = 3;
    private static final int ADD_SYS_ADMIN = 4;
    private static final int ADD_ADMIN = 5;
    private static final int ADD_DOMAIN = 6;
    private static final int CHANGE_PWD = 7;
    private static final int UNLOCK = 8;
    private static final int RESET_REMINDER = 9;
    private static final int CONFIGURE_PASSWORD_REQUIREMENTS = 10;

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_admin_pane_administrators";
    }

    @Override
    protected String getPanelName(Object item) {
        this.panelName = item != null && item instanceof AdminObject && Manager.isSystemAdmin(((AdminObject)item).getSemAdmin()) ? MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.systemAdminManagement") : MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.adminManagement");
        return this.panelName;
    }

    @Override
    protected String getLeftTableContent(Object item) {
        Object[] obj = new Object[]{this.getSystem((AdminObject)item)};
        String msg1 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.add_admin");
        String msg2 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.delete_admin");
        String msg3 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.rename_admin");
        String fm1 = MessageFormat.format(msg1, obj);
        String fm2 = MessageFormat.format(msg2, obj);
        String fm3 = MessageFormat.format(msg3, obj);
        String fm4 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.setPassword");
        String fm5 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.resetAccountLock");
        String fm6 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.editProperties");
        String fm7 = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.edit_password_requirements");
        String STARTROW = "<TR><TD>";
        String ENDROW = "</A></TD></TR>";
        return "<TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#ADD'>" + fm1 + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#DEL'>" + fm2 + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_RENAME_ACTION) + "<A href='http://localhost/a.html#REN'>" + fm3 + "</A></TD></TR><TR><TD>" + HTMLUtilities.img((URL)URL_PWD_ACTION) + "<A href='http://localhost/a.html#PWD'>" + fm4 + "</A></TD></TR>" + (String)(AdminHandler.isAdminLocked((AdminObject)item) ? "<TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#LOCK'>" + fm5 + "</A></TD></TR>" : "") + "<TR><TD>" + HTMLUtilities.img((URL)URL_ACTION) + "<A href='http://localhost/a.html#PROPERTIES'>" + fm6 + "</A></TD></TR>" + HTMLUtilities.img((URL)URL_CONFIGURE) + "<A href='http://localhost/a.html#CONFIGPWDREQ'>" + fm7 + "</A></TD></TR><TR><TD>";
    }

    @Override
    protected String getRightTableContent(Object item) {
        StringBuffer strTableContent = new StringBuffer();
        this.admin = (AdminObject)item;
        LoginConfigObject loginConfig = this.admin.getLoginConfig(true);
        AdminStateObject adminState = null;
        try {
            adminState = this.admin.retrieveState();
            if (adminState != null) {
                adminState.setLoginConfig(loginConfig);
            }
        }
        catch (Exception ex) {
            adminState = null;
            this.handleException(ex);
        }
        String[] str = new String[]{MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.adminName"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.fullName"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.email"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.attemptThreshold"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.onLineStatus"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.creationTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lockStatus"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lockTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lastLoginIP"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lastLoginTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lastLogoffTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.failedLoginAttempt"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.lastPasswordChangeTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.passwordEffectiveTime"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.enableOrDisable"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.AuthenticationMethod"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.passwordVerificationFailureThreshold"), MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.failedPasswordVerificationAttempts")};
        strTableContent.append(this.trWithBackground() + "<TD>" + str[0] + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)this.admin.getName()) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[1] + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)this.admin.getFullName()) + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[2] + "</TD><TD>" + HTMLUtilities.filterAndConvertNewLines((String)this.admin.getEmail()) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[3] + "</TD><TD>" + Integer.toString(loginConfig.getAttemptThresholdBeforeAlert()) + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[4] + "</TD><TD>" + this.getOnlineStatusString(adminState) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[5] + "</TD><TD>" + this.admin.getCreationTimeDisplayString() + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[6] + "</TD><TD>" + (adminState == null ? "" : adminState.getLockStatusDisplayString()) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[7] + "</TD><TD>" + (adminState == null ? "" : adminState.getLockTimeDisplayString()) + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[8] + "</TD><TD>" + (adminState == null ? "" : Utility.shortenIpv6Address((String)adminState.getLastLoginIpAddress())) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[9] + "</TD><TD>" + (adminState == null ? "" : adminState.getLastLoginTimeDisplayString()) + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[10] + "</TD><TD>" + (adminState == null ? "" : adminState.getLastLogoffTimeDisplayString()) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[11] + "</TD><TD>" + (adminState == null ? "" : adminState.getFailedLoginAttemptNumberDisplayString()) + "</TD></TR>");
        strTableContent.append(this.trWithBackground() + "<TD>" + str[14] + "</TD><TD>" + this.admin.getEnabledDisplayString() + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[15] + "</TD><TD>" + this.getAuthenticationMethodString() + "</TD></TR>");
        if (!this.isAuthenticatedBySmartcard()) {
            strTableContent.append(this.trWithBackground() + "<TD>" + str[16] + "</TD><TD>" + Integer.toString(loginConfig.getLoginConfig().getDefAttemptThresholdForPasswordVerification()) + "</TD></TR>");
        }
        if (adminState == null) {
            strTableContent.append("<TR><TD>" + str[17] + "</TD><TD>Unknown</TD></TR>");
        } else if (!this.isAuthenticatedBySmartcard()) {
            strTableContent.append("<TR><TD>" + str[17] + "</TD><TD>" + Integer.toString(adminState.getAdministratorState().getOptFailedPasswordVerificationAttemptNumber() == null ? adminState.getAdministratorState().getDefFailedPasswordVerificationAttemptNumber() : adminState.getAdministratorState().getOptFailedPasswordVerificationAttemptNumber()) + "</TD></TR>");
        }
        if (this.isAuthenticatedByRSA() || this.isAuthenticatedByAD() || this.isAuthenticatedBySmartcard()) {
            if (Manager.isSystemAdmin(this.admin.getSemAdmin())) {
                return strTableContent.append(this.getCompanyRow()).toString();
            }
            return strTableContent.toString();
        }
        strTableContent.append(this.trWithBackground() + "<TD>" + str[12] + "</TD><TD>" + (adminState == null ? "" : adminState.getLastPasswordChangeTimeDisplayString()) + "</TD></TR>");
        strTableContent.append("<TR><TD>" + str[13] + "</TD><TD>" + this.getPasswordAgeString(adminState) + "</TD></TR>");
        if (Manager.isSystemAdmin(this.admin.getSemAdmin())) {
            strTableContent.append(this.getCompanyRow());
            return strTableContent.toString();
        }
        return strTableContent.toString();
    }

    private String getOnlineStatusString(AdminStateObject adminState) {
        String onlineStatusString = "";
        String onlineStatus = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusOnline");
        String offlineStatus = MessageResources.getInstance().getString("com.sygate.scm.console.logicobject.logicobject", "AdminStateObject.statusOffline");
        AdminObject currentAdmin = AdminObject.retrieveCurrentAdminObject();
        if (null != adminState) {
            if (this.admin.getId().equalsIgnoreCase(currentAdmin.getId())) {
                onlineStatusString = onlineStatus;
            } else if (adminState.getLastCheckpointTime() == -1L || adminState.isOffline()) {
                onlineStatusString = offlineStatus;
            } else {
                long lastCheckpoint = adminState.getLastCheckpointTime();
                long currentTime = TimeUtil.getServerTime();
                onlineStatusString = currentTime - lastCheckpoint <= 180000L ? onlineStatus : offlineStatus;
            }
        }
        return onlineStatusString;
    }

    private String getCompanyRow() {
        String labelCompanyName = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.CompanyName");
        return this.trWithBackground() + "<TD>" + labelCompanyName + "</TD><TD>" + CompanyInformationHandler.getCompanyName() + "</TD></TR>";
    }

    private String getPasswordAgeString(AdminStateObject adminState) {
        if (adminState == null) {
            return "";
        }
        if (adminState.isPasswordNeverExpires()) {
            return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.passwordNeverExpire");
        }
        return adminState.getPasswordDurationDisplayString();
    }

    private boolean isAuthenticatedByRSA() {
        return SemAdministrator.SECURID.equals(this.admin.getSemAdmin().getOptAuthenticationMethod());
    }

    private boolean isAuthenticatedByAD() {
        return SemAdministrator.DIRECTORY.equals(this.admin.getSemAdmin().getOptAuthenticationMethod());
    }

    private boolean isAuthenticatedBySmartcard() {
        return SemAdministrator.SMARTCARD.equals(this.admin.getSemAdmin().getOptAuthenticationMethod());
    }

    private boolean isAuthenticatedByVip() {
        return SemAdministrator.VIP.equals(this.admin.getSemAdmin().getOptAuthenticationMethod());
    }

    private String getAuthenticationMethodString() {
        if (this.isAuthenticatedByRSA()) {
            return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.rsaAuthentication");
        }
        if (this.isAuthenticatedByAD()) {
            return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.directoryAuthentication");
        }
        if (this.isAuthenticatedBySmartcard()) {
            return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.smartcardAuthentication");
        }
        if (this.isAuthenticatedByVip()) {
            return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.vipAuthentication");
        }
        return MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.defaultAuthentication");
    }

    private String getSystem(AdminObject admin) {
        return Manager.isSystemAdmin(admin.getSemAdmin()) ? MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.system") : "";
    }

    @Override
    protected void linkActivated(HyperlinkEvent e) {
        this.adminPanel = this.getAdminPanel(e);
        if (this.adminPanel != null) {
            if ("ADD".equals(e.getURL().getRef())) {
                this.adminPanel.addAdmin();
            } else if ("DEL".equals(e.getURL().getRef())) {
                this.adminPanel.delAdmin();
            } else if ("REN".equals(e.getURL().getRef())) {
                this.adminPanel.renameAdmin();
            } else if ("PWD".equals(e.getURL().getRef())) {
                this.adminPanel.setAdminPwd();
            } else if ("LOCK".equals(e.getURL().getRef())) {
                this.adminPanel.resetAdminLock();
            } else if ("PROPERTIES".equals(e.getURL().getRef())) {
                this.adminPanel.editAdmin();
            } else if ("CONFIGPWDREQ".equals(e.getURL().getRef())) {
                this.adminPanel.configurePasswordRequirements();
            }
        }
    }

    public void handleException(Exception ex) {
        if (ex instanceof ConsoleException) {
            int errorCode = ((ConsoleException)ex).getErrorCode();
            if (((ConsoleException)ex).needRelogin()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.consoleError"), 0);
                Manager.getFrame().showLoginPanel();
                return;
            }
            if (errorCode == 0x16010000) {
                Object[] obj = new Object[]{this.admin.getName()};
                String msg = MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.theAdmin_NotExist");
                String fm = MessageFormat.format(msg, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.consoleError"), 0);
                this.getAdminPanel().removeSelectedAdmin(this.admin.getName());
                return;
            }
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.consoleError"), 0);
        } else {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    @Override
    public void executeTask(int taskIndex, Object userObject) {
        this.adminPanel = this.getAdminPanel();
        switch (taskIndex) {
            case 4: 
            case 5: {
                this.adminPanel.addAdmin();
                break;
            }
            case 2: {
                this.adminPanel.renameAdmin();
                break;
            }
            case 7: {
                this.adminPanel.setAdminPwd();
                break;
            }
            case 3: {
                this.adminPanel.delAdmin();
                break;
            }
            case 1: {
                this.adminPanel.editAdmin();
                break;
            }
            case 8: {
                this.adminPanel.resetAdminLock();
                break;
            }
            case 6: {
                this.adminPanel.addDomain();
                break;
            }
            case 9: {
                this.adminPanel.resetReminder();
                break;
            }
            case 10: {
                this.adminPanel.configurePasswordRequirements();
                break;
            }
        }
    }

    @Override
    public void addTableSelectionListener(ListSelectionListener listener) {
    }

    @Override
    public int getTableSelectedItem() {
        return 0;
    }

    @Override
    public List<List<TaskObject>> getTaskList(TreeItem item) {
        SemAdministrator semAdmin = DataobjectManager.getInstance().getCurrentAdministrator();
        AdminObject adminObj = new AdminObject(semAdmin);
        ArrayList<List<TaskObject>> taskList = new ArrayList<List<TaskObject>>();
        if (item instanceof AdminObject) {
            ArrayList<TaskObject> secondList;
            ArrayList<TaskObject> firstList;
            boolean isVipAuthMethod;
            AdminObject selectedAdminObj = (AdminObject)item;
            boolean isDefAuthMethod = selectedAdminObj.getAuthenticationMethod().intValue() == SemAdministrator.DEFAULT.intValue();
            boolean bl = isVipAuthMethod = selectedAdminObj.getAuthenticationMethod().intValue() == SemAdministrator.VIP.intValue();
            if (adminObj.isSysAdmin()) {
                firstList = new ArrayList<TaskObject>();
                if (!LIC_OBJ.isSBProduct()) {
                    firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.rename"), 2, this.renameIcon));
                    if (isDefAuthMethod || isVipAuthMethod) {
                        firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.setPassword"), 7, this.pwdIcon));
                    }
                }
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.editProperties"), 1, this.editAdminIcon));
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.delete"), 3, this.deleteIcon));
                taskList.add(firstList);
                secondList = new ArrayList<TaskObject>();
                secondList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.add_new_admin"), 4, this.addAdminIcon));
                secondList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.configure_password_requirements"), 10, this.configIcon));
                taskList.add(secondList);
            } else if (adminObj.isDomainSysAdmin()) {
                firstList = new ArrayList();
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.rename"), 2, this.renameIcon));
                if (isDefAuthMethod || isVipAuthMethod) {
                    firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.setPassword"), 7, this.pwdIcon));
                }
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.editProperties"), 1, this.editAdminIcon));
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.delete"), 3, this.deleteIcon));
                taskList.add(firstList);
                secondList = new ArrayList();
                secondList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.add_new_admin"), 5, this.addAdminIcon));
                taskList.add(secondList);
            } else {
                firstList = new ArrayList();
                if (!LIC_OBJ.isSBProduct() && (isDefAuthMethod || isVipAuthMethod)) {
                    firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.setPassword"), 7, this.pwdIcon));
                }
                firstList.add(new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.editProperties"), 1, this.editAdminIcon));
                taskList.add(firstList);
            }
            TaskObject unlockAction = new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.resetAccountLock"), 8, this.unlockIcon);
            TaskObject resetReminderAction = new TaskObject(MRS.getString("com.sygate.scm.console.ui.admin.admin", "AdmStatusPanel.resetPolicyCopyReminder"), 9, this.resetReminderIcon);
            AdminObject admObj = (AdminObject)item;
            if (AdminHandler.isAdminLocked(admObj)) {
                this.addTaskIntoFirstList(unlockAction, taskList);
            } else {
                this.removeTaskFromFirstList(unlockAction, taskList);
            }
            if (Manager.isCurrentAdmin(admObj.getId()) && admObj.isDisableCopyPolicyReminder()) {
                this.addTaskIntoFirstList(resetReminderAction, taskList);
            } else {
                this.removeTaskFromFirstList(resetReminderAction, taskList);
            }
        }
        return taskList;
    }

    private void addTaskIntoFirstList(TaskObject task, List<List<TaskObject>> taskList) {
        if (taskList == null) {
            return;
        }
        List<TaskObject> firstList = taskList.get(0);
        if (firstList != null && !firstList.contains(task)) {
            firstList.add(task);
        }
    }

    private void removeTaskFromFirstList(TaskObject task, List<List<TaskObject>> taskList) {
        if (taskList == null) {
            return;
        }
        List<TaskObject> firstList = taskList.get(0);
        if (firstList != null && firstList.contains(task)) {
            firstList.remove(task);
        }
    }
}

