/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.ConsoleMain;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SmartCardStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final MessageResourcesFile MSG_RES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");
    private static final int IMAGE_SIZE = 24;
    private static final int IMAGE_TEXT_GAP = 2;
    JLabel iconStatusRunning = new JLabel(MSG_RES.getString("SmartCard.validation.status.running"), new ImageIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("Terra_2_sec_48.gif"))).getImage().getScaledInstance(24, 24, 1)), 10);
    JLabel iconStatusFailed = new JLabel(MSG_RES.getString("SmartCard.validation.status.failed"), new ImageIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("status_bad_48-2.png"))).getImage().getScaledInstance(24, 24, 1)), 10);
    JLabel iconStatusSucceeded = new JLabel(MSG_RES.getString("SmartCard.validation.status.succeeded"), new ImageIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("status_good_48-2.png"))).getImage().getScaledInstance(24, 24, 1)), 10);

    public SmartCardStatusPanel() {
        this.jbInit();
        this.updateStatus(Status.NONE);
    }

    public void jbInit() {
        this.iconStatusRunning.setOpaque(false);
        this.iconStatusFailed.setOpaque(false);
        this.iconStatusSucceeded.setOpaque(false);
        this.iconStatusRunning.setIconTextGap(2);
        this.iconStatusFailed.setIconTextGap(2);
        this.iconStatusSucceeded.setIconTextGap(2);
        int indexY = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.iconStatusRunning, new GridBagConstraints(0, indexY, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.iconStatusFailed, new GridBagConstraints(0, indexY++, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.iconStatusSucceeded, new GridBagConstraints(0, indexY, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void updateStatus(Status status) {
        this.iconStatusRunning.setVisible(false);
        this.iconStatusFailed.setVisible(false);
        this.iconStatusSucceeded.setVisible(false);
        if (status == Status.RUNNING) {
            this.iconStatusRunning.setVisible(true);
        }
        if (status == Status.FAILED) {
            this.iconStatusFailed.setVisible(true);
        }
        if (status == Status.SUCCEEDED) {
            this.iconStatusSucceeded.setVisible(true);
        }
    }

    public boolean isIconStatusRunningEnabled() {
        return this.iconStatusRunning.isEnabled();
    }

    public boolean isIconStatusFailedEnabled() {
        return this.iconStatusFailed.isEnabled();
    }

    public boolean isIconStatusSucceededEnabled() {
        return this.iconStatusSucceeded.isEnabled();
    }

    public static enum Status {
        NONE,
        RUNNING,
        FAILED,
        SUCCEEDED;

    }
}

