/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;

public class ResetPasswordDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private String username = null;
    private String domainname = null;
    private String serverAddress = null;
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");
    private JEditorPane descPane = null;
    private JLabel usernameLabel = new JLabel(MSGRES.getString("ResetPasswordDialog.username"));
    private JTextField jTFName = new JTextField(30);
    private JLabel domainnameLabel = new JLabel(MSGRES.getString("ResetPasswordDialog.domain"));
    private JTextField jTFDomain = new JTextField(30);
    private JButton jBResetPassword = new JButton(UIText.get(4360));
    private JButton jBCancel = new JButton(UIText.get(512));
    private static String isResetPassword = null;

    public ResetPasswordDlg(String serverAddress, String userName, String domainName) {
        super(Manager.getFrame(), MSGRES.getString("ResetPasswordDialog.title"), true);
        this.serverAddress = serverAddress;
        this.username = userName;
        this.domainname = domainName;
        this.initialize();
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    public ResetPasswordDlg(String userName, String domainName) {
        this("localhost:8443", userName, domainName);
    }

    private void initialize() {
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResetPasswordDlg.this.cancel();
            }
        });
        this.jBResetPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cursor curCursor = ResetPasswordDlg.this.getCursor();
                try {
                    ResetPasswordDlg.this.setCursor(Cursor.getPredefinedCursor(3));
                    ResetPasswordDlg.this.ok();
                }
                finally {
                    ResetPasswordDlg.this.setCursor(curCursor);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        JPanel pwdCancelPanel = new JPanel();
        UIUtilities.layoutButtonPanel(pwdCancelPanel, new JButton[]{this.jBResetPassword, this.jBCancel}, 0, 4, true, false, 2);
        pwdCancelPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        panel.add((Component)this.getBodyTextArea(), "North");
        panel.add((Component)this.getInnerPanel(), "Center");
        panel.add((Component)pwdCancelPanel, "South");
        this.getContentPane().add((Component)panel, "Center");
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBResetPassword);
    }

    private JEditorPane getBodyTextArea() {
        if (this.descPane == null) {
            this.descPane = new JEditorPane();
            this.descPane.setEditable(false);
            this.descPane.setOpaque(false);
            this.descPane.setContentType("text/html");
            if (LicenseObject.getInstance().isSBProduct()) {
                this.descPane.setText(MSGRES.getString("ResetPasswordDialog.SBE.text"));
            } else {
                this.descPane.setText(MSGRES.getString("ResetPasswordDialog.EE.text"));
            }
            this.descPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.descPane;
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.fill = 1;
        constraints.anchor = 13;
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        RestrictedPlainDocument adminNameDoc = new RestrictedPlainDocument(64);
        adminNameDoc.setValidator("\"/\\[]:;|=,+*?<>", false);
        this.jTFName.setDocument(adminNameDoc);
        this.jTFName.setText(this.username);
        panel.add((Component)this.usernameLabel, constraints);
        constraints.gridx = 1;
        panel.add((Component)this.jTFName, constraints);
        if (!LicenseObject.getInstance().isSBProduct()) {
            constraints.gridx = 0;
            constraints.gridy = 1;
            panel.add((Component)this.domainnameLabel, constraints);
            constraints.gridx = 1;
            panel.add((Component)this.jTFDomain, constraints);
            this.jTFDomain.setText(this.domainname);
        }
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add((Component)panel, "East");
        return innerPanel;
    }

    @Override
    protected void commit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isValidate() {
        if (!ResetPasswordDlg.validateAdminName(this.jTFName.getText().trim())) {
            this.jTFName.requestFocus();
            return false;
        }
        try {
            this.username = this.jTFName.getText().trim();
            this.domainname = this.jTFDomain.getText().trim();
            if (this.serverAddress != null && this.serverAddress.trim().length() > 0) {
                if (this.serverAddress.indexOf(58) != -1) {
                    String serverip = this.serverAddress.substring(0, this.serverAddress.indexOf(58));
                    String serverport = this.serverAddress.substring(this.serverAddress.indexOf(58) + 1);
                    Env.setSemServer(serverip);
                    int port = Env.getSEM_PORT();
                    try {
                        port = Integer.parseInt(serverport);
                    }
                    catch (Exception ignore) {
                        port = -1;
                    }
                    Env.setSemServerPort(port);
                } else {
                    Env.setSemServer(this.serverAddress);
                }
            }
            Manager.doResetPassword(this.username, this.domainname, false, false);
            isResetPassword = Boolean.TRUE.toString();
            String description = "";
            description = LicenseObject.getInstance().isSBProduct() ? MSGRES.getString("ResetPasswordDialog.SBE.resetLog") : MSGRES.getString("ResetPasswordDialog.EE.resetLog");
            ConsoleLogger.logAdminEvent(4131, description);
        }
        catch (ConsoleException ex) {
            ConsoleLogger.log(ex);
            String message = null;
            if (ex.getErrorCode() == -2130182144) {
                switch (ex.getMessageId()) {
                    case 186: {
                        Object[] obj = new Object[]{this.username};
                        String str = MSGRES.getString("ResetPasswordDialog.alreadyRequestWithinGivenDuration");
                        message = MessageFormat.format(str, obj);
                        break;
                    }
                    case 184: {
                        message = ex.getMessage();
                        isResetPassword = Boolean.FALSE.toString();
                        UIUtilities.showErrorDialog(message);
                        boolean obj = true;
                        return obj;
                    }
                }
            } else if (0x10020000 == ex.getErrorCode()) {
                String str = ex.getMessage();
                Object[] obj = new Object[]{Env.getSEM_SERVER()};
                message = MessageFormat.format(str, obj);
            }
            if (message != null) {
                UIUtilities.showErrorDialog(message);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            GUIManager.stopAllBackgroupThreads();
        }
        UIUtilities.showInfoDialog(LicenseObject.getInstance().isSBProduct() ? MSGRES.getString("ResetPasswordDialog.SBE.message") : MSGRES.getString("ResetPasswordDialog.EE.message"));
        return true;
    }

    @Override
    protected boolean ok() {
        if (super.ok()) {
            // empty if block
        }
        return true;
    }

    public static boolean validateAdminName(String adminName) {
        String errorMsg = null;
        if (adminName == null || adminName.length() == 0) {
            errorMsg = MSGRES.getString("ResetPasswordDialog.error.enterUserName");
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MSGRES.getString("ResetPasswordDialog.error"), 0);
            return false;
        }
        try {
            AdminHandler.validateAdminName(adminName);
            return true;
        }
        catch (ConsoleException ex) {
            errorMsg = ex.getMessageString();
            JOptionPane.showMessageDialog(Manager.getFrame(), errorMsg, MSGRES.getString("ResetPasswordDialog.error"), 0);
            return false;
        }
    }

    JButton getJBResetPassword() {
        return this.jBResetPassword;
    }

    public String getIsResetPassword() {
        return isResetPassword;
    }
}

