/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.acl.AuthorizationManager;
import com.sygate.scm.common.acl.Permission;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.rpc.LicenseStatusInfo;
import com.sygate.scm.common.configobject.schema.License;
import com.sygate.scm.common.configobject.schema.LuDownloadedContentArray;
import com.sygate.scm.common.configobject.schema.LuState;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.configobject.schema.SemSiteArray;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.license.LicenseUtils;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.DateTimeManager;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.LicenseHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.SemClientAgentHandler;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.SiteObject;
import com.sygate.scm.console.logicobject.TrialwareLicenseObject;
import com.sygate.scm.console.logicobject.UpgradeLicenseObject;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationHandler;
import com.sygate.scm.console.ui.admin.iplLicense.LicenseActivationWizardDialog;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.policy.lu.LuDownloadNowDlg;
import com.sygate.scm.console.ui.policy.lu.LuDownloadStatusDlg;
import com.sygate.scm.console.ui.policy.lu.LuUtility;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.ImageLabel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class QuickStartDialog
extends JDialog {
    static final String PRODUCT_TOUR_ICON_JPG = "productTourIcon.jpg";
    static final String CLIENT_INSTALLATION_ICON_JPG = "clientInstallationIcon.jpg";
    static final String LICENSE_STATUS_ICON_JPG = "licenseStatusIcon.jpg";
    static final String WARNING_LICENSE_STATUS_ICON_JPG = "license_alert_icon.gif";
    static final String LIVE_UPDATE_ICON_JPG = "liveUpdateIcon.jpg";
    static final String YELLOW_ALERT_GIF = "yellow_alert_24.png";
    static final String GREEN_TICK_GIF = "status_good_48.png";
    static final String MOVE_CLIENT_BETWEEN_GROUP_JPG = "MoveClientBetweenGroups.jpg";
    static final String RUN_COMMAND_ON_GROUP_JPG = "RunCommandOnGroupORclient.jpg";
    static final String RUN_CLOUD_JPG = "cloudSecurityIcon.jpg";
    private ImageIcon tourIcon = this.getImageIcon("productTourIcon.jpg");
    private ImageIcon luIcon = this.getImageIcon("liveUpdateIcon.jpg");
    private ImageIcon licenseIcon = this.getImageIcon("licenseStatusIcon.jpg");
    private ImageIcon deployIcon = this.getImageIcon("clientInstallationIcon.jpg");
    private ImageIcon warningLicenseIcon = this.getImageIcon("license_alert_icon.gif");
    private ImageIcon yellowAlertIcon = this.getImageIcon("yellow_alert_24.png");
    private ImageIcon greenTickIcon = this.getImageIcon("status_good_48.png");
    private ImageIcon moveClientIcon = this.getImageIcon("MoveClientBetweenGroups.jpg");
    private ImageIcon runCommandIcon = this.getImageIcon("RunCommandOnGroupORclient.jpg");
    private ImageIcon runCloudIcon = this.getImageIcon("cloudSecurityIcon.jpg");
    static final int CENTER_PANEL_WIDTH = 604;
    static final int SCROLL_PANE_HEIGHT = 615;
    static final int SCREEN_HEIGHT_OFFSET = 175;
    static final int TOP_INSETS = 12;
    static final int HEADER_TOP_INSETS = 20;
    static final int RIGHT_INSETS = 20;
    static final long serialVersionUID = -3387686087988450725L;
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");
    private JCheckBox hideMeCheckbox = new JCheckBox(MSGRES.getString("WelcomeDialog.dontShowAgain"));
    private JButton btnClose = new JButton(UIText.get(519));
    private JPanel northPanel = null;
    private JPanel centerPanel = null;
    private JPanel quickLaunchCenterPanel = null;
    private JPanel featuresCenterPanel = null;
    private JPanel southPanel = null;
    private static boolean liveUpdateTaskCompleted = false;
    private static boolean clientTaskCompleted = false;
    private static LICENSE_STATE licenseState = LICENSE_STATE.PAIDVALID;
    JPanel tourPanel = null;
    JPanel luPanel = null;
    JPanel licensePanel = null;
    JPanel deployPanel = null;
    JPanel moveClientPanel = null;
    JPanel runCommandsPanel = null;
    JPanel runCloudPanel = null;
    private JLabel luAction1;
    private JLabel recentLuTime;
    private AdminObject currentAdminObject = null;
    private static final String PAGE_NAME = "quickstartdialog";
    private static final String AUTOMATION_LABEL_WELCOME_PRODUCT = "welcomeProduct";
    private static final String AUTOMATION_BUTTON_CLOSE = "close";
    private static final int MAX_FEATURES_WITH_TASKS = 4;

    public QuickStartDialog() {
        this(Manager.getFrame(), "", true);
    }

    public QuickStartDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.setUndecorated(true);
        this.initialize(parent);
    }

    public void initialize(JFrame parent) {
        if (this.currentAdminObject == null) {
            this.currentAdminObject = new AdminObject(DataobjectManager.getInstance().getCurrentAdministrator(false));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(CustomLookAndFeel.UNDECORATED_DIALOG_BORDER);
        this.getContentPane().setLayout(new BorderLayout());
        this.northPanel = this.getBannerPanel();
        boolean requiredTasksPending = QuickStartDialog.hasAnyRequiredTasksPending();
        this.centerPanel = this.getQuickLaunchCenterPanel();
        panel.add((Component)this.northPanel, "North");
        this.addQuickStartDialogCentralPanel(panel, this.centerPanel);
        this.southPanel = this.getBottomPanel(requiredTasksPending);
        panel.add((Component)this.southPanel, "South");
        this.getContentPane().add(panel);
        this.pack();
        UiUtilities.centerComponentInMultiGraphicsDevice((Component)this, (Container)parent);
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> this.getRootPane().setWindowDecorationStyle(0));
    }

    private void addQuickStartDialogCentralPanel(JPanel panel, JPanel centerPanel) {
        JScrollPane scrollablePaneCenterPanel = new JScrollPane(centerPanel);
        scrollablePaneCenterPanel.setBorder(BorderFactory.createEmptyBorder());
        Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
        int scrollPaneHeight = Math.min(615, screenResolution.height - 175);
        scrollablePaneCenterPanel.setHorizontalScrollBarPolicy(31);
        scrollablePaneCenterPanel.setVerticalScrollBarPolicy(20);
        scrollablePaneCenterPanel.setPreferredSize(new Dimension(604, scrollPaneHeight));
        JScrollBar scrollablePaneCerticalScrollBar = scrollablePaneCenterPanel.getVerticalScrollBar();
        scrollablePaneCerticalScrollBar.setValue(scrollablePaneCerticalScrollBar.getMinimum());
        panel.add((Component)scrollablePaneCenterPanel, "Center");
    }

    public static boolean hasAnyRequiredTasksPending() {
        boolean requiredTasksPending = true;
        if (QuickStartDialog.isUnknownLicenseState()) {
            licenseState = LICENSE_STATE.UNKNOWN;
        } else if (QuickStartDialog.isLicenseExpired()) {
            licenseState = LICENSE_STATE.EXPIRED;
        } else {
            LicenseStatusInfo licenseStatusInfo = QuickStartDialog.getLicenseStatusInfo();
            if (licenseStatusInfo == null) {
                licenseState = LICENSE_STATE.NOSTATUS;
            } else if (QuickStartDialog.isPaidLicenseState(licenseStatusInfo)) {
                if (licenseStatusInfo.getoverdeployedCount() != null && licenseStatusInfo.getoverdeployedCount() > 0) {
                    licenseState = LICENSE_STATE.OVERDEPLOYED;
                } else {
                    licenseState = LICENSE_STATE.PAIDVALID;
                    requiredTasksPending = false;
                }
            } else {
                licenseState = LICENSE_STATE.NOTPAID;
            }
        }
        liveUpdateTaskCompleted = QuickStartDialog.isLiveUpdateTaskCompleted();
        if (!liveUpdateTaskCompleted) {
            requiredTasksPending = true;
        }
        if (!(clientTaskCompleted = QuickStartDialog.hasAnyValidClient())) {
            requiredTasksPending = true;
        }
        return requiredTasksPending;
    }

    private JTextPane getTextPanelInBanner() {
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setOpaque(false);
        textPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        UIUtilities.setName(textPane, PAGE_NAME, UIUtilities.ComponentType.TEXTPANE, AUTOMATION_LABEL_WELCOME_PRODUCT);
        StyledDocument doc = textPane.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, UIFontUtilities.STANDARD_FONT_NAME);
        Style regular = doc.addStyle("regular", def);
        Style style = doc.addStyle("fontSize1", regular);
        StyleConstants.setBold(style, true);
        StyleConstants.setFontSize(style, UIFontUtilities.QUICKSTART_FONT_SIZE1);
        style = doc.addStyle("fontSize2", regular);
        StyleConstants.setBold(style, false);
        StyleConstants.setFontSize(style, UIFontUtilities.QUICKSTART_FONT_SIZE1);
        String welcomeToProductHeader = MSGRES.getString("QuickStartDialog.title.welcomeToProduct.header");
        String welcomeToProductSubHeader = MSGRES.getString("QuickStartDialog.title.welcomeToProduct.subheader");
        String product = LicenseObject.getInstance().getProductDisplayName();
        try {
            doc.insertString(doc.getLength(), welcomeToProductHeader + "\n", doc.getStyle("fontSize1"));
            doc.insertString(doc.getLength(), MessageFormat.format(welcomeToProductSubHeader, product), doc.getStyle("fontSize2"));
        }
        catch (BadLocationException ble) {
            LoggerUtilities.logException((Throwable)ble);
        }
        return textPane;
    }

    private JPanel getBannerPanel() {
        this.northPanel = new JPanel();
        this.northPanel.setBackground(UIColorUtilities.BANNER_BACKGROUND);
        this.northPanel.setLayout(new GridBagLayout());
        this.northPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 15, 15));
        this.northPanel.add((Component)new JLabel(ConsoleMain.symantecLogoIcon), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.northPanel;
    }

    private JPanel getLUPanel() {
        if (this.luPanel == null) {
            this.luPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.luIcon);
            imgLabel.getAccessibleContext().setAccessibleName(MSGRES.getString("QuickStartDialog.statusLURunNow"));
            JLabel desc2 = new JLabel(MSGRES.getString("QuickStartDialog.statusLUDesc2"));
            this.recentLuTime = new JLabel(MSGRES.getString("QuickStartDialog.statusLastDownload"));
            JPanel labelPnl = new JPanel(new FlowLayout(0, 0, 0));
            labelPnl.add(desc2);
            labelPnl.add(this.recentLuTime);
            JPanel context = new JPanel(new GridBagLayout());
            context.add((Component)labelPnl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.luAction1 = this.getLiveUpdateAction();
            context.add((Component)this.luAction1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.luPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.luPanel.add((Component)context, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
            ImageLabel statusLabel = null;
            if (liveUpdateTaskCompleted) {
                statusLabel = new ImageLabel(this.greenTickIcon);
                statusLabel.getAccessibleContext().setAccessibleName(MSGRES.getString("QuickStartDialog.complete"));
            } else {
                statusLabel = new ImageLabel(this.yellowAlertIcon);
                statusLabel.getAccessibleContext().setAccessibleName(MSGRES.getString("QuickStartDialog.notComplete"));
            }
            this.luPanel.add((Component)statusLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.luPanel.repaint();
        }
        return this.luPanel;
    }

    private static boolean isLiveUpdateTaskCompleted() {
        boolean liveUpdateTaskCompletedSuccessfully = false;
        boolean liveUpdateTaskHasRun = !StringUtilities.isEmpty((String)QuickStartDialog.getLULastUpdatedTime());
        boolean bl = liveUpdateTaskCompletedSuccessfully = liveUpdateTaskHasRun && QuickStartDialog.isLUDownloadedContentArrayContainingAtleastOneEntry();
        if (!liveUpdateTaskCompletedSuccessfully) {
            System.out.println("QuickstartDialog> isLiveUpdateTaskCompleted>> LU is not completed, checking any client has any security content...");
            liveUpdateTaskCompletedSuccessfully = QuickStartDialog.hasAnyClientWithLUContent();
        }
        return liveUpdateTaskCompletedSuccessfully;
    }

    private static boolean isLUDownloadedContentArrayContainingAtleastOneEntry() {
        LuDownloadedContentArray luContentArray = LuUtility.getLuDownloadedContentArray();
        System.out.println("QuickstartDialog> isLUDownloadedContentArrayContainingAtleastOneEntry>> Is luContentArray null: " + (luContentArray == null));
        return luContentArray != null && luContentArray.getLuDownloadedContent().size() > 1;
    }

    private JLabel getLiveUpdateAction() {
        this.luAction1 = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.statusLURunNow"));
        this.luAction1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!QuickStartDialog.this.luAction1.isEnabled()) {
                    return;
                }
                QuickStartDialog.this.downloadLuContents();
            }
        });
        return this.luAction1;
    }

    private void updateLUStatus() {
        this.luAction1.setEnabled(true);
        String luLastUpdatedTime = QuickStartDialog.getLULastUpdatedTime();
        if (!StringUtilities.isEmpty((String)luLastUpdatedTime)) {
            if (QuickStartDialog.isLUDownloadedContentArrayContainingAtleastOneEntry()) {
                this.recentLuTime.setText(luLastUpdatedTime);
            } else {
                this.recentLuTime.setText(MSGRES.getString("QuickStartDialog.statusLastDownload"));
            }
            this.getLUPanel().repaint();
        }
    }

    private static String getLULastUpdatedTime() {
        String lastUpdatedTimeString = null;
        LuState state = GUIManager.getCurrentLuState();
        if (state != null) {
            Long lastUpdateTime = state.getLastUpdateTime();
            if (!Long.valueOf(0L).equals(state.getLastUpdateTime())) {
                Date lastUpdateDate = new Date(lastUpdateTime);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
                lastUpdatedTimeString = dateFormat.format(lastUpdateDate);
            }
        }
        return lastUpdatedTimeString;
    }

    public static SiteObject getSiteObject() throws ConsoleException {
        DataobjectManager data = DataobjectManager.getInstance();
        SemConfigRoot configRoot = data.getSemConfigRoot();
        SemSiteArray siteArray = configRoot.getSemSiteArray();
        ObjReference objReference = siteArray.getObjReference(0);
        SemSite semSite = (SemSite)data.getObjectByGUID("SemSite", objReference.getTargetId());
        SiteObject siteObject = new SiteObject(semSite);
        return siteObject;
    }

    public void updateSite(SemSite currentSite) {
        block2: {
            try {
                DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)currentSite);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.server.server", "ServersPanel.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private JLabel getToolBarButton(String text) {
        HtmlEnabledJLabel link = new HtmlEnabledJLabel(text, true);
        return link;
    }

    private JLabel getToolBarButtonForGettingStarted(String text) {
        HtmlEnabledJLabel link = new HtmlEnabledJLabel(text, true);
        link.setFont(UIFontUtilities.QUICK_START_LINK_FONT);
        return link;
    }

    private JPanel getTourPanel() {
        if (this.tourPanel == null) {
            this.tourPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.tourIcon);
            JPanel context = new JPanel(new GridBagLayout());
            JLabel action1 = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.statusProductTourStart"));
            action1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    QuickStartDialog.this.takeTour();
                }
            });
            context.add((Component)action1, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.tourPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.tourPanel.add((Component)context, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        }
        return this.tourPanel;
    }

    private static boolean isLicenseExpired() {
        Boolean licenseExpired = null;
        try {
            DataobjectManager dataobjectManager = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = dataobjectManager.getSemConfigRoot();
            License license = semConfigRoot.getLicense();
            if (license != null) {
                licenseExpired = license.getOptLicenseExpired();
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        System.out.println("WelcomeDialog>> isLicenseExpired licenseExpired: " + licenseExpired);
        return licenseExpired != null && licenseExpired != false;
    }

    private static boolean isPaidLicenseState(LicenseStatusInfo licenseStatusInfo) {
        boolean isPaidLicense = false;
        if (licenseStatusInfo != null) {
            String licenseStateString = licenseStatusInfo.getlicenseState();
            isPaidLicense = !StringUtilities.isEmpty((String)licenseStateString) && licenseStateString.toUpperCase().endsWith("PAID");
        }
        return isPaidLicense;
    }

    private static LicenseStatusInfo getLicenseStatusInfo() {
        LicenseStatusInfo licenseStatusInfo = null;
        try {
            licenseStatusInfo = LicenseHandler.getLicenseStatusForSAV();
            if (licenseStatusInfo == null) {
                licenseStatusInfo = LicenseHandler.getLicenseStatusForSNAC();
            }
        }
        catch (ConsoleException e1) {
            ConsoleLogger.log(e1);
        }
        return licenseStatusInfo;
    }

    private static boolean isUnknownLicenseState() {
        try {
            return LicenseActivationHandler.isUnknownLicenseState();
        }
        catch (ConsoleException e1) {
            ConsoleLogger.log(e1);
            return false;
        }
    }

    private JLabel getLicenseAction() {
        JLabel licenseAction1 = null;
        if (QuickStartDialog.isUnknownLicenseState()) {
            return null;
        }
        licenseAction1 = QuickStartDialog.isPaidLicenseState(QuickStartDialog.getLicenseStatusInfo()) ? this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.statusAddNewLicense")) : this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.statusLicenseActivation"));
        licenseAction1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                LicenseActivationWizardDialog dlg;
                if (LicenseActivationHandler.checkLicenseValidState(QuickStartDialog.this) && (dlg = new LicenseActivationWizardDialog()).getisOk()) {
                    QuickStartDialog.this.getContentPane().removeAll();
                    QuickStartDialog.this.quickLaunchCenterPanel = null;
                    QuickStartDialog.this.featuresCenterPanel = null;
                    QuickStartDialog.this.licensePanel = null;
                    QuickStartDialog.this.initialize(Manager.getFrame());
                }
            }
        });
        return licenseAction1;
    }

    private JPanel getLicensePanel() {
        if (this.licensePanel == null) {
            this.licensePanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = null;
            String licenseDescString = "";
            ImageLabel statusLabel = null;
            imgLabel = new ImageLabel(this.warningLicenseIcon);
            statusLabel = new ImageLabel(this.yellowAlertIcon);
            switch (licenseState) {
                case UNKNOWN: {
                    System.out.println("WelcomeDialog> getLicensePanel>> License state is unknown. licenseState: " + licenseState);
                    licenseDescString = MSGRES.getString("QuickStartDialog.licenseUnknownStatusMessage");
                    break;
                }
                case NOSTATUS: {
                    System.out.println("WelcomeDialog> getLicensePanel>> No License status found. licenseState: " + licenseState);
                    licenseDescString = MSGRES.getString("QuickStartDialog.licenseUnknownStatusMessage");
                    break;
                }
                case NOTPAID: {
                    System.out.println("WelcomeDialog> getLicensePanel>> License state is either trial or upgrade(non-paid). licenseState: " + licenseState);
                    licenseDescString = this.getLicenseExpirationDateString();
                    break;
                }
                case OVERDEPLOYED: {
                    System.out.println("WelcomeDialog> getLicensePanel>> License state is over deployed. licenseState: " + licenseState);
                    licenseDescString = MSGRES.getString("QuickStartDialog.licenseOverDeployedMessage");
                    break;
                }
                case EXPIRED: {
                    System.out.println("WelcomeDialog> getLicensePanel>> License is expired. licenseState: " + licenseState);
                    licenseDescString = MSGRES.getString("QuickStartDialog.licenseExpiredMessage");
                    break;
                }
                default: {
                    imgLabel = new ImageLabel(this.licenseIcon);
                    licenseDescString = MSGRES.getString("QuickStartDialog.licenseOKMessage");
                    statusLabel = new ImageLabel(this.greenTickIcon);
                }
            }
            JPanel context = new JPanel(new GridBagLayout());
            DescriptionTextArea licenseDesc = new DescriptionTextArea(licenseDescString, 50);
            context.add((Component)licenseDesc, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JLabel licenseAction = this.getLicenseAction();
            if (licenseAction != null) {
                context.add((Component)licenseAction, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                imgLabel.getAccessibleContext().setAccessibleName(licenseAction.getText());
            }
            this.licensePanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.licensePanel.add((Component)context, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
            statusLabel.getAccessibleContext().setAccessibleName(licenseDescString);
            this.licensePanel.add((Component)statusLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.licensePanel.repaint();
        }
        return this.licensePanel;
    }

    private JPanel getDeploymentPanel() {
        if (this.deployPanel == null) {
            this.deployPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.deployIcon);
            JPanel context = new JPanel(new GridBagLayout());
            JLabel deploymentAction = this.getDeploymentAction();
            context.add((Component)deploymentAction, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            imgLabel.getAccessibleContext().setAccessibleName(deploymentAction.getText());
            this.deployPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.deployPanel.add((Component)context, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
            ImageLabel statusLabel = null;
            if (clientTaskCompleted) {
                statusLabel = new ImageLabel(this.greenTickIcon);
                statusLabel.getAccessibleContext().setAccessibleName(MSGRES.getString("QuickStartDialog.complete"));
            } else {
                statusLabel = new ImageLabel(this.yellowAlertIcon);
                statusLabel.getAccessibleContext().setAccessibleName(MSGRES.getString("QuickStartDialog.notComplete"));
            }
            this.deployPanel.add((Component)statusLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.deployPanel.repaint();
        }
        return this.deployPanel;
    }

    private static boolean hasAnyClientWithLUContent() {
        boolean hasAnyClientWithLiveUpdateContent = false;
        try {
            int agentCount = SemClientAgentHandler.getOnlineOrOfflineClientWithLUContent();
            System.out.println("WelcomeDialog>> hasAnyClientWithLUContent agentCount: " + agentCount);
            hasAnyClientWithLiveUpdateContent = agentCount > 0;
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return hasAnyClientWithLiveUpdateContent;
    }

    private static boolean hasAnyValidClient() {
        boolean hasAtleastOneValidClientDeployed = false;
        try {
            int agentCount = SemClientAgentHandler.getOnlineOrOfflineClientCount();
            System.out.println("WelcomeDialog>> hasAnyValidClient agentCount: " + agentCount);
            hasAtleastOneValidClientDeployed = agentCount > 0;
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return hasAtleastOneValidClientDeployed;
    }

    private JLabel getDeploymentAction() {
        JLabel deployAction = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.statusClientInstallLaunch"));
        deployAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                InstallClientWizardDialog dlg = new InstallClientWizardDialog(false);
                if (dlg.getisOk()) {
                    QuickStartDialog.this.getContentPane().removeAll();
                    QuickStartDialog.this.quickLaunchCenterPanel = null;
                    QuickStartDialog.this.featuresCenterPanel = null;
                    QuickStartDialog.this.deployPanel = null;
                    QuickStartDialog.this.initialize(Manager.getFrame());
                }
            }
        });
        return deployAction;
    }

    private void getRunCloudPanel() {
        if (this.runCloudPanel == null) {
            this.runCloudPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.runCloudIcon);
            JPanel context = new JPanel(new GridBagLayout());
            JLabel action1 = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.commonTaskRunCloud"));
            action1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    QuickStartDialog.this.dispose();
                    MainPanel mainPanel = (MainPanel)Manager.getFrame().getPanel();
                    mainPanel.setCurrentPanel("5ee0505f9a5149f492f399e91f93c95b", -1);
                }
            });
            context.add((Component)action1, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.runCloudPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.runCloudPanel.add((Component)context, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        }
    }

    private void getMoveClientsPane() {
        if (this.moveClientPanel == null) {
            this.moveClientPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.moveClientIcon);
            JPanel context = new JPanel(new GridBagLayout());
            JLabel action1 = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.commonTaskMoveClients"));
            action1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    HelpUtil.showHelpOrErrDlg("sesm_gs_common_task_move_clients");
                }
            });
            context.add((Component)action1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.moveClientPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.moveClientPanel.add((Component)context, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        }
    }

    private void getRunCommandsPane() {
        if (this.runCommandsPanel == null) {
            this.runCommandsPanel = new JPanel(new GridBagLayout());
            ImageLabel imgLabel = new ImageLabel(this.runCommandIcon);
            JPanel context = new JPanel(new GridBagLayout());
            JLabel action1 = this.getToolBarButtonForGettingStarted(MSGRES.getString("QuickStartDialog.commonTaskRunCommands"));
            action1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    HelpUtil.showHelpOrErrDlg("sesm_gs_common_task_run_command");
                }
            });
            context.add((Component)action1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.runCommandsPanel.add((Component)imgLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.runCommandsPanel.add((Component)context, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 0), 0, 0));
        }
    }

    private JPanel getQuickLaunchCenterPanel() {
        if (this.quickLaunchCenterPanel == null) {
            this.quickLaunchCenterPanel = new JPanel(new GridBagLayout());
        }
        this.quickLaunchCenterPanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 20));
        this.tourPanel = this.getTourPanel();
        int verticalIndex = -1;
        JTextPane jtp = this.getTextPanelInBanner();
        this.quickLaunchCenterPanel.add((Component)jtp, UiUtilities.getGridBagConstraints((int)0, (int)(++verticalIndex), (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0));
        verticalIndex = this.getRequiredTasksPanel(this.quickLaunchCenterPanel, verticalIndex);
        DescriptionTextArea header2 = new DescriptionTextArea(MSGRES.getString("QuickStartDialog.statusCommonTask"), true);
        this.quickLaunchCenterPanel.add((Component)header2, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        JLabel headerDesc = new JLabel(MSGRES.getString("QuickStartDialog.statusCommonTaskDesc"));
        this.quickLaunchCenterPanel.add((Component)headerDesc, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.currentAdminObject.isSysAdmin()) {
            this.getRunCloudPanel();
            this.quickLaunchCenterPanel.add((Component)this.runCloudPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        }
        this.getMoveClientsPane();
        this.getRunCommandsPane();
        this.quickLaunchCenterPanel.add((Component)this.moveClientPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.quickLaunchCenterPanel.add((Component)this.runCommandsPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        DescriptionTextArea header3 = new DescriptionTextArea(MSGRES.getString("QuickStartDialog.learnAboutTheProduct"), true);
        this.quickLaunchCenterPanel.add((Component)header3, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.quickLaunchCenterPanel.add((Component)this.tourPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 12, 0), 0, 0));
        return this.quickLaunchCenterPanel;
    }

    private int getRequiredTasksPanel(JPanel requiredTasksPanel, int verticalIndex) {
        boolean addClientDeployPanel;
        this.luPanel = this.getLUPanel();
        this.licensePanel = this.getLicensePanel();
        this.deployPanel = this.getDeploymentPanel();
        boolean addLUPanel = AdminPrivilegeObject.isCurrentAdminHasPolicyTypePrivilege("0x26") && AdminPrivilegeObject.isCurrentAdminHasRightToLocalSite() == 0;
        boolean addLicensePanel = this.currentAdminObject.isSysAdmin();
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        boolean bl = addClientDeployPanel = this.currentAdminObject.hasGroupFullAccessRight() && AuthorizationManager.getInstance().checkPermission(context, (Permission)AuthorizationManager.PackagePermission.FULL_ACCESS);
        if (addLUPanel || addLicensePanel || addClientDeployPanel) {
            DescriptionTextArea header1 = new DescriptionTextArea(MSGRES.getString("QuickStartDialog.statusRequireTask"), true);
            requiredTasksPanel.add((Component)header1, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(20, 0, 0, 0), 0, 0));
            JLabel headerDesc = new JLabel(MSGRES.getString("QuickStartDialog.statusRequireTaskDesc"));
            requiredTasksPanel.add((Component)headerDesc, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (addLUPanel) {
            this.updateLUStatus();
            requiredTasksPanel.add((Component)this.luPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        }
        if (addLicensePanel) {
            requiredTasksPanel.add((Component)this.licensePanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        }
        if (addClientDeployPanel) {
            requiredTasksPanel.add((Component)this.deployPanel, new GridBagConstraints(0, ++verticalIndex, 1, 1, 1.0, 1.0, 17, 2, new Insets(12, 0, 0, 0), 0, 0));
        }
        return verticalIndex;
    }

    private JPanel getBottomPanel(boolean requiredTasksPending) {
        JPanel panel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics grpcs) {
                Graphics2D g2 = (Graphics2D)grpcs.create();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), Color.LIGHT_GRAY);
                g2.setPaint(gradient);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        panel.setLayout(new BorderLayout());
        panel.setOpaque(true);
        this.hideMeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AdminHandler.refreshCurrentAdmin();
                    AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                    admin.setAdminLoggedIn(QuickStartDialog.this.hideMeCheckbox.isSelected());
                    admin.setDisabledCIWReminder(QuickStartDialog.this.hideMeCheckbox.isSelected());
                    if (QuickStartDialog.this.hideMeCheckbox.isSelected()) {
                        String currentServerVersion = ScmProperties.get("scm.server.version", null);
                        admin.setAdminViewedVersion(currentServerVersion);
                    } else {
                        admin.setAdminViewedVersion(null);
                    }
                    AdminHandler.updateAdmin(admin);
                }
                catch (ConsoleException ex) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("WelcomeDialog.error"), 0);
                }
                catch (Exception ex) {
                    System.out.println("WelcomeDialog> getBottomPanel>> checbox: Exception: " + ex.getMessage());
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        });
        this.hideMeCheckbox.setSelected(this.isCheckboxSelected());
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.btnClose);
        UIUtilities.setName(this.btnClose, PAGE_NAME, UIUtilities.ComponentType.BUTTON, AUTOMATION_BUTTON_CLOSE);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                QuickStartDialog.this.dispose();
            }
        });
        JSeparator js = new JSeparator();
        panel.add((Component)js, "North");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        panel.add((Component)buttonPanel, "Center");
        AjaxSwingCommonUtil.executeOneBasedOnWebConsoleRunning(() -> buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 15, 25, 15)), () -> buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15)));
        buttonPanel.setOpaque(true);
        if (!requiredTasksPending) {
            buttonPanel.add((Component)this.hideMeCheckbox, "West");
        }
        buttonPanel.add((Component)this.btnClose, "East");
        return panel;
    }

    private boolean isCheckboxSelected() {
        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
        String adminViewedVersion = admin.getAdminViewedVersion();
        if (null == adminViewedVersion || adminViewedVersion.isEmpty()) {
            return false;
        }
        if (Utility.compareVersion((String)ScmProperties.get("scm.server.version", null), (String)admin.getAdminViewedVersion()) == 1) {
            return false;
        }
        return admin.getDisabledCIWReminder();
    }

    private void downloadLuContents() {
        this.luAction1.setEnabled(false);
        LuDownloadNowDlg dlg = new LuDownloadNowDlg(Manager.getFrame(), "", true);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            ServerSystemLogMonitor.getLuStatusMonitor().setMonitorStartTime(TimeUtil.getServerTime());
            try {
                GUIManager.runLuNow();
            }
            catch (ConsoleException ce) {
                LoggerUtilities.logException((Throwable)ce);
            }
            this.getContentPane().removeAll();
            this.quickLaunchCenterPanel = null;
            this.featuresCenterPanel = null;
            this.luPanel = null;
            this.initialize(Manager.getFrame());
            this.showLUStatus();
        } else {
            this.updateLUStatus();
        }
    }

    public void showLUStatus() {
        LuDownloadStatusDlg.showStatus();
    }

    private void takeTour() {
        Cursor curCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_tourEE);
        this.setCursor(curCursor);
    }

    public String getLicenseExpirationDateString() {
        String formatDateString = "";
        try {
            AbstractUIObject license;
            LicenseStatusInfo licenseStatusInfo = LicenseHandler.getLicenseStatusForSAV();
            if (licenseStatusInfo == null) {
                licenseStatusInfo = LicenseHandler.getLicenseStatusForSNAC();
            }
            String licenseStateString = null;
            if (licenseStatusInfo != null) {
                licenseStateString = licenseStatusInfo.getlicenseState();
            }
            if (licenseStateString == null) {
                return "";
            }
            Object dateString = "";
            String desc = "";
            if (licenseStateString.toUpperCase().contains("UPGRADE")) {
                license = LicenseHandler.getUpgradeLicense(true);
                if (license != null) {
                    dateString = LicenseUtils.getDateStrInyyyy((long)((UpgradeLicenseObject)license).getExpireDate()) + " " + DateTimeManager.getLocalTimeZone();
                }
                desc = MSGRES.getString("QuickStartDialog.statusLicenseDesc");
            } else if (licenseStateString.toUpperCase().contains("TRIAL")) {
                license = LicenseHandler.getTrialwareLicense(true);
                if (license != null) {
                    dateString = LicenseUtils.getDateStrInyyyy((long)((TrialwareLicenseObject)license).getExpireDate()) + " " + DateTimeManager.getLocalTimeZone();
                }
                desc = MSGRES.getString("QuickStartDialog.trialStatusLicenseDesc");
            }
            Object[] obj = new Object[]{dateString};
            formatDateString = MessageFormat.format(desc, obj);
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return formatDateString;
    }

    private JLabel getNavigationPanel() {
        final JLabel quickLaunchAction = this.getToolBarButton(MSGRES.getString("QuickStartDialog.showWelcomePage"));
        quickLaunchAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                QuickStartDialog.this.getContentPane().removeAll();
                QuickStartDialog.this.quickLaunchCenterPanel = null;
                QuickStartDialog.this.luPanel = null;
                QuickStartDialog.this.licensePanel = null;
                QuickStartDialog.this.deployPanel = null;
                HtmlEnabledJLabel htmlJLabel = (HtmlEnabledJLabel)quickLaunchAction;
                htmlJLabel.unhighlightLink();
                QuickStartDialog.this.initialize(Manager.getFrame());
            }
        });
        return quickLaunchAction;
    }

    private JPanel getShowAllNewFeaturesPanel() {
        JPanel showAllNewFeatures = new JPanel(new GridBagLayout());
        JLabel showAllNewFeaturesAction = this.getToolBarButton(MSGRES.getString("QuickStartDialog.showAllNewFeatures"));
        showAllNewFeaturesAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_showNewFeaturesUrl);
            }
        });
        showAllNewFeatures.add((Component)showAllNewFeaturesAction, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return showAllNewFeatures;
    }

    private JPanel getWhiteSpacePanel() {
        JPanel whiteSpacePanel = new JPanel(new GridBagLayout());
        DescriptionTextArea whiteSpace = new DescriptionTextArea(" ", false);
        whiteSpacePanel.add((Component)whiteSpace, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return whiteSpacePanel;
    }

    private ImageIcon getImageIcon(String fileName) {
        return new ImageIcon(UiUtilities.loadImage(ConsoleMain.class, (String)fileName));
    }

    static URL getResource(String fileName) {
        return UiUtilities.getResource(ConsoleMain.class, (String)fileName);
    }

    static LICENSE_STATE getLicenseState() {
        return licenseState;
    }

    protected static enum LICENSE_STATE {
        UNKNOWN,
        EXPIRED,
        NOSTATUS,
        NOTPAID,
        OVERDEPLOYED,
        PAIDVALID;

    }
}

