/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.creamtec.ajaxswing.core.FastSubmitHandler;
import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.configobject.schema.AdministratorState;
import com.sygate.scm.common.configobject.schema.I18n;
import com.sygate.scm.common.configobject.schema.I18nString;
import com.sygate.scm.common.configobject.schema.I18nStrings;
import com.sygate.scm.common.configobject.schema.UiAddOnFeatureSet;
import com.sygate.scm.common.configobject.schema.UiAddOnItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.AjaxSwingCommandHandler;
import com.sygate.scm.console.handler.CustomJavascriptHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.AdminStateObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.AboutDialog;
import com.sygate.scm.console.ui.FeedbackMenuBar;
import com.sygate.scm.console.ui.QuickStartDialog;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.client.ClientPanel;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.monitoring.MonitorPanel;
import com.sygate.scm.console.ui.overview.OverviewPanel;
import com.sygate.scm.console.ui.policy.PolicyPanel;
import com.sygate.scm.console.ui.util.HyperlinkPane;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.SystemLevel;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.URLUtility;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;

public class MainPanel
extends JPanel
implements ActionListener,
ContentSensitiveHelpPage {
    private static final long serialVersionUID = -1829595351427570238L;
    private static final int DYNAMIC_IMAGE_STATUS_CHECK_TIMES = 3;
    private static final String AUTOMATION_LOG_OFF = "LogOffWebConsole";
    private static Logger logger = Logger.getLogger(MainPanel.class.getName());
    private static final LicenseObject LIC_OBJ = LicenseObject.getInstance();
    private static final MessageResources MSG_RES = MessageResources.getInstance();
    public static final String OVERVIEW_PANEL_NAME = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.productOverview");
    public static final String HOME_PANEL_KEY = "home";
    public static final String MONITOR_PANEL_KEY = "monitors";
    public static final String POLICY_PANEL_KEY = "policies";
    public static final String COMPANY_PANEL_KEY = "client";
    public static final String SERVER_PANEL_KEY = "server";
    public static final String ADMIN_PANEL_KEY = "admin";
    public static final String REPORT_PANEL_KEY = "reports";
    private static final String DYNAMIC_PANEL_KEY = "dynamic";
    public static final String TAB_INDEX_PROPERTY = "MainPanel.DefaultTabIndex";
    private NavigateButton jBHome;
    private NavigateButton jBMonitor;
    private NavigateButton jBReport;
    private NavigateButton jBPolicy;
    private NavigateButton jBCompany;
    private NavigateButton jBAdmin;
    private List<NavigateButton> jBDynamicButtons;
    private MonitorPanel reportPanel;
    OverviewPanel overviewPanel;
    private MonitorPanel monitorPanel;
    private PolicyPanel policyPanel;
    private ClientPanel clientPanel;
    private AdminPanel adminPanel;
    private List<MonitorPanel> dynamicPanels;
    private JPanel jPButton;
    private JPanel jPCenter = new JPanel(new CardLayout());
    private JLabel sepnewsImageLabel;
    protected Timer sepNewsTimer;
    private HashMap<String, PagePanel> panelMap = new HashMap();
    HashSet<Integer> shortcutKeySet;
    private UiAddOnFeatureSet featureSet;
    private NavigateButtonGroup buttonGroup = new NavigateButtonGroup();
    private static PagePanel currentSelPanel;
    private boolean inProgress = false;
    private JMenuItem helpTopicsMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.helpTopics"));
    private JMenuItem contactSupportMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.contactSupport"));
    private JMenuItem downloadSupportToolMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.downloadSupportTool"));
    private JMenuItem peerToPeerMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.peerToPeerDiscussion"));
    private JMenuItem welcomeScreenMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.welcomeScreen"));
    private JMenuItem whatsNewMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.whatsNewScreen"));
    private JMenuItem aboutMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.about"));
    private JMenuItem logMenuItem = new JMenuItem(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.log"));
    private static final String PAGE_NAME = "mainpanel";
    private static final String WHATS_NEW_URL_TOKEN = "whats-new-all-sep-releases";
    private static MainPanel me;

    public MainPanel() {
        MainPanel.setCurrentSelectedPanel(null);
        ConsoleMain.updateStaticImagesBasedOnCurrentProductType();
        this.featureSet = this.getFeaturesFromDatabase("5eedd6f6cf20750d1460fcc1ab6dd68e");
        this.jBDynamicButtons = new ArrayList<NavigateButton>();
        this.initialize();
        KeyStroke helpKey = KeyStroke.getKeyStroke(112, 0);
        String helpActionKey = "Context-Sensitive Help";
        this.getInputMap(1).put(helpKey, helpActionKey);
        this.getActionMap().put(helpActionKey, new HelpAction());
        MainPanel.setMainPanel(this);
    }

    public PagePanel getAdminPanel() {
        return this.panelMap.get(ADMIN_PANEL_KEY);
    }

    public PagePanel getPagePanel(String keyName) {
        return this.panelMap.get(keyName);
    }

    public static PagePanel getCurrentPanel() {
        return currentSelPanel;
    }

    public static PagePanel getOverviewPanel() {
        return MainPanel.me.panelMap.get(HOME_PANEL_KEY);
    }

    public static MonitorPanel getReportPanel() {
        if (MainPanel.me.reportPanel == null) {
            MainPanel.me.reportPanel = new MonitorPanel(3);
            MainPanel.me.jPCenter.add((Component)MainPanel.me.reportPanel, REPORT_PANEL_KEY);
            MainPanel.me.panelMap.put(REPORT_PANEL_KEY, MainPanel.me.reportPanel);
        }
        return (MonitorPanel)MainPanel.me.panelMap.get(REPORT_PANEL_KEY);
    }

    public synchronized void dispose() {
        if (this.clientPanel != null) {
            logger.info("Cleaning up client panel data.");
            this.clientPanel.cleanUp();
        }
        if (this.sepNewsTimer != null) {
            logger.info("Stopping sep news updater timer.");
            this.sepNewsTimer.stop();
            this.sepNewsTimer = null;
        }
        if (this.monitorPanel != null) {
            this.monitorPanel.disposeBrowser();
        }
        if (this.overviewPanel != null) {
            this.overviewPanel.disposeBrowser();
        }
        if (this.reportPanel != null) {
            this.reportPanel.disposeBrowser();
        }
        for (MonitorPanel dynPanel : this.dynamicPanels) {
            if (dynPanel == null) continue;
            dynPanel.disposeBrowser();
        }
    }

    private void navigateToMonitorPage(int urlChoice, String strParams) {
        if (this.monitorPanel == null) {
            this.monitorPanel = new MonitorPanel(2);
            this.jPCenter.add((Component)this.monitorPanel, MONITOR_PANEL_KEY);
            this.panelMap.put(MONITOR_PANEL_KEY, this.monitorPanel);
        }
        if (this.monitorPanel != null) {
            this.monitorPanel.setNextURL(urlChoice, strParams);
        }
        this.jBMonitor.doClick();
    }

    public void showNotificationLog(String strParams) {
        this.navigateToMonitorPage(1, strParams);
    }

    public void showCommandStatus(String strParams) {
        this.navigateToMonitorPage(2, strParams);
    }

    public void showScanLogs(String strParams) {
        this.navigateToMonitorPage(3, strParams);
    }

    public void showComputerStatus(String strParams) {
        this.navigateToMonitorPage(4, strParams);
    }

    public void showRiskLog(String strParams) {
        this.navigateToMonitorPage(5, strParams);
    }

    public void setCurrentPanel(String panelKey, int id) {
        PagePanel destPanel = null;
        if (panelKey.equals(HOME_PANEL_KEY)) {
            this.jBHome.doClick();
            destPanel = this.overviewPanel;
        } else if (panelKey.equals(MONITOR_PANEL_KEY)) {
            this.jBMonitor.doClick();
            destPanel = this.monitorPanel;
        } else if (panelKey.equals(POLICY_PANEL_KEY)) {
            this.jBPolicy.doClick();
            destPanel = this.policyPanel;
        } else if (panelKey.equals(COMPANY_PANEL_KEY)) {
            this.jBCompany.doClick();
            destPanel = this.clientPanel;
        } else if (panelKey.equals(ADMIN_PANEL_KEY)) {
            this.jBAdmin.doClick();
            destPanel = this.adminPanel;
        } else if (panelKey.equals(REPORT_PANEL_KEY)) {
            this.jBReport.doClick();
            destPanel = this.reportPanel;
        } else if (this.featureSet != null) {
            int enabledTabIndex = -1;
            for (UiAddOnItem addOnItem : this.featureSet.getUiAddOnItem()) {
                MonitorPanel cloudPanel;
                if (!addOnItem.getEnabled().booleanValue()) continue;
                ++enabledTabIndex;
                if (!panelKey.equals(addOnItem.getId())) continue;
                if ("5ee0505f9a5149f492f399e91f93c95b".equals(panelKey) && null != (cloudPanel = this.dynamicPanels.get(enabledTabIndex))) {
                    cloudPanel.selectItemIndex(0);
                }
                this.jBDynamicButtons.get(enabledTabIndex).doClick();
                destPanel = this.dynamicPanels.get(enabledTabIndex);
            }
        }
        if (destPanel != null && id != -1) {
            for (int retry = 0; retry < 10 && currentSelPanel != destPanel; ++retry) {
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (currentSelPanel != null && id != -1) {
            int index = currentSelPanel.getItemIndex(id);
            currentSelPanel.selectItemIndex(index);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.inProgress) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final String panelKey = ((JButton)event.getSource()).getActionCommand();
        final NavigateButton btn = (NavigateButton)event.getSource();
        if (currentSelPanel != null && this.panelMap.get(panelKey) == currentSelPanel && AjaxSwingCommonUtil.isAjaxSwingRunning() && !panelKey.equals(HOME_PANEL_KEY)) {
            return;
        }
        if (panelKey != null) {
            if (panelKey.equals(HOME_PANEL_KEY)) {
                System.setProperty("consoleusecase", "HOMEPAGEVIEW");
            } else if (panelKey.equals(MONITOR_PANEL_KEY)) {
                System.setProperty("consoleusecase", "MONITORTAB");
                if (this.monitorPanel == null) {
                    this.monitorPanel = new MonitorPanel(2);
                    this.jPCenter.add((Component)this.monitorPanel, MONITOR_PANEL_KEY);
                    this.panelMap.put(MONITOR_PANEL_KEY, this.monitorPanel);
                }
            } else if (panelKey.equals(REPORT_PANEL_KEY)) {
                System.setProperty("consoleusecase", "REPORTSTAB");
                if (this.reportPanel == null) {
                    this.reportPanel = new MonitorPanel(3);
                    this.jPCenter.add((Component)this.reportPanel, REPORT_PANEL_KEY);
                    this.panelMap.put(REPORT_PANEL_KEY, this.reportPanel);
                }
            } else if (panelKey.equals(POLICY_PANEL_KEY)) {
                System.setProperty("consoleusecase", "POLICYMANAGEMENT");
                if (this.policyPanel == null) {
                    this.policyPanel = new PolicyPanel();
                    this.jPCenter.add((Component)this.policyPanel, POLICY_PANEL_KEY);
                    this.panelMap.put(POLICY_PANEL_KEY, this.policyPanel);
                }
            } else if (panelKey.equals(COMPANY_PANEL_KEY)) {
                System.setProperty("consoleusecase", "CLIENTMANAGEMENT");
                if (this.clientPanel == null) {
                    this.clientPanel = new ClientPanel();
                    this.jPCenter.add((Component)this.clientPanel, COMPANY_PANEL_KEY);
                    this.panelMap.put(COMPANY_PANEL_KEY, this.clientPanel);
                }
            } else if (panelKey.equals(ADMIN_PANEL_KEY)) {
                System.setProperty("consoleusecase", "ADMINMANAGEMENT");
                if (this.adminPanel == null) {
                    this.adminPanel = new AdminPanel();
                    this.jPCenter.add((Component)this.adminPanel, ADMIN_PANEL_KEY);
                    this.panelMap.put(ADMIN_PANEL_KEY, this.adminPanel);
                }
            }
            if (this.featureSet != null) {
                int enabledTabIndex = -1;
                String isDomainChanged = GUIManager.getDomainChangedStatus();
                for (UiAddOnItem addOnItem : this.featureSet.getUiAddOnItem()) {
                    MonitorPanel dynPanel;
                    if (!addOnItem.getEnabled().booleanValue()) continue;
                    ++enabledTabIndex;
                    if (!panelKey.equals(addOnItem.getId())) continue;
                    this.refreshApiAccessToken();
                    if (this.dynamicPanels.get(enabledTabIndex) == null) {
                        dynPanel = new MonitorPanel(5, addOnItem.getWebContent().getUrl());
                        this.jPCenter.add((Component)dynPanel, panelKey);
                        this.panelMap.put(panelKey, dynPanel);
                        continue;
                    }
                    if (!"true".equals(isDomainChanged)) continue;
                    dynPanel = this.dynamicPanels.get(enabledTabIndex);
                    dynPanel.disposeBrowser();
                    dynPanel = new MonitorPanel(5, addOnItem.getWebContent().getUrl());
                    this.jPCenter.add((Component)dynPanel, panelKey);
                    this.panelMap.put(panelKey, dynPanel);
                }
            }
            final String instanceId = GUIDGenerator.getInstance().getGUIDString();
            logger.log(SystemLevel.STDOUT, "********************* Console top level use case set to {0} ****************, instanceId:  {1}", new Object[]{System.getProperty("consoleusecase"), instanceId});
            this.inProgress = true;
            SwingWorker worker = new SwingWorker("SwitchingTabs"){
                String eventId;
                String category;
                private SimpleProgressDlg progressDialog;
                {
                    super(arg0);
                    this.eventId = null;
                    this.category = null;
                    this.progressDialog = new SimpleProgressDlg((Frame)Manager.getFrame(), MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.loading"), "", false);
                }

                public Object construct() {
                    UIUtilities.initProgressStatus(this.progressDialog, true);
                    logger.log(SystemLevel.STDOUT, "********************* Console top level use case set to {0} ****************, instanceId:  {1}, construct...", new Object[]{System.getProperty("consoleusecase"), instanceId});
                    try {
                        this.category = "SEPM_Java";
                        if (panelKey.equals(MainPanel.HOME_PANEL_KEY) || panelKey.equals(MainPanel.MONITOR_PANEL_KEY) || panelKey.equalsIgnoreCase(MainPanel.REPORT_PANEL_KEY)) {
                            this.category = "SEPM_Php";
                        }
                        if (this.category.equals("SEPM_Java")) {
                            MonitorAgent.getInstance().startScenario(panelKey + "_Load", this.category);
                            this.eventId = MonitorAgent.getInstance().startEvent("UIRequest", null);
                        }
                        MainPanel.this.buttonGroup.setSticked(btn.getModel(), true);
                        boolean isNeedFresh = MainPanel.this.setCurrentPanel(panelKey);
                        if (currentSelPanel != null) {
                            currentSelPanel.refreshTaskBarViews();
                            Component taskPanel = currentSelPanel.getCurrentTaskPanel();
                            if (taskPanel instanceof TaskPanel && isNeedFresh) {
                                ((TaskPanel)((Object)taskPanel)).refresh();
                            }
                        }
                    }
                    catch (Exception exc) {
                        logger.log(SystemLevel.STDOUT, "********************* Console top level use case set to {0} ****************, instanceId:  {1}, exc: {2}.", new Object[]{System.getProperty("consoleusecase"), instanceId, exc.getMessage()});
                        ConsoleLogger.log(exc);
                        UIUtilities.disposeProgressStatus(this.progressDialog);
                        throw exc;
                    }
                    return null;
                }

                public void finished() {
                    logger.log(SystemLevel.STDOUT, "********************* Console top level use case set to {0} ****************, instanceId:  {1}, finished!", new Object[]{System.getProperty("consoleusecase"), instanceId});
                    UIUtilities.disposeProgressStatus(this.progressDialog);
                    MainPanel.this.inProgress = false;
                    btn.repaint();
                    MainPanel.this.jPCenter.setVisible(true);
                    ((CardLayout)MainPanel.this.jPCenter.getLayout()).show(MainPanel.this.jPCenter, panelKey);
                    MainPanel.this.jPCenter.updateUI();
                    if (this.category.equals("SEPM_Java")) {
                        MonitorAgent.getInstance().stopEvent(this.eventId);
                        MonitorAgent.getInstance().stopScenario(panelKey + "_Load");
                    }
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)currentSelPanel, true);
                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)MainPanel.this.jPCenter, true);
                        ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)MainPanel.this, true);
                        AjaxSwingManager.endOperation();
                        ClientAgent.getCurrentInstance().setUpdateBrowser(true);
                        ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
                    }
                    if (currentSelPanel instanceof OverviewPanel && ((OverviewPanel)currentSelPanel).isNeedPanelRefresh()) {
                        ((OverviewPanel)currentSelPanel).setNeedPanelRefresh(false);
                        ((OverviewPanel)currentSelPanel).doRefresh();
                    }
                    logger.log(SystemLevel.STDOUT, "********************* Console top level use case set to {0} ****************, instanceId:  {1}, finished!", new Object[]{System.getProperty("consoleusecase"), instanceId});
                }
            };
            AjaxSwingManager.beginOperation();
            worker.start();
        }
    }

    public void logout() {
        boolean hasReporting = AdminPrivilegeObject.isCurrentAdminHasReportPrivilege();
        ConsoleLogger.log("MainPanel >> logout begin, isCurrentAdminHasReportPrivilege: " + hasReporting + ", overviewPanel: " + this.overviewPanel);
        if (hasReporting && this.overviewPanel != null) {
            ConsoleLogger.log("MainPanel >> overviewPanel logout...");
            this.overviewPanel.doLogout();
        }
        ConsoleLogger.log("MainPanel >> logout done!");
    }

    public boolean isCloudTabEnabled() {
        boolean result = false;
        if (this.featureSet != null) {
            for (UiAddOnItem addOnItem : this.featureSet.getUiAddOnItem()) {
                if (!addOnItem.getEnabled().booleanValue() || !addOnItem.getId().equals("5ee0505f9a5149f492f399e91f93c95b")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void initialize() {
        this.initializePanels();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getToolBarPanel(), "North");
        this.add((Component)this.jPButton, "West");
        this.add((Component)this.getCenterPanel(), "Center");
        int defaultTabIdx = 0;
        String defaultTab = System.getProperty(TAB_INDEX_PROPERTY, "0");
        try {
            defaultTabIdx = Integer.parseInt(defaultTab);
        }
        catch (NumberFormatException ex) {
            logger.log(SystemLevel.STDERR, "", ex);
        }
        AbstractButton defaultButton = null;
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        for (int i = 0; i <= defaultTabIdx; ++i) {
            defaultButton = buttons.hasMoreElements() ? buttons.nextElement() : null;
        }
        if (defaultButton != null) {
            ((NavigateButton)defaultButton).doClick();
        } else {
            this.buttonGroup.getFirstButton().doClick();
        }
        long sepNewsUpdatePeriod = ScmProperties.getSepNewsUpdateFrequency(15L) * 60000L;
        if (sepNewsUpdatePeriod > Integer.MAX_VALUE || sepNewsUpdatePeriod < Integer.MIN_VALUE) {
            sepNewsUpdatePeriod = 900000L;
        }
        this.sepNewsTimer = new Timer((int)sepNewsUpdatePeriod, event -> this.updateNews());
        this.sepNewsTimer.start();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            ClientAgent.getCurrentInstance().addFastSubmitHandler((FastSubmitHandler)new CustomJavascriptHandler(), "showNotificationFromDashboard");
            ClientAgent.getCurrentInstance().addFastSubmitHandler((FastSubmitHandler)new AjaxSwingCommandHandler(), "ajaxSwingCommandHandler");
        }
    }

    private void refreshApiAccessToken() {
        GUIManager.deleteCachedApiToken();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            String key = "cookie.RestApiAccessToken";
            String value = "RestApiAccessToken=" + GUIManager.getAccessToken() + "; Max-Age=3600; Path=/sepm; SameSite=Strict; Secure; HttpOnly";
            ClientAgent.getCurrentInstance().getResponseData().getParams().put(key, value);
        }
    }

    private void updateNews() {
        this.sepnewsImageLabel.setVisible(this.isDisplayNewsPanel());
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.jPCenter);
        this.jPCenter.setVisible(false);
        return this.jPCenter;
    }

    private void initializePanels() {
        if (DataobjectManager.getInstance().getLoginInformation() == null) {
            throw new RuntimeException("No login information, need to re-logon the console...");
        }
        if (DataobjectManager.getInstance().getLoginInformation().getOptDomainGUID() != null) {
            if (AdminPrivilegeObject.isCurrentAdminHasReportPrivilege()) {
                TimeCounter counter1 = new TimeCounter();
                this.createOverViewPanel();
                System.out.println("\n>>>MainPanel: CreateHomePanel: " + counter1.toStringEx2(true));
                this.overviewPanel.checkIfInitiated();
                TimeCounter counter2 = new TimeCounter();
                this.createMonitorPanel();
                System.out.println(">>>MainPanel: CreateMonitorPanel: " + counter2.toStringEx2(true));
                TimeCounter counter3 = new TimeCounter();
                this.createReportPanel();
                System.out.println(">>>MainPanel: CreateReportPanel: " + counter3.toStringEx2(true));
            }
            if (AdminPrivilegeObject.isCurrentAdminHasPolicyPrivilege()) {
                TimeCounter counter4 = new TimeCounter();
                this.createPolicyPanel();
                System.out.println(">>>MainPanel: CreatePolicyPanel: " + counter4.toStringEx2(true));
            }
            try {
                if (AdminPrivilegeObject.isCurrentAdminHasClientPanelPrivilege()) {
                    TimeCounter counter5 = new TimeCounter();
                    this.createClientManagementPanel();
                    System.out.println(">>>MainPanel: CreateComputerUserPanel: " + counter5.toStringEx2(true));
                }
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
                System.err.println("Fail to fetch the group.");
            }
        }
        TimeCounter counter6 = new TimeCounter();
        this.createAdminPanel();
        System.out.println(">>>MainPanel: CreateAdminPanel: " + counter6.toStringEx2(true));
        TimeCounter counter7 = new TimeCounter();
        this.createDynamicPanel();
        System.out.println(">>>MainPanel: createDynamicPanels: " + counter7.toStringEx2(true));
        this.jPButton = new JPanel(new BorderLayout());
        this.jPButton.setBackground(UIColorUtilities.MAIN_NAVIGATION_BACKGROUND);
        this.initButtonPanel(this.buttonGroup);
    }

    public void refreshClientPanel() {
        this.clientPanel.refreshRightPanel();
    }

    private void createOverViewPanel() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new OverviewPanel(OVERVIEW_PANEL_NAME, this);
            this.jBHome = this.createButton("MainPanel.home", HOME_PANEL_KEY, "home32_deselect.png", 72, false);
            UIUtilities.setName(this.jBHome, PAGE_NAME, UIUtilities.ComponentType.BUTTON, HOME_PANEL_KEY);
            this.buttonGroup.add(this.jBHome);
            this.jPCenter.add((Component)this.overviewPanel, HOME_PANEL_KEY);
            this.panelMap.put(HOME_PANEL_KEY, this.overviewPanel);
        } else {
            this.overviewPanel.doRefresh();
        }
    }

    private void createMonitorPanel() {
        if (this.monitorPanel == null) {
            this.jBMonitor = this.createButton("MainPanel.monitors", MONITOR_PANEL_KEY, "monitor32_deselect.png", 77, false);
            UIUtilities.setName(this.jBMonitor, PAGE_NAME, UIUtilities.ComponentType.BUTTON, MONITOR_PANEL_KEY);
            this.buttonGroup.add(this.jBMonitor);
        }
    }

    private void createReportPanel() {
        if (this.reportPanel == null) {
            this.jBReport = this.createButton("MainPanel.reports", REPORT_PANEL_KEY, "reports32_deselect.png", 82, false);
            UIUtilities.setName(this.jBReport, PAGE_NAME, UIUtilities.ComponentType.BUTTON, REPORT_PANEL_KEY);
            this.buttonGroup.add(this.jBReport);
        }
    }

    private void createPolicyPanel() {
        this.jBPolicy = this.createButton("MainPanel.policies", POLICY_PANEL_KEY, "policies32_deselect.png", 80, false);
        UIUtilities.setName(this.jBPolicy, PAGE_NAME, UIUtilities.ComponentType.BUTTON, POLICY_PANEL_KEY);
        this.buttonGroup.add(this.jBPolicy);
    }

    private void createClientManagementPanel() {
        this.jBCompany = LIC_OBJ.isSBProduct() ? this.createButton("MainPanel.clients", COMPANY_PANEL_KEY, "clients32_deselect.png", 67, false) : this.createButton("MainPanel.eeclients", COMPANY_PANEL_KEY, "clients32_deselect.png", 67, false);
        UIUtilities.setName(this.jBCompany, PAGE_NAME, UIUtilities.ComponentType.BUTTON, COMPANY_PANEL_KEY);
        this.buttonGroup.add(this.jBCompany);
    }

    private void createAdminPanel() {
        this.jBAdmin = this.createButton("MainPanel.admin", ADMIN_PANEL_KEY, "systemadmin32_deselect.png", 65, false);
        UIUtilities.setName(this.jBAdmin, PAGE_NAME, UIUtilities.ComponentType.BUTTON, ADMIN_PANEL_KEY);
        this.buttonGroup.add(this.jBAdmin);
    }

    private void createDynamicPanel() {
        try {
            AdminObject.AdminType currentAdminType = this.getAdminType();
            this.dynamicPanels = new ArrayList<MonitorPanel>();
            this.shortcutKeySet = this.getShortcutKeySet();
            if (this.featureSet != null) {
                for (UiAddOnItem addOnItem : this.featureSet.getUiAddOnItem()) {
                    boolean isEnabled;
                    int accessRoles = addOnItem.getAllowRoles();
                    if (accessRoles < currentAdminType.ordinal() || !(isEnabled = addOnItem.getEnabled().booleanValue())) continue;
                    I18n i18n = addOnItem.getI18n();
                    I18nStrings i18nStrings = MainPanel.getI18nStrings(Locale.getDefault(), i18n);
                    String btnName = String.format("<html><div style=\"text-align:center\">%s</div></html>", MainPanel.getLocaleText(i18nStrings, "Name"));
                    String btnKey = addOnItem.getId();
                    String iconPath = addOnItem.getOptIconPath();
                    int shortcutKey = this.generateShortcutKey(addOnItem.getName());
                    String panelUrl = addOnItem.getWebContent().getUrl();
                    NavigateButton dynamicButton = this.createButton(btnName, btnKey, iconPath, shortcutKey, true);
                    UIUtilities.setName(dynamicButton, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "dynamic_" + addOnItem.getName());
                    this.buttonGroup.add(dynamicButton);
                    this.jBDynamicButtons.add(dynamicButton);
                    MonitorPanel dynamicPanel = new MonitorPanel(5, panelUrl);
                    this.dynamicPanels.add(dynamicPanel);
                    this.jPCenter.add((Component)dynamicPanel, btnKey);
                    this.panelMap.put(btnKey, dynamicPanel);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("\n MainPanel: createDynamicPanel() : Exception when retrieving creating panels, Exception : " + ex.getMessage());
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private HashSet<Integer> getShortcutKeySet() {
        this.shortcutKeySet = new HashSet();
        this.shortcutKeySet.add(83);
        this.shortcutKeySet.add(65);
        this.shortcutKeySet.add(67);
        this.shortcutKeySet.add(80);
        this.shortcutKeySet.add(82);
        this.shortcutKeySet.add(77);
        this.shortcutKeySet.add(72);
        return this.shortcutKeySet;
    }

    private Integer generateShortcutKey(String keyWord) {
        keyWord = keyWord.toUpperCase();
        for (char c : keyWord.toCharArray()) {
            if (this.shortcutKeySet.contains(c)) continue;
            this.shortcutKeySet.add(KeyEvent.getExtendedKeyCodeForChar(c));
            return KeyEvent.getExtendedKeyCodeForChar(c);
        }
        return 0;
    }

    private AdminObject.AdminType getAdminType() {
        AdminObject adminObject = AdminObject.retrieveCurrentAdminObject();
        return adminObject.getAdminType();
    }

    public static I18nStrings getI18nStrings(Locale locale, I18n i18n) {
        String lang = locale.getLanguage();
        String langAndCountry = lang + "_" + locale.getCountry();
        I18nStrings langAndCountryMatch = null;
        I18nStrings langMatch = null;
        I18nStrings englishMatch = null;
        for (I18nStrings i18nStrings : i18n.getI18nStrings()) {
            String i18nLocale = i18nStrings.getLocale();
            if (langAndCountry.equalsIgnoreCase(i18nLocale)) {
                langAndCountryMatch = i18nStrings;
                continue;
            }
            if (lang.equalsIgnoreCase(i18nLocale)) {
                langMatch = i18nStrings;
                continue;
            }
            if (!"en".equalsIgnoreCase(i18nLocale)) continue;
            englishMatch = i18nStrings;
        }
        if (langAndCountryMatch != null) {
            return langAndCountryMatch;
        }
        if (langMatch != null) {
            return langMatch;
        }
        return englishMatch;
    }

    public static String getLocaleText(I18nStrings i18nStrings, String key) {
        return i18nStrings.getI18nString().stream().filter(str -> key.equalsIgnoreCase(str.getTag())).findFirst().map(I18nString::getOptContent).orElse(null);
    }

    private UiAddOnFeatureSet getFeaturesFromDatabase(String guid) {
        UiAddOnFeatureSet featureObj = null;
        try {
            featureObj = (UiAddOnFeatureSet)GUIManager.getObject("UiAddOnFeatureSet", guid);
        }
        catch (ConsoleException ex) {
            System.out.println("\n MainPanel: getFeaturesFromDatabase() : Error getting features from Database ," + ex.getMessage());
        }
        return featureObj;
    }

    private NavigateButton createButton(String name, String key, String deSelIconName, int keyBinding, boolean isDynamic) {
        NavigateButton button;
        if (isDynamic) {
            char hotKey = (char)keyBinding;
            button = new NavigateButton(name, key, this.createDynamicImageIcon(deSelIconName), hotKey);
        } else {
            int hotKey = MSG_RES.getHotKey("com.sygate.scm.console.ui.ui", name, keyBinding);
            Image delSelIcon = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(deSelIconName));
            button = new NavigateButton(MSG_RES.getString("com.sygate.scm.console.ui.ui", name), key, new ImageIcon(delSelIcon), hotKey);
        }
        UIUtilities.setName(button, "NavigateButton_" + key);
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            button.setId("NavigateButton_" + key);
        }
        button.addActionListener(this);
        return button;
    }

    private ImageIcon createDynamicImageIcon(String deSelIconName) {
        String defaultIconName = "Inform.png";
        Image defaultImage = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(defaultIconName));
        ImageIcon imgIcon = new ImageIcon(defaultImage);
        if (!deSelIconName.isEmpty()) {
            String iconPath = Browser.preprocessURL(deSelIconName);
            if (URLUtility.isValidURLForWindows((String)iconPath, (Boolean)false)) {
                try {
                    if (MainPanel.checkDynamicImageIconURLStatus(iconPath, 3) != 200) {
                        return imgIcon;
                    }
                    imgIcon = new ImageIcon(new URL(iconPath));
                }
                catch (MalformedURLException ex) {
                    System.out.println("\n MainPanel: createDynamicImageIcon() : Exception when retrieving creating button : " + ex.getMessage());
                }
            } else {
                Image delSelIcon = Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource(deSelIconName));
                imgIcon = new ImageIcon(delSelIcon);
            }
        }
        return imgIcon;
    }

    public static int checkDynamicImageIconURLStatus(String iconPath, int retryTimes) {
        int responseCode = Browser.checkURLStatus(iconPath);
        for (int retry = 0; retry < retryTimes && responseCode != 200; ++retry) {
            ConsoleLogger.log("checkURLStatus failed, retry, URL: " + iconPath);
            Utility.threadSleep((int)1);
            responseCode = Browser.checkURLStatus(iconPath);
        }
        return responseCode;
    }

    private void initButtonPanel(ButtonGroup buttonGroup) {
        this.fitButtons(buttonGroup);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int count = 0;
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            NavigateButton b = (NavigateButton)buttons.nextElement();
            panel.add((Component)b, new GridBagConstraints(0, 2 * count + 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++count;
        }
        this.jPButton.add((Component)panel, "North");
    }

    private void fitButtons(ButtonGroup buttonGroup) {
        NavigateButton b;
        int width = 0;
        int height = 0;
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            b = (NavigateButton)buttons.nextElement();
            Dimension prefD = b.getPreferredSize();
            Dimension minD = b.getMinimumSize();
            int selfWidth = (int)Math.max(prefD.getWidth(), minD.getWidth());
            int selfHeight = (int)Math.max(prefD.getHeight(), minD.getHeight());
            width = Math.max(selfWidth, width);
            height = Math.max(selfHeight, height);
        }
        buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            b = (NavigateButton)buttons.nextElement();
            b.setPreferredSize(new Dimension(width, height));
        }
    }

    public void insertDomainRelatedPanels(String selPanelKey) {
        logger.log(SystemLevel.STDERR, ">> insertDomainRelatedPanels << ");
        this.buttonGroup.remove(this.jBAdmin);
        this.createMonitorPanel();
        this.createReportPanel();
        this.createPolicyPanel();
        this.createClientManagementPanel();
        this.createDynamicPanel();
        this.buttonGroup.add(this.jBAdmin);
        this.jPButton.removeAll();
        this.initButtonPanel(this.buttonGroup);
    }

    private boolean setCurrentPanel(String panelKey) {
        TimeCounter c = new TimeCounter();
        boolean isNeedFresh = true;
        if (currentSelPanel == this.panelMap.get(panelKey)) {
            return isNeedFresh;
        }
        logger.log(SystemLevel.STDOUT, "MainPanel::Button clicked begin");
        if (currentSelPanel != null) {
            currentSelPanel.switchOut();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)currentSelPanel, true);
            }
        }
        if ((currentSelPanel = this.panelMap.get(panelKey)) != null && !currentSelPanel.hasInitialized()) {
            int urlChoice = 0;
            String strNextURLParams = null;
            if (panelKey.equals(MONITOR_PANEL_KEY) && currentSelPanel instanceof MonitorPanel) {
                Object[] array = ((MonitorPanel)currentSelPanel).getNextURL();
                urlChoice = (Integer)array[0];
                strNextURLParams = (String)array[1];
            }
            currentSelPanel.initPanel();
            if (strNextURLParams != null && urlChoice == 1) {
                ((MonitorPanel)currentSelPanel).setNextURL(urlChoice, strNextURLParams);
            }
            isNeedFresh = false;
        }
        if (currentSelPanel != null) {
            if (null == DataobjectManager.getInstance().getLoginInformation()) {
                throw new RuntimeException("Log-off happened before switching panel " + currentSelPanel.getName());
            }
            try {
                currentSelPanel.switchIn();
                logger.log(SystemLevel.STDOUT, "MainPanel::Button clicked end: [{0}]:  {1}", new Object[]{currentSelPanel.getName(), c});
            }
            catch (Throwable th) {
                if (null == DataobjectManager.getInstance().getLoginInformation()) {
                    logger.log(SystemLevel.STDOUT, "Log-off happened before switching panel");
                    throw new RuntimeException("Log-off happened before switching panel: ", th);
                }
                throw th;
            }
        }
        return isNeedFresh;
    }

    private JPanel getToolBarPanel() {
        String sepnews_text = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.sepnews");
        String refresh_text = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.refresh");
        String logout_text = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.logout");
        String help_text = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help");
        MainPanelHyperlinkPane refresh = this.getToolBarButton("REFRESH", refresh_text);
        refresh.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && currentSelPanel != null) {
                if (currentSelPanel instanceof MonitorPanel) {
                    ((MonitorPanel)currentSelPanel).doRefresh();
                } else if (currentSelPanel instanceof OverviewPanel) {
                    ((OverviewPanel)currentSelPanel).doRefresh();
                }
                currentSelPanel.refreshTaskBarViews();
                Component taskPanel = currentSelPanel.getCurrentTaskPanel();
                if (taskPanel instanceof TaskPanel) {
                    ((TaskPanel)((Object)taskPanel)).refresh();
                }
            }
        });
        MainPanelHyperlinkPane logout = this.getToolBarButton("LOGOUT", logout_text);
        UIUtilities.setName(logout, "mainPage", UIUtilities.ComponentType.TEXTPANE, AUTOMATION_LOG_OFF);
        logout.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Manager.getFrame().logOutAndShowLoginPage();
            }
        });
        MainPanelHyperlinkPane help = this.getToolBarButton("HELP", help_text);
        help.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.help_popup(event);
            }
        });
        this.helpTopicsMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MainPanel.this.help(true);
            }
        });
        JPanel sepnewsPanel = new JPanel(new BorderLayout());
        sepnewsPanel.setOpaque(false);
        this.sepnewsImageLabel = new JLabel(ConsoleMain.latestNewsIcon);
        MainPanelHyperlinkPane sepnews = this.getToolBarButton("SEP NEWS", sepnews_text);
        sepnews.addHyperlinkListener(event -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_SEPNEWSURL);
                this.updateLatestSepNewsStatus(AdministratorState.READ);
                this.updateNews();
            }
        });
        sepnewsPanel.add((Component)sepnews, "Center");
        sepnewsPanel.add((Component)this.sepnewsImageLabel, "West");
        this.updateNews();
        this.logMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                MainPanel.this.openLogFile();
            }
        });
        this.contactSupportMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_contactSupportUrl);
            }
        });
        this.downloadSupportToolMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpUtil.showDownloadSupportTool();
            }
        });
        this.peerToPeerMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpUtil.showURL(HelpUtil.HELP_UTIL_URL_peerToPeerDiscussionUrl);
            }
        });
        this.aboutMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                new AboutDialog().setVisible(true);
            }
        });
        this.welcomeScreenMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                new QuickStartDialog().setVisible(true);
            }
        });
        this.whatsNewMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                HelpUtil.showHelp(MainPanel.WHATS_NEW_URL_TOKEN);
            }
        });
        JEditorPane consoleText = UIUtilities.createHTMLLabel();
        consoleText.setText(UIFontUtilities.formatLockupText((String)"Symantec Endpoint Protection Manager"));
        consoleText.addMouseListener(new BannerMouseListener());
        consoleText.setOpaque(false);
        consoleText.setHighlighter(null);
        JPanel logoPanel = new JPanel();
        logoPanel.setLayout(new BoxLayout(logoPanel, 0));
        logoPanel.setBorder(BorderFactory.createEmptyBorder(4, 10, 4, 0));
        logoPanel.setOpaque(false);
        logoPanel.add(new JLabel(ConsoleMain.MENU_BAR_LOGO_IMAGE));
        logoPanel.add(Box.createHorizontalStrut(5));
        logoPanel.add((Component)consoleText);
        JPanel taskPanel = new JPanel();
        taskPanel.setLayout(new BoxLayout(taskPanel, 0));
        taskPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 8));
        taskPanel.setOpaque(false);
        taskPanel.add(sepnewsPanel);
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(refresh);
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(help);
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(Box.createHorizontalStrut(5));
        taskPanel.add(logout);
        if (ScmProperties.isFeedbackEnabled()) {
            taskPanel.add(Box.createHorizontalStrut(5));
            taskPanel.add(Box.createHorizontalStrut(5));
            taskPanel.add(new FeedbackMenuBar.FeedbackLabel(this.getClass().getSimpleName(), this));
        }
        JPanel wrapPanel = new JPanel();
        wrapPanel.setBackground(UIColorUtilities.LOCKUP_BACKGROUND_COLOR);
        wrapPanel.setLayout(new GridBagLayout());
        wrapPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        wrapPanel.add((Component)logoPanel, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        wrapPanel.add((Component)taskPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return wrapPanel;
    }

    private void updateLatestSepNewsStatus(Integer state) {
        try {
            AdminHandler.setAdminAcknowledgeLatestNewsStatus(AdminObject.retrieveCurrentAdminObject(), state);
        }
        catch (ConsoleException ce) {
            logger.log(SystemLevel.STDERR, "MainPanel: updateLatestSepNewsStatus() : Exception in saving the Latest SEP News Status", ce);
        }
    }

    private boolean isDisplayNewsPanel() {
        try {
            AdminObject adminObject = AdminObject.retrieveCurrentAdminObject(true);
            AdminStateObject adminStateObject = adminObject.retrieveState();
            boolean displayPanel = adminStateObject != null && AdministratorState.NOT_READ.equals(adminStateObject.getNotifyLatestSepNews());
            logger.log(Level.INFO, "Show news panel :[{0}]", displayPanel);
            return displayPanel;
        }
        catch (ConsoleException ce) {
            logger.log(SystemLevel.STDERR, " MainPanel: isDisplayNewsPanel() : Exception in retrieving the Latest SEP News Status", ce);
            return false;
        }
    }

    private MainPanelHyperlinkPane getToolBarButton(String ref, String text) {
        MainPanelHyperlinkPane pane = new MainPanelHyperlinkPane();
        pane.setOpaque(false);
        pane.setContentType("text/html");
        pane.setText(this.getHtmlRefText(ref, text));
        pane.getAccessibleContext().setAccessibleName(text);
        pane.getAccessibleContext().setAccessibleDescription(text);
        pane.setEditable(false);
        return pane;
    }

    private String getHtmlRefText(String ref, String text) {
        return "<html><div style=\"white-space:nowrap\"><a href='http://localhost/a.html#" + ref + "' style=\"text-decoration: none;font-weight:bold;color:" + UIColorUtilities.colorToString((Color)UIColorUtilities.LOCKUP_FOREGROUND_COLOR) + "\">" + text + "</a></div></html>";
    }

    private void help() {
        PagePanel panel = MainPanel.getCurrentPanel();
        boolean isDisplayHelp = true;
        if (panel instanceof OverviewPanel || panel instanceof MonitorPanel) {
            Component component = Manager.getFrame().getFocusOwner();
            isDisplayHelp = component != null && (component instanceof NavigateButton || component instanceof javax.swing.JEditorPane);
        }
        if (AjaxSwingCommonUtil.isAjaxSwingRunning() || isDisplayHelp) {
            this.help(false);
        }
    }

    private String getHelpToken(boolean isFrom) {
        String token = null;
        String panel = MainPanel.getCurrentPanel().getName();
        if (isFrom && panel != null && panel.equals(OVERVIEW_PANEL_NAME)) {
            return token;
        }
        Component curPanel = MainPanel.getCurrentPanel().getCurrentTaskPanel();
        if (curPanel instanceof ContentSensitiveHelpPage) {
            token = ((ContentSensitiveHelpPage)((Object)curPanel)).getContentSensitiveHelpToken();
        }
        return token;
    }

    private void help(boolean isFrom) {
        HelpUtil.showHelp(this.getHelpToken(isFrom));
    }

    private void openLogFile() {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            String desc = MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.nameOfLogFile");
            desc = MessageFormat.format(desc, System.getProperty("java.io.tmpdir"), ConsoleMain.getLogName(), ConsoleMain.getErrorLogName());
            JOptionPane.showMessageDialog(Manager.getFrame(), desc);
        } else {
            MainPanel.exportConsoleLog();
        }
    }

    public static void exportConsoleLog() {
        HashMap<String, BufferedInputStream> physicalFileList = new HashMap<String, BufferedInputStream>();
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(UIText.get(1030));
        chooser.setDialogTitle(MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.exportLogFile"));
        chooser.updateUI();
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            chooser.setDialogType(1);
        }
        chooser.setSelectedFile(new File("ConsoleLog.zip"));
        if (0 == chooser.showDialog(Manager.getFrame(), null)) {
            String errMsg;
            block17: {
                errMsg = null;
                try {
                    File exportFile = chooser.getSelectedFile();
                    File logFile = new File(System.getProperty("java.io.tmpdir") + File.separator + ConsoleMain.getLogName());
                    File errorlogFile = new File(System.getProperty("java.io.tmpdir") + File.separator + ConsoleMain.getErrorLogName());
                    physicalFileList.put(logFile.getName(), new BufferedInputStream(new FileInputStream(logFile)));
                    physicalFileList.put(errorlogFile.getName(), new BufferedInputStream(new FileInputStream(errorlogFile)));
                    try (ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(exportFile)));){
                        if (physicalFileList == null || physicalFileList.size() == 0) break block17;
                        byte[] buff = new byte[1024];
                        for (String fileName : physicalFileList.keySet()) {
                            InputStream fileIS = (InputStream)physicalFileList.get(fileName);
                            try {
                                int len;
                                ZipEntry entry = new ZipEntry(fileName);
                                zip.putNextEntry(entry);
                                while ((len = fileIS.read(buff, 0, 1024)) > 0) {
                                    zip.write(buff, 0, len);
                                }
                                zip.closeEntry();
                            }
                            finally {
                                if (fileIS == null) continue;
                                fileIS.close();
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    errMsg = ioe.getMessage();
                }
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(Manager.getFrame(), MSG_RES.getString("com.sygate.scm.console.ui.ui", "MainPanel.help.FailtoExportLogFile") + errMsg);
            }
        }
    }

    private void help_popup(HyperlinkEvent event) {
        MainPanelHyperlinkPane curPanel = (MainPanelHyperlinkPane)event.getSource();
        JPopupMenu helpPopupMenu = new JPopupMenu();
        helpPopupMenu.add(this.helpTopicsMenuItem);
        helpPopupMenu.add(this.contactSupportMenuItem);
        helpPopupMenu.add(this.downloadSupportToolMenuItem);
        if (Boolean.getBoolean("scm.console.log")) {
            helpPopupMenu.add(this.logMenuItem);
        }
        helpPopupMenu.add(this.peerToPeerMenuItem);
        helpPopupMenu.add(this.welcomeScreenMenuItem);
        helpPopupMenu.add(this.whatsNewMenuItem);
        helpPopupMenu.addSeparator();
        helpPopupMenu.add(this.aboutMenuItem);
        curPanel.add(helpPopupMenu);
        int x = this.getSize().width - helpPopupMenu.getPreferredSize().width;
        helpPopupMenu.show(this, x, -8);
    }

    public void setAdminSubTab(String key) {
        this.adminPanel.setOutlookButtonPanel(key);
    }

    private static void setCurrentSelectedPanel(PagePanel pp) {
        currentSelPanel = pp;
    }

    private static void setMainPanel(MainPanel mp) {
        me = mp;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return this.getHelpToken(false);
    }

    static {
        me = null;
    }

    private static class MainPanelHyperlinkPane
    extends HyperlinkPane
    implements Accessible {
        private static final long serialVersionUID = 1L;

        private MainPanelHyperlinkPane() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleHyperlinkPane();
            }
            return this.accessibleContext;
        }

        protected class AccessibleHyperlinkPane
        extends JComponent.AccessibleJComponent {
            private static final long serialVersionUID = 1L;

            protected AccessibleHyperlinkPane() {
                super(MainPanelHyperlinkPane.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PUSH_BUTTON;
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MainPanel.this.help();
        }
    }

    private static class NavigateButtonGroup
    extends ButtonGroup {
        private static final long serialVersionUID = 1L;

        private NavigateButtonGroup() {
        }

        public void setSticked(ButtonModel model, boolean isSticked) {
            if (isSticked && model.isSelected()) {
                return;
            }
            Enumeration<AbstractButton> buttons = this.getElements();
            while (buttons.hasMoreElements()) {
                NavigateButton nb = (NavigateButton)buttons.nextElement();
                nb.getModel().setSelected(false);
            }
            model.setSelected(true);
        }

        public NavigateButton getFirstButton() {
            Enumeration<AbstractButton> buttons = this.getElements();
            if (buttons.hasMoreElements()) {
                return (NavigateButton)buttons.nextElement();
            }
            return null;
        }
    }

    public class NavigateButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private String id;

        public NavigateButton(String text, String actionKey, Icon icon, int keyBinding) {
            super(text, icon);
            this.id = "";
            this.setBackground(UIColorUtilities.MAIN_NAVIGATION_BACKGROUND);
            this.setForeground(UIColorUtilities.MAIN_NAVIGATION_FOREGROUND);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setRolloverEnabled(true);
            this.setActionCommand(actionKey);
            this.setMinimumSize(new Dimension(65, 75));
            this.setMnemonic(keyBinding);
        }

        @Override
        public String getUIClassID() {
            return "NavButtonUI";
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public Insets getInsets() {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public void paintBorder(Graphics g) {
        }

        @Override
        public void doClick() {
            MainPanel.this.buttonGroup.setSticked(this.getModel(), true);
            super.doClick();
            this.requestFocus();
        }
    }

    private class BannerMouseListener
    implements MouseListener {
        private BannerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            new AboutDialog().setVisible(true);
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            MainPanel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            MainPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

