/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.LoginPanel;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.client.dlg.InstallClientWizardDialog;
import com.sygate.scm.console.ui.policy.explorer.adaptive.AdaptivePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.av.AVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.AvPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.av.BaseAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.LinuxAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.av.MacAVScanPoolHandler;
import com.sygate.scm.console.ui.policy.explorer.fw.FwPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.hi.HostIntegrityPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IDSLibraryHandler;
import com.sygate.scm.console.ui.policy.explorer.ids.IdsPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.lu.LuContentPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.lu.LuPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.mem.MemPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.ntr.NtrPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.osp.OpAppProtectionPolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.override.OverridePolicyHandler;
import com.sygate.scm.console.ui.policy.explorer.sle.ServerListHandler;
import com.sygate.scm.console.ui.policy.explorer.up.UpgradePolicyHandler;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.MessageHandler;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 8478272522946013982L;
    int logoutTimeoutSecond = 30;
    private BorderLayout borderLayout1 = new BorderLayout();
    JPanel rootPanel = new JPanel();
    private MessageResources msgRes = MessageResources.getInstance();

    public MainFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void tryToDeleteFile(File f) {
        if (f.exists()) {
            try {
                Utility.delete((File)f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jbInit() throws Exception {
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            this.setUndecorated(true);
            this.setExtendedState(6);
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.setIconImage(CustomLookAndFeel.TITLE_LOGO_IMAGE);
        this.getContentPane().add((Component)this.rootPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                File f = new File(System.getProperty("user.dir") + File.separator + "jdic.log");
                MainFrame.this.tryToDeleteFile(f);
                f = new File(System.getProperty("user.dir") + File.separator + "desktop" + File.separator + "jdic.log");
                MainFrame.this.tryToDeleteFile(f);
                f = new File(System.getProperty("user.home") + File.separator + "desktop" + File.separator + "jdic.log");
                MainFrame.this.tryToDeleteFile(f);
                f = new File(System.getProperty("user.home") + File.separator + "jdic.log");
                MainFrame.this.tryToDeleteFile(f);
            }
        });
    }

    public MainPanel getMainPanel() throws ConsoleException {
        if (!(this.rootPanel instanceof MainPanel)) {
            throw new ConsoleException(0x11010000, 7);
        }
        return (MainPanel)this.rootPanel;
    }

    public synchronized void setPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        ConsoleLogger.log("Changing root panel to " + panel.toString());
        if (this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).dispose();
        }
        this.remove(this.rootPanel);
        this.getContentPane().add((Component)panel, "Center");
        this.rootPanel = panel;
        this.rootPanel.revalidate();
    }

    public void showNotificationLog(String strParams) {
        if (this.rootPanel != null && this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).showNotificationLog(strParams);
        }
    }

    public void showCommandStatus(String strParams) {
        if (this.rootPanel != null && this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).showCommandStatus(strParams);
        }
    }

    public void showScanLogs(String strParams) {
        if (this.rootPanel != null && this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).showScanLogs(strParams);
        }
    }

    public void showComputerStatus(String strParams) {
        if (this.rootPanel != null && this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).showComputerStatus(strParams);
        }
    }

    public void showRiskLog(String strParams) {
        if (this.rootPanel != null && this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).showRiskLog(strParams);
        }
    }

    public boolean isInLoginPanel() {
        return this.rootPanel != null && this.rootPanel instanceof LoginPanel;
    }

    void cleanUpForLogout() {
        ConsoleLogger.log("cleanUpForLogout >> Begin, isAjaxSwingRunning:" + AjaxSwingCommonUtil.isAjaxSwingRunning());
        AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> {
            AjaxSwingCommonUtil.logoutWebConsole();
            ConsoleLogger.log("cleanUpForLogout >> logout from web console!");
            MainFrame.exitSystem(0);
        });
        AvPolicyHandler.clearInstance();
        AVScanPoolHandler.clearInstance();
        BaseAVScanPoolHandler.clearInstance();
        LinuxAVScanPoolHandler.clearInstance();
        MacAVScanPoolHandler.clearInstance();
        FwPolicyHandler.clearInstance();
        HostIntegrityPolicyHandler.clearInstance();
        IDSLibraryHandler.clearInstance();
        IdsPolicyHandler.clearInstance();
        LuContentPolicyHandler.clearInstance();
        LuPolicyHandler.clearInstance();
        MemPolicyHandler.clearInstance();
        NtrPolicyHandler.clearInstance();
        OpAppProtectionPolicyHandler.clearInstance();
        OverridePolicyHandler.clearInstance();
        ServerListHandler.clearInstance();
        UpgradePolicyHandler.clearInstance();
        AdaptivePolicyHandler.clearInstance();
        MessageHandler.clearInstance();
        ConsoleLogger.log("Cleanup For Logout - Invoking GC.");
        System.gc();
        ConsoleLogger.log("cleanUpForLogout >> Done!");
    }

    public synchronized void showLoginPanel() {
        this.logOutAndShowLoginPage();
    }

    public synchronized void logOutAndShowLoginPage() {
        ConsoleLogger.log("logOutAndShowLoginPage >> Begin...");
        GUIManager.stopAllBackgroupThreads();
        if (this.rootPanel instanceof MainPanel) {
            ((MainPanel)this.rootPanel).logout();
        }
        Manager.doLogout(true);
        this.cleanUpForLogout();
        EventQueue.invokeLater(() -> this.logOutAndShowLoginPageLater());
        ConsoleLogger.log("logOutAndShowLoginPage >> Done!");
    }

    public synchronized void logOutAndShowLoginPageLater() {
        ConsoleLogger.log("logOutAndShowLoginPageLater >> Begin...");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            this.closeOwnedWindows();
            InstallClientWizardDialog.cleanUpForLogout();
            this.showFirstLoginPanel();
            Future<?> future = executor.submit(() -> MonitorAgent.getInstance().stopApplication(LoginPanel.applicationName));
            ConsoleLogger.log("logOutAndShowLoginPageLater >> wait for max seconds: " + this.logoutTimeoutSecond);
            future.get(this.logoutTimeoutSecond, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ConsoleLogger.logError("logOutAndShowLoginPageLater was interrupted: " + e.getMessage());
        }
        catch (ExecutionException | TimeoutException e) {
            ConsoleLogger.logError("logOutAndShowLoginPageLater Exception: " + e.getMessage());
        }
        finally {
            executor.shutdown();
            ConsoleLogger.log("logOutAndShowLoginPageLater >> Done!");
        }
    }

    public void closeOwnedWindows() {
        Window[] windows;
        for (Window window : windows = this.getOwnedWindows()) {
            ConsoleLogger.log("closeOwnedWindows >> window: " + window);
            window.dispose();
        }
        ConsoleLogger.log("closeOwnedWindows >> Done!");
    }

    public void showFirstLoginPanel() {
        ConsoleLogger.log("showFirstLoginPanel >> Begin...");
        this.setTitle(this.msgRes.getString("com.sygate.scm.console.ui.ui", "MainFrame.title"));
        LoginPanel loginPanel = new LoginPanel();
        this.setPanel(loginPanel);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)loginPanel.getLoginButton());
        this.pack();
        ConsoleMain.initFrame();
        ConsoleLogger.log("showFirstLoginPanel >> Done!");
    }

    public synchronized JPanel getPanel() {
        return this.rootPanel;
    }

    public void updateTitle() throws ConsoleException {
        StringBuffer buffer = new StringBuffer();
        boolean isSEPSB = LicenseObject.getInstance().isSBProduct();
        if (isSEPSB) {
            buffer.append(this.msgRes.getString("com.sygate.scm.console.ui.ui", "MainFrame.title.SEPSB"));
        } else {
            if (AdminHandler.getEnabledDomainCount() > 1) {
                DataobjectManager data = DataobjectManager.getInstance();
                SemDomain domain = data.getSemDomain(Manager.getCurrentDomainId());
                buffer.append(domain.getName()).append(" - ");
            }
            buffer.append(this.msgRes.getString("com.sygate.scm.console.ui.ui", "MainFrame.title"));
        }
        this.setTitle(buffer.toString());
    }

    private static void exitSystem(int exitCode) {
        System.exit(exitCode);
    }
}

