/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.creamtec.sepm.ajaxswing.support.WebViewPanel;
import com.sygate.scm.common.communicate.CommunicationException;
import com.sygate.scm.common.communicate.Communicator;
import com.sygate.scm.common.communicate.SmartCardPkcsKeyStore;
import com.sygate.scm.common.configobject.schema.LoginBanner;
import com.sygate.scm.common.configobject.schema.LoginBannerText;
import com.sygate.scm.common.configobject.schema.SemAdministrator;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.monitor.MonitorAgent;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.AjaxSwingManager;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.AdminHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.admin.AbstractAdminHandler;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.ui.AdminPwdExpirationDlg;
import com.sygate.scm.console.ui.ConsoleOptions;
import com.sygate.scm.console.ui.EnableDomainDlg;
import com.sygate.scm.console.ui.MainPanel;
import com.sygate.scm.console.ui.QuickStartDialog;
import com.sygate.scm.console.ui.ResetPasswordDlg;
import com.sygate.scm.console.ui.dlg.SimpleProgressDlg;
import com.sygate.scm.console.ui.monitoring.Browser;
import com.sygate.scm.console.ui.util.ConfirmationMsgBox;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.HyperlinkPane;
import com.sygate.scm.console.ui.util.MultiLineMsgBox;
import com.sygate.scm.console.ui.util.PasswordClearUtil;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.AjaxSwingUtil;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.console.util.GUIManagerReportingHelper;
import com.sygate.scm.console.util.PasswordSettingsUtil;
import com.sygate.scm.console.util.PasswordUtil;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.SmartCardUtil;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.NetworkUtils;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.validator.routines.InetAddressValidator;

public class LoginPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String PAGE_NAME = "loginpage";
    public static final String LOCAL_HOST = "localhost";
    public static final String LOOP_IP_ADDR = "127.0.0.1";
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");
    private JLabel jlDomain = null;
    private JTextField jtfUsername = null;
    private JPasswordField jpfPassword = null;
    private JComboBox<String> jcmbServerAddr = null;
    private JTextField jtfDomain = null;
    private JButton jbLogin = null;
    private JButton jbExit = null;
    private JButton jbOption = null;
    private JCheckBox jcbxRememberMe = null;
    private JCheckBox jcbxRememberMyPassword = null;
    private JCheckBox jcbxSmartCardAuthentication = null;
    private boolean passwordChanged = false;
    private boolean showUACWarning;
    private HyperlinkPane forgetPasswordPane = null;
    private JLabel jlPassword = null;
    public static final String SYSPROPERTY_SERVERADDR = "SepServer";
    public static final String SYSPROPERTY_USERNAME = "login.username";
    public static final String SYSPROPERTY_PASSWORD = "login.password";
    public static final String SYSPROPERTY_AUTOLOGON = "login.auto";
    public static final String SYSPROPERTY_CLIENTWIZARD = "login.runClientWizard";
    private ConsoleOptions options = ConsoleOptions.getInstance(false);
    private static Communicator communicator = new Communicator();
    private static boolean isSBProduct = false;
    private static boolean AUTO_LOGIN_DONE;
    static String applicationName;
    static String resetPassword;
    static String rememberPassword;
    private final Properties prop = new Properties();
    private static boolean isFirstShow;
    private boolean needRelogin = false;
    private String encryptedPassword = null;
    private static final String ERROR_MSG_SC_AUTH_FAILURE = "ErrorMsg_en_US.EE.SmartcardAuthenticationFailurePleaseRetry";

    public LoginPanel() {
        MonitorAgent agent = MonitorAgent.getInstance();
        if (!agent.isInitialize()) {
            boolean enableMonitor = Boolean.getBoolean("scm.profiler.enable");
            String monitorServer = null;
            int monitorPort = -1;
            if (enableMonitor) {
                monitorServer = System.getProperty("scm.profiler.server");
                monitorPort = Integer.parseInt(System.getProperty("scm.profiler.port"));
            }
            agent.initialize(enableMonitor, monitorServer, monitorPort);
            agent.setComponent("SEPM Console");
        }
        this.initialize();
        this.updateDomainField();
        this.updateSmartCardCheckbox();
    }

    private void msg(String msg) {
        System.out.println(System.currentTimeMillis() + ": " + msg);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(UIColorUtilities.LOGIN_PANE);
        graphics.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public JButton getLoginButton() {
        if (this.jbLogin == null) {
            this.jbLogin = new JButton(UIText.get(2821));
            UIUtilities.setName(this.jbLogin, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "login");
        }
        return this.jbLogin;
    }

    public static void formatApplicationName(String serverName) {
        int separator = -1;
        separator = serverName.indexOf(":");
        Object serverMachineName = separator >= 0 ? serverName.substring(0, separator) : serverName;
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
            String consoleMachine = addr.getHostName();
            String consoleIpAddr = addr.getHostAddress();
            serverMachineName = ((String)serverMachineName).equalsIgnoreCase(LOCAL_HOST) || ((String)serverMachineName).equalsIgnoreCase(LOOP_IP_ADDR) || ((String)serverMachineName).equalsIgnoreCase(consoleMachine) || ((String)serverMachineName).equals(consoleIpAddr) ? MonitorAgent.getInstance().getMachineName() + "_Local" : (String)serverMachineName + "_Remote";
        }
        catch (UnknownHostException e1) {
            ConsoleLogger.log(e1);
        }
        applicationName = "SEPM_" + (String)serverMachineName;
    }

    private void initialize() {
        Dimension probableDimension = null;
        probableDimension = Manager.getFrame() == null || Manager.getFrame().getSize().getWidth() == 0.0 ? new Dimension(980, 720) : Manager.getFrame().getContentPane().getSize();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension maxAvailableScreenDimension = new Dimension((int)screenDimension.getWidth() - (screenInsets.left + screenInsets.right), (int)screenDimension.getHeight() - (screenInsets.top + screenInsets.bottom));
        Dimension preferred = new Dimension(Math.min((int)probableDimension.getWidth(), (int)maxAvailableScreenDimension.getWidth()), Math.min((int)probableDimension.getHeight(), (int)maxAvailableScreenDimension.getHeight()));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            preferred = maxAvailableScreenDimension;
        }
        this.setPreferredSize(preferred);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getLoginPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        String hostName = "";
        String hostIP = "";
        try {
            InetAddress address = InetAddress.getLocalHost();
            hostName = address.getHostName();
            hostIP = address.getHostAddress();
        }
        catch (UnknownHostException ex) {
            ConsoleLogger.log(ex);
        }
        String osVersion = System.getProperty("os.version");
        String serverStr = Env.getSEM_SERVER();
        if (isFirstShow && Utility.isWindowsVistaOrGreater((String)osVersion) && !serverStr.equals(LOCAL_HOST) && !serverStr.equals(LOOP_IP_ADDR) && !serverStr.equals(hostName) && !serverStr.equals(hostIP) && this.options.showUACWarning()) {
            ConfirmationMsgBox msgbox = new ConfirmationMsgBox(MSGRES.getString("LoginPanel.vistaWarnTitle"));
            msgbox.init(MSGRES.getString("LoginPanel.vistaWarnMsg"), 90);
            msgbox.show();
            this.showUACWarning = !msgbox.isChecked();
            this.options.setLoginOption(this.getJBOption().getActionCommand(), String.valueOf(this.showUACWarning));
            isFirstShow = false;
        }
        this.getJTFUsername().requestFocus();
        if (System.getProperty(SYSPROPERTY_AUTOLOGON) != null && !AUTO_LOGIN_DONE) {
            AUTO_LOGIN_DONE = true;
            this.getLoginButton().doClick();
        }
    }

    private JPanel getLoginPanel() {
        JPanel bannerPanel = null;
        bannerPanel = new JPanel();
        bannerPanel.setLayout(new GridBagLayout());
        bannerPanel.setBackground(UIColorUtilities.BANNER_BACKGROUND);
        bannerPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        bannerPanel.add((Component)new JLabel(ConsoleMain.symantecLogoIcon), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getLoginButton().setBackground(UIColorUtilities.DEFAULT_BUTTON_BACKGROUND);
        bannerPanel.putClientProperty("cssClass", "loginBanner");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)bannerPanel, "North");
        panel.add((Component)this.getInnerPanel(), "Center");
        int row = 0;
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        JSeparator js = new JSeparator();
        bottomPanel.add((Component)js, UiUtilities.getGridBagConstraints((int)0, (int)row++, (int)5, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)40, (int)0, (int)0, (int)0, (int)0, (int)0));
        JLabel labelCopyRight = new JLabel(MSGRES.getString("LoginPanel.label.copyright"));
        labelCopyRight.setForeground(UIColorUtilities.SOFT_FOREGROUND);
        bottomPanel.add((Component)labelCopyRight, UiUtilities.getGridBagConstraints((int)1, (int)row++, (int)4, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)60, (int)0, (int)0, (int)0, (int)0));
        DescriptionTextArea textNotice = new DescriptionTextArea(MSGRES.getString("LoginPanel.label.message"));
        textNotice.setForeground(UIColorUtilities.SOFT_FOREGROUND);
        bottomPanel.add((Component)textNotice, UiUtilities.getGridBagConstraints((int)1, (int)row++, (int)4, (int)3, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)60, (int)15, (int)40, (int)0, (int)0));
        panel.add((Component)bottomPanel, "South");
        return panel;
    }

    private JPanel getInnerPanel() {
        RestrictedPlainDocument nameDoc = new RestrictedPlainDocument(64);
        nameDoc.setValidator("\"/\\[]:;|=,+*?<>", false);
        this.getJTFUsername().setDocument(nameDoc);
        this.initUsernamePassword();
        this.getJCmbServerAddr().setEditable(true);
        this.initOptionButton();
        this.initServerAddr();
        int right = 60;
        int between = 30;
        int row = 1;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(30, 60, 0, 20));
        panel.add((Component)new JLabel(ConsoleMain.LOGO_IMAGE), UiUtilities.getGridBagConstraints((int)1, (int)row, (int)1, (int)1, (double)0.0, (double)0.0, (int)13, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0));
        panel.add((Component)new JLabel(ConsoleMain.getNAME_IMAGE()), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)4, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)0, (int)0, (int)0, (int)0, (int)25, (int)0));
        JLabel userNameLabel = new JLabel(MSGRES.getString("LoginPanel.label.userName"));
        panel.add((Component)userNameLabel, UiUtilities.getGridBagConstraints((int)1, (int)row, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0));
        panel.add((Component)this.getJTFUsername(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)3, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)between, (int)0, (int)right, (int)0, (int)0));
        userNameLabel.setLabelFor(this.getJTFUsername());
        panel.add((Component)this.getJLPassword(), UiUtilities.getGridBagConstraints((int)1, (int)row, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0));
        panel.add((Component)this.getJPFPassword(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)3, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)between, (int)0, (int)right, (int)0, (int)0));
        this.getJLPassword().setLabelFor(this.getJPFPassword());
        JLabel serverLabel = new JLabel(MSGRES.getString("LoginPanel.label.server"));
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            this.getJCmbServerAddr().setVisible(false);
        } else {
            panel.add((Component)serverLabel, UiUtilities.getGridBagConstraints((int)1, (int)row, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0));
        }
        panel.add(this.getJCmbServerAddr(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)3, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)between, (int)0, (int)right, (int)0, (int)0));
        serverLabel.setLabelFor(this.jcmbServerAddr);
        this.getJCmbServerAddr().getAccessibleContext().setAccessibleName(MSGRES.getString("LoginPanel.label.server"));
        panel.add((Component)this.getJLDomain(), UiUtilities.getGridBagConstraints((int)1, (int)row, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0));
        panel.add((Component)this.getJTFDomain(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)3, (int)1, (double)1.0, (double)0.0, (int)10, (int)2, (int)10, (int)between, (int)0, (int)right, (int)0, (int)0));
        this.getJLDomain().setLabelFor(this.getJTFDomain());
        panel.add((Component)this.getJCbxRememberMe(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)10, (int)between, (int)0, (int)right, (int)0, (int)0));
        panel.add((Component)this.getJCbxRememberMyPassword(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)0, (int)between, (int)0, (int)right, (int)0, (int)0));
        panel.add((Component)this.getJcbxSmartCardAuthentication(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)3, (int)between, (int)0, (int)right, (int)0, (int)0));
        panel.add((Component)this.getForgotPasswordButton(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)1, (int)1, (double)0.0, (double)0.0, (int)17, (int)0, (int)5, (int)between, (int)0, (int)0, (int)0, (int)0));
        this.updatePasswordItemsBasedOnSwitch();
        panel.add((Component)this.getButtonPanel(), UiUtilities.getGridBagConstraints((int)2, (int)row++, (int)1, (int)1, (double)0.0, (double)0.0, (int)13, (int)0, (int)20, (int)between, (int)0, (int)right, (int)0, (int)0));
        ActionListener ationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object source = event.getSource();
                if (source == LoginPanel.this.getJCbxRememberMe()) {
                    if (!LoginPanel.this.getJCbxRememberMe().isSelected()) {
                        LoginPanel.this.getJCbxRememberMyPassword().setSelected(false);
                    }
                } else if (source == LoginPanel.this.getJCbxRememberMyPassword() && LoginPanel.this.getJCbxRememberMyPassword().isSelected()) {
                    LoginPanel.this.getJCbxRememberMe().setSelected(true);
                }
            }
        };
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LoginPanel.this.passwordChanged = true;
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LoginPanel.this.passwordChanged = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LoginPanel.this.passwordChanged = true;
            }
        };
        this.getJPFPassword().getDocument().addDocumentListener(documentListener);
        this.getJCbxRememberMe().addActionListener(ationListener);
        this.getJCbxRememberMyPassword().addActionListener(ationListener);
        return panel;
    }

    private void initUsernamePassword() {
        this.loadPasswordRecoveryFile();
        if (!(GUIManager.getAuthKey() != null && GUIManager.getAuthKey().length() > 0 || AUTO_LOGIN_DONE || this.getJTFUsername().getText() != null && this.getJTFUsername().getText().length() != 0 || System.getProperty(SYSPROPERTY_USERNAME) == null)) {
            this.getJTFUsername().setText(System.getProperty(SYSPROPERTY_USERNAME));
        }
        if (!(GUIManager.getAuthKey() != null && GUIManager.getAuthKey().length() > 0 || AUTO_LOGIN_DONE || this.getJPFPassword().getPassword() != null && this.getJPFPassword().getPassword().length != 0 || System.getProperty(SYSPROPERTY_PASSWORD) == null)) {
            this.encryptedPassword = System.getProperty(SYSPROPERTY_PASSWORD);
            char[] charPassword = Utility.decryptLatestasChar((String)System.getProperty(SYSPROPERTY_PASSWORD));
            if (charPassword != null) {
                for (int i = 0; i < charPassword.length; ++i) {
                    try {
                        this.getJPFPassword().getDocument().insertString(i, Character.toString(charPassword[i]), null);
                        continue;
                    }
                    catch (BadLocationException ex) {
                        LoggerUtilities.logException((Throwable)ex);
                    }
                }
                Arrays.fill(charPassword, '0');
            }
            this.passwordChanged = false;
        }
        if ((GUIManager.getAuthKey() == null || GUIManager.getAuthKey().length() <= 0) && System.getProperty("rememberPassword") != null) {
            rememberPassword = System.getProperty("rememberPassword");
        }
    }

    private void initServerAddr() {
        if (System.getProperty(SYSPROPERTY_SERVERADDR, null) != null) {
            this.getJCmbServerAddr().setSelectedItem(System.getProperty(SYSPROPERTY_SERVERADDR));
        }
    }

    private HyperlinkPane getForgotPasswordButton() {
        if (this.forgetPasswordPane == null) {
            this.forgetPasswordPane = new HyperlinkPane();
            this.forgetPasswordPane.setContentType("text/html");
            StringBuffer str = new StringBuffer();
            str.append("<html><a href=\"http://localhost/a.html#FORGOTPWD\" style=\"color:");
            str.append(UIColorUtilities.colorToString((Color)UIColorUtilities.SOFT_FOREGROUND));
            str.append("\">");
            str.append(MSGRES.getString("LoginPanel.link.forgotPassword"));
            str.append("</div></a></html>");
            this.forgetPasswordPane.setText(str.toString());
            this.forgetPasswordPane.setEditable(false);
            this.forgetPasswordPane.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent ex) {
                }

                @Override
                public void keyReleased(KeyEvent ex) {
                }

                @Override
                public void keyPressed(KeyEvent ex) {
                    if (ex.getKeyCode() == 10) {
                        LoginPanel.this.forgotPassword();
                    }
                }
            });
            this.forgetPasswordPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent ex) {
                    if (ex.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        LoginPanel.this.forgotPassword();
                    }
                }
            });
        }
        return this.forgetPasswordPane;
    }

    private void forgotPassword() {
        ResetPasswordDlg dlg = new ResetPasswordDlg((String)this.getJCmbServerAddr().getSelectedItem(), this.getJTFUsername().getText().trim(), this.getJTFDomain().getText().trim());
        dlg.setVisible(true);
        String isResetPassword = dlg.getIsResetPassword();
        if (!StringUtilities.isEmpty((String)isResetPassword)) {
            resetPassword = isResetPassword;
            this.updatePasswordItemsBasedOnSwitch();
        }
    }

    private JPanel getButtonPanel() {
        this.initLoginButton();
        this.getJBExit().addActionListener(event -> {
            AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(AjaxSwingCommonUtil::logoutWebConsole);
            Utility.exitSystem((int)0);
        });
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{this.getLoginButton(), this.getJBExit(), this.getJBOption()}, 0, 4, true, false, 2);
        return panel;
    }

    private void initOptionButton() {
        String option = this.options.getLoginOption();
        this.msg("LoginPanel> getOptionButton>> option: " + option);
        this.getJBOption().setText(this.getOptionButtonText(option));
        this.getJBOption().setActionCommand(option);
        this.getJBOption().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                String option = LoginPanel.this.getJBOption().getActionCommand();
                option = option.equals("more") ? "less" : "more";
                LoginPanel.this.getJBOption().setActionCommand(option);
                LoginPanel.this.getJBOption().setText(LoginPanel.this.getOptionButtonText(option));
                LoginPanel.this.updateDomainField();
                LoginPanel.this.updateSmartCardCheckbox();
            }
        });
    }

    private void initLoginButton() {
        this.getLoginButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                Browser.setLogOutInProgress(false);
                if ((GUIManager.getAuthKey() == null || GUIManager.getAuthKey().length() <= 0) && LoginPanel.this.getJTFUsername().getText().trim().length() == 0) {
                    UIUtilities.showErrorDialog(MSGRES.getString("LoginPanel.msg.noUserName"));
                    return;
                }
                if (!(GUIManager.getAuthKey() != null && GUIManager.getAuthKey().length() > 0 || LoginPanel.this.getJcbxSmartCardAuthentication().isSelected() || new String(LoginPanel.this.getJPFPassword().getPassword()).length() != 0)) {
                    UIUtilities.showErrorDialog(MSGRES.getString("LoginPanel.msg.noPassword"));
                    return;
                }
                String serverName = (String)LoginPanel.this.getJCmbServerAddr().getSelectedItem();
                if (!(GUIManager.getAuthKey() != null && GUIManager.getAuthKey().length() > 0 || UIUtilities.isValidServer(serverName))) {
                    UIUtilities.showErrorDialog(MSGRES.getString("LoginPanel.msg.invalidServer"));
                    return;
                }
                LoginPanel.formatApplicationName(serverName);
                MonitorAgent.getInstance().startApplication(applicationName);
                if ((GUIManager.getAuthKey() == null || GUIManager.getAuthKey().length() <= 0) && serverName.trim().length() == 0) {
                    UIUtilities.showErrorDialog(MSGRES.getString("LoginPanel.msg.noServer"));
                    return;
                }
                MonitorAgent.getInstance().startScenario("Login", "SEPM_Java");
                SwingWorker worker = new SwingWorker(){
                    String instanceId = GUIDGenerator.getInstance().getGUIDString();
                    private Exception exception = null;
                    private SimpleProgressDlg dlg = new SimpleProgressDlg(Manager.getFrame(), MSGRES.getString("LoginPanel.msg.loginToPM"), MSGRES.getString("LoginPanel.msg.loginToThePMPleaseWait"), false, true);
                    TimeCounter tc = new TimeCounter();

                    public Object construct() {
                        try {
                            LoginPanel.this.options.setLoginOption(LoginPanel.this.getJBOption().getActionCommand(), String.valueOf(LoginPanel.this.showUACWarning));
                            LoginPanel.this.msg("\n\n############# Begin Login ###############, instance: " + this.instanceId);
                            UIUtilities.initProgressStatus(this.dlg, false);
                            LoginPanel.this.login(this.dlg);
                            UIUtilities.updateProgressStatus(this.dlg, 100);
                        }
                        catch (CancellationException ce) {
                            UIUtilities.disposeProgressStatus(this.dlg);
                            LoginPanel.this.getLoginButton().setEnabled(true);
                        }
                        catch (Exception ex) {
                            this.exception = ex;
                        }
                        return null;
                    }

                    public void finished() {
                        LoginPanel.this.msg("\n\n############# Enter finished method ###############, instance: " + this.instanceId);
                        if (this.exception != null) {
                            UIUtilities.disposeProgressStatus(this.dlg);
                            ConsoleLogger.log(this.exception);
                            Manager.getFrame().setPanel(LoginPanel.this);
                            Manager.getFrame().getRootPane().setDefaultButton(LoginPanel.this.getLoginButton());
                            ConsoleMain.initFrame();
                            AjaxSwingManager.endOperation();
                            if (LoginPanel.this.needRelogin) {
                                LoginPanel.this.msg("\n\n############# Exception-1-relogin ###############, instance: " + this.instanceId + ", ex: " + this.exception.getMessage());
                                LoginPanel.this.needRelogin = false;
                                LoginPanel.this.getLoginButton().doClick();
                            } else {
                                LoginPanel.this.msg("\n\n############# Exception-1-return ###############, instance: " + this.instanceId + ", ex: " + this.exception.getMessage());
                            }
                            return;
                        }
                        MonitorAgent.getInstance().stopEvent(null);
                        MonitorAgent.getInstance().stopScenario("Login");
                        DataobjectManager dataMgr = DataobjectManager.getInstance();
                        if (dataMgr.getCurrentAdministrator() != null) {
                            try {
                                LoginPanel.this.setMainPanel();
                            }
                            catch (Exception ex) {
                                ConsoleLogger.log(ex);
                                LoginPanel.this.msg("\n\n############# Exception-2-relogin ###############, instance: " + this.instanceId + ", ex: " + ex.getMessage());
                                UIUtilities.disposeProgressStatus(this.dlg);
                                Manager.getFrame().showLoginPanel();
                                return;
                            }
                        }
                        UIUtilities.disposeProgressStatus(this.dlg);
                        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                        if (admin == null || admin.getSemAdmin() == null || admin.isNull()) {
                            LoginPanel.this.msg("\n\n############# Admin is null-return ###############, instance: " + this.instanceId);
                            return;
                        }
                        Browser.setLoginFlowCompleted(true);
                        if (LoginPanel.this.showWelcomeScreen(admin)) {
                            QuickStartDialog dialog = new QuickStartDialog();
                            dialog.setVisible(true);
                        }
                        LoginPanel.this.msg("############# AjaxSwingManager.endOperation ###############, instance: " + this.instanceId);
                        AjaxSwingManager.endOperation();
                        GUIManagerReportingHelper.storeAjaxSwingSessionCookie();
                        LoginPanel.this.msg("############# After Login ###############, instance: " + this.instanceId + ", tc: " + this.tc);
                    }
                };
                AjaxSwingManager.beginOperation();
                worker.start();
            }
        });
    }

    private boolean showWelcomeScreen(AdminObject admin) {
        if (admin == null || admin.getSemAdmin() == null || admin.isNull()) {
            return false;
        }
        String adminViewedVersion = admin.getAdminViewedVersion();
        if (null == adminViewedVersion || adminViewedVersion.isEmpty()) {
            return true;
        }
        if (Utility.compareVersion((String)ScmProperties.get("scm.server.version", null), (String)admin.getAdminViewedVersion()) == 1) {
            return true;
        }
        boolean displayWelcomeScreen = !admin.getDisabledCIWReminder();
        displayWelcomeScreen = displayWelcomeScreen ? displayWelcomeScreen : QuickStartDialog.hasAnyRequiredTasksPending();
        return displayWelcomeScreen;
    }

    private String getOptionButtonText(String option) {
        return UIText.get(option.equals("less") ? 3073 : 2817);
    }

    private void updateDomainField() {
        boolean moreOption = this.getJBOption().getActionCommand().equals("more");
        this.getJLDomain().setVisible(moreOption);
        this.getJTFDomain().setVisible(moreOption);
    }

    private void updateSmartCardCheckbox() {
        boolean moreOption = this.getJBOption().getActionCommand().equals("more");
        this.getJcbxSmartCardAuthentication().setVisible(moreOption);
    }

    protected String getPhpIpAddress() {
        String ip = LOCAL_HOST;
        String port = System.getProperty("scm.webserver.http.port", "8014");
        String url = this.getUrl(ip, port);
        if (!this.testConnection(url)) {
            Set ipAddress = NetworkUtils.getAllLocalIPAddress((Boolean)true);
            for (String newIp : ipAddress) {
                url = this.getUrl(newIp, port);
                if (!this.testConnection(url)) continue;
                ip = newIp;
                break;
            }
        }
        return ip;
    }

    protected String getUrl(String ip, String port) {
        if (port == null || "80".equals(port)) {
            return "http://" + ip + "/Reporting/index.php";
        }
        return "http://" + ip + ":" + port + "/Reporting/index.php";
    }

    protected boolean testConnection(String url) {
        Hashtable session = new Hashtable();
        try (InputStream is = communicator.getRequestInputStream(session, url, 0);){
            int numberOfBytes = is.available();
            ConsoleLogger.log("LoginPanel> testConnection>> connection success. numberOfBytes: " + numberOfBytes);
        }
        catch (CommunicationException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private void commitPassword(String password) throws ConsoleException {
        String hash = PasswordUtil.createPKDBF2PasswordHash(password);
        AdminObject admin = AdminObject.retrieveCurrentAdminObject();
        if (null != admin) {
            PasswordSettingsUtil.addPasswordToHistory(admin, password.toCharArray());
            AbstractAdminHandler handler = AbstractAdminHandler.getInstance(admin);
            handler.updatePassword(admin, hash, AbstractAdminHandler.ActionType.UPDATE, true);
            DataobjectManager.getInstance().setCurrentAdminPassword(Utility.encryptLatest((String)password));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void login(SimpleProgressDlg dlg) throws ConsoleException {
        block62: {
            block63: {
                block58: {
                    block61: {
                        block59: {
                            block60: {
                                if (!this.getLoginButton().isEnabled()) {
                                    Toolkit.getDefaultToolkit().beep();
                                    return;
                                }
                                System.setProperty("consoleusecase", "LOGIN");
                                this.forgetPasswordPane.setEnabled(false);
                                this.getLoginButton().setEnabled(false);
                                userName = this.getJTFUsername().getText().trim();
                                domainName = this.getJTFDomain().getText().trim();
                                pwd = null;
                                server = (String)this.getJCmbServerAddr().getSelectedItem();
                                if (server != null && server.trim().length() > 0) {
                                    if (server.indexOf(58) != -1) {
                                        serverip = server.substring(0, server.lastIndexOf(58));
                                        serverport = server.substring(server.lastIndexOf(58) + 1);
                                        if ("localhost".equalsIgnoreCase(serverip)) {
                                            serverip = this.getPhpIpAddress();
                                        }
                                        Env.setSemServer(serverip);
                                        port = Env.getSEM_PORT();
                                        try {
                                            port = Integer.parseInt(serverport);
                                        }
                                        catch (Exception ignore) {
                                            port = -1;
                                        }
                                        Env.setSemServerPort(port);
                                    } else {
                                        Env.setSemServer(server);
                                    }
                                }
                                UIUtilities.updateProgressStatus(dlg, 20);
                                if (this.passwordChanged) {
                                    pwd = this.getJPFPassword().getPassword();
                                    try {
                                        this.encryptedPassword = Utility.encryptLatest((char[])pwd);
                                    }
                                    catch (Exception ex) {
                                        LoggerUtilities.logException((Throwable)ex);
                                        throw new ConsoleException(ex);
                                    }
                                    this.passwordChanged = false;
                                }
                                SmartCardPkcsKeyStore.setAfterSmartCardLogin((boolean)false);
                                if (this.getJcbxSmartCardAuthentication().isSelected()) {
                                    ajaxSwingRequest = AjaxSwingCommonUtil.isAjaxSwingRunning();
                                    ConsoleLogger.log("LoginPanel> login>> Smartcard based authentication. ajaxSwingRequest: " + ajaxSwingRequest);
                                    if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                                        certs = AjaxSwingCommonUtil.getCertificatesFromHttpRequest();
                                        if (certs.isEmpty()) {
                                            ConsoleLogger.log("LoginPanel> login>> SmartCard certificate retrieved from Ajax swing http connection request is null.");
                                            UIUtilities.showErrorDialog(LoginPanel.MSGRES.getString("LoginPanel.msg.CardRead.Error"));
                                            throw new ConsoleException("Not able to retrieve the certificate from Ajax swing http connection request");
                                        }
                                        SmartCardUtil.doSmartCardBasedLogin(userName, domainName, certs, null);
                                    } else {
                                        cardTerminalHandle = SmartCardUtil.getSmartCardTerminal();
                                        if (cardTerminalHandle == null) {
                                            ConsoleLogger.log("LoginPanel> login>> Can't read smart card terminal. cardTerminalHandle is null.");
                                            UIUtilities.showErrorDialog(LoginPanel.MSGRES.getString("LoginPanel.msg.CardRead.Error"));
                                            throw new ConsoleException("Not able to read the smart card.");
                                        }
                                        try {
                                            SmartCardUtil.doSmartCardBasedLogin(userName, domainName, cardTerminalHandle);
                                        }
                                        catch (CancellationException ce) {
                                            SmartCardPkcsKeyStore.logOutFromSmartCard();
                                            throw ce;
                                        }
                                        catch (Throwable t1) {
                                            list = new ArrayList<Throwable>();
                                            count = 1;
                                            for (result = t1; result != null && !list.contains(result) && count <= 10; result = result.getCause(), ++count) {
                                                list.add(result);
                                            }
                                            System.out.println("the count is " + count);
                                            v0 = result = list.size() < 2 ? t1 : (Throwable)list.get(list.size() - 1);
                                            if (result != null && !StringUtilities.isEmpty((String)(rootCauseMessage = result.getMessage())) && rootCauseMessage.contains("CKR_PIN")) {
                                                expectedMessage = MessageResources.getInstance().getString("com.sygate.scm.util.util", "ErrorMsg_en_US.EE.SmartcardAuthenticationFailurePleaseRetry");
                                                UIUtilities.showErrorDialog(expectedMessage);
                                                throw new ConsoleException(expectedMessage);
                                            }
                                            SmartCardPkcsKeyStore.logOutFromSmartCard();
                                            throw new ConsoleException(t1, true);
                                        }
                                    }
                                } else {
                                    ConsoleLogger.log("LoginPanel> login>> Non smartcard based authentication.");
                                    Manager.doLogin(userName, this.encryptedPassword, null, domainName);
                                }
                                DataobjectManager.getInstance().setCurrentAdminPassword(Utility.encryptLatest((char[])this.getJPFPassword().getPassword()));
                                UIUtilities.updateProgressStatus(dlg, 30);
                                ScmProperties.load();
                                this.storePasswordRecoveryFile();
                                UIUtilities.updateProgressStatus(dlg, 40);
                                if (!Manager.isCurrentAdminPasswordExpired()) break block58;
                                state = this.setAdminExpiredPassword();
                                if (ReturnState.FAIL != state) break block59;
                                Manager.getFrame().showLoginPanel();
                                if (pwd != null) {
                                    PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                                }
                                if (pwd == null) break block60;
                                PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                                this.getJPFPassword().setText("");
                            }
                            return;
                        }
                        if (pwd != null) {
                            PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                        }
                        try {
                            charPassword = Utility.decryptLatestasChar((String)this.encryptedPassword);
                            for (i = 0; i < charPassword.length; ++i) {
                                this.getJPFPassword().getDocument().insertString(i, Character.toString(charPassword[i]), null);
                            }
                            Arrays.fill(charPassword, '0');
                            this.passwordChanged = false;
                        }
                        catch (Exception ex) {
                            LoggerUtilities.logException((Throwable)ex);
                        }
                        this.storePasswordRecoveryFile();
                        if (ReturnState.SUCCESS_VIP != state) break block58;
                        ConsoleLogger.log("LoginPanel:login: VIP password change, logout.");
                        Manager.getFrame().showLoginPanel();
                        if (pwd == null) break block61;
                        PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                        this.getJPFPassword().setText("");
                    }
                    return;
                }
                UIUtilities.updateProgressStatus(dlg, 50);
                data = DataobjectManager.getInstance();
                domain = data.getSemDomain(Manager.getCurrentDomainId());
                LoginPanel.rememberPassword = AjaxSwingCommonUtil.isAjaxSwingRunning() == false ? (domain.getOptRememberPassword() == null ? domain.getDefRememberPassword() : domain.getOptRememberPassword()).toString() : "false";
                root = data.getSemConfigRoot();
                LoginPanel.resetPassword = (root.getOptIsPSWRecoverable() == null ? root.getDefIsPSWRecoverable() : root.getOptIsPSWRecoverable()).toString();
                if (!Manager.isSystemAdmin(data.getCurrentAdministrator()) || domainName == null || domainName.length() <= 0) ** GOTO lbl172
                inputDomainObj = null;
                try {
                    inputDomainObj = AdminHandler.getDomainObjByName(domainName);
                }
                catch (Exception ex) {
                    ConsoleLogger.log(ex);
                }
                domainId = data.getLoginInformation().getOptDomainGUID();
                if (domainId == null || domainId.length() <= 0 || inputDomainObj == null || !inputDomainObj.getId().equals(domainId)) break block62;
                this.msg("LoginPanel> login>> The input domain is same as the login one.");
                this.storePasswordRecoveryFile();
                if (!LoginPanel.isSBProduct && !this.getJTFDomain().getText().trim().isEmpty()) {
                    ConsoleLogger.log("LoginPanel> login>> Domain name: " + this.getJTFDomain().getText().trim());
                }
                this.options = ConsoleOptions.getInstance(true);
                this.options.setLoginOption(this.jbOption.getActionCommand(), String.valueOf(this.showUACWarning));
                this.showDomainLogonBanner(domain);
                if (pwd == null) break block63;
                PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                this.getJPFPassword().setText("");
            }
            return;
        }
        try {
            UIUtilities.updateProgressStatus(dlg, 60);
            msgInputDomain = "";
            if (inputDomainObj == null) {
                msgInputDomain = LoginPanel.MSGRES.getString("LoginPanel.msg.domainDoesNotExist");
            } else if (!inputDomainObj.isEnabled()) {
                msgInputDomain = LoginPanel.MSGRES.getString("LoginPanel.msg.domainIsDisabled");
            } else {
                this.msg("LoginPanel> login>> WARNING The input domain, " + domainName + ", exists and is enabled. Why to switch to another domain ??");
            }
            UIUtilities.updateProgressStatus(dlg, 70);
            msgLoginDomain = "";
            if (domainId != null && domainId.length() > 0) {
                semDomain = (SemDomain)data.getObjectByGUID("SemDomain", domainId);
                loginDomainName = semDomain.getName();
                obj = new Object[]{loginDomainName};
                message = LoginPanel.MSGRES.getString("LoginPanel.msg.youHaveBeenLoggedIntoDomain");
                msgLoginDomain = MessageFormat.format(message, obj);
            } else {
                msgLoginDomain = LoginPanel.MSGRES.getString("LoginPanel.msg.youDoNotLogintoAnyDomain");
            }
            UIUtilities.showWarningDialog(msgInputDomain + " " + msgLoginDomain);
lbl172:
            // 2 sources

            UIUtilities.updateProgressStatus(dlg, 80);
            this.showDomainLogonBanner(domain);
            licState = data.getLoginInformation().getOptLicenseState();
            if (licState != null && licState.endsWith("_TRIAL") && data.getLoginInformation().getOptLicenseExpired() != null && Boolean.TRUE.equals(data.getLoginInformation().getOptLicenseExpired())) {
                msgbox = new ConfirmationMsgBox(Manager.getFrame(), LoginPanel.MSGRES.getString("LoginPanel.msg.maintenanceLicenseExpired"));
                msgbox.init(LoginPanel.MSGRES.getString("LoginPanel.msg.yourMaintenanceLicenseExpired"), 50);
                msgbox.getCheckBox().setVisible(false);
                msgbox.show();
            }
            UIUtilities.updateProgressStatus(dlg, 90);
            this.options = ConsoleOptions.getInstance(true);
            this.options.setLoginOption(this.jbOption.getActionCommand(), String.valueOf(this.showUACWarning));
            if (this.getJCbxRememberMe().isSelected() && !Utility.getBooleanValue((String)LoginPanel.rememberPassword, (Boolean)Boolean.FALSE)) {
                UIUtilities.showErrorDialog(LoginPanel.MSGRES.getString("LoginPanel.msg.disabledRememberPassword"));
            }
            this.updatePasswordItemsBasedOnSwitch();
            this.storePasswordRecoveryFile();
            if (!LoginPanel.isSBProduct && !this.getJTFDomain().getText().trim().isEmpty()) {
                ConsoleLogger.log("LoginPanel> login>> Domain name: " + this.getJTFDomain().getText().trim());
            }
            ** if (pwd == null) goto lbl-1000
        }
        catch (ConsoleException ex) {
            try {
                if (ex.getErrorCode() == 0) {
                    Manager.doLogout(false);
                } else {
                    GUIManager.stopAllBackgroupThreads();
                    message = this.getConsoleExceptionMessage(ex);
                    if (ex.getErrorCode() == 0x14010000) {
                        builder = new StringBuilder("Failed to login with given info. ");
                        if (GUIManager.getConsoleUsage().equals("ConsoleUsagePortal2")) {
                            builder.append(" From Host:");
                            builder.append(AjaxSwingUtil.getRemoteHostIP());
                            ConsoleLogger.logError(builder.toString());
                        } else if (GUIManager.getConsoleUsage().equals("ConsoleUsageThick")) {
                            ConsoleLogger.logError(builder.toString());
                        }
                        ConsoleLogger.logError(ex.getMessage());
                    } else {
                        ConsoleLogger.log(ex);
                    }
                    if (ex.getMessageId() == 253) {
                        this.enableDomain(ex.getObjects());
                    } else if (ex.getMessageId() == 254) {
                        this.createDefaultDomain(userName);
                    } else {
                        UIUtilities.showErrorDialog(message);
                        Manager.getFrame().setPanel(this);
                        ConsoleMain.initFrame();
                    }
                }
                this.getLoginButton().setEnabled(true);
                this.forgetPasswordPane.setEnabled(true);
                throw ex;
            }
            catch (Throwable var17_34) {
                if (pwd != null) {
                    PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
                    this.getJPFPassword().setText("");
                }
                throw var17_34;
            }
        }
lbl-1000:
        // 1 sources

        {
            PasswordClearUtil.clearPasswordInMemory(pwd, this.getJPFPassword());
            this.getJPFPassword().setText("");
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    private void showDomainLogonBanner(SemDomain domain) throws ConsoleException {
        LoginBanner banner = domain.getOptLoginBanner();
        if (banner != null && banner.getDisplay().booleanValue()) {
            String title = banner.getOptLoginBannerTitle();
            LoginBannerText bannerText = banner.getLoginBannerText();
            String text = bannerText.getOptContent();
            if (text != null && text.trim().length() > 0) {
                MultiLineMsgBox loginBannerDialog = new MultiLineMsgBox(Manager.getFrame(), title);
                loginBannerDialog.init(text, 50, 1, 2);
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    ClientAgent.getCurrentInstance().setUpdateBrowserInterval(2);
                    AjaxSwingManager.endOperation((boolean)true);
                }
                if (0 != loginBannerDialog.show()) {
                    ConsoleException ex = new ConsoleException(0);
                    ex.setNeedRelogin(true);
                    throw ex;
                }
                if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                    ClientAgent.getCurrentInstance().setUpdateBrowserInterval(0);
                    AjaxSwingManager.beginOperation();
                }
            }
        }
    }

    private void storePasswordRecoveryFile() {
        if (!GUIManager.getConsoleUsage().equals("ConsoleUsageThick") && !GUIManager.getConsoleUsage().equals("ConsoleUsagePortal2")) {
            ConsoleLogger.log("LoginPanel> storePasswordRecoveryFile>> Not logged in through Java Console or AjaxSwing, skipping password recovery file save operation.");
            return;
        }
        this.prop.clear();
        this.prop.setProperty("userName", this.getJTFUsername().getText().trim());
        if (!isSBProduct && !this.getJCbxRememberMe().isSelected() || !Utility.getBooleanValue((String)rememberPassword, (Boolean)Boolean.FALSE)) {
            this.prop.setProperty("userName", "");
        }
        if (!this.getJCbxRememberMyPassword().isSelected() || !Utility.getBooleanValue((String)rememberPassword, (Boolean)Boolean.FALSE)) {
            this.prop.setProperty("password", "");
        } else {
            this.prop.setProperty("password", this.encryptedPassword);
        }
        if (!isSBProduct) {
            this.prop.setProperty("serverAddress", (String)this.getJCmbServerAddr().getSelectedItem());
            this.prop.setProperty("domain", this.getJTFDomain().getText().trim());
        }
        this.prop.setProperty("resetPassword", resetPassword);
        this.prop.setProperty("rememberPassword", rememberPassword);
        GUIManager.storePasswordRecoveryFile(this.prop);
    }

    private void loadPasswordRecoveryFile() {
        if (!GUIManager.getConsoleUsage().equals("ConsoleUsageThick") && !GUIManager.getConsoleUsage().equals("ConsoleUsagePortal2")) {
            ConsoleLogger.log("LoginPanel> loadPasswordRecoveryFile>> Not logged in through Java Console or AjaxSwing, skipping password recovery file load operation.");
            return;
        }
        try {
            String password;
            String username;
            GUIManager.loadPasswordRecoveryFile(this.prop);
            if (!StringUtilities.isEmpty((String)this.prop.getProperty("resetPassword"))) {
                resetPassword = this.prop.getProperty("resetPassword");
            }
            if (!StringUtilities.isEmpty((String)this.prop.getProperty("rememberPassword"))) {
                rememberPassword = this.prop.getProperty("rememberPassword");
            }
            if (!StringUtilities.isEmpty((String)(username = this.prop.getProperty("userName")))) {
                this.getJTFUsername().setText(username);
                if (!isSBProduct) {
                    this.getJCbxRememberMe().setSelected(true);
                }
            }
            if (!StringUtilities.isEmpty((String)(password = this.prop.getProperty("password")))) {
                char[] charPassword = Utility.decryptLatestasChar((String)password);
                if (charPassword != null) {
                    for (int i = 0; i < charPassword.length; ++i) {
                        this.getJPFPassword().getDocument().insertString(i, Character.toString(charPassword[i]), null);
                    }
                    Arrays.fill(charPassword, '0');
                }
                this.passwordChanged = false;
                this.getJCbxRememberMyPassword().setSelected(true);
                this.encryptedPassword = password;
            }
            String domainName = this.prop.getProperty("domain") == null ? "" : this.prop.getProperty("domain");
            String serverAddress = this.prop.getProperty("serverAddress");
            if (!(!this.getJCbxRememberMe().isSelected() && !this.getJCbxRememberMyPassword().isSelected() || domainName == null && serverAddress == null || isSBProduct)) {
                this.getJTFDomain().setText(domainName);
                int index = this.getJCmbServerAddr().getItemCount();
                boolean exist = false;
                for (int i = 0; i < index; ++i) {
                    String server = this.getJCmbServerAddr().getItemAt(i);
                    if (StringUtilities.isEmpty((String)serverAddress) || !serverAddress.equals(server)) continue;
                    this.getJCmbServerAddr().setSelectedIndex(i);
                    exist = true;
                    break;
                }
                if (!StringUtilities.isEmpty((String)serverAddress) && !exist) {
                    this.getJCmbServerAddr().insertItemAt(serverAddress, index);
                }
            }
        }
        catch (Exception ex) {
            ConsoleLogger.log("LoginPanel> loadPasswordRecoveryFile>> Error loading credentials file. Exception: " + ex.getMessage());
            System.err.println("LoginPanel> loadPasswordRecoveryFile>> Error loading credentials file.");
            ConsoleLogger.log(ex);
        }
    }

    public void doAutomaticLogin(String username, String domain, String password, String server) {
        this.jtfUsername.setText(username);
        this.jpfPassword.setText(password);
        this.jtfDomain.setText(domain);
        this.jcmbServerAddr.setSelectedItem(server);
        this.jbLogin.doClick();
    }

    private void setMainPanel() throws ConsoleException {
        Manager.getFrame().setPanel(this);
        Manager.getFrame().setPanel(new MainPanel());
        Manager.getFrame().updateTitle();
        ConsoleMain.initFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnState setAdminExpiredPassword() {
        char[] oldPassword = this.getJPFPassword().getPassword();
        String oldHash = Utility.calculateHash((String)new String(oldPassword));
        AdminPwdExpirationDlg dlg = new AdminPwdExpirationDlg((Frame)Manager.getFrame(), MSGRES.getString("LoginPanel.msg.changeExpiredPassword"), oldHash, true);
        dlg.setIconImage(CustomLookAndFeel.TITLE_LOGO_IMAGE);
        dlg.setVisible(true);
        if (dlg.isCancelled()) {
            return ReturnState.FAIL;
        }
        char[] newPassword = dlg.getPassword();
        ReturnState state = ReturnState.FAIL;
        try {
            DataobjectManager.getInstance().setCurrentAdminPassword(Utility.encryptLatest((char[])newPassword));
            this.encryptedPassword = Utility.encryptLatest((char[])newPassword);
            String encryptedOldPassword = Utility.encryptLatest((char[])oldPassword);
            String domainName = this.getJTFDomain().getText().trim();
            AdminObject admin = AdminObject.retrieveCurrentAdminObject();
            Integer method = admin.getAuthenticationMethod();
            if (SemAdministrator.VIP.equals(method)) {
                state = ReturnState.SUCCESS_VIP;
                UIUtilities.showInfoDialog(MSGRES.getString("LoginPanel.msg.VipLoginAgain"));
                ConsoleLogger.log("LoginPanel:login: Committed new password for VIP account.");
            } else {
                Manager.doLogin(this.getJTFUsername().getText().trim(), encryptedOldPassword, this.encryptedPassword, domainName);
                state = ReturnState.SUCCESS;
                ConsoleLogger.log("LoginPanel:login: Committed new password for non-VIP account.");
            }
            this.commitPassword(new String(newPassword));
            ReturnState returnState = state;
            return returnState;
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MSGRES.getString("LoginPanel.msg.consoleError"), 0);
        }
        catch (Exception ex) {
            this.msg("LoginPanel> setAdminExpiredPassword>> Exception: " + ex.getMessage());
            ConsoleLogger.log(ex);
        }
        finally {
            PasswordClearUtil.clearPasswordInMemory(newPassword, dlg.getTFPwd());
            PasswordClearUtil.clearPasswordInMemory(oldPassword, this.getJPFPassword());
        }
        return ReturnState.FAIL;
    }

    private void enableDomain(Object[] domainList) {
        if (0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MSGRES.getString("LoginPanel.msg.enableDisabledDomain"), MSGRES.getString("LoginPanel.title.enableDomain"), 0)) {
            EnableDomainDlg dlg = new EnableDomainDlg(MSGRES.getString("EnableDomainDlg.title"), domainList);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                this.needRelogin = true;
            }
            dlg.dispose();
        }
    }

    private void createDefaultDomain(String userName) {
        if (0 == JOptionPane.showConfirmDialog(Manager.getFrame(), MSGRES.getString("LoginPanel.msg.createNewDefaultDomain"), MSGRES.getString("LoginPanel.title.createDefaultDomain"), 0)) {
            try {
                GUIManager.createDefaultDomain(userName);
                this.needRelogin = true;
            }
            catch (ConsoleException ex) {
                UIUtilities.showErrorDialog(MSGRES.getString("LoginPanel.msg.failToCreateDefaultDomain"));
                ConsoleLogger.log(ex);
            }
        }
    }

    private void updatePasswordItemsBasedOnSwitch() {
        if (Utility.getBooleanValue((String)rememberPassword, (Boolean)Boolean.FALSE)) {
            if (!isSBProduct) {
                this.getJCbxRememberMe().setVisible(true);
            }
            this.getJCbxRememberMyPassword().setVisible(true);
        } else {
            this.getJCbxRememberMe().setVisible(false);
            this.getJCbxRememberMyPassword().setVisible(false);
        }
        if (Utility.getBooleanValue((String)resetPassword, (Boolean)Boolean.FALSE)) {
            this.getForgotPasswordButton().setVisible(true);
        } else {
            this.getForgotPasswordButton().setVisible(false);
        }
    }

    public JLabel getJLDomain() {
        if (this.jlDomain == null) {
            this.jlDomain = new JLabel(MSGRES.getString("LoginPanel.label.domain"));
        }
        return this.jlDomain;
    }

    public JLabel getJLPassword() {
        if (this.jlPassword == null) {
            this.jlPassword = new JLabel(MSGRES.getString("LoginPanel.label.password"));
        }
        return this.jlPassword;
    }

    public JTextField getJTFUsername() {
        if (this.jtfUsername == null) {
            this.jtfUsername = new JTextField(30);
            UIUtilities.setName(this.jtfUsername, PAGE_NAME, UIUtilities.ComponentType.TEXTFIELD, "name");
        }
        return this.jtfUsername;
    }

    public JPasswordField getJPFPassword() {
        if (this.jpfPassword == null) {
            this.jpfPassword = new SEPMPasswordField((Document)new RestrictedPlainDocument(1024), "", 30);
            UIUtilities.setName(this.jpfPassword, PAGE_NAME, UIUtilities.ComponentType.PASSWORDFIELD, "password");
        }
        return this.jpfPassword;
    }

    public JComboBox<String> getJCmbServerAddr() {
        if (this.jcmbServerAddr == null) {
            this.jcmbServerAddr = new JComboBox<String>(new String[]{LoginPanel.getDefServerAddress()});
            this.jcmbServerAddr.setPrototypeDisplayValue("123456789012345678901234567890");
            UIUtilities.setName(this.jcmbServerAddr, PAGE_NAME, UIUtilities.ComponentType.COMBOBOX, "serveraddress");
        }
        return this.jcmbServerAddr;
    }

    public JTextField getJTFDomain() {
        if (this.jtfDomain == null) {
            this.jtfDomain = new JTextField(new RestrictedPlainDocument(256), "", 30);
            UIUtilities.setName(this.jtfDomain, PAGE_NAME, UIUtilities.ComponentType.TEXTFIELD, "domain");
        }
        return this.jtfDomain;
    }

    public JButton getJBExit() {
        if (this.jbExit == null) {
            this.jbExit = new JButton(UIText.get(1029));
            UIUtilities.setName(this.jbExit, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "exit");
        }
        return this.jbExit;
    }

    public JButton getJBOption() {
        if (this.jbOption == null) {
            this.jbOption = new JButton();
            UIUtilities.setName(this.jbOption, PAGE_NAME, UIUtilities.ComponentType.BUTTON, "options");
        }
        return this.jbOption;
    }

    public JCheckBox getJCbxRememberMe() {
        if (this.jcbxRememberMe == null) {
            this.jcbxRememberMe = new JCheckBox(MSGRES.getString("LoginPanel.cbx.rememberMe"));
            UIUtilities.setName(this.jcbxRememberMe, PAGE_NAME, UIUtilities.ComponentType.CHECKBOX, "rememberme");
        }
        return this.jcbxRememberMe;
    }

    public JCheckBox getJCbxRememberMyPassword() {
        if (this.jcbxRememberMyPassword == null) {
            this.jcbxRememberMyPassword = new JCheckBox(MSGRES.getString("LoginPanel.cbx.rememberMyPassword"));
            UIUtilities.setName(this.jcbxRememberMyPassword, PAGE_NAME, UIUtilities.ComponentType.CHECKBOX, "rememberpassword");
        }
        return this.jcbxRememberMyPassword;
    }

    public JCheckBox getJcbxSmartCardAuthentication() {
        if (this.jcbxSmartCardAuthentication == null) {
            this.jcbxSmartCardAuthentication = new JCheckBox(MSGRES.getString("LoginPanel.cbx.smartcardAuthentication"));
            this.jcbxSmartCardAuthentication.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e1) {
                    if (e1.getStateChange() == 1) {
                        LoginPanel.this.getJPFPassword().setVisible(false);
                        LoginPanel.this.getJLPassword().setVisible(false);
                        LoginPanel.this.getForgotPasswordButton().setVisible(false);
                        LoginPanel.this.getJCbxRememberMe().setVisible(false);
                        LoginPanel.this.getJCbxRememberMyPassword().setVisible(false);
                    } else if (e1.getStateChange() == 2) {
                        LoginPanel.this.getJPFPassword().setVisible(true);
                        LoginPanel.this.getJLPassword().setVisible(true);
                        LoginPanel.this.getForgotPasswordButton().setVisible(true);
                        LoginPanel.this.updatePasswordItemsBasedOnSwitch();
                    }
                }
            });
            UIUtilities.setName(this.jcbxSmartCardAuthentication, PAGE_NAME, UIUtilities.ComponentType.CHECKBOX, "smartcard");
        }
        return this.jcbxSmartCardAuthentication;
    }

    public static String getDefServerAddress() {
        String name = LoginPanel.getServerNameFromWebConsole().orElseGet(() -> Optional.of(Env.getSEM_SERVER()).filter(v -> Env.getSEM_REMOTE_CONSOLE() != 0 || !Env.getSEM_SERVER().contains("_")).orElseGet(LoginPanel::getLocalHostAddress));
        WebViewPanel.setUrlHost((String)name);
        return name + ":" + Env.getSEM_PORT();
    }

    public static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ConsoleLogger.log("LoginPanel> getDefServerAddress>> Error while getting the server address. Exception: " + ex.getMessage());
            System.err.println("LoginPanel> getDefServerAddress>> Cannot get local host IP.");
            ConsoleLogger.log(ex);
            return LOCAL_HOST;
        }
    }

    public static Optional<String> getServerNameFromWebConsole() {
        if (!AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return Optional.empty();
        }
        Optional<String> serverName = Optional.ofNullable(AjaxSwingUtil.getServerName());
        Optional<String> urlHost = serverName.filter(url -> url.indexOf(".") != -1 || url.indexOf(":") != -1);
        serverName.ifPresent(WebViewPanel::setUrlHost);
        return urlHost.filter(url -> InetAddressValidator.getInstance().isValidInet4Address(url) || InetAddressValidator.getInstance().isValidInet6Address(url)).filter(UIUtilities::isLocalHostAddress).or(() -> urlHost.filter(LoginPanel::matchCanonicalHostName));
    }

    public static boolean matchCanonicalHostName(String url) {
        try {
            return url.equalsIgnoreCase(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.getJTFUsername().requestFocus();
    }

    String getConsoleExceptionMessage(ConsoleException ex) {
        String message = null;
        switch (ex.getMessageId()) {
            case 44: {
                if (this.getJcbxSmartCardAuthentication().isSelected()) {
                    message = MessageResources.getInstance().getString("com.sygate.scm.util.util", ERROR_MSG_SC_AUTH_FAILURE);
                    break;
                }
                message = MessageResources.getInstance().getString("com.sygate.scm.util.util", "ErrorMsg_en_US.EE.AuthenticationFailurePleaseRetry");
                break;
            }
            case 247: {
                message = MessageResources.getInstance().getString("com.sygate.scm.util.util", ERROR_MSG_SC_AUTH_FAILURE);
                break;
            }
            default: {
                message = ex.getMessageString();
            }
        }
        return message;
    }

    static {
        resetPassword = "true";
        rememberPassword = "false";
        isFirstShow = true;
    }

    public static enum ReturnState {
        FAIL,
        SUCCESS,
        SUCCESS_VIP;

    }
}

