/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnableDomainDlg
extends DialogBase {
    private static final long serialVersionUID = 9187199574206757132L;
    JComboBox<Object> domainList = null;
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");

    public EnableDomainDlg(String title, Object[] list) {
        super(Manager.getFrame(), title, true, false);
        this.initialize(list);
    }

    private void initialize(Object[] list) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setPreferredSize(new Dimension(250, 100));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        contentPanel.setLayout(new GridBagLayout());
        JLabel descLabel = new JLabel(MSGRES.getString("EnableDomainDlg.descriptionLabel"));
        JLabel listLabel = new JLabel(MSGRES.getString("EnableDomainDlg.domainLabel"));
        this.domainList = this.getDomainList(list);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.insets = new Insets(10, 5, 5, 5);
        constraints.fill = 0;
        constraints.anchor = 18;
        contentPanel.add((Component)descLabel, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        contentPanel.add((Component)listLabel, constraints);
        constraints.gridx = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.insets = new Insets(10, 5, 20, 5);
        contentPanel.add(this.domainList, constraints);
        this.getContentPane().add((Component)contentPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    @Override
    protected void commit() {
        try {
            DropdownItem item = (DropdownItem)this.domainList.getSelectedItem();
            String domainId = (String)item.getValue();
            GUIManager.enableDomain(domainId);
        }
        catch (ConsoleException e) {
            UIUtilities.showErrorDialog(MSGRES.getString("EnableDomainDlg.failToEnableDomain"));
        }
    }

    private JComboBox<Object> getDomainList(Object[] list) {
        ArrayList<DropdownItem> items = new ArrayList<DropdownItem>();
        for (Object obj : list) {
            String[] info = (String[])obj;
            DropdownItem item = new DropdownItem(info[0], (Object)info[1]);
            items.add(item);
        }
        return new JComboBox<Object>(items.toArray());
    }
}

