/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.configobject.XMLHelper;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.Utilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConsoleOptions {
    private static final int MAX_SIZE_OF_OPTION_FILE = 0x100000;
    private Document optionDocument;
    private final String fileName;
    private boolean isPolicyLocationCountingEnabled = true;
    private boolean isGetAllGroupLocationsEnabled = true;
    public static final String MORE_OPTION = "more";
    public static final String LESS_OPTION = "less";
    public static final String COMPUTER_MODE = "computer";
    public static final String USER_MODE = "user";
    public static final String MIX_MODE = "all";
    public static final String WINDOWS_MODE = "Windows";
    public static final String MAC_MODE = "Mac";
    public static final String ONLINE_STATUS = "true";
    public static final String OFFLINE_STATUS = "false";
    public static final String MAX_PAGE_SIZE = "30";
    private static final String SESM_ELEMENT = "sesm";
    private static final String LOGIN_ELEMENT = "login";
    private static final String OPTION_ATTRIBUTE = "option";
    private static final String UAC_WARN_ATTRIBUTE = "vistaWarn";
    private static final String DISPLAY_FILTER_ELEMENT = "displayFilter";
    private static final String MODE_ATTRIBUTE = "mode";
    private static final String ONLINE_ATTRIBUTE = "showOnlineStatus";
    private static final String PAGE_SIZE_ATTRIBUTE = "pageSize";
    private static final String HI_REQ_TABLE_ELEMENT = "hiRequirementTable";
    private static final String HI_POLICY_ID_ATTRIBUTE = "hiPolicyId";
    private static final String WINDOWS_FOLDED_ATTRIBUTE = "windowsFolded";
    private static final String MAC_FOLDED_ATTRIBUTE = "macFolded";
    private static final String SHOW_PLATFORM = "showPlatform";
    private static final String SHOW_NEW_CLIENTS = "newClients";
    private static final String SHOW_ODC_HOSTED = "showODCHosted";
    static final String OPTION_FILE = "sesm.xml";
    private static final String ENABLE_POLICY_LOCATION_COUNTING = "locationCounting";
    private static final String ENABLE_GET_ALL_GROUP_LOCATIONS = "getAllGroupLocations";
    private static ConsoleOptions instance = null;

    public static synchronized ConsoleOptions getInstance() {
        if (instance == null) {
            instance = ConsoleOptions.createInstance(ConsoleOptions.getUserSpecificConsoleOptionFilePath());
        }
        return instance;
    }

    public static synchronized ConsoleOptions getInstance(boolean refresh) {
        if (refresh) {
            instance = ConsoleOptions.createInstance(ConsoleOptions.getUserSpecificConsoleOptionFilePath());
            return instance;
        }
        instance = ConsoleOptions.createInstance(ConsoleOptions.getCommonConsoleOptionFilePath());
        return instance;
    }

    private static ConsoleOptions createInstance(String consoleOptionFilePath) {
        ConsoleLogger.log("ConsoleOptions> createInstance>> Re-fetching Console Option File...");
        ConsoleOptions inst = new ConsoleOptions(consoleOptionFilePath);
        inst.initialize();
        return inst;
    }

    static synchronized void resetInstance() {
        instance = null;
    }

    ConsoleOptions(String tmpfilename) {
        ConsoleLogger.log("ConsoleOptions> Console Option File path: " + tmpfilename);
        this.fileName = tmpfilename;
    }

    File getOptionFile() {
        return new File(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        File optionFile = this.getOptionFile();
        System.out.println("ConsoleOptions> initialize>> file: " + optionFile.getPath() + "\tfile exists: " + optionFile.exists());
        if (!optionFile.exists() && optionFile.getName().indexOf(OPTION_FILE) == -1) {
            Utility.copyFile((File)new File(ConsoleOptions.getCommonConsoleOptionFilePath()), (File)optionFile);
        }
        if (optionFile.length() > 0x100000L) {
            ConsoleLogger.log("ConsoleOptions> initialize>> Console option file is invalid, so delete it.");
            Utility.deleteFile((File)optionFile);
        }
        if (optionFile.exists()) {
            try (FileInputStream fis = new FileInputStream(optionFile);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                this.optionDocument = XMLHelper.parse((InputStream)bis);
            }
            catch (Exception ex) {
                ConsoleLogger.log(ex);
            }
            finally {
                this.getLoginElement();
                this.getDisplayFilterElement();
                this.upgradeOldOptionFile();
            }
        } else {
            this.setLoginOption(LESS_OPTION, String.valueOf(Boolean.TRUE));
            this.setDisplayMode(this.getDefaultDisplayMode(), Integer.parseInt(MAX_PAGE_SIZE), String.valueOf(this.getDefaultPlatformFilter()), this.getDefaultNewClients(), this.getDefaultODCHosted());
        }
        this.getIsPolicyLocationCountingEnabled();
        this.getIsGetAllGroupLocationsEnabled();
    }

    private void upgradeOldOptionFile() {
        Element login = this.getLoginElement();
        Element filter = this.getDisplayFilterElement();
        String getAllGroupLocationsEnabled = login.getAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS);
        String policyLocationCountingEnabled = login.getAttribute(ENABLE_POLICY_LOCATION_COUNTING);
        if (!(getAllGroupLocationsEnabled != null && getAllGroupLocationsEnabled.compareToIgnoreCase("") != 0 || policyLocationCountingEnabled != null && policyLocationCountingEnabled.compareToIgnoreCase("") != 0)) {
            return;
        }
        login.removeAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS);
        filter.setAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS, getAllGroupLocationsEnabled);
        if (policyLocationCountingEnabled != null && policyLocationCountingEnabled.compareToIgnoreCase("") != 0) {
            login.removeAttribute(ENABLE_POLICY_LOCATION_COUNTING);
            filter.setAttribute(ENABLE_POLICY_LOCATION_COUNTING, policyLocationCountingEnabled);
        }
        this.setLoginOption(this.getLoginOption(), this.getShowUACWarning());
        this.setDisplayMode(this.getDisplayMode(), Integer.parseInt(this.getPageSizeFilter()), this.getPlatformFilter(), Boolean.valueOf(this.getNewClients()), Boolean.valueOf(this.getODCHosted()), this.getIsPolicyLocationCountingEnabled(), this.getIsGetAllGroupLocationsEnabled());
    }

    String getLoginOption() {
        String loginOption = LESS_OPTION;
        Element login = this.getLoginElement();
        loginOption = login.getAttribute(OPTION_ATTRIBUTE);
        if (loginOption == null || loginOption.compareToIgnoreCase("") == 0) {
            loginOption = LESS_OPTION;
        }
        return loginOption;
    }

    String getShowUACWarning() {
        String showUACWarning = String.valueOf(Boolean.TRUE);
        Element login = this.getLoginElement();
        showUACWarning = login.getAttribute(UAC_WARN_ATTRIBUTE);
        if (showUACWarning == null || showUACWarning.compareToIgnoreCase("") == 0) {
            showUACWarning = String.valueOf(Boolean.TRUE);
        }
        return showUACWarning;
    }

    public boolean showUACWarning() {
        return this.getShowUACWarning().equals(String.valueOf(Boolean.TRUE));
    }

    void setLoginOption(String isOptionExpanded, String isShowUACWarning) {
        Element login = this.getLoginElement();
        login.setAttribute(OPTION_ATTRIBUTE, isOptionExpanded);
        login.setAttribute(UAC_WARN_ATTRIBUTE, isShowUACWarning);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getOptionFile()));){
            XMLHelper.serialize((Document)this.optionDocument, (OutputStream)os);
            ((OutputStream)os).flush();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    String getIsPolicyLocationCountingEnabled() {
        String enabled = String.valueOf(this.getDefIsPolicyLocationCountingEnabled());
        Element filter = this.getDisplayFilterElement();
        enabled = filter.getAttribute(ENABLE_POLICY_LOCATION_COUNTING);
        if (enabled == null || enabled.compareToIgnoreCase("") == 0) {
            enabled = String.valueOf(this.getDefIsPolicyLocationCountingEnabled());
        }
        this.isPolicyLocationCountingEnabled = String.valueOf(Boolean.TRUE).equals(enabled);
        return String.valueOf(this.isPolicyLocationCountingEnabled());
    }

    public boolean isPolicyLocationCountingEnabled() {
        return this.isPolicyLocationCountingEnabled;
    }

    String getIsGetAllGroupLocationsEnabled() {
        String enabled = String.valueOf(Boolean.TRUE);
        Element filter = this.getDisplayFilterElement();
        enabled = filter.getAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS);
        if (enabled == null || enabled.compareToIgnoreCase("") == 0) {
            enabled = String.valueOf(Boolean.TRUE);
        }
        this.isGetAllGroupLocationsEnabled = String.valueOf(Boolean.TRUE).equals(enabled);
        return String.valueOf(this.isGetAllGroupLocationsEnabled());
    }

    public boolean isGetAllGroupLocationsEnabled() {
        return this.isGetAllGroupLocationsEnabled;
    }

    private void createOptionDocument() {
        try {
            this.optionDocument = XmlUtils.getSecureDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        if (this.optionDocument != null) {
            Element root = this.optionDocument.createElement(SESM_ELEMENT);
            this.optionDocument.appendChild(root);
        }
    }

    private Element getLoginElement() {
        Element root;
        ArrayList logins;
        if (this.optionDocument == null) {
            this.createOptionDocument();
        }
        if ((logins = XMLHelper.getChildElementByName((Element)(root = this.optionDocument.getDocumentElement()), (String)LOGIN_ELEMENT)).size() > 0) {
            return (Element)logins.get(0);
        }
        Element login = this.optionDocument.createElement(LOGIN_ELEMENT);
        login.setAttribute(OPTION_ATTRIBUTE, LESS_OPTION);
        login.setAttribute(UAC_WARN_ATTRIBUTE, String.valueOf(Boolean.TRUE));
        root.appendChild(login);
        return login;
    }

    private Element getDisplayFilterElement() {
        Element root;
        ArrayList filters;
        if (this.optionDocument == null) {
            this.createOptionDocument();
        }
        if ((filters = XMLHelper.getChildElementByName((Element)(root = this.optionDocument.getDocumentElement()), (String)DISPLAY_FILTER_ELEMENT)).size() > 0) {
            return (Element)filters.get(0);
        }
        Element filter = this.optionDocument.createElement(DISPLAY_FILTER_ELEMENT);
        filter.setAttribute(MODE_ATTRIBUTE, this.getDefaultDisplayMode());
        filter.setAttribute(ONLINE_ATTRIBUTE, ONLINE_STATUS);
        filter.setAttribute(PAGE_SIZE_ATTRIBUTE, MAX_PAGE_SIZE);
        filter.setAttribute(SHOW_PLATFORM, String.valueOf(this.getDefaultPlatformFilter()));
        filter.setAttribute(SHOW_NEW_CLIENTS, String.valueOf(this.getDefaultNewClients()));
        filter.setAttribute(ENABLE_POLICY_LOCATION_COUNTING, String.valueOf(this.getDefIsPolicyLocationCountingEnabled()));
        filter.setAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS, String.valueOf(Boolean.TRUE));
        root.appendChild(filter);
        return filter;
    }

    public void setDisplayMode(String mode, int size, String platformFilter, boolean newClients, boolean odcHostedFilter) {
        this.setDisplayMode(mode, size, platformFilter, newClients, odcHostedFilter, this.getIsPolicyLocationCountingEnabled(), this.getIsGetAllGroupLocationsEnabled());
    }

    public void setDisplayMode(String mode, int size, String platformFilter, boolean newClients, boolean odcHostedFilter, String isPolicyLocationCountingEnabled, String isGetAllGroupLocationsEnabled) {
        Element filter = this.getDisplayFilterElement();
        filter.setAttribute(MODE_ATTRIBUTE, mode);
        filter.setAttribute(PAGE_SIZE_ATTRIBUTE, "" + size);
        filter.setAttribute(SHOW_PLATFORM, platformFilter);
        filter.setAttribute(SHOW_NEW_CLIENTS, "" + newClients);
        filter.setAttribute(SHOW_ODC_HOSTED, "" + odcHostedFilter);
        filter.setAttribute(ENABLE_POLICY_LOCATION_COUNTING, isPolicyLocationCountingEnabled);
        filter.setAttribute(ENABLE_GET_ALL_GROUP_LOCATIONS, isGetAllGroupLocationsEnabled);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getOptionFile()));){
            XMLHelper.serialize((Document)this.optionDocument, (OutputStream)os);
            ((OutputStream)os).flush();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public String getDisplayMode() {
        String mode = this.getDefaultDisplayMode();
        Element filter = this.getDisplayFilterElement();
        mode = filter.getAttribute(MODE_ATTRIBUTE);
        if (mode == null || mode.compareToIgnoreCase("") == 0) {
            mode = this.getDefaultDisplayMode();
        }
        return mode;
    }

    private String getDefaultDisplayMode() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return COMPUTER_MODE;
        }
        return MIX_MODE;
    }

    public String getOnlineFilter() {
        String online = ONLINE_STATUS;
        Element filter = this.getDisplayFilterElement();
        online = filter.getAttribute(ONLINE_ATTRIBUTE);
        if (online == null || online.compareToIgnoreCase("") == 0) {
            online = ONLINE_STATUS;
        }
        return online;
    }

    public String getPageSizeFilter() {
        String page = MAX_PAGE_SIZE;
        Element filter = this.getDisplayFilterElement();
        page = filter.getAttribute(PAGE_SIZE_ATTRIBUTE);
        if (page == null || page.compareToIgnoreCase("") == 0 || page.compareToIgnoreCase("0") == 0) {
            page = MAX_PAGE_SIZE;
        }
        return page;
    }

    public void setHIReqTableShowStatus(String policyId, boolean windowsFolded, boolean macFolded) {
        Element root = null;
        if (this.optionDocument == null) {
            try {
                this.optionDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                root = this.optionDocument.createElement(SESM_ELEMENT);
                this.optionDocument.appendChild(root);
            }
            catch (ParserConfigurationException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
        }
        Element element = this.getHIReqTableElement(policyId);
        element.setAttribute(HI_POLICY_ID_ATTRIBUTE, policyId);
        element.setAttribute(WINDOWS_FOLDED_ATTRIBUTE, String.valueOf(windowsFolded));
        element.setAttribute(MAC_FOLDED_ATTRIBUTE, String.valueOf(macFolded));
        try {
            XMLHelper.serialize((Document)this.optionDocument, (OutputStream)new FileOutputStream(this.getOptionFile()));
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public boolean isHIReqTableWindowsFolded(String policyId) {
        Element element = this.getHIReqTableElement(policyId);
        String windowsStr = element.getAttribute(WINDOWS_FOLDED_ATTRIBUTE);
        if (!StringUtilities.isEmpty((String)windowsStr)) {
            return Boolean.valueOf(windowsStr);
        }
        return true;
    }

    public boolean isHIReqTableMacFolded(String policyId) {
        Element element = this.getHIReqTableElement(policyId);
        String windowsStr = element.getAttribute(MAC_FOLDED_ATTRIBUTE);
        if (!StringUtilities.isEmpty((String)windowsStr)) {
            return Boolean.valueOf(windowsStr);
        }
        return false;
    }

    private Element getHIReqTableElement(String policyId) {
        Element element = null;
        if (this.optionDocument != null) {
            Element root = this.optionDocument.getDocumentElement();
            ArrayList filters = XMLHelper.getChildElementByName((Element)root, (String)HI_REQ_TABLE_ELEMENT);
            if (filters != null && filters.size() > 0) {
                for (Element e : filters) {
                    if (!policyId.equals(e.getAttribute(HI_POLICY_ID_ATTRIBUTE))) continue;
                    return e;
                }
            }
            element = this.optionDocument.createElement(HI_REQ_TABLE_ELEMENT);
            element.setAttribute(HI_POLICY_ID_ATTRIBUTE, policyId);
            element.setAttribute(WINDOWS_FOLDED_ATTRIBUTE, OFFLINE_STATUS);
            element.setAttribute(MAC_FOLDED_ATTRIBUTE, ONLINE_STATUS);
            root.appendChild(element);
        }
        return element;
    }

    private Boolean getDefIsPolicyLocationCountingEnabled() {
        if (LicenseObject.getInstance().isSBProduct()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getPlatformFilter() {
        String osFilter = MIX_MODE;
        Element filter = this.getDisplayFilterElement();
        osFilter = filter.getAttribute(SHOW_PLATFORM);
        if (osFilter == null || osFilter.compareToIgnoreCase("") == 0) {
            osFilter = MIX_MODE;
        }
        return osFilter;
    }

    public String getNewClients() {
        String osFilter = ONLINE_STATUS;
        Element filter = this.getDisplayFilterElement();
        osFilter = filter.getAttribute(SHOW_NEW_CLIENTS);
        if (osFilter == null || osFilter.compareToIgnoreCase("") == 0) {
            osFilter = ONLINE_STATUS;
        }
        return osFilter;
    }

    public String getODCHosted() {
        String osFilter = null;
        Element filter = this.getDisplayFilterElement();
        osFilter = filter.getAttribute(SHOW_ODC_HOSTED);
        if (StringUtilities.isEmpty((String)osFilter)) {
            osFilter = ONLINE_STATUS;
        }
        return osFilter;
    }

    public Boolean getDefaultPlatformFilter() {
        return Boolean.TRUE;
    }

    public Boolean getDefaultNewClients() {
        return Boolean.TRUE;
    }

    public Boolean getDefaultODCHosted() {
        return Boolean.TRUE;
    }

    private static String getCommonJavaConsoleOptionFilePath() {
        File appDataDir = Utility.getAPPDATADir().toFile();
        if (!appDataDir.exists() && !appDataDir.mkdirs()) {
            ConsoleLogger.log("ConsoleOptions> getCommonJavaConsoleOptionFilePath>> Failed to create APPDATA folder:" + appDataDir.getAbsolutePath());
            String tmp = Utility.getTempDir();
            return new File(tmp, OPTION_FILE).getAbsolutePath();
        }
        return new File(appDataDir, OPTION_FILE).getAbsolutePath();
    }

    private static String getCommonAjaxSwingConsoleOptionFilePath() {
        String tmp = Utility.getTempDir();
        return new File(tmp, OPTION_FILE).getAbsolutePath();
    }

    private static String getUserSpecificConsoleOptionFilePath() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            String commonPath = ConsoleOptions.getCommonAjaxSwingConsoleOptionFilePath();
            String optionPath = Utilities.reformatFileNameToUserSpecific(commonPath);
            return optionPath;
        }
        String commonPath = ConsoleOptions.getCommonJavaConsoleOptionFilePath();
        String optionPath = Utilities.reformatFileNameToUserSpecific(commonPath);
        return optionPath;
    }

    static String getCommonConsoleOptionFilePath() {
        if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
            return ConsoleOptions.getCommonAjaxSwingConsoleOptionFilePath();
        }
        return ConsoleOptions.getCommonJavaConsoleOptionFilePath();
    }
}

