/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.configobject.schema.PasswordSettings;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.PasswordSettingsHelper;
import com.sygate.scm.common.ui.PasswordWidget;
import com.sygate.scm.common.ui.SEPMPasswordField;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.PasswordSettingsUtil;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.RootPaneContainer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdminPwdExpirationDlg
extends JDialog {
    private static final long serialVersionUID = 1L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel upPanel = new JPanel();
    private JPanel downPanel = new JPanel();
    private JLabel pwdLabel = new JLabel();
    private JLabel pwdConfirmLabel = new JLabel();
    private JPasswordField jTFPwd = null;
    private JPasswordField pwdConfirmField = new SEPMPasswordField(50);
    private JButton okBtn = new JButton(UIText.get(3584));
    private PasswordWidget jLPwdStatus = null;
    private boolean isCancelled = true;
    private JButton cancelBtn = new JButton(UIText.get(3584));
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel jLabel1 = new JLabel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private MessageResources msgRes = MessageResources.getInstance();
    private String oldPwdHash = null;

    public AdminPwdExpirationDlg(Frame frame, String title, String oldPwdHash, boolean modal) {
        super(frame, title, modal);
        try {
            this.oldPwdHash = oldPwdHash;
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public static void main(String[] argv) {
        AdminPwdExpirationDlg adminPwdExpirationDlg = new AdminPwdExpirationDlg(null, "", "", true);
        adminPwdExpirationDlg.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.pwdLabel.setText(this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.label.newPassword"));
        this.pwdLabel.setHorizontalAlignment(11);
        this.pwdConfirmLabel.setText(this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.label.confirmPassword"));
        this.pwdConfirmLabel.setHorizontalAlignment(11);
        RestrictedPlainDocument pwdDoc = new RestrictedPlainDocument(1024);
        this.getTFPwd().setDocument(pwdDoc);
        RestrictedPlainDocument pwdConfirmDoc = new RestrictedPlainDocument(1024);
        this.pwdConfirmField.setDocument(pwdConfirmDoc);
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminPwdExpirationDlg.this.okBtnActionPerformed(event);
            }
        });
        this.cancelBtn.setText(UIText.get(512));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AdminPwdExpirationDlg.this.cancelBtnActionPerformed(event);
            }
        });
        this.jLabel1.setText(this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.yourPasswordExpired"));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setVerticalTextPosition(3);
        this.upPanel.setLayout(this.gridBagLayout2);
        this.upPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 30));
        this.downPanel.setLayout(this.gridBagLayout1);
        this.upPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.upPanel.add((Component)this.pwdLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.upPanel.add((Component)this.getTFPwd(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
        this.upPanel.add((Component)this.pwdConfirmLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.upPanel.add((Component)this.pwdConfirmField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 10, 10), 0, 0));
        this.upPanel.add((Component)this.getJLPwdStatus(), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 10, 10), 0, 0));
        this.downPanel.add((Component)this.okBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 5), 0, 0));
        this.downPanel.add((Component)this.cancelBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)this.upPanel, "Center");
        this.getContentPane().add((Component)this.downPanel, "South");
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.okBtn);
        this.pack();
        this.setResizable(false);
        this.getTFPwd().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                AdminPwdExpirationDlg.this.handleListenerEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                AdminPwdExpirationDlg.this.handleListenerEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JOptionPane.showMessageDialog(Manager.getFrame(), AdminPwdExpirationDlg.this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.pleaseClickTheOK"), AdminPwdExpirationDlg.this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.information"), 0);
            }
        });
        UIUtilities.fitJComponent(new JButton[]{this.okBtn, this.cancelBtn});
        UiUtilities.centerComponent((Component)this);
    }

    private void handleListenerEvent() {
        PasswordSettingsUtil.handlePassword(this.getTFPwd(), this.getJLPwdStatus());
    }

    public JPasswordField getTFPwd() {
        if (this.jTFPwd == null) {
            this.jTFPwd = new SEPMPasswordField(30);
            this.jTFPwd.setPreferredSize(this.jTFPwd.getPreferredSize());
        }
        return this.jTFPwd;
    }

    private PasswordWidget getJLPwdStatus() {
        if (this.jLPwdStatus == null) {
            this.jLPwdStatus = new PasswordWidget(true, false);
        }
        return this.jLPwdStatus;
    }

    private void okBtnActionPerformed(ActionEvent event) {
        String newHash;
        char[] pwd = this.getPassword();
        char[] pwdcfm = this.pwdConfirmField.getPassword();
        String errorTitle = this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.error");
        AdminObject adminObject = AdminObject.retrieveCurrentAdminObject();
        if (PasswordSettingsUtil.isPasswordInHistory(adminObject, this.getTFPwd().getPassword())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.passwordTooRecent"), this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.invalidPasswordTitle"), 0);
            this.getTFPwd().requestFocus();
            return;
        }
        if (this.oldPwdHash != null && this.oldPwdHash.trim().length() > 0 && (newHash = Utility.calculateHash((String)new String(pwd))).equals(this.oldPwdHash)) {
            Object[] obj = new Object[]{0};
            String msg = this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.passwordMustDiffFromOld");
            String fm = MessageFormat.format(msg, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, errorTitle, 0);
            this.getTFPwd().requestFocus();
            return;
        }
        PasswordSettings passwordSettings = PasswordSettingsUtil.getPasswordSettings();
        int result = PasswordSettingsHelper.checkRequirements((PasswordSettings)passwordSettings, (char[])pwd);
        if (result != 0) {
            String passwordErrors = PasswordSettingsHelper.getPasswordErrorMessages((PasswordSettings)passwordSettings, (int)result, (boolean)true);
            JOptionPane.showMessageDialog(Manager.getFrame(), passwordErrors, this.msgRes.getString("com.sygate.scm.console.ui.ui", "AdminPwdExpirationDlg.msg.invalidPasswordTitle"), 0);
            this.getTFPwd().requestFocus();
            return;
        }
        if (!Arrays.equals(pwd, pwdcfm)) {
            String msg = this.msgRes.getString("com.sygate.scm.util.util", "Utility.pwdNotMatchMsg");
            String fm = MessageFormat.format(msg, "");
            JOptionPane.showMessageDialog(Manager.getFrame(), fm, errorTitle, 0);
            this.getTFPwd().requestFocus();
            return;
        }
        this.isCancelled = false;
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent event) {
        this.isCancelled = true;
        this.dispose();
    }

    public char[] getPassword() {
        return this.getTFPwd().getPassword();
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

