/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.ImagePanel;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.SchemaVersion;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jBOk = new JButton(UIText.get(3584));
    private static MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.ui");

    public AboutDialog() {
        super(Manager.getFrame(), "", true);
        this.setUndecorated(true);
        this.initialize();
        UiUtilities.centerComponentInMultiGraphicsDevice((Component)this, (Container)Manager.getFrame());
    }

    private void initialize() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createLineBorder(UIColorUtilities.ACCENT_BORDER, 2));
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                int modifier = ev.getModifiers();
                if (ev.getClickCount() == 2 && (modifier & 2) != 0 && (modifier & 8) != 0 && (modifier & 1) != 0) {
                    ConsoleMain.setMaintenanceMode(!ConsoleMain.isMaintenanceMode());
                    System.out.println((ConsoleMain.isMaintenanceMode() ? "Enter" : "Leave") + " maintenance mode");
                }
            }
        });
        if (LicenseObject.getInstance().isSEPSBProduct()) {
            panel.add((Component)new ImagePanel(ConsoleMain.getBANNER_IMAGE_Sepsb(), true), "North");
        } else {
            panel.add((Component)new ImagePanel(ConsoleMain.getBANNER_IMAGE(), true), "North");
        }
        panel.add((Component)this.getAboutPanel(), "Center");
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
    }

    private JPanel getAboutPanel() {
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBOk);
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AboutDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(30, 30, 0, 20));
        int yLayout = 0;
        if (!LicenseObject.getInstance().isSEPSBProduct()) {
            panel.add((Component)new JLabel(ConsoleMain.LOGO_IMAGE), new GridBagConstraints(0, yLayout, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(ConsoleMain.getNAME_IMAGE()), new GridBagConstraints(1, yLayout, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 25, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, yLayout, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 50, 0, 0), 0, 0));
        }
        String versionString = this.formatVersionString(Env.getSemVersion());
        panel.add((Component)new JLabel(versionString), new GridBagConstraints(1, ++yLayout, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel(MSGRES.getString("LoginPanel.label.copyright")), new GridBagConstraints(1, ++yLayout, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
        panel.add((Component)this.getMessageArea(), new GridBagConstraints(1, ++yLayout, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.getAgreementArea(), new GridBagConstraints(1, ++yLayout, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.getEulaNoticeArea(), new GridBagConstraints(1, ++yLayout, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        panel.add((Component)this.jBOk, new GridBagConstraints(1, ++yLayout, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 30, 0));
        return panel;
    }

    private String formatVersionString(String versionString) {
        String semVersion = Env.getSemVersion();
        if (StringUtilities.isEmpty((String)semVersion)) {
            return "";
        }
        String[] versionStringArr = versionString.split("\\.");
        if (versionStringArr.length < 4) {
            return "";
        }
        String ruNumber = this.getRuNumber(versionStringArr[3]);
        String ruMpString = this.formatRuAndMpString(versionStringArr[3]);
        String buildNumber = versionStringArr[2];
        int serverVersionDisplayLevel = ScmProperties.getServerVersionDisplayLevel();
        System.out.println("About >> ruNumber: " + ruNumber + ", ruMpString: " + ruMpString + ", serverVersionDisplayLevel: " + serverVersionDisplayLevel);
        if (ruNumber.equals("") || ruNumber.equals("0")) {
            Object releaseVersion = "";
            if (!ruMpString.equals("")) {
                releaseVersion = " (" + versionStringArr[0] + " " + ruMpString + ") ";
            }
            System.out.println("About >> releaseVersion: " + (String)releaseVersion);
            return this.getVersionStringForDisplay(versionString, versionStringArr, buildNumber, serverVersionDisplayLevel, (String)releaseVersion, ruMpString);
        }
        return this.getRUMPVersionStringForDisplay(versionString, versionStringArr, ruNumber, ruMpString, buildNumber, serverVersionDisplayLevel);
    }

    private String getVersionStringForDisplay(String versionString, String[] versionStringArr, String buildNumber, int serverVersionDisplayLevel, String releaseVersion, String ruMpString) {
        boolean isReleaseVersion = SchemaVersion.isReleaseVersion();
        switch (serverVersionDisplayLevel) {
            case 0: {
                Object[] args0 = new Object[]{versionStringArr[0] + releaseVersion, buildNumber, versionString};
                return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level0"), args0) : MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level0.preview"), args0);
            }
            case 1: {
                Object[] args1 = new Object[]{versionStringArr[0] + releaseVersion, versionStringArr[1], buildNumber, versionString};
                return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level1"), args1) : MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level1.preview"), args1);
            }
            case 2: {
                Object[] args2 = new Object[]{versionStringArr[0], versionStringArr[0], versionStringArr[1], ruMpString, buildNumber, versionString};
                return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0"), args2) : MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0.preview"), args2);
            }
        }
        Object[] argsd = new Object[]{versionStringArr[0] + releaseVersion, buildNumber, versionString};
        return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level0"), argsd) : MessageFormat.format(MSGRES.getString("HelpDialog.label.version.level0.preview"), argsd);
    }

    private String getRUMPVersionStringForDisplay(String versionString, String[] versionStringArr, String ruNumber, String ruMpString, String buildNumber, int serverVersionDisplayLevel) {
        boolean isReleaseVersion = SchemaVersion.isReleaseVersion();
        switch (serverVersionDisplayLevel) {
            case 0: {
                Object[] args0 = new Object[]{versionStringArr[0], versionStringArr[0], versionStringArr[1], ruMpString, buildNumber, versionString};
                return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0"), args0) : MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0.preview"), args0);
            }
            case 1: {
                Object[] args1 = new Object[]{versionStringArr[0], versionStringArr[1], ruNumber, versionStringArr[0], versionStringArr[1], ruMpString, buildNumber, versionString};
                return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level1"), args1) : MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level1.preview"), args1);
            }
        }
        Object[] argsd = new Object[]{versionStringArr[0], versionStringArr[0], versionStringArr[1], ruMpString, buildNumber, versionString};
        return isReleaseVersion ? MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0"), argsd) : MessageFormat.format(MSGRES.getString("HelpDialog.label.RUMPVersion.level0.preview"), argsd);
    }

    private String getRuNumber(String ruMpString) {
        if (StringUtilities.isEmpty((String)ruMpString)) {
            return "";
        }
        return ruMpString.substring(0, 1);
    }

    private String formatRuAndMpString(String ruMpString) {
        try {
            if (!StringUtilities.isEmpty((String)ruMpString)) {
                int releaseVer = Integer.parseInt(ruMpString);
                int ruVer = releaseVer / 1000;
                int mpVer = (releaseVer - ruVer * 1000) / 100;
                if (ruVer != 0) {
                    if (mpVer != 0) {
                        Object[] args = new Object[]{ruVer, mpVer};
                        return MessageFormat.format(MSGRES.getString("LoginPanel.label.versionNumber.rump"), args);
                    }
                    Object[] args = new Object[]{ruVer};
                    return MessageFormat.format(MSGRES.getString("LoginPanel.label.versionNumber.ru"), args);
                }
                if (mpVer != 0) {
                    Object[] args = new Object[]{mpVer};
                    return MessageFormat.format(MSGRES.getString("LoginPanel.label.versionNumber.mp"), args);
                }
            }
        }
        catch (IllegalArgumentException exception) {
            return "";
        }
        return "";
    }

    private DescriptionTextArea getMessageArea() {
        DescriptionTextArea area = new DescriptionTextArea(MSGRES.getString("AboutDialog.message"));
        area.setBackground(Color.WHITE);
        return area;
    }

    private DescriptionTextArea getAgreementArea() {
        DescriptionTextArea area = new DescriptionTextArea(MSGRES.getString("AboutDialog.agreement"));
        area.setBackground(Color.WHITE);
        return area;
    }

    private DescriptionTextArea getEulaNoticeArea() {
        DescriptionTextArea area = new DescriptionTextArea(MSGRES.getString("AboutDialog.eulaNotice"));
        area.setBackground(Color.WHITE);
        return area;
    }
}

