/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.logicobject;

import com.sygate.scm.common.configobject.TimeUtil;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.ComputerImage;
import com.sygate.scm.common.configobject.schema.DeltaImageFile;
import com.sygate.scm.common.configobject.schema.MasterImageFile;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.PhysicalFile;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.LockdownFileListObject;
import com.sygate.scm.console.ui.util.JLabelData;
import com.sygate.scm.console.ui.util.WarningButton;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WhiteListObject
extends LockdownFileListObject {
    public static final int INDEX_WARNING = 0;
    public static final int INDEX_NAME = 1;
    public static final int INDEX_DESCRIPTION = 2;
    public static final int INDEX_FILECOUNT = 3;
    public static final int INDEX_UPDATE_TIME = 4;
    private boolean isSelected = false;
    private boolean isGuiEnabled = true;
    public GroupObject group = null;

    public WhiteListObject(ComputerImage image) {
        super(image, false);
    }

    public static WhiteListObject newInstance(String name, String description) {
        ComputerImage image = new ComputerImage();
        image.setId(new GUIDGenerator().getGUIDString());
        image.setName(name);
        image.setOptDescription(description);
        image.setCreationTime(Long.valueOf(TimeUtil.getServerTime()));
        image.setOptUpdateTime(Long.valueOf(TimeUtil.getServerTime()));
        return new WhiteListObject(image);
    }

    public void setImage(ComputerImage image) {
        this.image = image;
        if (image != null) {
            this.name = image.getName();
        }
    }

    public boolean isValid() {
        return this.image != null;
    }

    public boolean hasWarning() {
        if (!this.isValid()) {
            return false;
        }
        return this.image.getOptLegacyHashCount() != null && this.image.getOptLegacyHashCount() > 0;
    }

    @Override
    public String getId() {
        if (!this.isValid()) {
            return "";
        }
        return this.image.getId();
    }

    private WarningButton getWarning() {
        if (this.hasWarning()) {
            return new WarningButton(true);
        }
        return new WarningButton(false);
    }

    private JLabelData getLabeledName() {
        JLabelData jLabelData = new JLabelData(this.name, null);
        if (this.isCollectedByCommand()) {
            jLabelData.setIcon(ConsoleMain.goldImageIcon);
            return jLabelData;
        }
        return jLabelData;
    }

    public JLabelData getDescription() {
        if (!this.isValid()) {
            return new JLabelData("", null);
        }
        return new JLabelData(this.image.getOptDescription() != null ? this.image.getOptDescription() : "", null);
    }

    public String getSource() {
        String source = null;
        try {
            if (this.image.getOptSource() == null) {
                ComputerImage ciTemp = new ComputerImage();
                ciTemp.setOptSource(ciTemp.getDefSource());
                source = ciTemp.getOptSourceValue();
            } else {
                source = this.image.getOptSourceValue();
            }
        }
        catch (ValidationException ex) {
            ConsoleLogger.log("Exception getting source field from computer image object. source: " + source);
            ConsoleLogger.log(ex);
            source = "CONSOLE";
        }
        return source;
    }

    public String getCreationTimeLongFormat() {
        return Utility.getTimeDisplayStringFromConfigObject((long)this.image.getCreationTime());
    }

    public String getUpdateTimeLongFormat() {
        String updateTime = "";
        Long longtime = this.image.getOptUpdateTime();
        if (longtime != null && longtime != 0L) {
            updateTime = Utility.getTimeDisplayStringFromConfigObject((long)this.image.getOptUpdateTime());
        }
        return updateTime;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public long getCount() {
        if (!this.isValid() || this.image.getOptHashCount() == null) {
            return 0L;
        }
        return this.image.getOptHashCount().intValue();
    }

    public JLabelData getCountDisplayString() {
        return new JLabelData(Long.toString(this.getCount()), null);
    }

    public JLabelData getUpdateTime() {
        Long longtime;
        String time = "";
        if (this.image != null && (longtime = this.image.getOptUpdateTime()) != null && longtime != 0L) {
            Date date = new Date(longtime);
            SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
            time = formatter.format(date);
        }
        return new JLabelData(time, null);
    }

    public PhysicalFile getPhysicalFile(boolean master) {
        if (!this.isValid()) {
            return null;
        }
        String id = null;
        if (master) {
            MasterImageFile fileMaster = this.image.getMasterImageFile();
            id = fileMaster.getObjReference().getTargetId();
        } else {
            DeltaImageFile fileDelta = this.image.getOptDeltaImageFile();
            if (fileDelta == null) {
                return null;
            }
            id = fileDelta.getObjReference().getTargetId();
        }
        try {
            return DataobjectManager.getInstance().getPhysicalFile(id);
        }
        catch (Throwable ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public void setImageFile(PhysicalFile pf, boolean master) {
        if (!this.isValid() || pf == null) {
            return;
        }
        ObjReference ref = null;
        if (master) {
            MasterImageFile file = this.image.getMasterImageFile();
            if (file == null) {
                file = new MasterImageFile();
                this.image.setMasterImageFile(file);
            }
            if ((ref = file.getObjReference()) == null) {
                ref = new ObjReference();
                file.setObjReference(ref);
            }
        } else {
            DeltaImageFile file = this.image.getOptDeltaImageFile();
            if (file == null) {
                file = new DeltaImageFile();
                this.image.setOptDeltaImageFile(file);
            }
            if ((ref = file.getObjReference()) == null) {
                ref = new ObjReference();
                file.setObjReference(ref);
            }
        }
        ref.setName("ImageFileLink");
        ref.setTargetType("PhysicalFile");
        ref.setTargetId(pf.getId());
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getWarning();
            }
            case 1: {
                return this.getLabeledName();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getCountDisplayString();
            }
            case 4: {
                return this.getUpdateTime();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return WarningButton.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return JLabelData.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isGuiEnabled() {
        return this.isGuiEnabled;
    }

    public void setGuiEnabled(boolean enabled) {
        this.isGuiEnabled = enabled;
    }

    public void setGroup(GroupObject group) {
        this.group = group;
    }

    public GroupObject getGroup() {
        return this.group;
    }

    public boolean isCollectedByCommand() {
        return null != this.image && ComputerImage.COMMAND.equals(this.image.getOptSource());
    }

    public boolean isCollectedByWebService() {
        return null != this.image && ComputerImage.WEBSERVICE.equals(this.image.getOptSource());
    }

    public String getHardwareKey() {
        if (this.image != null && this.image.getOptHardwareKey() != null) {
            return this.image.getOptHardwareKey();
        }
        return "";
    }

    public String getComputerName() {
        if (this.image != null && this.image.getOptComputerName() != null) {
            return this.image.getOptComputerName();
        }
        return "";
    }

    public String getComputerIPv4() {
        if (this.image != null && this.image.getOptComputerIPv4() != null) {
            return this.image.getOptComputerIPv4();
        }
        return "";
    }

    public String getComputerOS() {
        if (this.image != null && this.image.getOptComputerOS() != null) {
            return this.image.getOptComputerOS();
        }
        return "";
    }
}

